package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyReplicaMode invokes the r_kvstore.ModifyReplicaMode API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyreplicamode.html
func (client *Client) ModifyReplicaMode(request *ModifyReplicaModeRequest) (response *ModifyReplicaModeResponse, err error) {
	response = CreateModifyReplicaModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyReplicaModeWithChan invokes the r_kvstore.ModifyReplicaMode API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyreplicamode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyReplicaModeWithChan(request *ModifyReplicaModeRequest) (<-chan *ModifyReplicaModeResponse, <-chan error) {
	responseChan := make(chan *ModifyReplicaModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyReplicaMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyReplicaModeWithCallback invokes the r_kvstore.ModifyReplicaMode API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyreplicamode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyReplicaModeWithCallback(request *ModifyReplicaModeRequest, callback func(response *ModifyReplicaModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyReplicaModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyReplicaMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyReplicaModeRequest is the request struct for api ModifyReplicaMode
type ModifyReplicaModeRequest struct {
	*requests.RpcRequest
	DomainMode           string           `position:"Query" name:"DomainMode"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ReplicaId            string           `position:"Query" name:"ReplicaId"`
	PrimaryInstanceId    string           `position:"Query" name:"PrimaryInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ReplicaMode          string           `position:"Query" name:"ReplicaMode"`
}

// ModifyReplicaModeResponse is the response struct for api ModifyReplicaMode
type ModifyReplicaModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyReplicaModeRequest creates a request to invoke ModifyReplicaMode API
func CreateModifyReplicaModeRequest() (request *ModifyReplicaModeRequest) {
	request = &ModifyReplicaModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyReplicaMode", "", "")
	return
}

// CreateModifyReplicaModeResponse creates a response to parse from ModifyReplicaMode response
func CreateModifyReplicaModeResponse() (response *ModifyReplicaModeResponse) {
	response = &ModifyReplicaModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
