package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceProxyConfiguration invokes the rds.DescribeDBInstanceProxyConfiguration API synchronously
// api document: https://help.aliyun.com/api/rds/describedbinstanceproxyconfiguration.html
func (client *Client) DescribeDBInstanceProxyConfiguration(request *DescribeDBInstanceProxyConfigurationRequest) (response *DescribeDBInstanceProxyConfigurationResponse, err error) {
	response = CreateDescribeDBInstanceProxyConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceProxyConfigurationWithChan invokes the rds.DescribeDBInstanceProxyConfiguration API asynchronously
// api document: https://help.aliyun.com/api/rds/describedbinstanceproxyconfiguration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDBInstanceProxyConfigurationWithChan(request *DescribeDBInstanceProxyConfigurationRequest) (<-chan *DescribeDBInstanceProxyConfigurationResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceProxyConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceProxyConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceProxyConfigurationWithCallback invokes the rds.DescribeDBInstanceProxyConfiguration API asynchronously
// api document: https://help.aliyun.com/api/rds/describedbinstanceproxyconfiguration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDBInstanceProxyConfigurationWithCallback(request *DescribeDBInstanceProxyConfigurationRequest, callback func(response *DescribeDBInstanceProxyConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceProxyConfigurationResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceProxyConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceProxyConfigurationRequest is the request struct for api DescribeDBInstanceProxyConfiguration
type DescribeDBInstanceProxyConfigurationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// DescribeDBInstanceProxyConfigurationResponse is the response struct for api DescribeDBInstanceProxyConfiguration
type DescribeDBInstanceProxyConfigurationResponse struct {
	*responses.BaseResponse
	RequestId                          string `json:"RequestId" xml:"RequestId"`
	TransparentSwitchConfiguration     string `json:"TransparentSwitchConfiguration" xml:"TransparentSwitchConfiguration"`
	PersistentConnectionsConfiguration string `json:"PersistentConnectionsConfiguration" xml:"PersistentConnectionsConfiguration"`
	AttacksProtectionConfiguration     string `json:"AttacksProtectionConfiguration" xml:"AttacksProtectionConfiguration"`
}

// CreateDescribeDBInstanceProxyConfigurationRequest creates a request to invoke DescribeDBInstanceProxyConfiguration API
func CreateDescribeDBInstanceProxyConfigurationRequest() (request *DescribeDBInstanceProxyConfigurationRequest) {
	request = &DescribeDBInstanceProxyConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDBInstanceProxyConfiguration", "rds", "openAPI")
	return
}

// CreateDescribeDBInstanceProxyConfigurationResponse creates a response to parse from DescribeDBInstanceProxyConfiguration response
func CreateDescribeDBInstanceProxyConfigurationResponse() (response *DescribeDBInstanceProxyConfigurationResponse) {
	response = &DescribeDBInstanceProxyConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
