package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNetworkOptimizationSetting invokes the smartag.DeleteNetworkOptimizationSetting API synchronously
// api document: https://help.aliyun.com/api/smartag/deletenetworkoptimizationsetting.html
func (client *Client) DeleteNetworkOptimizationSetting(request *DeleteNetworkOptimizationSettingRequest) (response *DeleteNetworkOptimizationSettingResponse, err error) {
	response = CreateDeleteNetworkOptimizationSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNetworkOptimizationSettingWithChan invokes the smartag.DeleteNetworkOptimizationSetting API asynchronously
// api document: https://help.aliyun.com/api/smartag/deletenetworkoptimizationsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNetworkOptimizationSettingWithChan(request *DeleteNetworkOptimizationSettingRequest) (<-chan *DeleteNetworkOptimizationSettingResponse, <-chan error) {
	responseChan := make(chan *DeleteNetworkOptimizationSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNetworkOptimizationSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNetworkOptimizationSettingWithCallback invokes the smartag.DeleteNetworkOptimizationSetting API asynchronously
// api document: https://help.aliyun.com/api/smartag/deletenetworkoptimizationsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNetworkOptimizationSettingWithCallback(request *DeleteNetworkOptimizationSettingRequest, callback func(response *DeleteNetworkOptimizationSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNetworkOptimizationSettingResponse
		var err error
		defer close(result)
		response, err = client.DeleteNetworkOptimizationSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNetworkOptimizationSettingRequest is the request struct for api DeleteNetworkOptimizationSetting
type DeleteNetworkOptimizationSettingRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Type                 string           `position:"Query" name:"Type"`
	NetworkOptId         string           `position:"Query" name:"NetworkOptId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Domain               string           `position:"Query" name:"Domain"`
}

// DeleteNetworkOptimizationSettingResponse is the response struct for api DeleteNetworkOptimizationSetting
type DeleteNetworkOptimizationSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNetworkOptimizationSettingRequest creates a request to invoke DeleteNetworkOptimizationSetting API
func CreateDeleteNetworkOptimizationSettingRequest() (request *DeleteNetworkOptimizationSettingRequest) {
	request = &DeleteNetworkOptimizationSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DeleteNetworkOptimizationSetting", "smartag", "openAPI")
	return
}

// CreateDeleteNetworkOptimizationSettingResponse creates a response to parse from DeleteNetworkOptimizationSetting response
func CreateDeleteNetworkOptimizationSettingResponse() (response *DeleteNetworkOptimizationSettingResponse) {
	response = &DeleteNetworkOptimizationSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
