package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeACLs invokes the smartag.DescribeACLs API synchronously
// api document: https://help.aliyun.com/api/smartag/describeacls.html
func (client *Client) DescribeACLs(request *DescribeACLsRequest) (response *DescribeACLsResponse, err error) {
	response = CreateDescribeACLsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeACLsWithChan invokes the smartag.DescribeACLs API asynchronously
// api document: https://help.aliyun.com/api/smartag/describeacls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeACLsWithChan(request *DescribeACLsRequest) (<-chan *DescribeACLsResponse, <-chan error) {
	responseChan := make(chan *DescribeACLsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeACLs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeACLsWithCallback invokes the smartag.DescribeACLs API asynchronously
// api document: https://help.aliyun.com/api/smartag/describeacls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeACLsWithCallback(request *DescribeACLsRequest, callback func(response *DescribeACLsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeACLsResponse
		var err error
		defer close(result)
		response, err = client.DescribeACLs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeACLsRequest is the request struct for api DescribeACLs
type DescribeACLsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AclIds               string           `position:"Query" name:"AclIds"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
}

// DescribeACLsResponse is the response struct for api DescribeACLs
type DescribeACLsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	Acls       Acls   `json:"Acls" xml:"Acls"`
}

// CreateDescribeACLsRequest creates a request to invoke DescribeACLs API
func CreateDescribeACLsRequest() (request *DescribeACLsRequest) {
	request = &DescribeACLsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeACLs", "smartag", "openAPI")
	return
}

// CreateDescribeACLsResponse creates a response to parse from DescribeACLs response
func CreateDescribeACLsResponse() (response *DescribeACLsResponse) {
	response = &DescribeACLsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
