package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DowngradeSmartAccessGatewaySoftware invokes the smartag.DowngradeSmartAccessGatewaySoftware API synchronously
// api document: https://help.aliyun.com/api/smartag/downgradesmartaccessgatewaysoftware.html
func (client *Client) DowngradeSmartAccessGatewaySoftware(request *DowngradeSmartAccessGatewaySoftwareRequest) (response *DowngradeSmartAccessGatewaySoftwareResponse, err error) {
	response = CreateDowngradeSmartAccessGatewaySoftwareResponse()
	err = client.DoAction(request, response)
	return
}

// DowngradeSmartAccessGatewaySoftwareWithChan invokes the smartag.DowngradeSmartAccessGatewaySoftware API asynchronously
// api document: https://help.aliyun.com/api/smartag/downgradesmartaccessgatewaysoftware.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DowngradeSmartAccessGatewaySoftwareWithChan(request *DowngradeSmartAccessGatewaySoftwareRequest) (<-chan *DowngradeSmartAccessGatewaySoftwareResponse, <-chan error) {
	responseChan := make(chan *DowngradeSmartAccessGatewaySoftwareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DowngradeSmartAccessGatewaySoftware(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DowngradeSmartAccessGatewaySoftwareWithCallback invokes the smartag.DowngradeSmartAccessGatewaySoftware API asynchronously
// api document: https://help.aliyun.com/api/smartag/downgradesmartaccessgatewaysoftware.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DowngradeSmartAccessGatewaySoftwareWithCallback(request *DowngradeSmartAccessGatewaySoftwareRequest, callback func(response *DowngradeSmartAccessGatewaySoftwareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DowngradeSmartAccessGatewaySoftwareResponse
		var err error
		defer close(result)
		response, err = client.DowngradeSmartAccessGatewaySoftware(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DowngradeSmartAccessGatewaySoftwareRequest is the request struct for api DowngradeSmartAccessGatewaySoftware
type DowngradeSmartAccessGatewaySoftwareRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UserCount            requests.Integer `position:"Query" name:"UserCount"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	DataPlan             requests.Integer `position:"Query" name:"DataPlan"`
}

// DowngradeSmartAccessGatewaySoftwareResponse is the response struct for api DowngradeSmartAccessGatewaySoftware
type DowngradeSmartAccessGatewaySoftwareResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateDowngradeSmartAccessGatewaySoftwareRequest creates a request to invoke DowngradeSmartAccessGatewaySoftware API
func CreateDowngradeSmartAccessGatewaySoftwareRequest() (request *DowngradeSmartAccessGatewaySoftwareRequest) {
	request = &DowngradeSmartAccessGatewaySoftwareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DowngradeSmartAccessGatewaySoftware", "smartag", "openAPI")
	return
}

// CreateDowngradeSmartAccessGatewaySoftwareResponse creates a response to parse from DowngradeSmartAccessGatewaySoftware response
func CreateDowngradeSmartAccessGatewaySoftwareResponse() (response *DowngradeSmartAccessGatewaySoftwareResponse) {
	response = &DowngradeSmartAccessGatewaySoftwareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
