package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebootSmartAccessGateway invokes the smartag.RebootSmartAccessGateway API synchronously
// api document: https://help.aliyun.com/api/smartag/rebootsmartaccessgateway.html
func (client *Client) RebootSmartAccessGateway(request *RebootSmartAccessGatewayRequest) (response *RebootSmartAccessGatewayResponse, err error) {
	response = CreateRebootSmartAccessGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// RebootSmartAccessGatewayWithChan invokes the smartag.RebootSmartAccessGateway API asynchronously
// api document: https://help.aliyun.com/api/smartag/rebootsmartaccessgateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RebootSmartAccessGatewayWithChan(request *RebootSmartAccessGatewayRequest) (<-chan *RebootSmartAccessGatewayResponse, <-chan error) {
	responseChan := make(chan *RebootSmartAccessGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebootSmartAccessGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebootSmartAccessGatewayWithCallback invokes the smartag.RebootSmartAccessGateway API asynchronously
// api document: https://help.aliyun.com/api/smartag/rebootsmartaccessgateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RebootSmartAccessGatewayWithCallback(request *RebootSmartAccessGatewayRequest, callback func(response *RebootSmartAccessGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebootSmartAccessGatewayResponse
		var err error
		defer close(result)
		response, err = client.RebootSmartAccessGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebootSmartAccessGatewayRequest is the request struct for api RebootSmartAccessGateway
type RebootSmartAccessGatewayRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// RebootSmartAccessGatewayResponse is the response struct for api RebootSmartAccessGateway
type RebootSmartAccessGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRebootSmartAccessGatewayRequest creates a request to invoke RebootSmartAccessGateway API
func CreateRebootSmartAccessGatewayRequest() (request *RebootSmartAccessGatewayRequest) {
	request = &RebootSmartAccessGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "RebootSmartAccessGateway", "smartag", "openAPI")
	return
}

// CreateRebootSmartAccessGatewayResponse creates a response to parse from RebootSmartAccessGateway response
func CreateRebootSmartAccessGatewayResponse() (response *RebootSmartAccessGatewayResponse) {
	response = &RebootSmartAccessGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
