package xtrace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetToken invokes the xtrace.GetToken API synchronously
// api document: https://help.aliyun.com/api/xtrace/gettoken.html
func (client *Client) GetToken(request *GetTokenRequest) (response *GetTokenResponse, err error) {
	response = CreateGetTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetTokenWithChan invokes the xtrace.GetToken API asynchronously
// api document: https://help.aliyun.com/api/xtrace/gettoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTokenWithChan(request *GetTokenRequest) (<-chan *GetTokenResponse, <-chan error) {
	responseChan := make(chan *GetTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTokenWithCallback invokes the xtrace.GetToken API asynchronously
// api document: https://help.aliyun.com/api/xtrace/gettoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTokenWithCallback(request *GetTokenRequest, callback func(response *GetTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTokenResponse
		var err error
		defer close(result)
		response, err = client.GetToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTokenRequest is the request struct for api GetToken
type GetTokenRequest struct {
	*requests.RpcRequest
	AppType string `position:"Query" name:"AppType"`
}

// GetTokenResponse is the response struct for api GetToken
type GetTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Token     Token  `json:"Token" xml:"Token"`
}

// CreateGetTokenRequest creates a request to invoke GetToken API
func CreateGetTokenRequest() (request *GetTokenRequest) {
	request = &GetTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("xtrace", "2019-08-08", "GetToken", "xtrace", "openAPI")
	return
}

// CreateGetTokenResponse creates a response to parse from GetToken response
func CreateGetTokenResponse() (response *GetTokenResponse) {
	response = &GetTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
