package xtrace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIpOrHosts invokes the xtrace.ListIpOrHosts API synchronously
// api document: https://help.aliyun.com/api/xtrace/listiporhosts.html
func (client *Client) ListIpOrHosts(request *ListIpOrHostsRequest) (response *ListIpOrHostsResponse, err error) {
	response = CreateListIpOrHostsResponse()
	err = client.DoAction(request, response)
	return
}

// ListIpOrHostsWithChan invokes the xtrace.ListIpOrHosts API asynchronously
// api document: https://help.aliyun.com/api/xtrace/listiporhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListIpOrHostsWithChan(request *ListIpOrHostsRequest) (<-chan *ListIpOrHostsResponse, <-chan error) {
	responseChan := make(chan *ListIpOrHostsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIpOrHosts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIpOrHostsWithCallback invokes the xtrace.ListIpOrHosts API asynchronously
// api document: https://help.aliyun.com/api/xtrace/listiporhosts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListIpOrHostsWithCallback(request *ListIpOrHostsRequest, callback func(response *ListIpOrHostsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIpOrHostsResponse
		var err error
		defer close(result)
		response, err = client.ListIpOrHosts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIpOrHostsRequest is the request struct for api ListIpOrHosts
type ListIpOrHostsRequest struct {
	*requests.RpcRequest
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	ServiceName string           `position:"Query" name:"ServiceName"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
}

// ListIpOrHostsResponse is the response struct for api ListIpOrHosts
type ListIpOrHostsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	IpNames   IpNames `json:"IpNames" xml:"IpNames"`
}

// CreateListIpOrHostsRequest creates a request to invoke ListIpOrHosts API
func CreateListIpOrHostsRequest() (request *ListIpOrHostsRequest) {
	request = &ListIpOrHostsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("xtrace", "2019-08-08", "ListIpOrHosts", "xtrace", "openAPI")
	return
}

// CreateListIpOrHostsResponse creates a response to parse from ListIpOrHosts response
func CreateListIpOrHostsResponse() (response *ListIpOrHostsResponse) {
	response = &ListIpOrHostsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
