package yundun_bastionhost

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGrant invokes the yundun_bastionhost.DescribeGrant API synchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describegrant.html
func (client *Client) DescribeGrant(request *DescribeGrantRequest) (response *DescribeGrantResponse, err error) {
	response = CreateDescribeGrantResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGrantWithChan invokes the yundun_bastionhost.DescribeGrant API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describegrant.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGrantWithChan(request *DescribeGrantRequest) (<-chan *DescribeGrantResponse, <-chan error) {
	responseChan := make(chan *DescribeGrantResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGrant(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGrantWithCallback invokes the yundun_bastionhost.DescribeGrant API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describegrant.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGrantWithCallback(request *DescribeGrantRequest, callback func(response *DescribeGrantResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGrantResponse
		var err error
		defer close(result)
		response, err = client.DescribeGrant(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGrantRequest is the request struct for api DescribeGrant
type DescribeGrantRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeGrantResponse is the response struct for api DescribeGrant
type DescribeGrantResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	EntityRoleGrant bool   `json:"EntityRoleGrant" xml:"EntityRoleGrant"`
}

// CreateDescribeGrantRequest creates a request to invoke DescribeGrant API
func CreateDescribeGrantRequest() (request *DescribeGrantRequest) {
	request = &DescribeGrantRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-bastionhost", "2018-10-10", "DescribeGrant", "bastionhost", "openAPI")
	return
}

// CreateDescribeGrantResponse creates a response to parse from DescribeGrant response
func CreateDescribeGrantResponse() (response *DescribeGrantResponse) {
	response = &DescribeGrantResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
