package yundun_bastionhost

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TagResourcesSystemTags invokes the yundun_bastionhost.TagResourcesSystemTags API synchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/tagresourcessystemtags.html
func (client *Client) TagResourcesSystemTags(request *TagResourcesSystemTagsRequest) (response *TagResourcesSystemTagsResponse, err error) {
	response = CreateTagResourcesSystemTagsResponse()
	err = client.DoAction(request, response)
	return
}

// TagResourcesSystemTagsWithChan invokes the yundun_bastionhost.TagResourcesSystemTags API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/tagresourcessystemtags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TagResourcesSystemTagsWithChan(request *TagResourcesSystemTagsRequest) (<-chan *TagResourcesSystemTagsResponse, <-chan error) {
	responseChan := make(chan *TagResourcesSystemTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TagResourcesSystemTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TagResourcesSystemTagsWithCallback invokes the yundun_bastionhost.TagResourcesSystemTags API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/tagresourcessystemtags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TagResourcesSystemTagsWithCallback(request *TagResourcesSystemTagsRequest, callback func(response *TagResourcesSystemTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TagResourcesSystemTagsResponse
		var err error
		defer close(result)
		response, err = client.TagResourcesSystemTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TagResourcesSystemTagsRequest is the request struct for api TagResourcesSystemTags
type TagResourcesSystemTagsRequest struct {
	*requests.RpcRequest
	ResourceId   *[]string                    `position:"Query" name:"ResourceId"  type:"Repeated"`
	ResourceType string                       `position:"Query" name:"ResourceType"`
	SourceIp     string                       `position:"Query" name:"SourceIp"`
	Tag          *[]TagResourcesSystemTagsTag `position:"Query" name:"Tag"  type:"Repeated"`
}

// TagResourcesSystemTagsTag is a repeated param struct in TagResourcesSystemTagsRequest
type TagResourcesSystemTagsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// TagResourcesSystemTagsResponse is the response struct for api TagResourcesSystemTags
type TagResourcesSystemTagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateTagResourcesSystemTagsRequest creates a request to invoke TagResourcesSystemTags API
func CreateTagResourcesSystemTagsRequest() (request *TagResourcesSystemTagsRequest) {
	request = &TagResourcesSystemTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-bastionhost", "2018-10-10", "TagResourcesSystemTags", "bastionhost", "openAPI")
	return
}

// CreateTagResourcesSystemTagsResponse creates a response to parse from TagResourcesSystemTags response
func CreateTagResourcesSystemTagsResponse() (response *TagResourcesSystemTagsResponse) {
	response = &TagResourcesSystemTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
