// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStackRequest
type BatchAssociateUserStackInput struct {
	_ struct{} `type:"structure"`

	// The list of UserStackAssociation objects.
	//
	// UserStackAssociations is a required field
	UserStackAssociations []UserStackAssociation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchAssociateUserStackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateUserStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchAssociateUserStackInput"}

	if s.UserStackAssociations == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserStackAssociations"))
	}
	if s.UserStackAssociations != nil && len(s.UserStackAssociations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserStackAssociations", 1))
	}
	if s.UserStackAssociations != nil {
		for i, v := range s.UserStackAssociations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserStackAssociations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStackResult
type BatchAssociateUserStackOutput struct {
	_ struct{} `type:"structure"`

	// The list of UserStackAssociationError objects.
	Errors []UserStackAssociationError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchAssociateUserStackOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchAssociateUserStack = "BatchAssociateUserStack"

// BatchAssociateUserStackRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Associates the specified users with the specified stacks. Users in a user
// pool cannot be assigned to stacks with fleets that are joined to an Active
// Directory domain.
//
//    // Example sending a request using BatchAssociateUserStackRequest.
//    req := client.BatchAssociateUserStackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStack
func (c *Client) BatchAssociateUserStackRequest(input *BatchAssociateUserStackInput) BatchAssociateUserStackRequest {
	op := &aws.Operation{
		Name:       opBatchAssociateUserStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchAssociateUserStackInput{}
	}

	req := c.newRequest(op, input, &BatchAssociateUserStackOutput{})
	return BatchAssociateUserStackRequest{Request: req, Input: input, Copy: c.BatchAssociateUserStackRequest}
}

// BatchAssociateUserStackRequest is the request type for the
// BatchAssociateUserStack API operation.
type BatchAssociateUserStackRequest struct {
	*aws.Request
	Input *BatchAssociateUserStackInput
	Copy  func(*BatchAssociateUserStackInput) BatchAssociateUserStackRequest
}

// Send marshals and sends the BatchAssociateUserStack API request.
func (r BatchAssociateUserStackRequest) Send(ctx context.Context) (*BatchAssociateUserStackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchAssociateUserStackResponse{
		BatchAssociateUserStackOutput: r.Request.Data.(*BatchAssociateUserStackOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchAssociateUserStackResponse is the response type for the
// BatchAssociateUserStack API operation.
type BatchAssociateUserStackResponse struct {
	*BatchAssociateUserStackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchAssociateUserStack request.
func (r *BatchAssociateUserStackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
