// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypesInput
type DescribeTerminationPolicyTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeTerminationPolicyTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypesAnswer
type DescribeTerminationPolicyTypesOutput struct {
	_ struct{} `type:"structure"`

	// The termination policies supported by Amazon EC2 Auto Scaling: OldestInstance,
	// OldestLaunchConfiguration, NewestInstance, ClosestToNextInstanceHour, Default,
	// OldestLaunchTemplate, and AllocationStrategy.
	TerminationPolicyTypes []string `type:"list"`
}

// String returns the string representation
func (s DescribeTerminationPolicyTypesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTerminationPolicyTypes = "DescribeTerminationPolicyTypes"

// DescribeTerminationPolicyTypesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Describes the termination policies supported by Amazon EC2 Auto Scaling.
//
// For more information, see Controlling Which Auto Scaling Instances Terminate
// During Scale In (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using DescribeTerminationPolicyTypesRequest.
//    req := client.DescribeTerminationPolicyTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes
func (c *Client) DescribeTerminationPolicyTypesRequest(input *DescribeTerminationPolicyTypesInput) DescribeTerminationPolicyTypesRequest {
	op := &aws.Operation{
		Name:       opDescribeTerminationPolicyTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTerminationPolicyTypesInput{}
	}

	req := c.newRequest(op, input, &DescribeTerminationPolicyTypesOutput{})
	return DescribeTerminationPolicyTypesRequest{Request: req, Input: input, Copy: c.DescribeTerminationPolicyTypesRequest}
}

// DescribeTerminationPolicyTypesRequest is the request type for the
// DescribeTerminationPolicyTypes API operation.
type DescribeTerminationPolicyTypesRequest struct {
	*aws.Request
	Input *DescribeTerminationPolicyTypesInput
	Copy  func(*DescribeTerminationPolicyTypesInput) DescribeTerminationPolicyTypesRequest
}

// Send marshals and sends the DescribeTerminationPolicyTypes API request.
func (r DescribeTerminationPolicyTypesRequest) Send(ctx context.Context) (*DescribeTerminationPolicyTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTerminationPolicyTypesResponse{
		DescribeTerminationPolicyTypesOutput: r.Request.Data.(*DescribeTerminationPolicyTypesOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTerminationPolicyTypesResponse is the response type for the
// DescribeTerminationPolicyTypes API operation.
type DescribeTerminationPolicyTypesResponse struct {
	*DescribeTerminationPolicyTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTerminationPolicyTypes request.
func (r *DescribeTerminationPolicyTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
