// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachTypedLinkRequest
type DetachTypedLinkInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the directory where you want to detach
	// the typed link.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// Used to accept a typed link specifier as input.
	//
	// TypedLinkSpecifier is a required field
	TypedLinkSpecifier *TypedLinkSpecifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetachTypedLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachTypedLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachTypedLinkInput"}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}

	if s.TypedLinkSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("TypedLinkSpecifier"))
	}
	if s.TypedLinkSpecifier != nil {
		if err := s.TypedLinkSpecifier.Validate(); err != nil {
			invalidParams.AddNested("TypedLinkSpecifier", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachTypedLinkInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.TypedLinkSpecifier != nil {
		v := s.TypedLinkSpecifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TypedLinkSpecifier", v, metadata)
	}
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachTypedLinkOutput
type DetachTypedLinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachTypedLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachTypedLinkOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDetachTypedLink = "DetachTypedLink"

// DetachTypedLinkRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Detaches a typed link from a specified source and target object. For more
// information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
//
//    // Example sending a request using DetachTypedLinkRequest.
//    req := client.DetachTypedLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachTypedLink
func (c *Client) DetachTypedLinkRequest(input *DetachTypedLinkInput) DetachTypedLinkRequest {
	op := &aws.Operation{
		Name:       opDetachTypedLink,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/detach",
	}

	if input == nil {
		input = &DetachTypedLinkInput{}
	}

	req := c.newRequest(op, input, &DetachTypedLinkOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DetachTypedLinkRequest{Request: req, Input: input, Copy: c.DetachTypedLinkRequest}
}

// DetachTypedLinkRequest is the request type for the
// DetachTypedLink API operation.
type DetachTypedLinkRequest struct {
	*aws.Request
	Input *DetachTypedLinkInput
	Copy  func(*DetachTypedLinkInput) DetachTypedLinkRequest
}

// Send marshals and sends the DetachTypedLink API request.
func (r DetachTypedLinkRequest) Send(ctx context.Context) (*DetachTypedLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachTypedLinkResponse{
		DetachTypedLinkOutput: r.Request.Data.(*DetachTypedLinkOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachTypedLinkResponse is the response type for the
// DetachTypedLink API operation.
type DetachTypedLinkResponse struct {
	*DetachTypedLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachTypedLink request.
func (r *DetachTypedLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
