// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetDirectoryRequest
type GetDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the directory.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDirectoryInput"}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDirectoryInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetDirectoryResponse
type GetDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// Metadata about the directory.
	//
	// Directory is a required field
	Directory *Directory `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDirectoryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Directory != nil {
		v := s.Directory

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Directory", v, metadata)
	}
	return nil
}

const opGetDirectory = "GetDirectory"

// GetDirectoryRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Retrieves metadata about a directory.
//
//    // Example sending a request using GetDirectoryRequest.
//    req := client.GetDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetDirectory
func (c *Client) GetDirectoryRequest(input *GetDirectoryInput) GetDirectoryRequest {
	op := &aws.Operation{
		Name:       opGetDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/directory/get",
	}

	if input == nil {
		input = &GetDirectoryInput{}
	}

	req := c.newRequest(op, input, &GetDirectoryOutput{})
	return GetDirectoryRequest{Request: req, Input: input, Copy: c.GetDirectoryRequest}
}

// GetDirectoryRequest is the request type for the
// GetDirectory API operation.
type GetDirectoryRequest struct {
	*aws.Request
	Input *GetDirectoryInput
	Copy  func(*GetDirectoryInput) GetDirectoryRequest
}

// Send marshals and sends the GetDirectory API request.
func (r GetDirectoryRequest) Send(ctx context.Context) (*GetDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDirectoryResponse{
		GetDirectoryOutput: r.Request.Data.(*GetDirectoryOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDirectoryResponse is the response type for the
// GetDirectory API operation.
type GetDirectoryResponse struct {
	*GetDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDirectory request.
func (r *GetDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
