// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DeletePublicKeyRequest
type DeletePublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the public key you want to remove from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the public
	// key identity to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeletePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePublicKeyInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePublicKeyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DeletePublicKeyOutput
type DeletePublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePublicKeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePublicKey = "DeletePublicKey2018_11_05"

// DeletePublicKeyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Remove a public key you previously added to CloudFront.
//
//    // Example sending a request using DeletePublicKeyRequest.
//    req := client.DeletePublicKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DeletePublicKey
func (c *Client) DeletePublicKeyRequest(input *DeletePublicKeyInput) DeletePublicKeyRequest {
	op := &aws.Operation{
		Name:       opDeletePublicKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2018-11-05/public-key/{Id}",
	}

	if input == nil {
		input = &DeletePublicKeyInput{}
	}

	req := c.newRequest(op, input, &DeletePublicKeyOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeletePublicKeyRequest{Request: req, Input: input, Copy: c.DeletePublicKeyRequest}
}

// DeletePublicKeyRequest is the request type for the
// DeletePublicKey API operation.
type DeletePublicKeyRequest struct {
	*aws.Request
	Input *DeletePublicKeyInput
	Copy  func(*DeletePublicKeyInput) DeletePublicKeyRequest
}

// Send marshals and sends the DeletePublicKey API request.
func (r DeletePublicKeyRequest) Send(ctx context.Context) (*DeletePublicKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePublicKeyResponse{
		DeletePublicKeyOutput: r.Request.Data.(*DeletePublicKeyOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePublicKeyResponse is the response type for the
// DeletePublicKey API operation.
type DeletePublicKeyResponse struct {
	*DeletePublicKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePublicKey request.
func (r *DeletePublicKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
