// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Returns information about a specific Git blob object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BlobMetadata
type BlobMetadata struct {
	_ struct{} `type:"structure"`

	// The full ID of the blob.
	BlobId *string `locationName:"blobId" type:"string"`

	// The file mode permissions of the blob. File mode permission codes include:
	//
	//    * 100644 indicates read/write
	//
	//    * 100755 indicates read/write/execute
	//
	//    * 160000 indicates a submodule
	//
	//    * 120000 indicates a symlink
	Mode *string `locationName:"mode" type:"string"`

	// The path to the blob and any associated file name, if any.
	Path *string `locationName:"path" type:"string"`
}

// String returns the string representation
func (s BlobMetadata) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a branch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BranchInfo
type BranchInfo struct {
	_ struct{} `type:"structure"`

	// The name of the branch.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The ID of the last commit made to the branch.
	CommitId *string `locationName:"commitId" type:"string"`
}

// String returns the string representation
func (s BranchInfo) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a specific comment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Comment
type Comment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the person who posted the comment.
	AuthorArn *string `locationName:"authorArn" type:"string"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The system-generated comment ID.
	CommentId *string `locationName:"commentId" type:"string"`

	// The content of the comment.
	Content *string `locationName:"content" type:"string"`

	// The date and time the comment was created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// A Boolean value indicating whether the comment has been deleted.
	Deleted *bool `locationName:"deleted" type:"boolean"`

	// The ID of the comment for which this comment is a reply, if any.
	InReplyTo *string `locationName:"inReplyTo" type:"string"`

	// The date and time the comment was most recently modified, in timestamp format.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Comment) String() string {
	return awsutil.Prettify(s)
}

// Returns information about comments on the comparison between two commits.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CommentsForComparedCommit
type CommentsForComparedCommit struct {
	_ struct{} `type:"structure"`

	// The full blob ID of the commit used to establish the 'after' of the comparison.
	AfterBlobId *string `locationName:"afterBlobId" type:"string"`

	// The full commit ID of the commit used to establish the 'after' of the comparison.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// The full blob ID of the commit used to establish the 'before' of the comparison.
	BeforeBlobId *string `locationName:"beforeBlobId" type:"string"`

	// The full commit ID of the commit used to establish the 'before' of the comparison.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// An array of comment objects. Each comment object contains information about
	// a comment on the comparison between commits.
	Comments []Comment `locationName:"comments" type:"list"`

	// Location information about the comment on the comparison, including the file
	// name, line number, and whether the version of the file where the comment
	// was made is 'BEFORE' or 'AFTER'.
	Location *Location `locationName:"location" type:"structure"`

	// The name of the repository that contains the compared commits.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s CommentsForComparedCommit) String() string {
	return awsutil.Prettify(s)
}

// Returns information about comments on a pull request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CommentsForPullRequest
type CommentsForPullRequest struct {
	_ struct{} `type:"structure"`

	// The full blob ID of the file on which you want to comment on the source commit.
	AfterBlobId *string `locationName:"afterBlobId" type:"string"`

	// he full commit ID of the commit that was the tip of the source branch at
	// the time the comment was made.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// The full blob ID of the file on which you want to comment on the destination
	// commit.
	BeforeBlobId *string `locationName:"beforeBlobId" type:"string"`

	// The full commit ID of the commit that was the tip of the destination branch
	// when the pull request was created. This commit will be superceded by the
	// after commit in the source branch when and if you merge the source branch
	// into the destination branch.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// An array of comment objects. Each comment object contains information about
	// a comment on the pull request.
	Comments []Comment `locationName:"comments" type:"list"`

	// Location information about the comment on the pull request, including the
	// file name, line number, and whether the version of the file where the comment
	// was made is 'BEFORE' (destination branch) or 'AFTER' (source branch).
	Location *Location `locationName:"location" type:"structure"`

	// The system-generated ID of the pull request.
	PullRequestId *string `locationName:"pullRequestId" type:"string"`

	// The name of the repository that contains the pull request.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s CommentsForPullRequest) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a specific commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Commit
type Commit struct {
	_ struct{} `type:"structure"`

	// Any additional data associated with the specified commit.
	AdditionalData *string `locationName:"additionalData" type:"string"`

	// Information about the author of the specified commit. Information includes
	// the date in timestamp format with GMT offset, the name of the author, and
	// the email address for the author, as configured in Git.
	Author *UserInfo `locationName:"author" type:"structure"`

	// The full SHA of the specified commit.
	CommitId *string `locationName:"commitId" type:"string"`

	// Information about the person who committed the specified commit, also known
	// as the committer. Information includes the date in timestamp format with
	// GMT offset, the name of the committer, and the email address for the committer,
	// as configured in Git.
	//
	// For more information about the difference between an author and a committer
	// in Git, see Viewing the Commit History (http://git-scm.com/book/ch2-3.html)
	// in Pro Git by Scott Chacon and Ben Straub.
	Committer *UserInfo `locationName:"committer" type:"structure"`

	// The commit message associated with the specified commit.
	Message *string `locationName:"message" type:"string"`

	// A list of parent commits for the specified commit. Each parent commit ID
	// is the full commit ID.
	Parents []string `locationName:"parents" type:"list"`

	// Tree information for the specified commit.
	TreeId *string `locationName:"treeId" type:"string"`
}

// String returns the string representation
func (s Commit) String() string {
	return awsutil.Prettify(s)
}

// A file that will be deleted as part of a commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteFileEntry
type DeleteFileEntry struct {
	_ struct{} `type:"structure"`

	// The full path of the file that will be deleted, including the name of the
	// file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFileEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFileEntry"}

	if s.FilePath == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilePath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns information about a set of differences for a commit specifier.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Difference
type Difference struct {
	_ struct{} `type:"structure"`

	// Information about an afterBlob data type object, including the ID, the file
	// mode permission code, and the path.
	AfterBlob *BlobMetadata `locationName:"afterBlob" type:"structure"`

	// Information about a beforeBlob data type object, including the ID, the file
	// mode permission code, and the path.
	BeforeBlob *BlobMetadata `locationName:"beforeBlob" type:"structure"`

	// Whether the change type of the difference is an addition (A), deletion (D),
	// or modification (M).
	ChangeType ChangeTypeEnum `locationName:"changeType" type:"string" enum:"true"`
}

// String returns the string representation
func (s Difference) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a file in a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/File
type File struct {
	_ struct{} `type:"structure"`

	// The fully-qualified path to the file in the repository.
	AbsolutePath *string `locationName:"absolutePath" type:"string"`

	// The blob ID that contains the file information.
	BlobId *string `locationName:"blobId" type:"string"`

	// The extrapolated file mode permissions for the file. Valid values include
	// EXECUTABLE and NORMAL.
	FileMode FileModeTypeEnum `locationName:"fileMode" type:"string" enum:"true"`

	// The relative path of the file from the folder where the query originated.
	RelativePath *string `locationName:"relativePath" type:"string"`
}

// String returns the string representation
func (s File) String() string {
	return awsutil.Prettify(s)
}

// A file that will be added, updated, or deleted as part of a commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/FileMetadata
type FileMetadata struct {
	_ struct{} `type:"structure"`

	// The full path to the file that will be added or updated, including the name
	// of the file.
	AbsolutePath *string `locationName:"absolutePath" type:"string"`

	// The blob ID that contains the file information.
	BlobId *string `locationName:"blobId" type:"string"`

	// The extrapolated file mode permissions for the file. Valid values include
	// EXECUTABLE and NORMAL.
	FileMode FileModeTypeEnum `locationName:"fileMode" type:"string" enum:"true"`
}

// String returns the string representation
func (s FileMetadata) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a folder in a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Folder
type Folder struct {
	_ struct{} `type:"structure"`

	// The fully-qualified path of the folder in the repository.
	AbsolutePath *string `locationName:"absolutePath" type:"string"`

	// The relative path of the specified folder from the folder where the query
	// originated.
	RelativePath *string `locationName:"relativePath" type:"string"`

	// The full SHA-1 pointer of the tree information for the commit that contains
	// the folder.
	TreeId *string `locationName:"treeId" type:"string"`
}

// String returns the string representation
func (s Folder) String() string {
	return awsutil.Prettify(s)
}

// Returns information about the location of a change or comment in the comparison
// between two commits or a pull request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Location
type Location struct {
	_ struct{} `type:"structure"`

	// The name of the file being compared, including its extension and subdirectory,
	// if any.
	FilePath *string `locationName:"filePath" type:"string"`

	// The position of a change within a compared file, in line number format.
	FilePosition *int64 `locationName:"filePosition" type:"long"`

	// In a comparison of commits or a pull request, whether the change is in the
	// 'before' or 'after' of that comparison.
	RelativeFileVersion RelativeFileVersionEnum `locationName:"relativeFileVersion" type:"string" enum:"true"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a merge or potential merge between a source reference
// and a destination reference in a pull request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeMetadata
type MergeMetadata struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether the merge has been made.
	IsMerged *bool `locationName:"isMerged" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user who merged the branches.
	MergedBy *string `locationName:"mergedBy" type:"string"`
}

// String returns the string representation
func (s MergeMetadata) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a pull request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequest
type PullRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user who created the pull request.
	AuthorArn *string `locationName:"authorArn" type:"string"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The date and time the pull request was originally created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The user-defined description of the pull request. This description can be
	// used to clarify what should be reviewed and other details of the request.
	Description *string `locationName:"description" type:"string"`

	// The day and time of the last user or system activity on the pull request,
	// in timestamp format.
	LastActivityDate *time.Time `locationName:"lastActivityDate" type:"timestamp" timestampFormat:"unix"`

	// The system-generated ID of the pull request.
	PullRequestId *string `locationName:"pullRequestId" type:"string"`

	// The status of the pull request. Pull request status can only change from
	// OPEN to CLOSED.
	PullRequestStatus PullRequestStatusEnum `locationName:"pullRequestStatus" type:"string" enum:"true"`

	// The targets of the pull request, including the source branch and destination
	// branch for the pull request.
	PullRequestTargets []PullRequestTarget `locationName:"pullRequestTargets" type:"list"`

	// The user-defined title of the pull request. This title is displayed in the
	// list of pull requests to other users of the repository.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation
func (s PullRequest) String() string {
	return awsutil.Prettify(s)
}

// Metadata about the pull request that is used when comparing the pull request
// source with its destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequestCreatedEventMetadata
type PullRequestCreatedEventMetadata struct {
	_ struct{} `type:"structure"`

	// The commit ID of the tip of the branch specified as the destination branch
	// when the pull request was created.
	DestinationCommitId *string `locationName:"destinationCommitId" type:"string"`

	// The commit ID of the most recent commit that the source branch and the destination
	// branch have in common.
	MergeBase *string `locationName:"mergeBase" type:"string"`

	// The name of the repository where the pull request was created.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`

	// The commit ID on the source branch used when the pull request was created.
	SourceCommitId *string `locationName:"sourceCommitId" type:"string"`
}

// String returns the string representation
func (s PullRequestCreatedEventMetadata) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a pull request event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequestEvent
type PullRequestEvent struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user whose actions resulted in the
	// event. Examples include updating the pull request with additional commits
	// or changing the status of a pull request.
	ActorArn *string `locationName:"actorArn" type:"string"`

	// The day and time of the pull request event, in timestamp format.
	EventDate *time.Time `locationName:"eventDate" type:"timestamp" timestampFormat:"unix"`

	// Information about the source and destination branches for the pull request.
	PullRequestCreatedEventMetadata *PullRequestCreatedEventMetadata `locationName:"pullRequestCreatedEventMetadata" type:"structure"`

	// The type of the pull request event, for example a status change event (PULL_REQUEST_STATUS_CHANGED)
	// or update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED).
	PullRequestEventType PullRequestEventType `locationName:"pullRequestEventType" type:"string" enum:"true"`

	// The system-generated ID of the pull request.
	PullRequestId *string `locationName:"pullRequestId" type:"string"`

	// Information about the change in mergability state for the pull request event.
	PullRequestMergedStateChangedEventMetadata *PullRequestMergedStateChangedEventMetadata `locationName:"pullRequestMergedStateChangedEventMetadata" type:"structure"`

	// Information about the updated source branch for the pull request event.
	PullRequestSourceReferenceUpdatedEventMetadata *PullRequestSourceReferenceUpdatedEventMetadata `locationName:"pullRequestSourceReferenceUpdatedEventMetadata" type:"structure"`

	// Information about the change in status for the pull request event.
	PullRequestStatusChangedEventMetadata *PullRequestStatusChangedEventMetadata `locationName:"pullRequestStatusChangedEventMetadata" type:"structure"`
}

// String returns the string representation
func (s PullRequestEvent) String() string {
	return awsutil.Prettify(s)
}

// Returns information about the change in the merge state for a pull request
// event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequestMergedStateChangedEventMetadata
type PullRequestMergedStateChangedEventMetadata struct {
	_ struct{} `type:"structure"`

	// The name of the branch that the pull request will be merged into.
	DestinationReference *string `locationName:"destinationReference" type:"string"`

	// Information about the merge state change event.
	MergeMetadata *MergeMetadata `locationName:"mergeMetadata" type:"structure"`

	// The name of the repository where the pull request was created.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s PullRequestMergedStateChangedEventMetadata) String() string {
	return awsutil.Prettify(s)
}

// Information about an update to the source branch of a pull request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequestSourceReferenceUpdatedEventMetadata
type PullRequestSourceReferenceUpdatedEventMetadata struct {
	_ struct{} `type:"structure"`

	// The full commit ID of the commit in the source branch that was the tip of
	// the branch at the time the pull request was updated.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// The full commit ID of the commit in the destination branch that was the tip
	// of the branch at the time the pull request was updated.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// The commit ID of the most recent commit that the source branch and the destination
	// branch have in common.
	MergeBase *string `locationName:"mergeBase" type:"string"`

	// The name of the repository where the pull request was updated.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s PullRequestSourceReferenceUpdatedEventMetadata) String() string {
	return awsutil.Prettify(s)
}

// Information about a change to the status of a pull request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequestStatusChangedEventMetadata
type PullRequestStatusChangedEventMetadata struct {
	_ struct{} `type:"structure"`

	// The changed status of the pull request.
	PullRequestStatus PullRequestStatusEnum `locationName:"pullRequestStatus" type:"string" enum:"true"`
}

// String returns the string representation
func (s PullRequestStatusChangedEventMetadata) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a pull request target.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequestTarget
type PullRequestTarget struct {
	_ struct{} `type:"structure"`

	// The full commit ID that is the tip of the destination branch. This is the
	// commit where the pull request was or will be merged.
	DestinationCommit *string `locationName:"destinationCommit" type:"string"`

	// The branch of the repository where the pull request changes will be merged
	// into. Also known as the destination branch.
	DestinationReference *string `locationName:"destinationReference" type:"string"`

	// The commit ID of the most recent commit that the source branch and the destination
	// branch have in common.
	MergeBase *string `locationName:"mergeBase" type:"string"`

	// Returns metadata about the state of the merge, including whether the merge
	// has been made.
	MergeMetadata *MergeMetadata `locationName:"mergeMetadata" type:"structure"`

	// The name of the repository that contains the pull request source and destination
	// branches.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`

	// The full commit ID of the tip of the source branch used to create the pull
	// request. If the pull request branch is updated by a push while the pull request
	// is open, the commit ID will change to reflect the new tip of the branch.
	SourceCommit *string `locationName:"sourceCommit" type:"string"`

	// The branch of the repository that contains the changes for the pull request.
	// Also known as the source branch.
	SourceReference *string `locationName:"sourceReference" type:"string"`
}

// String returns the string representation
func (s PullRequestTarget) String() string {
	return awsutil.Prettify(s)
}

// Information about a file that will be added or updated as part of a commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutFileEntry
type PutFileEntry struct {
	_ struct{} `type:"structure"`

	// The content of the file, if a source file is not specified.
	//
	// FileContent is automatically base64 encoded/decoded by the SDK.
	FileContent []byte `locationName:"fileContent" type:"blob"`

	// The extrapolated file mode permissions for the file. Valid values include
	// EXECUTABLE and NORMAL.
	FileMode FileModeTypeEnum `locationName:"fileMode" type:"string" enum:"true"`

	// The full path to the file in the repository, including the name of the file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" type:"string" required:"true"`

	// The name and full path of the file that contains the changes you want to
	// make as part of the commit, if you are not providing the file content directly.
	SourceFile *SourceFileSpecifier `locationName:"sourceFile" type:"structure"`
}

// String returns the string representation
func (s PutFileEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFileEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutFileEntry"}

	if s.FilePath == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilePath"))
	}
	if s.SourceFile != nil {
		if err := s.SourceFile.Validate(); err != nil {
			invalidParams.AddNested("SourceFile", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryMetadata
type RepositoryMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account associated with the repository.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the repository.
	Arn *string `type:"string"`

	// The URL to use for cloning the repository over HTTPS.
	CloneUrlHttp *string `locationName:"cloneUrlHttp" type:"string"`

	// The URL to use for cloning the repository over SSH.
	CloneUrlSsh *string `locationName:"cloneUrlSsh" type:"string"`

	// The date and time the repository was created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The repository's default branch name.
	DefaultBranch *string `locationName:"defaultBranch" min:"1" type:"string"`

	// The date and time the repository was last modified, in timestamp format.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// A comment or description about the repository.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The ID of the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The repository's name.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryMetadata) String() string {
	return awsutil.Prettify(s)
}

// Information about a repository name and ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryNameIdPair
type RepositoryNameIdPair struct {
	_ struct{} `type:"structure"`

	// The ID associated with the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The name associated with the repository.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryNameIdPair) String() string {
	return awsutil.Prettify(s)
}

// Information about a trigger for a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryTrigger
type RepositoryTrigger struct {
	_ struct{} `type:"structure"`

	// The branches that will be included in the trigger configuration. If you specify
	// an empty array, the trigger will apply to all branches.
	//
	// While no content is required in the array, you must include the array itself.
	Branches []string `locationName:"branches" type:"list"`

	// Any custom data associated with the trigger that will be included in the
	// information sent to the target of the trigger.
	CustomData *string `locationName:"customData" type:"string"`

	// The ARN of the resource that is the target for a trigger. For example, the
	// ARN of a topic in Amazon Simple Notification Service (SNS).
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" type:"string" required:"true"`

	// The repository events that will cause the trigger to run actions in another
	// service, such as sending a notification through Amazon Simple Notification
	// Service (SNS).
	//
	// The valid value "all" cannot be used with any other values.
	//
	// Events is a required field
	Events []RepositoryTriggerEventEnum `locationName:"events" type:"list" required:"true"`

	// The name of the trigger.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s RepositoryTrigger) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryTrigger) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RepositoryTrigger"}

	if s.DestinationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationArn"))
	}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A trigger failed to run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryTriggerExecutionFailure
type RepositoryTriggerExecutionFailure struct {
	_ struct{} `type:"structure"`

	// Additional message information about the trigger that did not run.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The name of the trigger that did not run.
	Trigger *string `locationName:"trigger" type:"string"`
}

// String returns the string representation
func (s RepositoryTriggerExecutionFailure) String() string {
	return awsutil.Prettify(s)
}

// Information about the file mode changes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/SetFileModeEntry
type SetFileModeEntry struct {
	_ struct{} `type:"structure"`

	// The file mode for the file.
	//
	// FileMode is a required field
	FileMode FileModeTypeEnum `locationName:"fileMode" type:"string" required:"true" enum:"true"`

	// The full path to the file, including the name of the file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" type:"string" required:"true"`
}

// String returns the string representation
func (s SetFileModeEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetFileModeEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetFileModeEntry"}
	if len(s.FileMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FileMode"))
	}

	if s.FilePath == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilePath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a source file that is part of changes made in a commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/SourceFileSpecifier
type SourceFileSpecifier struct {
	_ struct{} `type:"structure"`

	// The full path to the file, including the name of the file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" type:"string" required:"true"`

	// Whether to remove the source file from the parent commit.
	IsMove *bool `locationName:"isMove" type:"boolean"`
}

// String returns the string representation
func (s SourceFileSpecifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceFileSpecifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceFileSpecifier"}

	if s.FilePath == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilePath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns information about a submodule reference in a repository folder.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/SubModule
type SubModule struct {
	_ struct{} `type:"structure"`

	// The fully qualified path to the folder that contains the reference to the
	// submodule.
	AbsolutePath *string `locationName:"absolutePath" type:"string"`

	// The commit ID that contains the reference to the submodule.
	CommitId *string `locationName:"commitId" type:"string"`

	// The relative path of the submodule from the folder where the query originated.
	RelativePath *string `locationName:"relativePath" type:"string"`
}

// String returns the string representation
func (s SubModule) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a symbolic link in a repository folder.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/SymbolicLink
type SymbolicLink struct {
	_ struct{} `type:"structure"`

	// The fully-qualified path to the folder that contains the symbolic link.
	AbsolutePath *string `locationName:"absolutePath" type:"string"`

	// The blob ID that contains the information about the symbolic link.
	BlobId *string `locationName:"blobId" type:"string"`

	// The file mode permissions of the blob that cotains information about the
	// symbolic link.
	FileMode FileModeTypeEnum `locationName:"fileMode" type:"string" enum:"true"`

	// The relative path of the symbolic link from the folder where the query originated.
	RelativePath *string `locationName:"relativePath" type:"string"`
}

// String returns the string representation
func (s SymbolicLink) String() string {
	return awsutil.Prettify(s)
}

// Returns information about a target for a pull request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Target
type Target struct {
	_ struct{} `type:"structure"`

	// The branch of the repository where the pull request changes will be merged
	// into. Also known as the destination branch.
	DestinationReference *string `locationName:"destinationReference" type:"string"`

	// The name of the repository that contains the pull request.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The branch of the repository that contains the changes for the pull request.
	// Also known as the source branch.
	//
	// SourceReference is a required field
	SourceReference *string `locationName:"sourceReference" type:"string" required:"true"`
}

// String returns the string representation
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Target"}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if s.SourceReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the user who made a specified commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UserInfo
type UserInfo struct {
	_ struct{} `type:"structure"`

	// The date when the specified commit was commited, in timestamp format with
	// GMT offset.
	Date *string `locationName:"date" type:"string"`

	// The email address associated with the user who made the commit, if any.
	Email *string `locationName:"email" type:"string"`

	// The name of the user who made the specified commit.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UserInfo) String() string {
	return awsutil.Prettify(s)
}
