// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the request to delete a user pool client.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClientRequest
type DeleteUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The app client ID of the app associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool where you want to delete the client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolClientInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteUserPoolClientInput"}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClientOutput
type DeleteUserPoolClientOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteUserPoolClient = "DeleteUserPoolClient"

// DeleteUserPoolClientRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Allows the developer to delete the user pool client.
//
//    // Example sending a request using DeleteUserPoolClientRequest.
//    req := client.DeleteUserPoolClientRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient
func (c *Client) DeleteUserPoolClientRequest(input *DeleteUserPoolClientInput) DeleteUserPoolClientRequest {
	op := &aws.Operation{
		Name:       opDeleteUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolClientInput{}
	}

	req := c.newRequest(op, input, &DeleteUserPoolClientOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteUserPoolClientRequest{Request: req, Input: input, Copy: c.DeleteUserPoolClientRequest}
}

// DeleteUserPoolClientRequest is the request type for the
// DeleteUserPoolClient API operation.
type DeleteUserPoolClientRequest struct {
	*aws.Request
	Input *DeleteUserPoolClientInput
	Copy  func(*DeleteUserPoolClientInput) DeleteUserPoolClientRequest
}

// Send marshals and sends the DeleteUserPoolClient API request.
func (r DeleteUserPoolClientRequest) Send(ctx context.Context) (*DeleteUserPoolClientResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteUserPoolClientResponse{
		DeleteUserPoolClientOutput: r.Request.Data.(*DeleteUserPoolClientOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteUserPoolClientResponse is the response type for the
// DeleteUserPoolClient API operation.
type DeleteUserPoolClientResponse struct {
	*DeleteUserPoolClientOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteUserPoolClient request.
func (r *DeleteUserPoolClientResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
