// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the get upload operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUploadRequest
type GetUploadInput struct {
	_ struct{} `type:"structure"`

	// The upload's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUploadInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetUploadInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a get upload request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUploadResult
type GetUploadOutput struct {
	_ struct{} `type:"structure"`

	// An app or a set of one or more tests to upload or that have been uploaded.
	Upload *Upload `locationName:"upload" type:"structure"`
}

// String returns the string representation
func (s GetUploadOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetUpload = "GetUpload"

// GetUploadRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about an upload.
//
//    // Example sending a request using GetUploadRequest.
//    req := client.GetUploadRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload
func (c *Client) GetUploadRequest(input *GetUploadInput) GetUploadRequest {
	op := &aws.Operation{
		Name:       opGetUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUploadInput{}
	}

	req := c.newRequest(op, input, &GetUploadOutput{})
	return GetUploadRequest{Request: req, Input: input, Copy: c.GetUploadRequest}
}

// GetUploadRequest is the request type for the
// GetUpload API operation.
type GetUploadRequest struct {
	*aws.Request
	Input *GetUploadInput
	Copy  func(*GetUploadInput) GetUploadRequest
}

// Send marshals and sends the GetUpload API request.
func (r GetUploadRequest) Send(ctx context.Context) (*GetUploadResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUploadResponse{
		GetUploadOutput: r.Request.Data.(*GetUploadOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetUploadResponse is the response type for the
// GetUpload API operation.
type GetUploadResponse struct {
	*GetUploadOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUpload request.
func (r *GetUploadResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
