// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcRequest
type AttachClassicLinkVpcInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of one or more of the VPC's security groups. You cannot specify security
	// groups from a different VPC.
	//
	// Groups is a required field
	Groups []string `locationName:"SecurityGroupId" locationNameList:"groupId" type:"list" required:"true"`

	// The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	// The ID of a ClassicLink-enabled VPC.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachClassicLinkVpcInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachClassicLinkVpcInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachClassicLinkVpcInput"}

	if s.Groups == nil {
		invalidParams.Add(aws.NewErrParamRequired("Groups"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.VpcId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcResult
type AttachClassicLinkVpcOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s AttachClassicLinkVpcOutput) String() string {
	return awsutil.Prettify(s)
}

const opAttachClassicLinkVpc = "AttachClassicLinkVpc"

// AttachClassicLinkVpcRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or
// more of the VPC's security groups. You cannot link an EC2-Classic instance
// to more than one VPC at a time. You can only link an instance that's in the
// running state. An instance is automatically unlinked from a VPC when it's
// stopped - you can link it to the VPC again when you restart it.
//
// After you've linked an instance, you cannot change the VPC security groups
// that are associated with it. To change the security groups, you must first
// unlink the instance, and then link it again.
//
// Linking your instance to a VPC is sometimes referred to as attaching your
// instance.
//
//    // Example sending a request using AttachClassicLinkVpcRequest.
//    req := client.AttachClassicLinkVpcRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc
func (c *Client) AttachClassicLinkVpcRequest(input *AttachClassicLinkVpcInput) AttachClassicLinkVpcRequest {
	op := &aws.Operation{
		Name:       opAttachClassicLinkVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachClassicLinkVpcInput{}
	}

	req := c.newRequest(op, input, &AttachClassicLinkVpcOutput{})
	return AttachClassicLinkVpcRequest{Request: req, Input: input, Copy: c.AttachClassicLinkVpcRequest}
}

// AttachClassicLinkVpcRequest is the request type for the
// AttachClassicLinkVpc API operation.
type AttachClassicLinkVpcRequest struct {
	*aws.Request
	Input *AttachClassicLinkVpcInput
	Copy  func(*AttachClassicLinkVpcInput) AttachClassicLinkVpcRequest
}

// Send marshals and sends the AttachClassicLinkVpc API request.
func (r AttachClassicLinkVpcRequest) Send(ctx context.Context) (*AttachClassicLinkVpcResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AttachClassicLinkVpcResponse{
		AttachClassicLinkVpcOutput: r.Request.Data.(*AttachClassicLinkVpcOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AttachClassicLinkVpcResponse is the response type for the
// AttachClassicLinkVpc API operation.
type AttachClassicLinkVpcResponse struct {
	*AttachClassicLinkVpcOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AttachClassicLinkVpc request.
func (r *AttachClassicLinkVpcResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
