// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectTransitGatewayVpcAttachmentRequest
type RejectTransitGatewayVpcAttachmentInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the attachment.
	//
	// TransitGatewayAttachmentId is a required field
	TransitGatewayAttachmentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RejectTransitGatewayVpcAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectTransitGatewayVpcAttachmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RejectTransitGatewayVpcAttachmentInput"}

	if s.TransitGatewayAttachmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayAttachmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectTransitGatewayVpcAttachmentResult
type RejectTransitGatewayVpcAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the attachment.
	TransitGatewayVpcAttachment *TransitGatewayVpcAttachment `locationName:"transitGatewayVpcAttachment" type:"structure"`
}

// String returns the string representation
func (s RejectTransitGatewayVpcAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opRejectTransitGatewayVpcAttachment = "RejectTransitGatewayVpcAttachment"

// RejectTransitGatewayVpcAttachmentRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Rejects a request to attach a VPC to a transit gateway.
//
// The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments
// to view your pending VPC attachment requests. Use AcceptTransitGatewayVpcAttachment
// to accept a VPC attachment request.
//
//    // Example sending a request using RejectTransitGatewayVpcAttachmentRequest.
//    req := client.RejectTransitGatewayVpcAttachmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectTransitGatewayVpcAttachment
func (c *Client) RejectTransitGatewayVpcAttachmentRequest(input *RejectTransitGatewayVpcAttachmentInput) RejectTransitGatewayVpcAttachmentRequest {
	op := &aws.Operation{
		Name:       opRejectTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectTransitGatewayVpcAttachmentInput{}
	}

	req := c.newRequest(op, input, &RejectTransitGatewayVpcAttachmentOutput{})
	return RejectTransitGatewayVpcAttachmentRequest{Request: req, Input: input, Copy: c.RejectTransitGatewayVpcAttachmentRequest}
}

// RejectTransitGatewayVpcAttachmentRequest is the request type for the
// RejectTransitGatewayVpcAttachment API operation.
type RejectTransitGatewayVpcAttachmentRequest struct {
	*aws.Request
	Input *RejectTransitGatewayVpcAttachmentInput
	Copy  func(*RejectTransitGatewayVpcAttachmentInput) RejectTransitGatewayVpcAttachmentRequest
}

// Send marshals and sends the RejectTransitGatewayVpcAttachment API request.
func (r RejectTransitGatewayVpcAttachmentRequest) Send(ctx context.Context) (*RejectTransitGatewayVpcAttachmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RejectTransitGatewayVpcAttachmentResponse{
		RejectTransitGatewayVpcAttachmentOutput: r.Request.Data.(*RejectTransitGatewayVpcAttachmentOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RejectTransitGatewayVpcAttachmentResponse is the response type for the
// RejectTransitGatewayVpcAttachment API operation.
type RejectTransitGatewayVpcAttachmentResponse struct {
	*RejectTransitGatewayVpcAttachmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RejectTransitGatewayVpcAttachment request.
func (r *RejectTransitGatewayVpcAttachmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
