// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersionMessage
type UpdateApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with this version.
	//
	// If no application is found with this name, UpdateApplication returns an InvalidParameterValue
	// error.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A new description for this version.
	Description *string `type:"string"`

	// The name of the version to update.
	//
	// If no application version is found with this label, UpdateApplication returns
	// an InvalidParameterValue error.
	//
	// VersionLabel is a required field
	VersionLabel *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateApplicationVersionInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.VersionLabel == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionLabel"))
	}
	if s.VersionLabel != nil && len(*s.VersionLabel) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Result message wrapping a single description of an application version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplicationVersionDescriptionMessage
type UpdateApplicationVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ApplicationVersionDescription of the application version.
	ApplicationVersion *ApplicationVersionDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateApplicationVersion = "UpdateApplicationVersion"

// UpdateApplicationVersionRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Updates the specified application version to have the specified properties.
//
// If a property (for example, description) is not provided, the value remains
// unchanged. To clear properties, specify an empty string.
//
//    // Example sending a request using UpdateApplicationVersionRequest.
//    req := client.UpdateApplicationVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion
func (c *Client) UpdateApplicationVersionRequest(input *UpdateApplicationVersionInput) UpdateApplicationVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateApplicationVersionOutput{})
	return UpdateApplicationVersionRequest{Request: req, Input: input, Copy: c.UpdateApplicationVersionRequest}
}

// UpdateApplicationVersionRequest is the request type for the
// UpdateApplicationVersion API operation.
type UpdateApplicationVersionRequest struct {
	*aws.Request
	Input *UpdateApplicationVersionInput
	Copy  func(*UpdateApplicationVersionInput) UpdateApplicationVersionRequest
}

// Send marshals and sends the UpdateApplicationVersion API request.
func (r UpdateApplicationVersionRequest) Send(ctx context.Context) (*UpdateApplicationVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateApplicationVersionResponse{
		UpdateApplicationVersionOutput: r.Request.Data.(*UpdateApplicationVersionOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateApplicationVersionResponse is the response type for the
// UpdateApplicationVersion API operation.
type UpdateApplicationVersionResponse struct {
	*UpdateApplicationVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateApplicationVersion request.
func (r *UpdateApplicationVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
