// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about an action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Action
type Action struct {
	_ struct{} `type:"structure"`

	// [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
	// Specify only when Type is authenticate-cognito.
	AuthenticateCognitoConfig *AuthenticateCognitoActionConfig `type:"structure"`

	// [HTTPS listeners] Information about an identity provider that is compliant
	// with OpenID Connect (OIDC). Specify only when Type is authenticate-oidc.
	AuthenticateOidcConfig *AuthenticateOidcActionConfig `type:"structure"`

	// [Application Load Balancer] Information for creating an action that returns
	// a custom HTTP response. Specify only when Type is fixed-response.
	FixedResponseConfig *FixedResponseActionConfig `type:"structure"`

	// The order for the action. This value is required for rules with multiple
	// actions. The action with the lowest value for order is performed first. The
	// final action to be performed must be a forward or a fixed-response action.
	Order *int64 `min:"1" type:"integer"`

	// [Application Load Balancer] Information for creating a redirect action. Specify
	// only when Type is redirect.
	RedirectConfig *RedirectActionConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group. Specify only when Type
	// is forward.
	TargetGroupArn *string `type:"string"`

	// The type of action. Each rule must include exactly one of the following types
	// of actions: forward, fixed-response, or redirect.
	//
	// Type is a required field
	Type ActionTypeEnum `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Action"}
	if s.Order != nil && *s.Order < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Order", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.AuthenticateCognitoConfig != nil {
		if err := s.AuthenticateCognitoConfig.Validate(); err != nil {
			invalidParams.AddNested("AuthenticateCognitoConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.AuthenticateOidcConfig != nil {
		if err := s.AuthenticateOidcConfig.Validate(); err != nil {
			invalidParams.AddNested("AuthenticateOidcConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.FixedResponseConfig != nil {
		if err := s.FixedResponseConfig.Validate(); err != nil {
			invalidParams.AddNested("FixedResponseConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.RedirectConfig != nil {
		if err := s.RedirectConfig.Validate(); err != nil {
			invalidParams.AddNested("RedirectConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Request parameters to use when integrating with Amazon Cognito to authenticate
// users.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AuthenticateCognitoActionConfig
type AuthenticateCognitoActionConfig struct {
	_ struct{} `type:"structure"`

	// The query parameters (up to 10) to include in the redirect request to the
	// authorization endpoint.
	AuthenticationRequestExtraParams map[string]string `type:"map"`

	// The behavior if the user is not authenticated. The following are possible
	// values:
	//
	//    * deny - Return an HTTP 401 Unauthorized error.
	//
	//    * allow - Allow the request to be forwarded to the target.
	//
	//    * authenticate - Redirect the request to the IdP authorization endpoint.
	//    This is the default value.
	OnUnauthenticatedRequest AuthenticateCognitoActionConditionalBehaviorEnum `type:"string" enum:"true"`

	// The set of user claims to be requested from the IdP. The default is openid.
	//
	// To verify which scope values your IdP supports and how to separate multiple
	// values, see the documentation for your IdP.
	Scope *string `type:"string"`

	// The name of the cookie used to maintain session information. The default
	// is AWSELBAuthSessionCookie.
	SessionCookieName *string `type:"string"`

	// The maximum duration of the authentication session, in seconds. The default
	// is 604800 seconds (7 days).
	SessionTimeout *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
	//
	// UserPoolArn is a required field
	UserPoolArn *string `type:"string" required:"true"`

	// The ID of the Amazon Cognito user pool client.
	//
	// UserPoolClientId is a required field
	UserPoolClientId *string `type:"string" required:"true"`

	// The domain prefix or fully-qualified domain name of the Amazon Cognito user
	// pool.
	//
	// UserPoolDomain is a required field
	UserPoolDomain *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AuthenticateCognitoActionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthenticateCognitoActionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuthenticateCognitoActionConfig"}

	if s.UserPoolArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolArn"))
	}

	if s.UserPoolClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolClientId"))
	}

	if s.UserPoolDomain == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolDomain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Request parameters when using an identity provider (IdP) that is compliant
// with OpenID Connect (OIDC) to authenticate users.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AuthenticateOidcActionConfig
type AuthenticateOidcActionConfig struct {
	_ struct{} `type:"structure"`

	// The query parameters (up to 10) to include in the redirect request to the
	// authorization endpoint.
	AuthenticationRequestExtraParams map[string]string `type:"map"`

	// The authorization endpoint of the IdP. This must be a full URL, including
	// the HTTPS protocol, the domain, and the path.
	//
	// AuthorizationEndpoint is a required field
	AuthorizationEndpoint *string `type:"string" required:"true"`

	// The OAuth 2.0 client identifier.
	//
	// ClientId is a required field
	ClientId *string `type:"string" required:"true"`

	// The OAuth 2.0 client secret. This parameter is required if you are creating
	// a rule. If you are modifying a rule, you can omit this parameter if you set
	// UseExistingClientSecret to true.
	ClientSecret *string `type:"string"`

	// The OIDC issuer identifier of the IdP. This must be a full URL, including
	// the HTTPS protocol, the domain, and the path.
	//
	// Issuer is a required field
	Issuer *string `type:"string" required:"true"`

	// The behavior if the user is not authenticated. The following are possible
	// values:
	//
	//    * deny - Return an HTTP 401 Unauthorized error.
	//
	//    * allow - Allow the request to be forwarded to the target.
	//
	//    * authenticate - Redirect the request to the IdP authorization endpoint.
	//    This is the default value.
	OnUnauthenticatedRequest AuthenticateOidcActionConditionalBehaviorEnum `type:"string" enum:"true"`

	// The set of user claims to be requested from the IdP. The default is openid.
	//
	// To verify which scope values your IdP supports and how to separate multiple
	// values, see the documentation for your IdP.
	Scope *string `type:"string"`

	// The name of the cookie used to maintain session information. The default
	// is AWSELBAuthSessionCookie.
	SessionCookieName *string `type:"string"`

	// The maximum duration of the authentication session, in seconds. The default
	// is 604800 seconds (7 days).
	SessionTimeout *int64 `type:"long"`

	// The token endpoint of the IdP. This must be a full URL, including the HTTPS
	// protocol, the domain, and the path.
	//
	// TokenEndpoint is a required field
	TokenEndpoint *string `type:"string" required:"true"`

	// Indicates whether to use the existing client secret when modifying a rule.
	// If you are creating a rule, you can omit this parameter or set it to false.
	UseExistingClientSecret *bool `type:"boolean"`

	// The user info endpoint of the IdP. This must be a full URL, including the
	// HTTPS protocol, the domain, and the path.
	//
	// UserInfoEndpoint is a required field
	UserInfoEndpoint *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AuthenticateOidcActionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthenticateOidcActionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuthenticateOidcActionConfig"}

	if s.AuthorizationEndpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthorizationEndpoint"))
	}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}

	if s.Issuer == nil {
		invalidParams.Add(aws.NewErrParamRequired("Issuer"))
	}

	if s.TokenEndpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("TokenEndpoint"))
	}

	if s.UserInfoEndpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserInfoEndpoint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about an Availability Zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// [Network Load Balancers] The static IP address.
	LoadBalancerAddresses []LoadBalancerAddress `type:"list"`

	// The ID of the subnet.
	SubnetId *string `type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// Information about an SSL server certificate.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Certificate
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string `type:"string"`

	// Indicates whether the certificate is the default certificate. Do not set
	// IsDefault when specifying a certificate as an input parameter.
	IsDefault *bool `type:"boolean"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// Information about a cipher used in a policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Cipher
type Cipher struct {
	_ struct{} `type:"structure"`

	// The name of the cipher.
	Name *string `type:"string"`

	// The priority of the cipher.
	Priority *int64 `type:"integer"`
}

// String returns the string representation
func (s Cipher) String() string {
	return awsutil.Prettify(s)
}

// Information about an action that returns a custom HTTP response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/FixedResponseActionConfig
type FixedResponseActionConfig struct {
	_ struct{} `type:"structure"`

	// The content type.
	//
	// Valid Values: text/plain | text/css | text/html | application/javascript
	// | application/json
	ContentType *string `type:"string"`

	// The message.
	MessageBody *string `type:"string"`

	// The HTTP response code (2XX, 4XX, or 5XX).
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FixedResponseActionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedResponseActionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FixedResponseActionConfig"}

	if s.StatusCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("StatusCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/HostHeaderConditionConfig
type HostHeaderConditionConfig struct {
	_ struct{} `type:"structure"`

	Values []string `type:"list"`
}

// String returns the string representation
func (s HostHeaderConditionConfig) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/HttpHeaderConditionConfig
type HttpHeaderConditionConfig struct {
	_ struct{} `type:"structure"`

	HttpHeaderName *string `type:"string"`

	Values []string `type:"list"`
}

// String returns the string representation
func (s HttpHeaderConditionConfig) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/HttpRequestMethodConditionConfig
type HttpRequestMethodConditionConfig struct {
	_ struct{} `type:"structure"`

	Values []string `type:"list"`
}

// String returns the string representation
func (s HttpRequestMethodConditionConfig) String() string {
	return awsutil.Prettify(s)
}

// Information about an Elastic Load Balancing resource limit for your AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Limit
type Limit struct {
	_ struct{} `type:"structure"`

	// The maximum value of the limit.
	Max *string `type:"string"`

	// The name of the limit. The possible values are:
	//
	//    * application-load-balancers
	//
	//    * listeners-per-application-load-balancer
	//
	//    * listeners-per-network-load-balancer
	//
	//    * network-load-balancers
	//
	//    * rules-per-application-load-balancer
	//
	//    * target-groups
	//
	//    * targets-per-application-load-balancer
	//
	//    * targets-per-availability-zone-per-network-load-balancer
	//
	//    * targets-per-network-load-balancer
	Name *string `type:"string"`
}

// String returns the string representation
func (s Limit) String() string {
	return awsutil.Prettify(s)
}

// Information about a listener.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Listener
type Listener struct {
	_ struct{} `type:"structure"`

	// The SSL server certificate. You must provide a certificate if the protocol
	// is HTTPS or TLS.
	Certificates []Certificate `type:"list"`

	// The default actions for the listener.
	DefaultActions []Action `type:"list"`

	// The Amazon Resource Name (ARN) of the listener.
	ListenerArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string `type:"string"`

	// The port on which the load balancer is listening.
	Port *int64 `min:"1" type:"integer"`

	// The protocol for connections from clients to the load balancer.
	Protocol ProtocolEnum `type:"string" enum:"true"`

	// The security policy that defines which ciphers and protocols are supported.
	// The default is the current predefined security policy.
	SslPolicy *string `type:"string"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// Information about a load balancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/LoadBalancer
type LoadBalancer struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the load balancer.
	AvailabilityZones []AvailabilityZone `type:"list"`

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string `type:"string"`

	// The date and time the load balancer was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The public DNS name of the load balancer.
	DNSName *string `type:"string"`

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and
	// IPv6 addresses).
	IpAddressType IpAddressType `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string `type:"string"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The nodes of an Internet-facing load balancer have public IP addresses. The
	// DNS name of an Internet-facing load balancer is publicly resolvable to the
	// public IP addresses of the nodes. Therefore, Internet-facing load balancers
	// can route requests from clients over the internet.
	//
	// The nodes of an internal load balancer have only private IP addresses. The
	// DNS name of an internal load balancer is publicly resolvable to the private
	// IP addresses of the nodes. Therefore, internal load balancers can only route
	// requests from clients with access to the VPC for the load balancer.
	Scheme LoadBalancerSchemeEnum `type:"string" enum:"true"`

	// The IDs of the security groups for the load balancer.
	SecurityGroups []string `type:"list"`

	// The state of the load balancer.
	State *LoadBalancerState `type:"structure"`

	// The type of load balancer.
	Type LoadBalancerTypeEnum `type:"string" enum:"true"`

	// The ID of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// Information about a static IP address for a load balancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/LoadBalancerAddress
type LoadBalancerAddress struct {
	_ struct{} `type:"structure"`

	// [Network Load Balancers] The allocation ID of the Elastic IP address.
	AllocationId *string `type:"string"`

	// The static IP address.
	IpAddress *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerAddress) String() string {
	return awsutil.Prettify(s)
}

// Information about a load balancer attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/LoadBalancerAttribute
type LoadBalancerAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	// The following attributes are supported by both Application Load Balancers
	// and Network Load Balancers:
	//
	//    * access_logs.s3.enabled - Indicates whether access logs are enabled.
	//    The value is true or false. The default is false.
	//
	//    * access_logs.s3.bucket - The name of the S3 bucket for the access logs.
	//    This attribute is required if access logs are enabled. The bucket must
	//    exist in the same region as the load balancer and have a bucket policy
	//    that grants Elastic Load Balancing permissions to write to the bucket.
	//
	//    * access_logs.s3.prefix - The prefix for the location in the S3 bucket
	//    for the access logs.
	//
	//    * deletion_protection.enabled - Indicates whether deletion protection
	//    is enabled. The value is true or false. The default is false.
	//
	// The following attributes are supported by only Application Load Balancers:
	//
	//    * idle_timeout.timeout_seconds - The idle timeout value, in seconds. The
	//    valid range is 1-4000 seconds. The default is 60 seconds.
	//
	//    * routing.http2.enabled - Indicates whether HTTP/2 is enabled. The value
	//    is true or false. The default is true.
	//
	// The following attributes are supported by only Network Load Balancers:
	//
	//    * load_balancing.cross_zone.enabled - Indicates whether cross-zone load
	//    balancing is enabled. The value is true or false. The default is false.
	Key *string `type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerAttribute) String() string {
	return awsutil.Prettify(s)
}

// Information about the state of the load balancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/LoadBalancerState
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The state code. The initial state of the load balancer is provisioning. After
	// the load balancer is fully set up and ready to route traffic, its state is
	// active. If the load balancer could not be set up, its state is failed.
	Code LoadBalancerStateEnum `type:"string" enum:"true"`

	// A description of the state.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// Information to use when checking for a successful response from a target.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Matcher
type Matcher struct {
	_ struct{} `type:"structure"`

	// The HTTP codes.
	//
	// For Application Load Balancers, you can specify values between 200 and 499,
	// and the default value is 200. You can specify multiple values (for example,
	// "200,202") or a range of values (for example, "200-299").
	//
	// For Network Load Balancers, this is 200–399.
	//
	// HttpCode is a required field
	HttpCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Matcher) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Matcher) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Matcher"}

	if s.HttpCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("HttpCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/PathPatternConditionConfig
type PathPatternConditionConfig struct {
	_ struct{} `type:"structure"`

	Values []string `type:"list"`
}

// String returns the string representation
func (s PathPatternConditionConfig) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/QueryStringConditionConfig
type QueryStringConditionConfig struct {
	_ struct{} `type:"structure"`

	Values []QueryStringKeyValuePair `type:"list"`
}

// String returns the string representation
func (s QueryStringConditionConfig) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/QueryStringKeyValuePair
type QueryStringKeyValuePair struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s QueryStringKeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// Information about a redirect action.
//
// A URI consists of the following components: protocol://hostname:port/path?query.
// You must modify at least one of the following components to avoid a redirect
// loop: protocol, hostname, port, or path. Any components that you do not modify
// retain their original values.
//
// You can reuse URI components using the following reserved keywords:
//
//    * #{protocol}
//
//    * #{host}
//
//    * #{port}
//
//    * #{path} (the leading "/" is removed)
//
//    * #{query}
//
// For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}",
// or the query to "#{query}&value=xyz".
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RedirectActionConfig
type RedirectActionConfig struct {
	_ struct{} `type:"structure"`

	// The hostname. This component is not percent-encoded. The hostname can contain
	// #{host}.
	Host *string `min:"1" type:"string"`

	// The absolute path, starting with the leading "/". This component is not percent-encoded.
	// The path can contain #{host}, #{path}, and #{port}.
	Path *string `min:"1" type:"string"`

	// The port. You can specify a value from 1 to 65535 or #{port}.
	Port *string `type:"string"`

	// The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect
	// HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS
	// to HTTP.
	Protocol *string `type:"string"`

	// The query parameters, URL-encoded when necessary, but not percent-encoded.
	// Do not include the leading "?", as it is automatically added. You can specify
	// any of the reserved keywords.
	Query *string `type:"string"`

	// The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary
	// (HTTP 302).
	//
	// StatusCode is a required field
	StatusCode RedirectActionStatusCodeEnum `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RedirectActionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectActionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RedirectActionConfig"}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Host", 1))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Path", 1))
	}
	if len(s.StatusCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("StatusCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// The actions.
	Actions []Action `type:"list"`

	// The conditions.
	Conditions []RuleCondition `type:"list"`

	// Indicates whether this is the default rule.
	IsDefault *bool `type:"boolean"`

	// The priority.
	Priority *string `type:"string"`

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string `type:"string"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// Information about a condition for a rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RuleCondition
type RuleCondition struct {
	_ struct{} `type:"structure"`

	// The name of the field. The possible values are host-header and path-pattern.
	Field *string `type:"string"`

	HostHeaderConfig *HostHeaderConditionConfig `type:"structure"`

	HttpHeaderConfig *HttpHeaderConditionConfig `type:"structure"`

	HttpRequestMethodConfig *HttpRequestMethodConditionConfig `type:"structure"`

	PathPatternConfig *PathPatternConditionConfig `type:"structure"`

	QueryStringConfig *QueryStringConditionConfig `type:"structure"`

	SourceIpConfig *SourceIpConditionConfig `type:"structure"`

	// The condition value.
	//
	// If the field name is host-header, you can specify a single host name (for
	// example, my.example.com). A host name is case insensitive, can be up to 128
	// characters in length, and can contain any of the following characters. You
	// can include up to three wildcard characters.
	//
	//    * A-Z, a-z, 0-9
	//
	//    * - .
	//
	//    * * (matches 0 or more characters)
	//
	//    * ? (matches exactly 1 character)
	//
	// If the field name is path-pattern, you can specify a single path pattern
	// (for example, /img/*). A path pattern is case-sensitive, can be up to 128
	// characters in length, and can contain any of the following characters. You
	// can include up to three wildcard characters.
	//
	//    * A-Z, a-z, 0-9
	//
	//    * _ - . $ / ~ " ' @ : +
	//
	//    * & (using &)
	//
	//    * * (matches 0 or more characters)
	//
	//    * ? (matches exactly 1 character)
	Values []string `type:"list"`
}

// String returns the string representation
func (s RuleCondition) String() string {
	return awsutil.Prettify(s)
}

// Information about the priorities for the rules for a listener.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RulePriorityPair
type RulePriorityPair struct {
	_ struct{} `type:"structure"`

	// The rule priority.
	Priority *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string `type:"string"`
}

// String returns the string representation
func (s RulePriorityPair) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RulePriorityPair) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RulePriorityPair"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Priority", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SourceIpConditionConfig
type SourceIpConditionConfig struct {
	_ struct{} `type:"structure"`

	Values []string `type:"list"`
}

// String returns the string representation
func (s SourceIpConditionConfig) String() string {
	return awsutil.Prettify(s)
}

// Information about a policy used for SSL negotiation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SslPolicy
type SslPolicy struct {
	_ struct{} `type:"structure"`

	// The ciphers.
	Ciphers []Cipher `type:"list"`

	// The name of the policy.
	Name *string `type:"string"`

	// The protocols.
	SslProtocols []string `type:"list"`
}

// String returns the string representation
func (s SslPolicy) String() string {
	return awsutil.Prettify(s)
}

// Information about a subnet mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SubnetMapping
type SubnetMapping struct {
	_ struct{} `type:"structure"`

	// [Network Load Balancers] The allocation ID of the Elastic IP address.
	AllocationId *string `type:"string"`

	// The ID of the subnet.
	SubnetId *string `type:"string"`
}

// String returns the string representation
func (s SubnetMapping) String() string {
	return awsutil.Prettify(s)
}

// Information about a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The tags associated with a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/TagDescription
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// Information about the tags.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// Information about a target.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/TargetDescription
type TargetDescription struct {
	_ struct{} `type:"structure"`

	// An Availability Zone or all. This determines whether the target receives
	// traffic from the load balancer nodes in the specified Availability Zone or
	// from all enabled Availability Zones for the load balancer.
	//
	// This parameter is not supported if the target type of the target group is
	// instance.
	//
	// If the target type is ip and the IP address is in a subnet of the VPC for
	// the target group, the Availability Zone is automatically detected and this
	// parameter is optional. If the IP address is outside the VPC, this parameter
	// is required.
	//
	// With an Application Load Balancer, if the target type is ip and the IP address
	// is outside the VPC for the target group, the only supported value is all.
	//
	// If the target type is lambda, this parameter is optional and the only supported
	// value is all.
	AvailabilityZone *string `type:"string"`

	// The ID of the target. If the target type of the target group is instance,
	// specify an instance ID. If the target type is ip, specify an IP address.
	// If the target type is lambda, specify the ARN of the Lambda function.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The port on which the target is listening.
	Port *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s TargetDescription) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetDescription) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetDescription"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a target group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/TargetGroup
type TargetGroup struct {
	_ struct{} `type:"structure"`

	// Indicates whether health checks are enabled.
	HealthCheckEnabled *bool `type:"boolean"`

	// The approximate amount of time, in seconds, between health checks of an individual
	// target.
	HealthCheckIntervalSeconds *int64 `min:"5" type:"integer"`

	// The destination for the health check request.
	HealthCheckPath *string `min:"1" type:"string"`

	// The port to use to connect with the target.
	HealthCheckPort *string `type:"string"`

	// The protocol to use to connect with the target.
	HealthCheckProtocol ProtocolEnum `type:"string" enum:"true"`

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	HealthCheckTimeoutSeconds *int64 `min:"2" type:"integer"`

	// The number of consecutive health checks successes required before considering
	// an unhealthy target healthy.
	HealthyThresholdCount *int64 `min:"2" type:"integer"`

	// The Amazon Resource Names (ARN) of the load balancers that route traffic
	// to this target group.
	LoadBalancerArns []string `type:"list"`

	// The HTTP codes to use when checking for a successful response from a target.
	Matcher *Matcher `type:"structure"`

	// The port on which the targets are listening.
	Port *int64 `min:"1" type:"integer"`

	// The protocol to use for routing traffic to the targets.
	Protocol ProtocolEnum `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the target group.
	TargetGroupArn *string `type:"string"`

	// The name of the target group.
	TargetGroupName *string `type:"string"`

	// The type of target that you must specify when registering targets with this
	// target group. The possible values are instance (targets are specified by
	// instance ID) or ip (targets are specified by IP address).
	TargetType TargetTypeEnum `type:"string" enum:"true"`

	// The number of consecutive health check failures required before considering
	// the target unhealthy.
	UnhealthyThresholdCount *int64 `min:"2" type:"integer"`

	// The ID of the VPC for the targets.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s TargetGroup) String() string {
	return awsutil.Prettify(s)
}

// Information about a target group attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/TargetGroupAttribute
type TargetGroupAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	// The following attribute is supported by both Application Load Balancers and
	// Network Load Balancers:
	//
	//    * deregistration_delay.timeout_seconds - The amount of time, in seconds,
	//    for Elastic Load Balancing to wait before changing the state of a deregistering
	//    target from draining to unused. The range is 0-3600 seconds. The default
	//    value is 300 seconds. If the target is a Lambda function, this attribute
	//    is not supported.
	//
	// The following attributes are supported by Application Load Balancers if the
	// target is not a Lambda function:
	//
	//    * slow_start.duration_seconds - The time period, in seconds, during which
	//    a newly registered target receives a linearly increasing share of the
	//    traffic to the target group. After this time period ends, the target receives
	//    its full share of traffic. The range is 30-900 seconds (15 minutes). Slow
	//    start mode is disabled by default.
	//
	//    * stickiness.enabled - Indicates whether sticky sessions are enabled.
	//    The value is true or false. The default is false.
	//
	//    * stickiness.type - The type of sticky sessions. The possible value is
	//    lb_cookie.
	//
	//    * stickiness.lb_cookie.duration_seconds - The time period, in seconds,
	//    during which requests from a client should be routed to the same target.
	//    After this time period expires, the load balancer-generated cookie is
	//    considered stale. The range is 1 second to 1 week (604800 seconds). The
	//    default value is 1 day (86400 seconds).
	//
	// The following attribute is supported only if the target is a Lambda function.
	//
	//    * lambda.multi_value_headers.enabled - Indicates whether the request and
	//    response headers exchanged between the load balancer and the Lambda function
	//    include arrays of values or strings. The value is true or false. The default
	//    is false. If the value is false and the request contains a duplicate header
	//    field name or query parameter key, the load balancer uses the last value
	//    sent by the client.
	//
	// The following attribute is supported only by Network Load Balancers:
	//
	//    * proxy_protocol_v2.enabled - Indicates whether Proxy Protocol version
	//    2 is enabled. The value is true or false. The default is false.
	Key *string `type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TargetGroupAttribute) String() string {
	return awsutil.Prettify(s)
}

// Information about the current health of a target.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/TargetHealth
type TargetHealth struct {
	_ struct{} `type:"structure"`

	// A description of the target health that provides additional details. If the
	// state is healthy, a description is not provided.
	Description *string `type:"string"`

	// The reason code.
	//
	// If the target state is healthy, a reason code is not provided.
	//
	// If the target state is initial, the reason code can be one of the following
	// values:
	//
	//    * Elb.RegistrationInProgress - The target is in the process of being registered
	//    with the load balancer.
	//
	//    * Elb.InitialHealthChecking - The load balancer is still sending the target
	//    the minimum number of health checks required to determine its health status.
	//
	// If the target state is unhealthy, the reason code can be one of the following
	// values:
	//
	//    * Target.ResponseCodeMismatch - The health checks did not return an expected
	//    HTTP code.
	//
	//    * Target.Timeout - The health check requests timed out.
	//
	//    * Target.FailedHealthChecks - The health checks failed because the connection
	//    to the target timed out, the target response was malformed, or the target
	//    failed the health check for an unknown reason.
	//
	//    * Elb.InternalError - The health checks failed due to an internal error.
	//
	// If the target state is unused, the reason code can be one of the following
	// values:
	//
	//    * Target.NotRegistered - The target is not registered with the target
	//    group.
	//
	//    * Target.NotInUse - The target group is not used by any load balancer
	//    or the target is in an Availability Zone that is not enabled for its load
	//    balancer.
	//
	//    * Target.IpUnusable - The target IP address is reserved for use by a load
	//    balancer.
	//
	//    * Target.InvalidState - The target is in the stopped or terminated state.
	//
	// If the target state is draining, the reason code can be the following value:
	//
	//    * Target.DeregistrationInProgress - The target is in the process of being
	//    deregistered and the deregistration delay period has not expired.
	//
	// If the target state is unavailable, the reason code can be the following
	// value:
	//
	//    * Target.HealthCheckDisabled - Health checks are disabled for the target
	//    group.
	Reason TargetHealthReasonEnum `type:"string" enum:"true"`

	// The state of the target.
	State TargetHealthStateEnum `type:"string" enum:"true"`
}

// String returns the string representation
func (s TargetHealth) String() string {
	return awsutil.Prettify(s)
}

// Information about the health of a target.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/TargetHealthDescription
type TargetHealthDescription struct {
	_ struct{} `type:"structure"`

	// The port to use to connect with the target.
	HealthCheckPort *string `type:"string"`

	// The description of the target.
	Target *TargetDescription `type:"structure"`

	// The health information for the target.
	TargetHealth *TargetHealth `type:"structure"`
}

// String returns the string representation
func (s TargetHealthDescription) String() string {
	return awsutil.Prettify(s)
}
