// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProvidersRequest
type ListOpenIDConnectProvidersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListOpenIDConnectProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a successful ListOpenIDConnectProviders request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProvidersResponse
type ListOpenIDConnectProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The list of IAM OIDC provider resource objects defined in the AWS account.
	OpenIDConnectProviderList []OpenIDConnectProviderListEntry `type:"list"`
}

// String returns the string representation
func (s ListOpenIDConnectProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListOpenIDConnectProviders = "ListOpenIDConnectProviders"

// ListOpenIDConnectProvidersRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Lists information about the IAM OpenID Connect (OIDC) provider resource objects
// defined in the AWS account.
//
//    // Example sending a request using ListOpenIDConnectProvidersRequest.
//    req := client.ListOpenIDConnectProvidersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders
func (c *Client) ListOpenIDConnectProvidersRequest(input *ListOpenIDConnectProvidersInput) ListOpenIDConnectProvidersRequest {
	op := &aws.Operation{
		Name:       opListOpenIDConnectProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOpenIDConnectProvidersInput{}
	}

	req := c.newRequest(op, input, &ListOpenIDConnectProvidersOutput{})
	return ListOpenIDConnectProvidersRequest{Request: req, Input: input, Copy: c.ListOpenIDConnectProvidersRequest}
}

// ListOpenIDConnectProvidersRequest is the request type for the
// ListOpenIDConnectProviders API operation.
type ListOpenIDConnectProvidersRequest struct {
	*aws.Request
	Input *ListOpenIDConnectProvidersInput
	Copy  func(*ListOpenIDConnectProvidersInput) ListOpenIDConnectProvidersRequest
}

// Send marshals and sends the ListOpenIDConnectProviders API request.
func (r ListOpenIDConnectProvidersRequest) Send(ctx context.Context) (*ListOpenIDConnectProvidersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListOpenIDConnectProvidersResponse{
		ListOpenIDConnectProvidersOutput: r.Request.Data.(*ListOpenIDConnectProvidersOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListOpenIDConnectProvidersResponse is the response type for the
// ListOpenIDConnectProviders API operation.
type ListOpenIDConnectProvidersResponse struct {
	*ListOpenIDConnectProvidersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListOpenIDConnectProviders request.
func (r *ListOpenIDConnectProvidersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
