// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for the DeleteThing operation.
type DeleteThingInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the thing record in the registry. If the version
	// of the record in the registry does not match the expected version specified
	// in the request, the DeleteThing request is rejected with a VersionConflictException.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the thing to delete.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteThingInput"}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExpectedVersion != nil {
		v := *s.ExpectedVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "expectedVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The output of the DeleteThing operation.
type DeleteThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteThing = "DeleteThing"

// DeleteThingRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes the specified thing. Returns successfully with no error if the deletion
// is successful or you specify a thing that doesn't exist.
//
//    // Example sending a request using DeleteThingRequest.
//    req := client.DeleteThingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteThingRequest(input *DeleteThingInput) DeleteThingRequest {
	op := &aws.Operation{
		Name:       opDeleteThing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DeleteThingInput{}
	}

	req := c.newRequest(op, input, &DeleteThingOutput{})
	return DeleteThingRequest{Request: req, Input: input, Copy: c.DeleteThingRequest}
}

// DeleteThingRequest is the request type for the
// DeleteThing API operation.
type DeleteThingRequest struct {
	*aws.Request
	Input *DeleteThingInput
	Copy  func(*DeleteThingInput) DeleteThingRequest
}

// Send marshals and sends the DeleteThing API request.
func (r DeleteThingRequest) Send(ctx context.Context) (*DeleteThingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteThingResponse{
		DeleteThingOutput: r.Request.Data.(*DeleteThingOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteThingResponse is the response type for the
// DeleteThing API operation.
type DeleteThingResponse struct {
	*DeleteThingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteThing request.
func (r *DeleteThingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
