// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshotRequest
type DescribeApplicationSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The identifier of an application snapshot. You can retrieve this value using .
	//
	// SnapshotName is a required field
	SnapshotName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeApplicationSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeApplicationSnapshotInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.SnapshotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotName"))
	}
	if s.SnapshotName != nil && len(*s.SnapshotName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshotResponse
type DescribeApplicationSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the application snapshot.
	//
	// SnapshotDetails is a required field
	SnapshotDetails *SnapshotDetails `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeApplicationSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeApplicationSnapshot = "DescribeApplicationSnapshot"

// DescribeApplicationSnapshotRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Returns information about a snapshot of application state data.
//
//    // Example sending a request using DescribeApplicationSnapshotRequest.
//    req := client.DescribeApplicationSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshot
func (c *Client) DescribeApplicationSnapshotRequest(input *DescribeApplicationSnapshotInput) DescribeApplicationSnapshotRequest {
	op := &aws.Operation{
		Name:       opDescribeApplicationSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationSnapshotInput{}
	}

	req := c.newRequest(op, input, &DescribeApplicationSnapshotOutput{})
	return DescribeApplicationSnapshotRequest{Request: req, Input: input, Copy: c.DescribeApplicationSnapshotRequest}
}

// DescribeApplicationSnapshotRequest is the request type for the
// DescribeApplicationSnapshot API operation.
type DescribeApplicationSnapshotRequest struct {
	*aws.Request
	Input *DescribeApplicationSnapshotInput
	Copy  func(*DescribeApplicationSnapshotInput) DescribeApplicationSnapshotRequest
}

// Send marshals and sends the DescribeApplicationSnapshot API request.
func (r DescribeApplicationSnapshotRequest) Send(ctx context.Context) (*DescribeApplicationSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeApplicationSnapshotResponse{
		DescribeApplicationSnapshotOutput: r.Request.Data.(*DescribeApplicationSnapshotOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeApplicationSnapshotResponse is the response type for the
// DescribeApplicationSnapshot API operation.
type DescribeApplicationSnapshotResponse struct {
	*DescribeApplicationSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeApplicationSnapshot request.
func (r *DescribeApplicationSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
