// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMappingRequest
type GetEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSourceMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEventSourceMappingInput"}

	if s.UUID == nil {
		invalidParams.Add(aws.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetEventSourceMappingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A mapping between an AWS resource and an AWS Lambda function. See CreateEventSourceMapping
// for details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/EventSourceMappingConfiguration
type GetEventSourceMappingOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string `type:"string"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The date that the event source mapping was last updated.
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be one of the following: Creating,
	// Enabling, Enabled, Disabling, Disabled, Updating, or Deleting.
	State *string `type:"string"`

	// The cause of the last state change, either User initiated or Lambda initiated.
	StateTransitionReason *string `type:"string"`

	// The identifier of the event source mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s GetEventSourceMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetEventSourceMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastProcessingResult != nil {
		v := *s.LastProcessingResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastProcessingResult", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateTransitionReason != nil {
		v := *s.StateTransitionReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateTransitionReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetEventSourceMapping = "GetEventSourceMapping"

// GetEventSourceMappingRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns details about an event source mapping. You can get the identifier
// of a mapping from the output of ListEventSourceMappings.
//
//    // Example sending a request using GetEventSourceMappingRequest.
//    req := client.GetEventSourceMappingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping
func (c *Client) GetEventSourceMappingRequest(input *GetEventSourceMappingInput) GetEventSourceMappingRequest {
	op := &aws.Operation{
		Name:       opGetEventSourceMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &GetEventSourceMappingInput{}
	}

	req := c.newRequest(op, input, &GetEventSourceMappingOutput{})
	return GetEventSourceMappingRequest{Request: req, Input: input, Copy: c.GetEventSourceMappingRequest}
}

// GetEventSourceMappingRequest is the request type for the
// GetEventSourceMapping API operation.
type GetEventSourceMappingRequest struct {
	*aws.Request
	Input *GetEventSourceMappingInput
	Copy  func(*GetEventSourceMappingInput) GetEventSourceMappingRequest
}

// Send marshals and sends the GetEventSourceMapping API request.
func (r GetEventSourceMappingRequest) Send(ctx context.Context) (*GetEventSourceMappingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEventSourceMappingResponse{
		GetEventSourceMappingOutput: r.Request.Data.(*GetEventSourceMappingOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEventSourceMappingResponse is the response type for the
// GetEventSourceMapping API operation.
type GetEventSourceMappingResponse struct {
	*GetEventSourceMappingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEventSourceMapping request.
func (r *GetEventSourceMappingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
