// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotTypeRequest
type DeleteSlotTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the slot type. The name is case sensitive.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlotTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSlotTypeInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSlotTypeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotTypeOutput
type DeleteSlotTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSlotTypeOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteSlotType = "DeleteSlotType"

// DeleteSlotTypeRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Deletes all versions of the slot type, including the $LATEST version. To
// delete a specific version of the slot type, use the DeleteSlotTypeVersion
// operation.
//
// You can delete a version of a slot type only if it is not referenced. To
// delete a slot type that is referred to in one or more intents, you must remove
// those references first.
//
// If you get the ResourceInUseException exception, the exception provides an
// example reference that shows the intent where the slot type is referenced.
// To remove the reference to the slot type, either update the intent or delete
// it. If you get the same exception when you attempt to delete the slot type
// again, repeat until the slot type has no references and the DeleteSlotType
// call is successful.
//
// This operation requires permission for the lex:DeleteSlotType action.
//
//    // Example sending a request using DeleteSlotTypeRequest.
//    req := client.DeleteSlotTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotType
func (c *Client) DeleteSlotTypeRequest(input *DeleteSlotTypeInput) DeleteSlotTypeRequest {
	op := &aws.Operation{
		Name:       opDeleteSlotType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/slottypes/{name}",
	}

	if input == nil {
		input = &DeleteSlotTypeInput{}
	}

	req := c.newRequest(op, input, &DeleteSlotTypeOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteSlotTypeRequest{Request: req, Input: input, Copy: c.DeleteSlotTypeRequest}
}

// DeleteSlotTypeRequest is the request type for the
// DeleteSlotType API operation.
type DeleteSlotTypeRequest struct {
	*aws.Request
	Input *DeleteSlotTypeInput
	Copy  func(*DeleteSlotTypeInput) DeleteSlotTypeRequest
}

// Send marshals and sends the DeleteSlotType API request.
func (r DeleteSlotTypeRequest) Send(ctx context.Context) (*DeleteSlotTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSlotTypeResponse{
		DeleteSlotTypeOutput: r.Request.Data.(*DeleteSlotTypeOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSlotTypeResponse is the response type for the
// DeleteSlotType API operation.
type DeleteSlotTypeResponse struct {
	*DeleteSlotTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSlotType request.
func (r *DeleteSlotTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
