// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventoryRequest
type ListResourceInventoryInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	Filters []InventoryFilter `type:"list"`

	// Maximum number of results to return in a single call. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceInventoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceInventoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourceInventoryInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventoryResponse
type ListResourceInventoryOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results.
	NextToken *string `type:"string"`

	// The detailed list of resources.
	ResourceInventoryList []ResourceInventory `type:"list"`
}

// String returns the string representation
func (s ListResourceInventoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opListResourceInventory = "ListResourceInventory"

// ListResourceInventoryRequest returns a request value for making API operation for
// AWS License Manager.
//
// Returns a detailed list of resources.
//
//    // Example sending a request using ListResourceInventoryRequest.
//    req := client.ListResourceInventoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory
func (c *Client) ListResourceInventoryRequest(input *ListResourceInventoryInput) ListResourceInventoryRequest {
	op := &aws.Operation{
		Name:       opListResourceInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceInventoryInput{}
	}

	req := c.newRequest(op, input, &ListResourceInventoryOutput{})
	return ListResourceInventoryRequest{Request: req, Input: input, Copy: c.ListResourceInventoryRequest}
}

// ListResourceInventoryRequest is the request type for the
// ListResourceInventory API operation.
type ListResourceInventoryRequest struct {
	*aws.Request
	Input *ListResourceInventoryInput
	Copy  func(*ListResourceInventoryInput) ListResourceInventoryRequest
}

// Send marshals and sends the ListResourceInventory API request.
func (r ListResourceInventoryRequest) Send(ctx context.Context) (*ListResourceInventoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourceInventoryResponse{
		ListResourceInventoryOutput: r.Request.Data.(*ListResourceInventoryOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListResourceInventoryResponse is the response type for the
// ListResourceInventory API operation.
type ListResourceInventoryResponse struct {
	*ListResourceInventoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResourceInventory request.
func (r *ListResourceInventoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
