// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Aac Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AacSettings
type AacSettings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid values depend on rate control mode
	// and profile.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control
	// mode and profile. The adReceiverMix setting receives a stereo description
	// plus control track and emits a mono AAC encode of the description track,
	// with control data emitted in the PES header as per ETSI TS 101 154 Annex
	// E.
	CodingMode AacCodingMode `locationName:"codingMode" type:"string" enum:"true"`

	// Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD
	// (narration) as a stereo pair. The Audio Type field (audioType) will be set
	// to 3, which signals to downstream systems that this stream contains "broadcaster
	// mixed AD". Note that the input received by the encoder must contain pre-mixed
	// audio; the encoder does not perform the mixing. The values in audioTypeControl
	// and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd.Leave
	// set to "normal" when input does not contain pre-mixed audio + AD.
	InputType AacInputType `locationName:"inputType" type:"string" enum:"true"`

	// AAC Profile.
	Profile AacProfile `locationName:"profile" type:"string" enum:"true"`

	// Rate Control Mode.
	RateControlMode AacRateControlMode `locationName:"rateControlMode" type:"string" enum:"true"`

	// Sets LATM / LOAS AAC output for raw containers.
	RawFormat AacRawFormat `locationName:"rawFormat" type:"string" enum:"true"`

	// Sample rate in Hz. Valid values depend on rate control mode and profile.
	SampleRate *float64 `locationName:"sampleRate" type:"double"`

	// Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport
	// Stream containers.
	Spec AacSpec `locationName:"spec" type:"string" enum:"true"`

	// VBR Quality Level - Only used if rateControlMode is VBR.
	VbrQuality AacVbrQuality `locationName:"vbrQuality" type:"string" enum:"true"`
}

// String returns the string representation
func (s AacSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AacSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bitrate != nil {
		v := *s.Bitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitrate", protocol.Float64Value(v), metadata)
	}
	if len(s.CodingMode) > 0 {
		v := s.CodingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "codingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.InputType) > 0 {
		v := s.InputType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Profile) > 0 {
		v := s.Profile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profile", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.RateControlMode) > 0 {
		v := s.RateControlMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rateControlMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.RawFormat) > 0 {
		v := s.RawFormat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rawFormat", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SampleRate != nil {
		v := *s.SampleRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sampleRate", protocol.Float64Value(v), metadata)
	}
	if len(s.Spec) > 0 {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spec", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.VbrQuality) > 0 {
		v := s.VbrQuality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vbrQuality", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Ac3 Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Ac3Settings
type Ac3Settings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted AC-3 stream. See ATSC
	// A/52-2012 for background on these values.
	BitstreamMode Ac3BitstreamMode `locationName:"bitstreamMode" type:"string" enum:"true"`

	// Dolby Digital coding mode. Determines number of channels.
	CodingMode Ac3CodingMode `locationName:"codingMode" type:"string" enum:"true"`

	// Sets the dialnorm for the output. If excluded and input audio is Dolby Digital,
	// dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// If set to filmStandard, adds dynamic range compression signaling to the output
	// bitstream as defined in the Dolby Digital specification.
	DrcProfile Ac3DrcProfile `locationName:"drcProfile" type:"string" enum:"true"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid in codingMode32Lfe mode.
	LfeFilter Ac3LfeFilter `locationName:"lfeFilter" type:"string" enum:"true"`

	// When set to "followInput", encoder metadata will be sourced from the DD,
	// DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl Ac3MetadataControl `locationName:"metadataControl" type:"string" enum:"true"`
}

// String returns the string representation
func (s Ac3Settings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ac3Settings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Ac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Ac3Settings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bitrate != nil {
		v := *s.Bitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitrate", protocol.Float64Value(v), metadata)
	}
	if len(s.BitstreamMode) > 0 {
		v := s.BitstreamMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitstreamMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.CodingMode) > 0 {
		v := s.CodingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "codingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Dialnorm != nil {
		v := *s.Dialnorm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dialnorm", protocol.Int64Value(v), metadata)
	}
	if len(s.DrcProfile) > 0 {
		v := s.DrcProfile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "drcProfile", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.LfeFilter) > 0 {
		v := s.LfeFilter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lfeFilter", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.MetadataControl) > 0 {
		v := s.MetadataControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metadataControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Archive Container Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ArchiveContainerSettings
type ArchiveContainerSettings struct {
	_ struct{} `type:"structure"`

	// M2ts Settings
	M2tsSettings *M2tsSettings `locationName:"m2tsSettings" type:"structure"`
}

// String returns the string representation
func (s ArchiveContainerSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveContainerSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ArchiveContainerSettings"}
	if s.M2tsSettings != nil {
		if err := s.M2tsSettings.Validate(); err != nil {
			invalidParams.AddNested("M2tsSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArchiveContainerSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.M2tsSettings != nil {
		v := s.M2tsSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "m2tsSettings", v, metadata)
	}
	return nil
}

// Archive Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ArchiveGroupSettings
type ArchiveGroupSettings struct {
	_ struct{} `type:"structure"`

	// A directory and base filename where archive files should be written.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Number of seconds to write to archive file before closing and starting a
	// new one.
	RolloverInterval *int64 `locationName:"rolloverInterval" min:"1" type:"integer"`
}

// String returns the string representation
func (s ArchiveGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveGroupSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ArchiveGroupSettings"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.RolloverInterval != nil && *s.RolloverInterval < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("RolloverInterval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArchiveGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if s.RolloverInterval != nil {
		v := *s.RolloverInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rolloverInterval", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Archive Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ArchiveOutputSettings
type ArchiveOutputSettings struct {
	_ struct{} `type:"structure"`

	// Settings specific to the container type of the file.
	//
	// ContainerSettings is a required field
	ContainerSettings *ArchiveContainerSettings `locationName:"containerSettings" type:"structure" required:"true"`

	// Output file extension. If excluded, this will be auto-selected from the container
	// type.
	Extension *string `locationName:"extension" type:"string"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s ArchiveOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveOutputSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ArchiveOutputSettings"}

	if s.ContainerSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerSettings"))
	}
	if s.ContainerSettings != nil {
		if err := s.ContainerSettings.Validate(); err != nil {
			invalidParams.AddNested("ContainerSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ArchiveOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContainerSettings != nil {
		v := s.ContainerSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "containerSettings", v, metadata)
	}
	if s.Extension != nil {
		v := *s.Extension

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "extension", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NameModifier != nil {
		v := *s.NameModifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nameModifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Arib Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AribDestinationSettings
type AribDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AribDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AribDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Arib Source Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AribSourceSettings
type AribSourceSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AribSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AribSourceSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Audio Channel Mapping
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioChannelMapping
type AudioChannelMapping struct {
	_ struct{} `type:"structure"`

	// Indices and gain values for each input channel that should be remixed into
	// this output channel.
	//
	// InputChannelLevels is a required field
	InputChannelLevels []InputChannelLevel `locationName:"inputChannelLevels" type:"list" required:"true"`

	// The index of the output channel being produced.
	//
	// OutputChannel is a required field
	OutputChannel *int64 `locationName:"outputChannel" type:"integer" required:"true"`
}

// String returns the string representation
func (s AudioChannelMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioChannelMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioChannelMapping"}

	if s.InputChannelLevels == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputChannelLevels"))
	}

	if s.OutputChannel == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputChannel"))
	}
	if s.InputChannelLevels != nil {
		for i, v := range s.InputChannelLevels {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputChannelLevels", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioChannelMapping) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.InputChannelLevels) > 0 {
		v := s.InputChannelLevels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputChannelLevels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.OutputChannel != nil {
		v := *s.OutputChannel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputChannel", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Audio Codec Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioCodecSettings
type AudioCodecSettings struct {
	_ struct{} `type:"structure"`

	// Aac Settings
	AacSettings *AacSettings `locationName:"aacSettings" type:"structure"`

	// Ac3 Settings
	Ac3Settings *Ac3Settings `locationName:"ac3Settings" type:"structure"`

	// Eac3 Settings
	Eac3Settings *Eac3Settings `locationName:"eac3Settings" type:"structure"`

	// Mp2 Settings
	Mp2Settings *Mp2Settings `locationName:"mp2Settings" type:"structure"`

	// Pass Through Settings
	PassThroughSettings *PassThroughSettings `locationName:"passThroughSettings" type:"structure"`
}

// String returns the string representation
func (s AudioCodecSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioCodecSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioCodecSettings"}
	if s.Ac3Settings != nil {
		if err := s.Ac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Ac3Settings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Eac3Settings != nil {
		if err := s.Eac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Eac3Settings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioCodecSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AacSettings != nil {
		v := s.AacSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "aacSettings", v, metadata)
	}
	if s.Ac3Settings != nil {
		v := s.Ac3Settings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ac3Settings", v, metadata)
	}
	if s.Eac3Settings != nil {
		v := s.Eac3Settings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "eac3Settings", v, metadata)
	}
	if s.Mp2Settings != nil {
		v := s.Mp2Settings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "mp2Settings", v, metadata)
	}
	if s.PassThroughSettings != nil {
		v := s.PassThroughSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "passThroughSettings", v, metadata)
	}
	return nil
}

// Audio Description
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioDescription
type AudioDescription struct {
	_ struct{} `type:"structure"`

	// Advanced audio normalization settings.
	AudioNormalizationSettings *AudioNormalizationSettings `locationName:"audioNormalizationSettings" type:"structure"`

	// The name of the AudioSelector used as the source for this AudioDescription.
	//
	// AudioSelectorName is a required field
	AudioSelectorName *string `locationName:"audioSelectorName" type:"string" required:"true"`

	// Applies only if audioTypeControl is useConfigured. The values for audioType
	// are defined in ISO-IEC 13818-1.
	AudioType AudioType `locationName:"audioType" type:"string" enum:"true"`

	// Determines how audio type is determined. followInput: If the input contains
	// an ISO 639 audioType, then that value is passed through to the output. If
	// the input contains no ISO 639 audioType, the value in Audio Type is included
	// in the output. useConfigured: The value in Audio Type is included in the
	// output.Note that this field and audioType are both ignored if inputType is
	// broadcasterMixedAd.
	AudioTypeControl AudioDescriptionAudioTypeControl `locationName:"audioTypeControl" type:"string" enum:"true"`

	// Audio codec settings.
	CodecSettings *AudioCodecSettings `locationName:"codecSettings" type:"structure"`

	// Indicates the language of the audio output track. Only used if languageControlMode
	// is useConfigured, or there is no ISO 639 language code specified in the input.
	LanguageCode *string `locationName:"languageCode" min:"3" type:"string"`

	// Choosing followInput will cause the ISO 639 language code of the output to
	// follow the ISO 639 language code of the input. The languageCode will be used
	// when useConfigured is set, or when followInput is selected but there is no
	// ISO 639 language code specified by the input.
	LanguageCodeControl AudioDescriptionLanguageCodeControl `locationName:"languageCodeControl" type:"string" enum:"true"`

	// The name of this AudioDescription. Outputs will use this name to uniquely
	// identify this AudioDescription. Description names should be unique within
	// this Live Event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Settings that control how input audio channels are remixed into the output
	// audio channels.
	RemixSettings *RemixSettings `locationName:"remixSettings" type:"structure"`

	// Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by
	// the player (eg. English, or Director Commentary).
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s AudioDescription) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioDescription) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioDescription"}

	if s.AudioSelectorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AudioSelectorName"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("LanguageCode", 3))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.CodecSettings != nil {
		if err := s.CodecSettings.Validate(); err != nil {
			invalidParams.AddNested("CodecSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.RemixSettings != nil {
		if err := s.RemixSettings.Validate(); err != nil {
			invalidParams.AddNested("RemixSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.AudioNormalizationSettings != nil {
		v := s.AudioNormalizationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "audioNormalizationSettings", v, metadata)
	}
	if s.AudioSelectorName != nil {
		v := *s.AudioSelectorName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioSelectorName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AudioType) > 0 {
		v := s.AudioType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.AudioTypeControl) > 0 {
		v := s.AudioTypeControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioTypeControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CodecSettings != nil {
		v := s.CodecSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "codecSettings", v, metadata)
	}
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LanguageCodeControl) > 0 {
		v := s.LanguageCodeControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageCodeControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RemixSettings != nil {
		v := s.RemixSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remixSettings", v, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Audio Language Selection
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioLanguageSelection
type AudioLanguageSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific three-letter language code from within an audio source.
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" type:"string" required:"true"`

	// When set to "strict", the transport stream demux strictly identifies audio
	// streams by their language descriptor. If a PMT update occurs such that an
	// audio stream matching the initially selected language is no longer present
	// then mute will be encoded until the language returns. If "loose", then on
	// a PMT update the demux will choose another audio stream in the program with
	// the same stream type if it can't find one with the same language.
	LanguageSelectionPolicy AudioLanguageSelectionPolicy `locationName:"languageSelectionPolicy" type:"string" enum:"true"`
}

// String returns the string representation
func (s AudioLanguageSelection) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLanguageSelection) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioLanguageSelection"}

	if s.LanguageCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioLanguageSelection) MarshalFields(e protocol.FieldEncoder) error {
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LanguageSelectionPolicy) > 0 {
		v := s.LanguageSelectionPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageSelectionPolicy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Audio Normalization Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioNormalizationSettings
type AudioNormalizationSettings struct {
	_ struct{} `type:"structure"`

	// Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification,
	// itu17702 conforms to the EBU R-128 specification.
	Algorithm AudioNormalizationAlgorithm `locationName:"algorithm" type:"string" enum:"true"`

	// When set to correctAudio the output audio is corrected using the chosen algorithm.
	// If set to measureOnly, the audio will be measured but not adjusted.
	AlgorithmControl AudioNormalizationAlgorithmControl `locationName:"algorithmControl" type:"string" enum:"true"`

	// Target LKFS(loudness) to adjust volume to. If no value is entered, a default
	// value will be used according to the chosen algorithm. The CALM Act (1770-1)
	// recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends
	// a target of -23 LKFS.
	TargetLkfs *float64 `locationName:"targetLkfs" type:"double"`
}

// String returns the string representation
func (s AudioNormalizationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioNormalizationSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Algorithm) > 0 {
		v := s.Algorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "algorithm", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.AlgorithmControl) > 0 {
		v := s.AlgorithmControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "algorithmControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TargetLkfs != nil {
		v := *s.TargetLkfs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetLkfs", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Audio Only Hls Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioOnlyHlsSettings
type AudioOnlyHlsSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the group to which the audio Rendition belongs.
	AudioGroupId *string `locationName:"audioGroupId" type:"string"`

	// For use with an audio only Stream. Must be a .jpg or .png file. If given,
	// this image will be used as the cover-art for the audio only output. Ideally,
	// it should be formatted for an iPhone screen for two reasons. The iPhone does
	// not resize the image, it crops a centered image on the top/bottom and left/right.
	// Additionally, this image file gets saved bit-for-bit into every 10-second
	// segment file, so will increase bandwidth by {image file size} * {segment
	// count} * {user count.}.
	AudioOnlyImage *InputLocation `locationName:"audioOnlyImage" type:"structure"`

	// Four types of audio-only tracks are supported:Audio-Only Variant StreamThe
	// client can play back this audio-only stream instead of video in low-bandwidth
	// scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.Alternate
	// Audio, Auto Select, DefaultAlternate rendition that the client should try
	// to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest
	// with DEFAULT=YES, AUTOSELECT=YESAlternate Audio, Auto Select, Not DefaultAlternate
	// rendition that the client may try to play back by default. Represented as
	// an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YESAlternate
	// Audio, not Auto SelectAlternate rendition that the client will not try to
	// play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with
	// DEFAULT=NO, AUTOSELECT=NO
	AudioTrackType AudioOnlyHlsTrackType `locationName:"audioTrackType" type:"string" enum:"true"`
}

// String returns the string representation
func (s AudioOnlyHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioOnlyHlsSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioOnlyHlsSettings"}
	if s.AudioOnlyImage != nil {
		if err := s.AudioOnlyImage.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyImage", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioOnlyHlsSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AudioGroupId != nil {
		v := *s.AudioGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AudioOnlyImage != nil {
		v := s.AudioOnlyImage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "audioOnlyImage", v, metadata)
	}
	if len(s.AudioTrackType) > 0 {
		v := s.AudioTrackType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioTrackType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Audio Pid Selection
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioPidSelection
type AudioPidSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific PID from within a source.
	//
	// Pid is a required field
	Pid *int64 `locationName:"pid" type:"integer" required:"true"`
}

// String returns the string representation
func (s AudioPidSelection) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioPidSelection) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioPidSelection"}

	if s.Pid == nil {
		invalidParams.Add(aws.NewErrParamRequired("Pid"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioPidSelection) MarshalFields(e protocol.FieldEncoder) error {
	if s.Pid != nil {
		v := *s.Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pid", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Audio Selector
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioSelector
type AudioSelector struct {
	_ struct{} `type:"structure"`

	// The name of this AudioSelector. AudioDescriptions will use this name to uniquely
	// identify this Selector. Selector names should be unique per input.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The audio selector settings.
	SelectorSettings *AudioSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s AudioSelector) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelector) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioSelector"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioSelector) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SelectorSettings != nil {
		v := s.SelectorSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "selectorSettings", v, metadata)
	}
	return nil
}

// Audio Selector Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AudioSelectorSettings
type AudioSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Audio Language Selection
	AudioLanguageSelection *AudioLanguageSelection `locationName:"audioLanguageSelection" type:"structure"`

	// Audio Pid Selection
	AudioPidSelection *AudioPidSelection `locationName:"audioPidSelection" type:"structure"`
}

// String returns the string representation
func (s AudioSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelectorSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AudioSelectorSettings"}
	if s.AudioLanguageSelection != nil {
		if err := s.AudioLanguageSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioLanguageSelection", err.(aws.ErrInvalidParams))
		}
	}
	if s.AudioPidSelection != nil {
		if err := s.AudioPidSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioPidSelection", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AudioSelectorSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AudioLanguageSelection != nil {
		v := s.AudioLanguageSelection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "audioLanguageSelection", v, metadata)
	}
	if s.AudioPidSelection != nil {
		v := s.AudioPidSelection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "audioPidSelection", v, metadata)
	}
	return nil
}

// Avail Blanking
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AvailBlanking
type AvailBlanking struct {
	_ struct{} `type:"structure"`

	// Blanking image to be used. Leave empty for solid black. Only bmp and png
	// images are supported.
	AvailBlankingImage *InputLocation `locationName:"availBlankingImage" type:"structure"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// insertion metadata is added.
	State AvailBlankingState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s AvailBlanking) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailBlanking) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AvailBlanking"}
	if s.AvailBlankingImage != nil {
		if err := s.AvailBlankingImage.Validate(); err != nil {
			invalidParams.AddNested("AvailBlankingImage", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AvailBlanking) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailBlankingImage != nil {
		v := s.AvailBlankingImage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "availBlankingImage", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Avail Configuration
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AvailConfiguration
type AvailConfiguration struct {
	_ struct{} `type:"structure"`

	// Ad avail settings.
	AvailSettings *AvailSettings `locationName:"availSettings" type:"structure"`
}

// String returns the string representation
func (s AvailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AvailConfiguration"}
	if s.AvailSettings != nil {
		if err := s.AvailSettings.Validate(); err != nil {
			invalidParams.AddNested("AvailSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AvailConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailSettings != nil {
		v := s.AvailSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "availSettings", v, metadata)
	}
	return nil
}

// Avail Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AvailSettings
type AvailSettings struct {
	_ struct{} `type:"structure"`

	// Scte35 Splice Insert
	Scte35SpliceInsert *Scte35SpliceInsert `locationName:"scte35SpliceInsert" type:"structure"`

	// Scte35 Time Signal Apos
	Scte35TimeSignalApos *Scte35TimeSignalApos `locationName:"scte35TimeSignalApos" type:"structure"`
}

// String returns the string representation
func (s AvailSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AvailSettings"}
	if s.Scte35SpliceInsert != nil {
		if err := s.Scte35SpliceInsert.Validate(); err != nil {
			invalidParams.AddNested("Scte35SpliceInsert", err.(aws.ErrInvalidParams))
		}
	}
	if s.Scte35TimeSignalApos != nil {
		if err := s.Scte35TimeSignalApos.Validate(); err != nil {
			invalidParams.AddNested("Scte35TimeSignalApos", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AvailSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Scte35SpliceInsert != nil {
		v := s.Scte35SpliceInsert

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte35SpliceInsert", v, metadata)
	}
	if s.Scte35TimeSignalApos != nil {
		v := s.Scte35TimeSignalApos

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte35TimeSignalApos", v, metadata)
	}
	return nil
}

// A list of schedule actions to create (in a request) or that have been created
// (in a response).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchScheduleActionCreateRequest
type BatchScheduleActionCreateRequest struct {
	_ struct{} `type:"structure"`

	// A list of schedule actions to create.
	//
	// ScheduleActions is a required field
	ScheduleActions []ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionCreateRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchScheduleActionCreateRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchScheduleActionCreateRequest"}

	if s.ScheduleActions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduleActions"))
	}
	if s.ScheduleActions != nil {
		for i, v := range s.ScheduleActions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScheduleActions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchScheduleActionCreateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ScheduleActions) > 0 {
		v := s.ScheduleActions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "scheduleActions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// List of actions that have been created in the schedule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchScheduleActionCreateResult
type BatchScheduleActionCreateResult struct {
	_ struct{} `type:"structure"`

	// List of actions that have been created in the schedule.
	//
	// ScheduleActions is a required field
	ScheduleActions []ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionCreateResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchScheduleActionCreateResult) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ScheduleActions) > 0 {
		v := s.ScheduleActions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "scheduleActions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A list of schedule actions to delete.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchScheduleActionDeleteRequest
type BatchScheduleActionDeleteRequest struct {
	_ struct{} `type:"structure"`

	// A list of schedule actions to delete.
	//
	// ActionNames is a required field
	ActionNames []string `locationName:"actionNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionDeleteRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchScheduleActionDeleteRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchScheduleActionDeleteRequest"}

	if s.ActionNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActionNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchScheduleActionDeleteRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ActionNames) > 0 {
		v := s.ActionNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actionNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// List of actions that have been deleted from the schedule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchScheduleActionDeleteResult
type BatchScheduleActionDeleteResult struct {
	_ struct{} `type:"structure"`

	// List of actions that have been deleted from the schedule.
	//
	// ScheduleActions is a required field
	ScheduleActions []ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchScheduleActionDeleteResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchScheduleActionDeleteResult) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ScheduleActions) > 0 {
		v := s.ScheduleActions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "scheduleActions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Blackout Slate
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BlackoutSlate
type BlackoutSlate struct {
	_ struct{} `type:"structure"`

	// Blackout slate image to be used. Leave empty for solid black. Only bmp and
	// png images are supported.
	BlackoutSlateImage *InputLocation `locationName:"blackoutSlateImage" type:"structure"`

	// Setting to enabled causes the encoder to blackout the video, audio, and captions,
	// and raise the "Network Blackout Image" slate when an SCTE104/35 Network End
	// Segmentation Descriptor is encountered. The blackout will be lifted when
	// the Network Start Segmentation Descriptor is encountered. The Network End
	// and Network Start descriptors must contain a network ID that matches the
	// value entered in "Network ID".
	NetworkEndBlackout BlackoutSlateNetworkEndBlackout `locationName:"networkEndBlackout" type:"string" enum:"true"`

	// Path to local file to use as Network End Blackout image. Image will be scaled
	// to fill the entire output raster.
	NetworkEndBlackoutImage *InputLocation `locationName:"networkEndBlackoutImage" type:"structure"`

	// Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
	NetworkId *string `locationName:"networkId" min:"34" type:"string"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// indicated by program metadata.
	State BlackoutSlateState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s BlackoutSlate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlackoutSlate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BlackoutSlate"}
	if s.NetworkId != nil && len(*s.NetworkId) < 34 {
		invalidParams.Add(aws.NewErrParamMinLen("NetworkId", 34))
	}
	if s.BlackoutSlateImage != nil {
		if err := s.BlackoutSlateImage.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlateImage", err.(aws.ErrInvalidParams))
		}
	}
	if s.NetworkEndBlackoutImage != nil {
		if err := s.NetworkEndBlackoutImage.Validate(); err != nil {
			invalidParams.AddNested("NetworkEndBlackoutImage", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BlackoutSlate) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlackoutSlateImage != nil {
		v := s.BlackoutSlateImage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "blackoutSlateImage", v, metadata)
	}
	if len(s.NetworkEndBlackout) > 0 {
		v := s.NetworkEndBlackout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkEndBlackout", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.NetworkEndBlackoutImage != nil {
		v := s.NetworkEndBlackoutImage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "networkEndBlackoutImage", v, metadata)
	}
	if s.NetworkId != nil {
		v := *s.NetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Burn In Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BurnInDestinationSettings
type BurnInDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
	Alignment BurnInAlignment `locationName:"alignment" type:"string" enum:"true"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor BurnInBackgroundColor `locationName:"backgroundColor" type:"string" enum:"true"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter out is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor BurnInFontColor `locationName:"fontColor" type:"string" enum:"true"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to 'auto' fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor BurnInOutlineColor `locationName:"outlineColor" type:"string" enum:"true"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor BurnInShadowColor `locationName:"shadowColor" type:"string" enum:"true"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter out is equivalent to setting it to 0 (transparent). All burn-in
	// and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl BurnInTeletextGridControl `locationName:"teletextGridControl" type:"string" enum:"true"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. All burn-in
	// and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation
func (s BurnInDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BurnInDestinationSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BurnInDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(aws.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BurnInDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Alignment) > 0 {
		v := s.Alignment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "alignment", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.BackgroundColor) > 0 {
		v := s.BackgroundColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "backgroundColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.BackgroundOpacity != nil {
		v := *s.BackgroundOpacity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "backgroundOpacity", protocol.Int64Value(v), metadata)
	}
	if s.Font != nil {
		v := s.Font

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "font", v, metadata)
	}
	if len(s.FontColor) > 0 {
		v := s.FontColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FontOpacity != nil {
		v := *s.FontOpacity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontOpacity", protocol.Int64Value(v), metadata)
	}
	if s.FontResolution != nil {
		v := *s.FontResolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontResolution", protocol.Int64Value(v), metadata)
	}
	if s.FontSize != nil {
		v := *s.FontSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontSize", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OutlineColor) > 0 {
		v := s.OutlineColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outlineColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OutlineSize != nil {
		v := *s.OutlineSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outlineSize", protocol.Int64Value(v), metadata)
	}
	if len(s.ShadowColor) > 0 {
		v := s.ShadowColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ShadowOpacity != nil {
		v := *s.ShadowOpacity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowOpacity", protocol.Int64Value(v), metadata)
	}
	if s.ShadowXOffset != nil {
		v := *s.ShadowXOffset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowXOffset", protocol.Int64Value(v), metadata)
	}
	if s.ShadowYOffset != nil {
		v := *s.ShadowYOffset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowYOffset", protocol.Int64Value(v), metadata)
	}
	if len(s.TeletextGridControl) > 0 {
		v := s.TeletextGridControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "teletextGridControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.XPosition != nil {
		v := *s.XPosition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "xPosition", protocol.Int64Value(v), metadata)
	}
	if s.YPosition != nil {
		v := *s.YPosition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "yPosition", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CaptionDescription
type CaptionDescription struct {
	_ struct{} `type:"structure"`

	// Specifies which input caption selector to use as a caption source when generating
	// output captions. This field should match a captionSelector name.
	//
	// CaptionSelectorName is a required field
	CaptionSelectorName *string `locationName:"captionSelectorName" type:"string" required:"true"`

	// Additional settings for captions destination that depend on the destination
	// type.
	DestinationSettings *CaptionDestinationSettings `locationName:"destinationSettings" type:"structure"`

	// ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Human readable information to indicate captions available for players (eg.
	// English, or Spanish).
	LanguageDescription *string `locationName:"languageDescription" type:"string"`

	// Name of the caption description. Used to associate a caption description
	// with an output. Names must be unique within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CaptionDescription) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDescription) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CaptionDescription"}

	if s.CaptionSelectorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CaptionSelectorName"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.DestinationSettings != nil {
		if err := s.DestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DestinationSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CaptionDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.CaptionSelectorName != nil {
		v := *s.CaptionSelectorName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "captionSelectorName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationSettings != nil {
		v := s.DestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destinationSettings", v, metadata)
	}
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LanguageDescription != nil {
		v := *s.LanguageDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Caption Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CaptionDestinationSettings
type CaptionDestinationSettings struct {
	_ struct{} `type:"structure"`

	// Arib Destination Settings
	AribDestinationSettings *AribDestinationSettings `locationName:"aribDestinationSettings" type:"structure"`

	// Burn In Destination Settings
	BurnInDestinationSettings *BurnInDestinationSettings `locationName:"burnInDestinationSettings" type:"structure"`

	// Dvb Sub Destination Settings
	DvbSubDestinationSettings *DvbSubDestinationSettings `locationName:"dvbSubDestinationSettings" type:"structure"`

	// Embedded Destination Settings
	EmbeddedDestinationSettings *EmbeddedDestinationSettings `locationName:"embeddedDestinationSettings" type:"structure"`

	// Embedded Plus Scte20 Destination Settings
	EmbeddedPlusScte20DestinationSettings *EmbeddedPlusScte20DestinationSettings `locationName:"embeddedPlusScte20DestinationSettings" type:"structure"`

	// Rtmp Caption Info Destination Settings
	RtmpCaptionInfoDestinationSettings *RtmpCaptionInfoDestinationSettings `locationName:"rtmpCaptionInfoDestinationSettings" type:"structure"`

	// Scte20 Plus Embedded Destination Settings
	Scte20PlusEmbeddedDestinationSettings *Scte20PlusEmbeddedDestinationSettings `locationName:"scte20PlusEmbeddedDestinationSettings" type:"structure"`

	// Scte27 Destination Settings
	Scte27DestinationSettings *Scte27DestinationSettings `locationName:"scte27DestinationSettings" type:"structure"`

	// Smpte Tt Destination Settings
	SmpteTtDestinationSettings *SmpteTtDestinationSettings `locationName:"smpteTtDestinationSettings" type:"structure"`

	// Teletext Destination Settings
	TeletextDestinationSettings *TeletextDestinationSettings `locationName:"teletextDestinationSettings" type:"structure"`

	// Ttml Destination Settings
	TtmlDestinationSettings *TtmlDestinationSettings `locationName:"ttmlDestinationSettings" type:"structure"`

	// Webvtt Destination Settings
	WebvttDestinationSettings *WebvttDestinationSettings `locationName:"webvttDestinationSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDestinationSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CaptionDestinationSettings"}
	if s.BurnInDestinationSettings != nil {
		if err := s.BurnInDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("BurnInDestinationSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.DvbSubDestinationSettings != nil {
		if err := s.DvbSubDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubDestinationSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CaptionDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AribDestinationSettings != nil {
		v := s.AribDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "aribDestinationSettings", v, metadata)
	}
	if s.BurnInDestinationSettings != nil {
		v := s.BurnInDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "burnInDestinationSettings", v, metadata)
	}
	if s.DvbSubDestinationSettings != nil {
		v := s.DvbSubDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dvbSubDestinationSettings", v, metadata)
	}
	if s.EmbeddedDestinationSettings != nil {
		v := s.EmbeddedDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "embeddedDestinationSettings", v, metadata)
	}
	if s.EmbeddedPlusScte20DestinationSettings != nil {
		v := s.EmbeddedPlusScte20DestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "embeddedPlusScte20DestinationSettings", v, metadata)
	}
	if s.RtmpCaptionInfoDestinationSettings != nil {
		v := s.RtmpCaptionInfoDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "rtmpCaptionInfoDestinationSettings", v, metadata)
	}
	if s.Scte20PlusEmbeddedDestinationSettings != nil {
		v := s.Scte20PlusEmbeddedDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte20PlusEmbeddedDestinationSettings", v, metadata)
	}
	if s.Scte27DestinationSettings != nil {
		v := s.Scte27DestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte27DestinationSettings", v, metadata)
	}
	if s.SmpteTtDestinationSettings != nil {
		v := s.SmpteTtDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "smpteTtDestinationSettings", v, metadata)
	}
	if s.TeletextDestinationSettings != nil {
		v := s.TeletextDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "teletextDestinationSettings", v, metadata)
	}
	if s.TtmlDestinationSettings != nil {
		v := s.TtmlDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ttmlDestinationSettings", v, metadata)
	}
	if s.WebvttDestinationSettings != nil {
		v := s.WebvttDestinationSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "webvttDestinationSettings", v, metadata)
	}
	return nil
}

// Maps a caption channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2),
// with an optional description.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CaptionLanguageMapping
type CaptionLanguageMapping struct {
	_ struct{} `type:"structure"`

	// The closed caption channel being described by this CaptionLanguageMapping.
	// Each channel mapping must have a unique channel number (maximum of 4)
	//
	// CaptionChannel is a required field
	CaptionChannel *int64 `locationName:"captionChannel" min:"1" type:"integer" required:"true"`

	// Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" min:"3" type:"string" required:"true"`

	// Textual description of language
	//
	// LanguageDescription is a required field
	LanguageDescription *string `locationName:"languageDescription" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CaptionLanguageMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionLanguageMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CaptionLanguageMapping"}

	if s.CaptionChannel == nil {
		invalidParams.Add(aws.NewErrParamRequired("CaptionChannel"))
	}
	if s.CaptionChannel != nil && *s.CaptionChannel < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CaptionChannel", 1))
	}

	if s.LanguageCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("LanguageCode", 3))
	}

	if s.LanguageDescription == nil {
		invalidParams.Add(aws.NewErrParamRequired("LanguageDescription"))
	}
	if s.LanguageDescription != nil && len(*s.LanguageDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LanguageDescription", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CaptionLanguageMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.CaptionChannel != nil {
		v := *s.CaptionChannel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "captionChannel", protocol.Int64Value(v), metadata)
	}
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LanguageDescription != nil {
		v := *s.LanguageDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CaptionSelector
type CaptionSelector struct {
	_ struct{} `type:"structure"`

	// When specified this field indicates the three letter language code of the
	// caption track to extract from the source.
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Name identifier for a caption selector. This name is used to associate this
	// caption selector with one or more caption descriptions. Names must be unique
	// within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Caption selector settings.
	SelectorSettings *CaptionSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionSelector) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelector) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CaptionSelector"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CaptionSelector) MarshalFields(e protocol.FieldEncoder) error {
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "languageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SelectorSettings != nil {
		v := s.SelectorSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "selectorSettings", v, metadata)
	}
	return nil
}

// Caption Selector Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CaptionSelectorSettings
type CaptionSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Arib Source Settings
	AribSourceSettings *AribSourceSettings `locationName:"aribSourceSettings" type:"structure"`

	// Dvb Sub Source Settings
	DvbSubSourceSettings *DvbSubSourceSettings `locationName:"dvbSubSourceSettings" type:"structure"`

	// Embedded Source Settings
	EmbeddedSourceSettings *EmbeddedSourceSettings `locationName:"embeddedSourceSettings" type:"structure"`

	// Scte20 Source Settings
	Scte20SourceSettings *Scte20SourceSettings `locationName:"scte20SourceSettings" type:"structure"`

	// Scte27 Source Settings
	Scte27SourceSettings *Scte27SourceSettings `locationName:"scte27SourceSettings" type:"structure"`

	// Teletext Source Settings
	TeletextSourceSettings *TeletextSourceSettings `locationName:"teletextSourceSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelectorSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CaptionSelectorSettings"}
	if s.DvbSubSourceSettings != nil {
		if err := s.DvbSubSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubSourceSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.EmbeddedSourceSettings != nil {
		if err := s.EmbeddedSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("EmbeddedSourceSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Scte20SourceSettings != nil {
		if err := s.Scte20SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte20SourceSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Scte27SourceSettings != nil {
		if err := s.Scte27SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte27SourceSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CaptionSelectorSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AribSourceSettings != nil {
		v := s.AribSourceSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "aribSourceSettings", v, metadata)
	}
	if s.DvbSubSourceSettings != nil {
		v := s.DvbSubSourceSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dvbSubSourceSettings", v, metadata)
	}
	if s.EmbeddedSourceSettings != nil {
		v := s.EmbeddedSourceSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "embeddedSourceSettings", v, metadata)
	}
	if s.Scte20SourceSettings != nil {
		v := s.Scte20SourceSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte20SourceSettings", v, metadata)
	}
	if s.Scte27SourceSettings != nil {
		v := s.Scte27SourceSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte27SourceSettings", v, metadata)
	}
	if s.TeletextSourceSettings != nil {
		v := s.TeletextSourceSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "teletextSourceSettings", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Channel
type Channel struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass ChannelClass `locationName:"channelClass" type:"string" enum:"true"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level being written to CloudWatch Logs.
	LogLevel LogLevel `locationName:"logLevel" type:"string" enum:"true"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State ChannelState `locationName:"state" type:"string" enum:"true"`

	// A collection of key-value pairs.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Channel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChannelClass) > 0 {
		v := s.ChannelClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Destinations) > 0 {
		v := s.Destinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "destinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.EgressEndpoints) > 0 {
		v := s.EgressEndpoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "egressEndpoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.EncoderSettings != nil {
		v := s.EncoderSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encoderSettings", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.InputAttachments) > 0 {
		v := s.InputAttachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputAttachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.InputSpecification != nil {
		v := s.InputSpecification

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputSpecification", v, metadata)
	}
	if len(s.LogLevel) > 0 {
		v := s.LogLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PipelinesRunningCount != nil {
		v := *s.PipelinesRunningCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelinesRunningCount", protocol.Int64Value(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ChannelEgressEndpoint
type ChannelEgressEndpoint struct {
	_ struct{} `type:"structure"`

	// Public IP of where a channel's output comes from
	SourceIp *string `locationName:"sourceIp" type:"string"`
}

// String returns the string representation
func (s ChannelEgressEndpoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelEgressEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.SourceIp != nil {
		v := *s.SourceIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceIp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ChannelSummary
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass ChannelClass `locationName:"channelClass" type:"string" enum:"true"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level being written to CloudWatch Logs.
	LogLevel LogLevel `locationName:"logLevel" type:"string" enum:"true"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State ChannelState `locationName:"state" type:"string" enum:"true"`

	// A collection of key-value pairs.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChannelClass) > 0 {
		v := s.ChannelClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Destinations) > 0 {
		v := s.Destinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "destinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.EgressEndpoints) > 0 {
		v := s.EgressEndpoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "egressEndpoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.InputAttachments) > 0 {
		v := s.InputAttachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputAttachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.InputSpecification != nil {
		v := s.InputSpecification

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputSpecification", v, metadata)
	}
	if len(s.LogLevel) > 0 {
		v := s.LogLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PipelinesRunningCount != nil {
		v := *s.PipelinesRunningCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelinesRunningCount", protocol.Int64Value(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// DVB Network Information Table (NIT)
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DvbNitSettings
type DvbNitSettings struct {
	_ struct{} `type:"structure"`

	// The numeric value placed in the Network Information Table (NIT).
	//
	// NetworkId is a required field
	NetworkId *int64 `locationName:"networkId" type:"integer" required:"true"`

	// The network name text placed in the networkNameDescriptor inside the Network
	// Information Table. Maximum length is 256 characters.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" min:"1" type:"string" required:"true"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`
}

// String returns the string representation
func (s DvbNitSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbNitSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DvbNitSettings"}

	if s.NetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkId"))
	}

	if s.NetworkName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkName"))
	}
	if s.NetworkName != nil && len(*s.NetworkName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NetworkName", 1))
	}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(aws.NewErrParamMinValue("RepInterval", 25))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DvbNitSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.NetworkId != nil {
		v := *s.NetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkId", protocol.Int64Value(v), metadata)
	}
	if s.NetworkName != nil {
		v := *s.NetworkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepInterval != nil {
		v := *s.RepInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repInterval", protocol.Int64Value(v), metadata)
	}
	return nil
}

// DVB Service Description Table (SDT)
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DvbSdtSettings
type DvbSdtSettings struct {
	_ struct{} `type:"structure"`

	// Selects method of inserting SDT information into output stream. The sdtFollow
	// setting copies SDT information from input stream to output stream. The sdtFollowIfPresent
	// setting copies SDT information from input stream to output stream if SDT
	// information is present in the input, otherwise it will fall back on the user-defined
	// values. The sdtManual setting means user will enter the SDT information.
	// The sdtNone setting means output stream will not contain SDT information.
	OutputSdt DvbSdtOutputSdt `locationName:"outputSdt" type:"string" enum:"true"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`

	// The service name placed in the serviceDescriptor in the Service Description
	// Table. Maximum length is 256 characters.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The service provider name placed in the serviceDescriptor in the Service
	// Description Table. Maximum length is 256 characters.
	ServiceProviderName *string `locationName:"serviceProviderName" min:"1" type:"string"`
}

// String returns the string representation
func (s DvbSdtSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSdtSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DvbSdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(aws.NewErrParamMinValue("RepInterval", 25))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceName", 1))
	}
	if s.ServiceProviderName != nil && len(*s.ServiceProviderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DvbSdtSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.OutputSdt) > 0 {
		v := s.OutputSdt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputSdt", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RepInterval != nil {
		v := *s.RepInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repInterval", protocol.Int64Value(v), metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceProviderName != nil {
		v := *s.ServiceProviderName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceProviderName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Dvb Sub Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DvbSubDestinationSettings
type DvbSubDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. This option is not valid for source captions that
	// are STL or 608/embedded. These source settings are already pre-defined by
	// the caption stream. All burn-in and DVB-Sub font settings must match.
	Alignment DvbSubDestinationAlignment `locationName:"alignment" type:"string" enum:"true"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor DvbSubDestinationBackgroundColor `locationName:"backgroundColor" type:"string" enum:"true"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter blank is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor DvbSubDestinationFontColor `locationName:"fontColor" type:"string" enum:"true"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to auto fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor DvbSubDestinationOutlineColor `locationName:"outlineColor" type:"string" enum:"true"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor DvbSubDestinationShadowColor `locationName:"shadowColor" type:"string" enum:"true"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter blank is equivalent to setting it to 0 (transparent). All
	// burn-in and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl DvbSubDestinationTeletextGridControl `locationName:"teletextGridControl" type:"string" enum:"true"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// This option is not valid for source captions that are STL, 608/embedded or
	// teletext. These source settings are already pre-defined by the caption stream.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. This option
	// is not valid for source captions that are STL, 608/embedded or teletext.
	// These source settings are already pre-defined by the caption stream. All
	// burn-in and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation
func (s DvbSubDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubDestinationSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DvbSubDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(aws.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DvbSubDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Alignment) > 0 {
		v := s.Alignment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "alignment", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.BackgroundColor) > 0 {
		v := s.BackgroundColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "backgroundColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.BackgroundOpacity != nil {
		v := *s.BackgroundOpacity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "backgroundOpacity", protocol.Int64Value(v), metadata)
	}
	if s.Font != nil {
		v := s.Font

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "font", v, metadata)
	}
	if len(s.FontColor) > 0 {
		v := s.FontColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FontOpacity != nil {
		v := *s.FontOpacity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontOpacity", protocol.Int64Value(v), metadata)
	}
	if s.FontResolution != nil {
		v := *s.FontResolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontResolution", protocol.Int64Value(v), metadata)
	}
	if s.FontSize != nil {
		v := *s.FontSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fontSize", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OutlineColor) > 0 {
		v := s.OutlineColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outlineColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OutlineSize != nil {
		v := *s.OutlineSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outlineSize", protocol.Int64Value(v), metadata)
	}
	if len(s.ShadowColor) > 0 {
		v := s.ShadowColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowColor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ShadowOpacity != nil {
		v := *s.ShadowOpacity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowOpacity", protocol.Int64Value(v), metadata)
	}
	if s.ShadowXOffset != nil {
		v := *s.ShadowXOffset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowXOffset", protocol.Int64Value(v), metadata)
	}
	if s.ShadowYOffset != nil {
		v := *s.ShadowYOffset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "shadowYOffset", protocol.Int64Value(v), metadata)
	}
	if len(s.TeletextGridControl) > 0 {
		v := s.TeletextGridControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "teletextGridControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.XPosition != nil {
		v := *s.XPosition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "xPosition", protocol.Int64Value(v), metadata)
	}
	if s.YPosition != nil {
		v := *s.YPosition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "yPosition", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Dvb Sub Source Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DvbSubSourceSettings
type DvbSubSourceSettings struct {
	_ struct{} `type:"structure"`

	// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source
	// content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through,
	// regardless of selectors.
	Pid *int64 `locationName:"pid" min:"1" type:"integer"`
}

// String returns the string representation
func (s DvbSubSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubSourceSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DvbSubSourceSettings"}
	if s.Pid != nil && *s.Pid < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Pid", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DvbSubSourceSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Pid != nil {
		v := *s.Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pid", protocol.Int64Value(v), metadata)
	}
	return nil
}

// DVB Time and Date Table (SDT)
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DvbTdtSettings
type DvbTdtSettings struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"1000" type:"integer"`
}

// String returns the string representation
func (s DvbTdtSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbTdtSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DvbTdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 1000 {
		invalidParams.Add(aws.NewErrParamMinValue("RepInterval", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DvbTdtSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.RepInterval != nil {
		v := *s.RepInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repInterval", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Eac3 Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Eac3Settings
type Eac3Settings struct {
	_ struct{} `type:"structure"`

	// When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
	// Only used for 3/2 coding mode.
	AttenuationControl Eac3AttenuationControl `locationName:"attenuationControl" type:"string" enum:"true"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC
	// A/52-2012 (Annex E) for background on these values.
	BitstreamMode Eac3BitstreamMode `locationName:"bitstreamMode" type:"string" enum:"true"`

	// Dolby Digital Plus coding mode. Determines number of channels.
	CodingMode Eac3CodingMode `locationName:"codingMode" type:"string" enum:"true"`

	// When set to enabled, activates a DC highpass filter for all input channels.
	DcFilter Eac3DcFilter `locationName:"dcFilter" type:"string" enum:"true"`

	// Sets the dialnorm for the output. If blank and input audio is Dolby Digital
	// Plus, dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// Sets the Dolby dynamic range compression profile.
	DrcLine Eac3DrcLine `locationName:"drcLine" type:"string" enum:"true"`

	// Sets the profile for heavy Dolby dynamic range compression, ensures that
	// the instantaneous signal peaks do not exceed specified levels.
	DrcRf Eac3DrcRf `locationName:"drcRf" type:"string" enum:"true"`

	// When encoding 3/2 audio, setting to lfe enables the LFE channel
	LfeControl Eac3LfeControl `locationName:"lfeControl" type:"string" enum:"true"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid with codingMode32 coding mode.
	LfeFilter Eac3LfeFilter `locationName:"lfeFilter" type:"string" enum:"true"`

	// Left only/Right only center mix level. Only used for 3/2 coding mode.
	LoRoCenterMixLevel *float64 `locationName:"loRoCenterMixLevel" type:"double"`

	// Left only/Right only surround mix level. Only used for 3/2 coding mode.
	LoRoSurroundMixLevel *float64 `locationName:"loRoSurroundMixLevel" type:"double"`

	// Left total/Right total center mix level. Only used for 3/2 coding mode.
	LtRtCenterMixLevel *float64 `locationName:"ltRtCenterMixLevel" type:"double"`

	// Left total/Right total surround mix level. Only used for 3/2 coding mode.
	LtRtSurroundMixLevel *float64 `locationName:"ltRtSurroundMixLevel" type:"double"`

	// When set to followInput, encoder metadata will be sourced from the DD, DD+,
	// or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl Eac3MetadataControl `locationName:"metadataControl" type:"string" enum:"true"`

	// When set to whenPossible, input DD+ audio will be passed through if it is
	// present on the input. This detection is dynamic over the life of the transcode.
	// Inputs that alternate between DD+ and non-DD+ content will have a consistent
	// DD+ output as the system alternates between passthrough and encoding.
	PassthroughControl Eac3PassthroughControl `locationName:"passthroughControl" type:"string" enum:"true"`

	// When set to shift90Degrees, applies a 90-degree phase shift to the surround
	// channels. Only used for 3/2 coding mode.
	PhaseControl Eac3PhaseControl `locationName:"phaseControl" type:"string" enum:"true"`

	// Stereo downmix preference. Only used for 3/2 coding mode.
	StereoDownmix Eac3StereoDownmix `locationName:"stereoDownmix" type:"string" enum:"true"`

	// When encoding 3/2 audio, sets whether an extra center back surround channel
	// is matrix encoded into the left and right surround channels.
	SurroundExMode Eac3SurroundExMode `locationName:"surroundExMode" type:"string" enum:"true"`

	// When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into
	// the two channels.
	SurroundMode Eac3SurroundMode `locationName:"surroundMode" type:"string" enum:"true"`
}

// String returns the string representation
func (s Eac3Settings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eac3Settings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Eac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Eac3Settings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttenuationControl) > 0 {
		v := s.AttenuationControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attenuationControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Bitrate != nil {
		v := *s.Bitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitrate", protocol.Float64Value(v), metadata)
	}
	if len(s.BitstreamMode) > 0 {
		v := s.BitstreamMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitstreamMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.CodingMode) > 0 {
		v := s.CodingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "codingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.DcFilter) > 0 {
		v := s.DcFilter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dcFilter", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Dialnorm != nil {
		v := *s.Dialnorm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dialnorm", protocol.Int64Value(v), metadata)
	}
	if len(s.DrcLine) > 0 {
		v := s.DrcLine

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "drcLine", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.DrcRf) > 0 {
		v := s.DrcRf

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "drcRf", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.LfeControl) > 0 {
		v := s.LfeControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lfeControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.LfeFilter) > 0 {
		v := s.LfeFilter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lfeFilter", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LoRoCenterMixLevel != nil {
		v := *s.LoRoCenterMixLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "loRoCenterMixLevel", protocol.Float64Value(v), metadata)
	}
	if s.LoRoSurroundMixLevel != nil {
		v := *s.LoRoSurroundMixLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "loRoSurroundMixLevel", protocol.Float64Value(v), metadata)
	}
	if s.LtRtCenterMixLevel != nil {
		v := *s.LtRtCenterMixLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ltRtCenterMixLevel", protocol.Float64Value(v), metadata)
	}
	if s.LtRtSurroundMixLevel != nil {
		v := *s.LtRtSurroundMixLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ltRtSurroundMixLevel", protocol.Float64Value(v), metadata)
	}
	if len(s.MetadataControl) > 0 {
		v := s.MetadataControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metadataControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.PassthroughControl) > 0 {
		v := s.PassthroughControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passthroughControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.PhaseControl) > 0 {
		v := s.PhaseControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "phaseControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.StereoDownmix) > 0 {
		v := s.StereoDownmix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stereoDownmix", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SurroundExMode) > 0 {
		v := s.SurroundExMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "surroundExMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SurroundMode) > 0 {
		v := s.SurroundMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "surroundMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Embedded Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/EmbeddedDestinationSettings
type EmbeddedDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EmbeddedDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmbeddedDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Embedded Plus Scte20 Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/EmbeddedPlusScte20DestinationSettings
type EmbeddedPlusScte20DestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EmbeddedPlusScte20DestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmbeddedPlusScte20DestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Embedded Source Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/EmbeddedSourceSettings
type EmbeddedSourceSettings struct {
	_ struct{} `type:"structure"`

	// If upconvert, 608 data is both passed through via the "608 compatibility
	// bytes" fields of the 708 wrapper as well as translated into 708. 708 data
	// present in the source content will be discarded.
	Convert608To708 EmbeddedConvert608To708 `locationName:"convert608To708" type:"string" enum:"true"`

	// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20
	// and Embedded captions.
	Scte20Detection EmbeddedScte20Detection `locationName:"scte20Detection" type:"string" enum:"true"`

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber *int64 `locationName:"source608ChannelNumber" min:"1" type:"integer"`

	// This field is unused and deprecated.
	Source608TrackNumber *int64 `locationName:"source608TrackNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s EmbeddedSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmbeddedSourceSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EmbeddedSourceSettings"}
	if s.Source608ChannelNumber != nil && *s.Source608ChannelNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Source608ChannelNumber", 1))
	}
	if s.Source608TrackNumber != nil && *s.Source608TrackNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Source608TrackNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmbeddedSourceSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Convert608To708) > 0 {
		v := s.Convert608To708

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "convert608To708", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Scte20Detection) > 0 {
		v := s.Scte20Detection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scte20Detection", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Source608ChannelNumber != nil {
		v := *s.Source608ChannelNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "source608ChannelNumber", protocol.Int64Value(v), metadata)
	}
	if s.Source608TrackNumber != nil {
		v := *s.Source608TrackNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "source608TrackNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Encoder Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/EncoderSettings
type EncoderSettings struct {
	_ struct{} `type:"structure"`

	// AudioDescriptions is a required field
	AudioDescriptions []AudioDescription `locationName:"audioDescriptions" type:"list" required:"true"`

	// Settings for ad avail blanking.
	AvailBlanking *AvailBlanking `locationName:"availBlanking" type:"structure"`

	// Event-wide configuration settings for ad avail insertion.
	AvailConfiguration *AvailConfiguration `locationName:"availConfiguration" type:"structure"`

	// Settings for blackout slate.
	BlackoutSlate *BlackoutSlate `locationName:"blackoutSlate" type:"structure"`

	// Settings for caption decriptions
	CaptionDescriptions []CaptionDescription `locationName:"captionDescriptions" type:"list"`

	// Configuration settings that apply to the event as a whole.
	GlobalConfiguration *GlobalConfiguration `locationName:"globalConfiguration" type:"structure"`

	// OutputGroups is a required field
	OutputGroups []OutputGroup `locationName:"outputGroups" type:"list" required:"true"`

	// Contains settings used to acquire and adjust timecode information from inputs.
	//
	// TimecodeConfig is a required field
	TimecodeConfig *TimecodeConfig `locationName:"timecodeConfig" type:"structure" required:"true"`

	// VideoDescriptions is a required field
	VideoDescriptions []VideoDescription `locationName:"videoDescriptions" type:"list" required:"true"`
}

// String returns the string representation
func (s EncoderSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncoderSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncoderSettings"}

	if s.AudioDescriptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("AudioDescriptions"))
	}

	if s.OutputGroups == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputGroups"))
	}

	if s.TimecodeConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimecodeConfig"))
	}

	if s.VideoDescriptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("VideoDescriptions"))
	}
	if s.AudioDescriptions != nil {
		for i, v := range s.AudioDescriptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioDescriptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.AvailBlanking != nil {
		if err := s.AvailBlanking.Validate(); err != nil {
			invalidParams.AddNested("AvailBlanking", err.(aws.ErrInvalidParams))
		}
	}
	if s.AvailConfiguration != nil {
		if err := s.AvailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AvailConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.BlackoutSlate != nil {
		if err := s.BlackoutSlate.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlate", err.(aws.ErrInvalidParams))
		}
	}
	if s.CaptionDescriptions != nil {
		for i, v := range s.CaptionDescriptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionDescriptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.GlobalConfiguration != nil {
		if err := s.GlobalConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GlobalConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputGroups != nil {
		for i, v := range s.OutputGroups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputGroups", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TimecodeConfig != nil {
		if err := s.TimecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("TimecodeConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.VideoDescriptions != nil {
		for i, v := range s.VideoDescriptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VideoDescriptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncoderSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AudioDescriptions) > 0 {
		v := s.AudioDescriptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "audioDescriptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AvailBlanking != nil {
		v := s.AvailBlanking

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "availBlanking", v, metadata)
	}
	if s.AvailConfiguration != nil {
		v := s.AvailConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "availConfiguration", v, metadata)
	}
	if s.BlackoutSlate != nil {
		v := s.BlackoutSlate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "blackoutSlate", v, metadata)
	}
	if len(s.CaptionDescriptions) > 0 {
		v := s.CaptionDescriptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "captionDescriptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.GlobalConfiguration != nil {
		v := s.GlobalConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "globalConfiguration", v, metadata)
	}
	if len(s.OutputGroups) > 0 {
		v := s.OutputGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "outputGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TimecodeConfig != nil {
		v := s.TimecodeConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "timecodeConfig", v, metadata)
	}
	if len(s.VideoDescriptions) > 0 {
		v := s.VideoDescriptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "videoDescriptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Fec Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/FecOutputSettings
type FecOutputSettings struct {
	_ struct{} `type:"structure"`

	// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix. The
	// number of transport stream packets per column error correction packet. Must
	// be between 4 and 20, inclusive.
	ColumnDepth *int64 `locationName:"columnDepth" min:"4" type:"integer"`

	// Enables column only or column and row based FEC
	IncludeFec FecOutputIncludeFec `locationName:"includeFec" type:"string" enum:"true"`

	// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix. Must
	// be between 1 and 20, inclusive. If only Column FEC is used, then larger values
	// increase robustness. If Row FEC is used, then this is the number of transport
	// stream packets per row error correction packet, and the value must be between
	// 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column,
	// this value must be 1 to 20, inclusive.
	RowLength *int64 `locationName:"rowLength" min:"1" type:"integer"`
}

// String returns the string representation
func (s FecOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FecOutputSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FecOutputSettings"}
	if s.ColumnDepth != nil && *s.ColumnDepth < 4 {
		invalidParams.Add(aws.NewErrParamMinValue("ColumnDepth", 4))
	}
	if s.RowLength != nil && *s.RowLength < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("RowLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FecOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ColumnDepth != nil {
		v := *s.ColumnDepth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "columnDepth", protocol.Int64Value(v), metadata)
	}
	if len(s.IncludeFec) > 0 {
		v := s.IncludeFec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "includeFec", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RowLength != nil {
		v := *s.RowLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rowLength", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Start time for the action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/FixedModeScheduleActionStartSettings
type FixedModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Start time for the action to start in the channel. (Not the time for the
	// action to be added to the schedule: actions are always added to the schedule
	// immediately.) UTC format: yyyy-mm-ddThh:mm:ss.nnnZ. All the letters are digits
	// (for example, mm might be 01) except for the two constants "T" for time and
	// "Z" for "UTC format".
	//
	// Time is a required field
	Time *string `locationName:"time" type:"string" required:"true"`
}

// String returns the string representation
func (s FixedModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedModeScheduleActionStartSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FixedModeScheduleActionStartSettings"}

	if s.Time == nil {
		invalidParams.Add(aws.NewErrParamRequired("Time"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FixedModeScheduleActionStartSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Time != nil {
		v := *s.Time

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "time", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Settings to specify if an action follows another.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/FollowModeScheduleActionStartSettings
type FollowModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Identifies whether this action starts relative to the start or relative to
	// the end of the reference action.
	//
	// FollowPoint is a required field
	FollowPoint FollowPoint `locationName:"followPoint" type:"string" required:"true" enum:"true"`

	// The action name of another action that this one refers to.
	//
	// ReferenceActionName is a required field
	ReferenceActionName *string `locationName:"referenceActionName" type:"string" required:"true"`
}

// String returns the string representation
func (s FollowModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FollowModeScheduleActionStartSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FollowModeScheduleActionStartSettings"}
	if len(s.FollowPoint) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FollowPoint"))
	}

	if s.ReferenceActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReferenceActionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FollowModeScheduleActionStartSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.FollowPoint) > 0 {
		v := s.FollowPoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "followPoint", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ReferenceActionName != nil {
		v := *s.ReferenceActionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "referenceActionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Frame Capture Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/FrameCaptureGroupSettings
type FrameCaptureGroupSettings struct {
	_ struct{} `type:"structure"`

	// The destination for the frame capture files. Either the URI for an Amazon
	// S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_)
	// or the URI for a MediaStore container, plus a file name prefix (for example,
	// mediastoressl://sportsDelivery/20180820/curling_). The final file names consist
	// of the prefix from the destination field (for example, "curling_") + name
	// modifier + the counter (5 digits, starting from 00001) + extension (which
	// is always .jpg). For example, curlingLow.00001.jpg
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`
}

// String returns the string representation
func (s FrameCaptureGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameCaptureGroupSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FrameCaptureGroupSettings"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FrameCaptureGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	return nil
}

// Frame Capture Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/FrameCaptureOutputSettings
type FrameCaptureOutputSettings struct {
	_ struct{} `type:"structure"`

	// Required if the output group contains more than one output. This modifier
	// forms part of the output file name.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s FrameCaptureOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FrameCaptureOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.NameModifier != nil {
		v := *s.NameModifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nameModifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Frame Capture Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/FrameCaptureSettings
type FrameCaptureSettings struct {
	_ struct{} `type:"structure"`

	// The frequency, in seconds, for capturing frames for inclusion in the output.
	// For example, "10" means capture a frame every 10 seconds.
	//
	// CaptureInterval is a required field
	CaptureInterval *int64 `locationName:"captureInterval" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s FrameCaptureSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameCaptureSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FrameCaptureSettings"}

	if s.CaptureInterval == nil {
		invalidParams.Add(aws.NewErrParamRequired("CaptureInterval"))
	}
	if s.CaptureInterval != nil && *s.CaptureInterval < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CaptureInterval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FrameCaptureSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.CaptureInterval != nil {
		v := *s.CaptureInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "captureInterval", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Global Configuration
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GlobalConfiguration
type GlobalConfiguration struct {
	_ struct{} `type:"structure"`

	// Value to set the initial audio gain for the Live Event.
	InitialAudioGain *int64 `locationName:"initialAudioGain" type:"integer"`

	// Indicates the action to take when the current input completes (e.g. end-of-file).
	// When switchAndLoopInputs is configured the encoder will restart at the beginning
	// of the first input. When "none" is configured the encoder will transcode
	// either black, a solid color, or a user specified slate images per the "Input
	// Loss Behavior" configuration until the next input switch occurs (which is
	// controlled through the Channel Schedule API).
	InputEndAction GlobalConfigurationInputEndAction `locationName:"inputEndAction" type:"string" enum:"true"`

	// Settings for system actions when input is lost.
	InputLossBehavior *InputLossBehavior `locationName:"inputLossBehavior" type:"structure"`

	// Indicates how MediaLive pipelines are synchronized.PIPELINELOCKING - MediaLive
	// will attempt to synchronize the output of each pipeline to the other.EPOCHLOCKING
	// - MediaLive will attempt to synchronize the output of each pipeline to the
	// Unix epoch.
	OutputLockingMode GlobalConfigurationOutputLockingMode `locationName:"outputLockingMode" type:"string" enum:"true"`

	// Indicates whether the rate of frames emitted by the Live encoder should be
	// paced by its system clock (which optionally may be locked to another source
	// via NTP) or should be locked to the clock of the source that is providing
	// the input stream.
	OutputTimingSource GlobalConfigurationOutputTimingSource `locationName:"outputTimingSource" type:"string" enum:"true"`

	// Adjusts video input buffer for streams with very low video framerates. This
	// is commonly set to enabled for music channels with less than one video frame
	// per second.
	SupportLowFramerateInputs GlobalConfigurationLowFramerateInputs `locationName:"supportLowFramerateInputs" type:"string" enum:"true"`
}

// String returns the string representation
func (s GlobalConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlobalConfiguration"}
	if s.InitialAudioGain != nil && *s.InitialAudioGain < -60 {
		invalidParams.Add(aws.NewErrParamMinValue("InitialAudioGain", -60))
	}
	if s.InputLossBehavior != nil {
		if err := s.InputLossBehavior.Validate(); err != nil {
			invalidParams.AddNested("InputLossBehavior", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GlobalConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.InitialAudioGain != nil {
		v := *s.InitialAudioGain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "initialAudioGain", protocol.Int64Value(v), metadata)
	}
	if len(s.InputEndAction) > 0 {
		v := s.InputEndAction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputEndAction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.InputLossBehavior != nil {
		v := s.InputLossBehavior

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputLossBehavior", v, metadata)
	}
	if len(s.OutputLockingMode) > 0 {
		v := s.OutputLockingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputLockingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.OutputTimingSource) > 0 {
		v := s.OutputTimingSource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputTimingSource", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SupportLowFramerateInputs) > 0 {
		v := s.SupportLowFramerateInputs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "supportLowFramerateInputs", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// H264 Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/H264Settings
type H264Settings struct {
	_ struct{} `type:"structure"`

	// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
	// quality.
	AdaptiveQuantization H264AdaptiveQuantization `locationName:"adaptiveQuantization" type:"string" enum:"true"`

	// Indicates that AFD values will be written into the output stream. If afdSignaling
	// is "auto", the system will try to preserve the input AFD value (in cases
	// where multiple AFD values are valid). If set to "fixed", the AFD value will
	// be the value configured in the fixedAfd parameter.
	AfdSignaling AfdSignaling `locationName:"afdSignaling" type:"string" enum:"true"`

	// Average bitrate in bits/second. Required when the rate control mode is VBR
	// or CBR. Not used for QVBR. In an MS Smooth output group, each output must
	// have a unique value when its bitrate is rounded down to the nearest multiple
	// of 1000.
	Bitrate *int64 `locationName:"bitrate" min:"1000" type:"integer"`

	// Percentage of the buffer that should initially be filled (HRD buffer model).
	BufFillPct *int64 `locationName:"bufFillPct" type:"integer"`

	// Size of buffer (HRD buffer model) in bits/second.
	BufSize *int64 `locationName:"bufSize" type:"integer"`

	// Includes colorspace metadata in the output.
	ColorMetadata H264ColorMetadata `locationName:"colorMetadata" type:"string" enum:"true"`

	// Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
	EntropyEncoding H264EntropyEncoding `locationName:"entropyEncoding" type:"string" enum:"true"`

	// Four bit AFD value to write on all frames of video in the output stream.
	// Only valid when afdSignaling is set to 'Fixed'.
	FixedAfd FixedAfd `locationName:"fixedAfd" type:"string" enum:"true"`

	// If set to enabled, adjust quantization within each frame to reduce flicker
	// or 'pop' on I-frames.
	FlickerAq H264FlickerAq `locationName:"flickerAq" type:"string" enum:"true"`

	// This field indicates how the output video frame rate is specified. If "specified"
	// is selected then the output video frame rate is determined by framerateNumerator
	// and framerateDenominator, else if "initializeFromSource" is selected then
	// the output video frame rate will be set equal to the input video frame rate
	// of the first input.
	FramerateControl H264FramerateControl `locationName:"framerateControl" type:"string" enum:"true"`

	// Framerate denominator.
	FramerateDenominator *int64 `locationName:"framerateDenominator" min:"1" type:"integer"`

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976
	// fps.
	FramerateNumerator *int64 `locationName:"framerateNumerator" min:"1" type:"integer"`

	// If enabled, use reference B frames for GOP structures that have B frames
	// > 1.
	GopBReference H264GopBReference `locationName:"gopBReference" type:"string" enum:"true"`

	// Frequency of closed GOPs. In streaming applications, it is recommended that
	// this be set to 1 so a decoder joining mid-stream will receive an IDR frame
	// as quickly as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence *int64 `locationName:"gopClosedCadence" type:"integer"`

	// Number of B-frames between reference frames.
	GopNumBFrames *int64 `locationName:"gopNumBFrames" type:"integer"`

	// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
	// Must be greater than zero.
	GopSize *float64 `locationName:"gopSize" type:"double"`

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits H264GopSizeUnits `locationName:"gopSizeUnits" type:"string" enum:"true"`

	// H.264 Level.
	Level H264Level `locationName:"level" type:"string" enum:"true"`

	// Amount of lookahead. A value of low can decrease latency and memory usage,
	// while high can produce better quality for certain content.
	LookAheadRateControl H264LookAheadRateControl `locationName:"lookAheadRateControl" type:"string" enum:"true"`

	// For QVBR: See the tooltip for Quality level For VBR: Set the maximum bitrate
	// in order to accommodate expected spikes in the complexity of the video.
	MaxBitrate *int64 `locationName:"maxBitrate" min:"1000" type:"integer"`

	// Only meaningful if sceneChangeDetect is set to enabled. Enforces separation
	// between repeated (cadence) I-frames and I-frames inserted by Scene Change
	// Detection. If a scene change I-frame is within I-interval frames of a cadence
	// I-frame, the GOP is shrunk and/or stretched to the scene change I-frame.
	// GOP stretch requires enabling lookahead as well as setting I-interval. The
	// normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP
	// size + Min-I-interval - 1
	MinIInterval *int64 `locationName:"minIInterval" type:"integer"`

	// Number of reference frames to use. The encoder may use more than requested
	// if using B-frames and/or interlaced encoding.
	NumRefFrames *int64 `locationName:"numRefFrames" min:"1" type:"integer"`

	// This field indicates how the output pixel aspect ratio is specified. If "specified"
	// is selected then the output video pixel aspect ratio is determined by parNumerator
	// and parDenominator, else if "initializeFromSource" is selected then the output
	// pixsel aspect ratio will be set equal to the input video pixel aspect ratio
	// of the first input.
	ParControl H264ParControl `locationName:"parControl" type:"string" enum:"true"`

	// Pixel Aspect Ratio denominator.
	ParDenominator *int64 `locationName:"parDenominator" min:"1" type:"integer"`

	// Pixel Aspect Ratio numerator.
	ParNumerator *int64 `locationName:"parNumerator" type:"integer"`

	// H.264 Profile.
	Profile H264Profile `locationName:"profile" type:"string" enum:"true"`

	// Controls the target quality for the video encode. Applies only when the rate
	// control mode is QVBR. Set values for the QVBR quality level field and Max
	// bitrate field that suit your most important viewing devices. Recommended
	// values are:- Primary screen: Quality level: 8 to 10. Max bitrate: 4M- PC
	// or tablet: Quality level: 7. Max bitrate: 1.5M to 3M- Smartphone: Quality
	// level: 6. Max bitrate: 1M to 1.5M
	QvbrQualityLevel *int64 `locationName:"qvbrQualityLevel" min:"1" type:"integer"`

	// Rate control mode. QVBR: Quality will match the specified quality level except
	// when it is constrained by themaximum bitrate. Recommended if you or your
	// viewers pay for bandwidth.VBR: Quality and bitrate vary, depending on the
	// video complexity. Recommended instead of QVBRif you want to maintain a specific
	// average bitrate over the duration of the channel.CBR: Quality varies, depending
	// on the video complexity. Recommended only if you distributeyour assets to
	// devices that cannot handle variable bitrates.
	RateControlMode H264RateControlMode `locationName:"rateControlMode" type:"string" enum:"true"`

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType H264ScanType `locationName:"scanType" type:"string" enum:"true"`

	// Scene change detection.- On: inserts I-frames when scene change is detected.-
	// Off: does not force an I-frame when scene change is detected.
	SceneChangeDetect H264SceneChangeDetect `locationName:"sceneChangeDetect" type:"string" enum:"true"`

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half
	// the number of macroblock rows for interlaced pictures.This field is optional;
	// when no value is specified the encoder will choose the number of slices based
	// on encode resolution.
	Slices *int64 `locationName:"slices" min:"1" type:"integer"`

	// Softness. Selects quantizer matrix, larger values reduce high-frequency content
	// in the encoded image.
	Softness *int64 `locationName:"softness" type:"integer"`

	// If set to enabled, adjust quantization within each frame based on spatial
	// variation of content complexity.
	SpatialAq H264SpatialAq `locationName:"spatialAq" type:"string" enum:"true"`

	// If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic,
	// optimize the number of B-frames used for each sub-GOP to improve visual quality.
	SubgopLength H264SubGopLength `locationName:"subgopLength" type:"string" enum:"true"`

	// Produces a bitstream compliant with SMPTE RP-2027.
	Syntax H264Syntax `locationName:"syntax" type:"string" enum:"true"`

	// If set to enabled, adjust quantization within each frame based on temporal
	// variation of content complexity.
	TemporalAq H264TemporalAq `locationName:"temporalAq" type:"string" enum:"true"`

	// Determines how timecodes should be inserted into the video elementary stream.-
	// 'disabled': Do not include timecodes- 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion H264TimecodeInsertionBehavior `locationName:"timecodeInsertion" type:"string" enum:"true"`
}

// String returns the string representation
func (s H264Settings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *H264Settings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "H264Settings"}
	if s.Bitrate != nil && *s.Bitrate < 1000 {
		invalidParams.Add(aws.NewErrParamMinValue("Bitrate", 1000))
	}
	if s.FramerateDenominator != nil && *s.FramerateDenominator < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FramerateDenominator", 1))
	}
	if s.FramerateNumerator != nil && *s.FramerateNumerator < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FramerateNumerator", 1))
	}
	if s.MaxBitrate != nil && *s.MaxBitrate < 1000 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxBitrate", 1000))
	}
	if s.NumRefFrames != nil && *s.NumRefFrames < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NumRefFrames", 1))
	}
	if s.ParDenominator != nil && *s.ParDenominator < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ParDenominator", 1))
	}
	if s.QvbrQualityLevel != nil && *s.QvbrQualityLevel < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("QvbrQualityLevel", 1))
	}
	if s.Slices != nil && *s.Slices < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Slices", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s H264Settings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdaptiveQuantization) > 0 {
		v := s.AdaptiveQuantization

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adaptiveQuantization", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.AfdSignaling) > 0 {
		v := s.AfdSignaling

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "afdSignaling", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Bitrate != nil {
		v := *s.Bitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitrate", protocol.Int64Value(v), metadata)
	}
	if s.BufFillPct != nil {
		v := *s.BufFillPct

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bufFillPct", protocol.Int64Value(v), metadata)
	}
	if s.BufSize != nil {
		v := *s.BufSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bufSize", protocol.Int64Value(v), metadata)
	}
	if len(s.ColorMetadata) > 0 {
		v := s.ColorMetadata

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "colorMetadata", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.EntropyEncoding) > 0 {
		v := s.EntropyEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entropyEncoding", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.FixedAfd) > 0 {
		v := s.FixedAfd

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fixedAfd", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.FlickerAq) > 0 {
		v := s.FlickerAq

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flickerAq", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.FramerateControl) > 0 {
		v := s.FramerateControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "framerateControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FramerateDenominator != nil {
		v := *s.FramerateDenominator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "framerateDenominator", protocol.Int64Value(v), metadata)
	}
	if s.FramerateNumerator != nil {
		v := *s.FramerateNumerator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "framerateNumerator", protocol.Int64Value(v), metadata)
	}
	if len(s.GopBReference) > 0 {
		v := s.GopBReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gopBReference", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.GopClosedCadence != nil {
		v := *s.GopClosedCadence

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gopClosedCadence", protocol.Int64Value(v), metadata)
	}
	if s.GopNumBFrames != nil {
		v := *s.GopNumBFrames

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gopNumBFrames", protocol.Int64Value(v), metadata)
	}
	if s.GopSize != nil {
		v := *s.GopSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gopSize", protocol.Float64Value(v), metadata)
	}
	if len(s.GopSizeUnits) > 0 {
		v := s.GopSizeUnits

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gopSizeUnits", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Level) > 0 {
		v := s.Level

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "level", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.LookAheadRateControl) > 0 {
		v := s.LookAheadRateControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lookAheadRateControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MaxBitrate != nil {
		v := *s.MaxBitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxBitrate", protocol.Int64Value(v), metadata)
	}
	if s.MinIInterval != nil {
		v := *s.MinIInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minIInterval", protocol.Int64Value(v), metadata)
	}
	if s.NumRefFrames != nil {
		v := *s.NumRefFrames

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numRefFrames", protocol.Int64Value(v), metadata)
	}
	if len(s.ParControl) > 0 {
		v := s.ParControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ParDenominator != nil {
		v := *s.ParDenominator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parDenominator", protocol.Int64Value(v), metadata)
	}
	if s.ParNumerator != nil {
		v := *s.ParNumerator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parNumerator", protocol.Int64Value(v), metadata)
	}
	if len(s.Profile) > 0 {
		v := s.Profile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profile", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.QvbrQualityLevel != nil {
		v := *s.QvbrQualityLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "qvbrQualityLevel", protocol.Int64Value(v), metadata)
	}
	if len(s.RateControlMode) > 0 {
		v := s.RateControlMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rateControlMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ScanType) > 0 {
		v := s.ScanType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scanType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SceneChangeDetect) > 0 {
		v := s.SceneChangeDetect

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sceneChangeDetect", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Slices != nil {
		v := *s.Slices

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "slices", protocol.Int64Value(v), metadata)
	}
	if s.Softness != nil {
		v := *s.Softness

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "softness", protocol.Int64Value(v), metadata)
	}
	if len(s.SpatialAq) > 0 {
		v := s.SpatialAq

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spatialAq", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SubgopLength) > 0 {
		v := s.SubgopLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subgopLength", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Syntax) > 0 {
		v := s.Syntax

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "syntax", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TemporalAq) > 0 {
		v := s.TemporalAq

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "temporalAq", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TimecodeInsertion) > 0 {
		v := s.TimecodeInsertion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timecodeInsertion", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Hls Akamai Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsAkamaiSettings
type HlsAkamaiSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to Akamai. User should
	// contact Akamai to enable this feature.
	HttpTransferMode HlsAkamaiHttpTransferMode `locationName:"httpTransferMode" type:"string" enum:"true"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`

	// Salt for authenticated Akamai.
	Salt *string `locationName:"salt" type:"string"`

	// Token parameter for authenticated akamai. If not specified, _gda_ is used.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation
func (s HlsAkamaiSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsAkamaiSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionRetryInterval != nil {
		v := *s.ConnectionRetryInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionRetryInterval", protocol.Int64Value(v), metadata)
	}
	if s.FilecacheDuration != nil {
		v := *s.FilecacheDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filecacheDuration", protocol.Int64Value(v), metadata)
	}
	if len(s.HttpTransferMode) > 0 {
		v := s.HttpTransferMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "httpTransferMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.NumRetries != nil {
		v := *s.NumRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numRetries", protocol.Int64Value(v), metadata)
	}
	if s.RestartDelay != nil {
		v := *s.RestartDelay

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restartDelay", protocol.Int64Value(v), metadata)
	}
	if s.Salt != nil {
		v := *s.Salt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "salt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Token != nil {
		v := *s.Token

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Hls Basic Put Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsBasicPutSettings
type HlsBasicPutSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsBasicPutSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsBasicPutSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionRetryInterval != nil {
		v := *s.ConnectionRetryInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionRetryInterval", protocol.Int64Value(v), metadata)
	}
	if s.FilecacheDuration != nil {
		v := *s.FilecacheDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filecacheDuration", protocol.Int64Value(v), metadata)
	}
	if s.NumRetries != nil {
		v := *s.NumRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numRetries", protocol.Int64Value(v), metadata)
	}
	if s.RestartDelay != nil {
		v := *s.RestartDelay

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restartDelay", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Hls Cdn Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsCdnSettings
type HlsCdnSettings struct {
	_ struct{} `type:"structure"`

	// Hls Akamai Settings
	HlsAkamaiSettings *HlsAkamaiSettings `locationName:"hlsAkamaiSettings" type:"structure"`

	// Hls Basic Put Settings
	HlsBasicPutSettings *HlsBasicPutSettings `locationName:"hlsBasicPutSettings" type:"structure"`

	// Hls Media Store Settings
	HlsMediaStoreSettings *HlsMediaStoreSettings `locationName:"hlsMediaStoreSettings" type:"structure"`

	// Hls Webdav Settings
	HlsWebdavSettings *HlsWebdavSettings `locationName:"hlsWebdavSettings" type:"structure"`
}

// String returns the string representation
func (s HlsCdnSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsCdnSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.HlsAkamaiSettings != nil {
		v := s.HlsAkamaiSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsAkamaiSettings", v, metadata)
	}
	if s.HlsBasicPutSettings != nil {
		v := s.HlsBasicPutSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsBasicPutSettings", v, metadata)
	}
	if s.HlsMediaStoreSettings != nil {
		v := s.HlsMediaStoreSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsMediaStoreSettings", v, metadata)
	}
	if s.HlsWebdavSettings != nil {
		v := s.HlsWebdavSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsWebdavSettings", v, metadata)
	}
	return nil
}

// Hls Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsGroupSettings
type HlsGroupSettings struct {
	_ struct{} `type:"structure"`

	// Choose one or more ad marker types to pass SCTE35 signals through to this
	// group of Apple HLS outputs.
	AdMarkers []HlsAdMarkers `locationName:"adMarkers" type:"list"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlContent *string `locationName:"baseUrlContent" type:"string"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlManifest *string `locationName:"baseUrlManifest" type:"string"`

	// Mapping of up to 4 caption channels to caption languages. Is only meaningful
	// if captionLanguageSetting is set to "insert".
	CaptionLanguageMappings []CaptionLanguageMapping `locationName:"captionLanguageMappings" type:"list"`

	// Applies only to 608 Embedded output captions.insert: Include CLOSED-CAPTIONS
	// lines in the manifest. Specify at least one language in the CC1 Language
	// Code field. One CLOSED-CAPTION line is added for each Language Code you specify.
	// Make sure to specify the languages in the order in which they appear in the
	// original source (if the source is embedded format) or the order of the caption
	// selectors (if the source is other than embedded). Otherwise, languages in
	// the manifest will not match up properly with the output captions.none: Include
	// CLOSED-CAPTIONS=NONE line in the manifest.omit: Omit any CLOSED-CAPTIONS
	// line from the manifest.
	CaptionLanguageSetting HlsCaptionLanguageSetting `locationName:"captionLanguageSetting" type:"string" enum:"true"`

	// When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest,
	// which prevents clients from saving media segments for later replay.
	ClientCache HlsClientCache `locationName:"clientCache" type:"string" enum:"true"`

	// Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist
	// generation.
	CodecSpecification HlsCodecSpecification `locationName:"codecSpecification" type:"string" enum:"true"`

	// For use with encryptionType. This is a 128-bit, 16-byte hex value represented
	// by a 32-character text string. If ivSource is set to "explicit" then this
	// parameter is required and is used as the IV for encryption.
	ConstantIv *string `locationName:"constantIv" min:"32" type:"string"`

	// A directory or HTTP destination for the HLS segments, manifest files, and
	// encryption keys (if enabled).
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Place segments in subdirectories.
	DirectoryStructure HlsDirectoryStructure `locationName:"directoryStructure" type:"string" enum:"true"`

	// Encrypts the segments with the given encryption scheme. Exclude this parameter
	// if no encryption is desired.
	EncryptionType HlsEncryptionType `locationName:"encryptionType" type:"string" enum:"true"`

	// Parameters that control interactions with the CDN.
	HlsCdnSettings *HlsCdnSettings `locationName:"hlsCdnSettings" type:"structure"`

	// DISABLED: Do not create an I-frame-only manifest, but do create the master
	// and media manifests (according to the Output Selection field).STANDARD: Create
	// an I-frame-only manifest for each output that contains video, as well as
	// the other manifests (according to the Output Selection field). The I-frame
	// manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only,
	// and one or more #EXT-X-BYTERANGE entries identifying the I-frame position.
	// For example, #EXT-X-BYTERANGE:160364@1461888"
	IFrameOnlyPlaylists IFrameOnlyPlaylistType `locationName:"iFrameOnlyPlaylists" type:"string" enum:"true"`

	// Applies only if Mode field is LIVE. Specifies the maximum number of segments
	// in the media manifest file. After this maximum, older segments are removed
	// from the media manifest. This number must be less than or equal to the Keep
	// Segments field.
	IndexNSegments *int64 `locationName:"indexNSegments" min:"3" type:"integer"`

	// Parameter that control output group behavior on input loss.
	InputLossAction InputLossActionForHlsOut `locationName:"inputLossAction" type:"string" enum:"true"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If set to
	// "include", IV is listed in the manifest, otherwise the IV is not in the manifest.
	IvInManifest HlsIvInManifest `locationName:"ivInManifest" type:"string" enum:"true"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If this setting
	// is "followsSegmentNumber", it will cause the IV to change every segment (to
	// match the segment number). If this is set to "explicit", you must enter a
	// constantIv value.
	IvSource HlsIvSource `locationName:"ivSource" type:"string" enum:"true"`

	// Applies only if Mode field is LIVE. Specifies the number of media segments
	// (.ts files) to retain in the destination directory.
	KeepSegments *int64 `locationName:"keepSegments" min:"1" type:"integer"`

	// The value specifies how the key is represented in the resource identified
	// by the URI. If parameter is absent, an implicit value of "identity" is used.
	// A reverse DNS string can also be given.
	KeyFormat *string `locationName:"keyFormat" type:"string"`

	// Either a single positive integer version value or a slash delimited list
	// of version values (1/2/3).
	KeyFormatVersions *string `locationName:"keyFormatVersions" type:"string"`

	// The key provider settings.
	KeyProviderSettings *KeyProviderSettings `locationName:"keyProviderSettings" type:"structure"`

	// When set to gzip, compresses HLS playlist.
	ManifestCompression HlsManifestCompression `locationName:"manifestCompression" type:"string" enum:"true"`

	// Indicates whether the output manifest should use floating point or integer
	// values for segment duration.
	ManifestDurationFormat HlsManifestDurationFormat `locationName:"manifestDurationFormat" type:"string" enum:"true"`

	// When set, minimumSegmentLength is enforced by looking ahead and back within
	// the specified range for a nearby avail and extending the segment size if
	// needed.
	MinSegmentLength *int64 `locationName:"minSegmentLength" type:"integer"`

	// If "vod", all segments are indexed and kept permanently in the destination
	// and manifest. If "live", only the number segments specified in keepSegments
	// and indexNSegments are kept; newer segments replace older segments, which
	// may prevent players from rewinding all the way to the beginning of the event.VOD
	// mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running,
	// converting it to a "VOD" type manifest on completion of the stream.
	Mode HlsMode `locationName:"mode" type:"string" enum:"true"`

	// MANIFESTSANDSEGMENTS: Generates manifests (master manifest, if applicable,
	// and media manifests) for this output group.SEGMENTSONLY: Does not generate
	// any manifests for this output group.
	OutputSelection HlsOutputSelection `locationName:"outputSelection" type:"string" enum:"true"`

	// Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files.
	// The value is calculated as follows: either the program date and time are
	// initialized using the input timecode source, or the time is initialized using
	// the input timecode source and the date is initialized using the timestampOffset.
	ProgramDateTime HlsProgramDateTime `locationName:"programDateTime" type:"string" enum:"true"`

	// Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
	ProgramDateTimePeriod *int64 `locationName:"programDateTimePeriod" type:"integer"`

	// ENABLED: The master manifest (.m3u8 file) for each pipeline includes information
	// about both pipelines: first its own media files, then the media files of
	// the other pipeline. This feature allows playout device that support stale
	// manifest detection to switch from one manifest to the other, when the current
	// manifest seems to be stale. There are still two destinations and two master
	// manifests, but both master manifests reference the media files from both
	// pipelines.DISABLED: The master manifest (.m3u8 file) for each pipeline includes
	// information about its own pipeline only.For an HLS output group with MediaPackage
	// as the destination, the DISABLED behavior is always followed. MediaPackage
	// regenerates the manifests it serves to players so a redundant manifest from
	// MediaLive is irrelevant.
	RedundantManifest HlsRedundantManifest `locationName:"redundantManifest" type:"string" enum:"true"`

	// Length of MPEG-2 Transport Stream segments to create (in seconds). Note that
	// segments will end on the next keyframe after this number of seconds, so actual
	// segment length may be longer.
	SegmentLength *int64 `locationName:"segmentLength" min:"1" type:"integer"`

	// useInputSegmentation has been deprecated. The configured segment size is
	// always used.
	SegmentationMode HlsSegmentationMode `locationName:"segmentationMode" type:"string" enum:"true"`

	// Number of segments to write to a subdirectory before starting a new one.
	// directoryStructure must be subdirectoryPerStream for this setting to have
	// an effect.
	SegmentsPerSubdirectory *int64 `locationName:"segmentsPerSubdirectory" min:"1" type:"integer"`

	// Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag
	// of variant manifest.
	StreamInfResolution HlsStreamInfResolution `locationName:"streamInfResolution" type:"string" enum:"true"`

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame HlsTimedMetadataId3Frame `locationName:"timedMetadataId3Frame" type:"string" enum:"true"`

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period *int64 `locationName:"timedMetadataId3Period" type:"integer"`

	// Provides an extra millisecond delta offset to fine tune the timestamps.
	TimestampDeltaMilliseconds *int64 `locationName:"timestampDeltaMilliseconds" type:"integer"`

	// SEGMENTEDFILES: Emit the program as segments - multiple .ts media files.SINGLEFILE:
	// Applies only if Mode field is VOD. Emit the program as a single .ts media
	// file. The media manifest includes #EXT-X-BYTERANGE tags to index segments
	// for playback. A typical use for this value is when sending the output to
	// AWS Elemental MediaConvert, which can accept only a single media file. Playback
	// while the channel is running is not guaranteed due to HTTP server caching.
	TsFileMode HlsTsFileMode `locationName:"tsFileMode" type:"string" enum:"true"`
}

// String returns the string representation
func (s HlsGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsGroupSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HlsGroupSettings"}
	if s.ConstantIv != nil && len(*s.ConstantIv) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("ConstantIv", 32))
	}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.IndexNSegments != nil && *s.IndexNSegments < 3 {
		invalidParams.Add(aws.NewErrParamMinValue("IndexNSegments", 3))
	}
	if s.KeepSegments != nil && *s.KeepSegments < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("KeepSegments", 1))
	}
	if s.SegmentLength != nil && *s.SegmentLength < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("SegmentLength", 1))
	}
	if s.SegmentsPerSubdirectory != nil && *s.SegmentsPerSubdirectory < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("SegmentsPerSubdirectory", 1))
	}
	if s.CaptionLanguageMappings != nil {
		for i, v := range s.CaptionLanguageMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionLanguageMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.KeyProviderSettings != nil {
		if err := s.KeyProviderSettings.Validate(); err != nil {
			invalidParams.AddNested("KeyProviderSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdMarkers) > 0 {
		v := s.AdMarkers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "adMarkers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.BaseUrlContent != nil {
		v := *s.BaseUrlContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "baseUrlContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BaseUrlManifest != nil {
		v := *s.BaseUrlManifest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "baseUrlManifest", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CaptionLanguageMappings) > 0 {
		v := s.CaptionLanguageMappings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "captionLanguageMappings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.CaptionLanguageSetting) > 0 {
		v := s.CaptionLanguageSetting

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "captionLanguageSetting", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ClientCache) > 0 {
		v := s.ClientCache

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCache", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.CodecSpecification) > 0 {
		v := s.CodecSpecification

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "codecSpecification", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ConstantIv != nil {
		v := *s.ConstantIv

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "constantIv", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if len(s.DirectoryStructure) > 0 {
		v := s.DirectoryStructure

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "directoryStructure", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.EncryptionType) > 0 {
		v := s.EncryptionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "encryptionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.HlsCdnSettings != nil {
		v := s.HlsCdnSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsCdnSettings", v, metadata)
	}
	if len(s.IFrameOnlyPlaylists) > 0 {
		v := s.IFrameOnlyPlaylists

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iFrameOnlyPlaylists", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IndexNSegments != nil {
		v := *s.IndexNSegments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "indexNSegments", protocol.Int64Value(v), metadata)
	}
	if len(s.InputLossAction) > 0 {
		v := s.InputLossAction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputLossAction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.IvInManifest) > 0 {
		v := s.IvInManifest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ivInManifest", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.IvSource) > 0 {
		v := s.IvSource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ivSource", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.KeepSegments != nil {
		v := *s.KeepSegments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keepSegments", protocol.Int64Value(v), metadata)
	}
	if s.KeyFormat != nil {
		v := *s.KeyFormat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyFormat", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyFormatVersions != nil {
		v := *s.KeyFormatVersions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyFormatVersions", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyProviderSettings != nil {
		v := s.KeyProviderSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "keyProviderSettings", v, metadata)
	}
	if len(s.ManifestCompression) > 0 {
		v := s.ManifestCompression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestCompression", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ManifestDurationFormat) > 0 {
		v := s.ManifestDurationFormat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "manifestDurationFormat", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MinSegmentLength != nil {
		v := *s.MinSegmentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minSegmentLength", protocol.Int64Value(v), metadata)
	}
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.OutputSelection) > 0 {
		v := s.OutputSelection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputSelection", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ProgramDateTime) > 0 {
		v := s.ProgramDateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programDateTime", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ProgramDateTimePeriod != nil {
		v := *s.ProgramDateTimePeriod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programDateTimePeriod", protocol.Int64Value(v), metadata)
	}
	if len(s.RedundantManifest) > 0 {
		v := s.RedundantManifest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "redundantManifest", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SegmentLength != nil {
		v := *s.SegmentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentLength", protocol.Int64Value(v), metadata)
	}
	if len(s.SegmentationMode) > 0 {
		v := s.SegmentationMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SegmentsPerSubdirectory != nil {
		v := *s.SegmentsPerSubdirectory

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentsPerSubdirectory", protocol.Int64Value(v), metadata)
	}
	if len(s.StreamInfResolution) > 0 {
		v := s.StreamInfResolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamInfResolution", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TimedMetadataId3Frame) > 0 {
		v := s.TimedMetadataId3Frame

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataId3Frame", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimedMetadataId3Period != nil {
		v := *s.TimedMetadataId3Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataId3Period", protocol.Int64Value(v), metadata)
	}
	if s.TimestampDeltaMilliseconds != nil {
		v := *s.TimestampDeltaMilliseconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timestampDeltaMilliseconds", protocol.Int64Value(v), metadata)
	}
	if len(s.TsFileMode) > 0 {
		v := s.TsFileMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tsFileMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Hls Input Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsInputSettings
type HlsInputSettings struct {
	_ struct{} `type:"structure"`

	// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches
	// this value will be chosen, otherwise the highest bandwidth stream in the
	// m3u8 will be chosen. The bitrate is specified in bits per second, as in an
	// HLS manifest.
	Bandwidth *int64 `locationName:"bandwidth" type:"integer"`

	// When specified, reading of the HLS input will begin this many buffer segments
	// from the end (most recently written segment). When not specified, the HLS
	// input will begin with the first segment specified in the m3u8.
	BufferSegments *int64 `locationName:"bufferSegments" type:"integer"`

	// The number of consecutive times that attempts to read a manifest or segment
	// must fail before the input is considered unavailable.
	Retries *int64 `locationName:"retries" type:"integer"`

	// The number of seconds between retries when an attempt to read a manifest
	// or segment fails.
	RetryInterval *int64 `locationName:"retryInterval" type:"integer"`
}

// String returns the string representation
func (s HlsInputSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsInputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bandwidth != nil {
		v := *s.Bandwidth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bandwidth", protocol.Int64Value(v), metadata)
	}
	if s.BufferSegments != nil {
		v := *s.BufferSegments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bufferSegments", protocol.Int64Value(v), metadata)
	}
	if s.Retries != nil {
		v := *s.Retries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "retries", protocol.Int64Value(v), metadata)
	}
	if s.RetryInterval != nil {
		v := *s.RetryInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "retryInterval", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Hls Media Store Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsMediaStoreSettings
type HlsMediaStoreSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// When set to temporal, output files are stored in non-persistent memory for
	// faster reading and writing.
	MediaStoreStorageClass HlsMediaStoreStorageClass `locationName:"mediaStoreStorageClass" type:"string" enum:"true"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsMediaStoreSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsMediaStoreSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionRetryInterval != nil {
		v := *s.ConnectionRetryInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionRetryInterval", protocol.Int64Value(v), metadata)
	}
	if s.FilecacheDuration != nil {
		v := *s.FilecacheDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filecacheDuration", protocol.Int64Value(v), metadata)
	}
	if len(s.MediaStoreStorageClass) > 0 {
		v := s.MediaStoreStorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mediaStoreStorageClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.NumRetries != nil {
		v := *s.NumRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numRetries", protocol.Int64Value(v), metadata)
	}
	if s.RestartDelay != nil {
		v := *s.RestartDelay

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restartDelay", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Hls Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsOutputSettings
type HlsOutputSettings struct {
	_ struct{} `type:"structure"`

	// Settings regarding the underlying stream. These settings are different for
	// audio-only outputs.
	//
	// HlsSettings is a required field
	HlsSettings *HlsSettings `locationName:"hlsSettings" type:"structure" required:"true"`

	// String concatenated to the end of the destination filename. Accepts \"Format
	// Identifiers\":#formatIdentifierParameters.
	NameModifier *string `locationName:"nameModifier" min:"1" type:"string"`

	// String concatenated to end of segment filenames.
	SegmentModifier *string `locationName:"segmentModifier" type:"string"`
}

// String returns the string representation
func (s HlsOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsOutputSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HlsOutputSettings"}

	if s.HlsSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("HlsSettings"))
	}
	if s.NameModifier != nil && len(*s.NameModifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NameModifier", 1))
	}
	if s.HlsSettings != nil {
		if err := s.HlsSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.HlsSettings != nil {
		v := s.HlsSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsSettings", v, metadata)
	}
	if s.NameModifier != nil {
		v := *s.NameModifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nameModifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentModifier != nil {
		v := *s.SegmentModifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentModifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Hls Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsSettings
type HlsSettings struct {
	_ struct{} `type:"structure"`

	// Audio Only Hls Settings
	AudioOnlyHlsSettings *AudioOnlyHlsSettings `locationName:"audioOnlyHlsSettings" type:"structure"`

	// Standard Hls Settings
	StandardHlsSettings *StandardHlsSettings `locationName:"standardHlsSettings" type:"structure"`
}

// String returns the string representation
func (s HlsSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HlsSettings"}
	if s.AudioOnlyHlsSettings != nil {
		if err := s.AudioOnlyHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyHlsSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.StandardHlsSettings != nil {
		if err := s.StandardHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("StandardHlsSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AudioOnlyHlsSettings != nil {
		v := s.AudioOnlyHlsSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "audioOnlyHlsSettings", v, metadata)
	}
	if s.StandardHlsSettings != nil {
		v := s.StandardHlsSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "standardHlsSettings", v, metadata)
	}
	return nil
}

// Settings for the action to emit HLS metadata
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsTimedMetadataScheduleActionSettings
type HlsTimedMetadataScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
	//
	// Id3 is a required field
	Id3 *string `locationName:"id3" type:"string" required:"true"`
}

// String returns the string representation
func (s HlsTimedMetadataScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsTimedMetadataScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HlsTimedMetadataScheduleActionSettings"}

	if s.Id3 == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id3"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsTimedMetadataScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id3 != nil {
		v := *s.Id3

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id3", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Hls Webdav Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/HlsWebdavSettings
type HlsWebdavSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to WebDAV.
	HttpTransferMode HlsWebdavHttpTransferMode `locationName:"httpTransferMode" type:"string" enum:"true"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsWebdavSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HlsWebdavSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionRetryInterval != nil {
		v := *s.ConnectionRetryInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionRetryInterval", protocol.Int64Value(v), metadata)
	}
	if s.FilecacheDuration != nil {
		v := *s.FilecacheDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filecacheDuration", protocol.Int64Value(v), metadata)
	}
	if len(s.HttpTransferMode) > 0 {
		v := s.HttpTransferMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "httpTransferMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.NumRetries != nil {
		v := *s.NumRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numRetries", protocol.Int64Value(v), metadata)
	}
	if s.RestartDelay != nil {
		v := *s.RestartDelay

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restartDelay", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Input
type Input struct {
	_ struct{} `type:"structure"`

	// The Unique ARN of the input (generated, immutable).
	Arn *string `locationName:"arn" type:"string"`

	// A list of channel IDs that that input is attached to (currently an input
	// can only be attached to one channel).
	AttachedChannels []string `locationName:"attachedChannels" type:"list"`

	// A list of the destinations of the input (PUSH-type).
	Destinations []InputDestination `locationName:"destinations" type:"list"`

	// The generated ID of the input (unique for user account, immutable).
	Id *string `locationName:"id" type:"string"`

	// STANDARD - MediaLive expects two sources to be connected to this input. If
	// the channel is also STANDARD, both sources will be ingested. If the channel
	// is SINGLE_PIPELINE, only the first source will be ingested; the second source
	// will always be ignored, even if the first source fails.SINGLE_PIPELINE -
	// You can connect only one source to this input. If the ChannelClass is also
	// SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this
	// value is not valid because the channel requires two sources in the input.
	InputClass InputClass `locationName:"inputClass" type:"string" enum:"true"`

	// A list of MediaConnect Flows for this input.
	MediaConnectFlows []MediaConnectFlow `locationName:"mediaConnectFlows" type:"list"`

	// The user-assigned name (This is a mutable value).
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the role this input assumes during and
	// after creation.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// A list of IDs for all the Input Security Groups attached to the input.
	SecurityGroups []string `locationName:"securityGroups" type:"list"`

	// A list of the sources of the input (PULL-type).
	Sources []InputSource `locationName:"sources" type:"list"`

	State InputState `locationName:"state" type:"string" enum:"true"`

	// A collection of key-value pairs.
	Tags map[string]string `locationName:"tags" type:"map"`

	Type InputType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Input) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AttachedChannels) > 0 {
		v := s.AttachedChannels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attachedChannels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Destinations) > 0 {
		v := s.Destinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "destinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.InputClass) > 0 {
		v := s.InputClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.MediaConnectFlows) > 0 {
		v := s.MediaConnectFlows

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "mediaConnectFlows", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SecurityGroups) > 0 {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Sources) > 0 {
		v := s.Sources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "sources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputAttachment
type InputAttachment struct {
	_ struct{} `type:"structure"`

	// User-specified name for the attachment. This is required if the user wants
	// to use this input in an input switch action.
	InputAttachmentName *string `locationName:"inputAttachmentName" type:"string"`

	// The ID of the input
	InputId *string `locationName:"inputId" type:"string"`

	// Settings of an input (caption selector, etc.)
	InputSettings *InputSettings `locationName:"inputSettings" type:"structure"`
}

// String returns the string representation
func (s InputAttachment) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputAttachment) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputAttachment"}
	if s.InputSettings != nil {
		if err := s.InputSettings.Validate(); err != nil {
			invalidParams.AddNested("InputSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputAttachment) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputAttachmentName != nil {
		v := *s.InputAttachmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputAttachmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputId != nil {
		v := *s.InputId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputSettings != nil {
		v := s.InputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputSettings", v, metadata)
	}
	return nil
}

// Input Channel Level
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputChannelLevel
type InputChannelLevel struct {
	_ struct{} `type:"structure"`

	// Remixing value. Units are in dB and acceptable values are within the range
	// from -60 (mute) and 6 dB.
	//
	// Gain is a required field
	Gain *int64 `locationName:"gain" type:"integer" required:"true"`

	// The index of the input channel used as a source.
	//
	// InputChannel is a required field
	InputChannel *int64 `locationName:"inputChannel" type:"integer" required:"true"`
}

// String returns the string representation
func (s InputChannelLevel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputChannelLevel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputChannelLevel"}

	if s.Gain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Gain"))
	}
	if s.Gain != nil && *s.Gain < -60 {
		invalidParams.Add(aws.NewErrParamMinValue("Gain", -60))
	}

	if s.InputChannel == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputChannel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputChannelLevel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Gain != nil {
		v := *s.Gain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gain", protocol.Int64Value(v), metadata)
	}
	if s.InputChannel != nil {
		v := *s.InputChannel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputChannel", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The settings for a PUSH type input.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputDestination
type InputDestination struct {
	_ struct{} `type:"structure"`

	// The system-generated static IP address of endpoint.It remains fixed for the
	// lifetime of the input.
	Ip *string `locationName:"ip" type:"string"`

	// The port number for the input.
	Port *string `locationName:"port" type:"string"`

	// This represents the endpoint that the customer stream will bepushed to.
	Url *string `locationName:"url" type:"string"`

	// The properties for a VPC type input destination.
	Vpc *InputDestinationVpc `locationName:"vpc" type:"structure"`
}

// String returns the string representation
func (s InputDestination) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.Ip != nil {
		v := *s.Ip

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ip", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Vpc != nil {
		v := s.Vpc

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "vpc", v, metadata)
	}
	return nil
}

// Endpoint settings for a PUSH type input.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputDestinationRequest
type InputDestinationRequest struct {
	_ struct{} `type:"structure"`

	// A unique name for the location the RTMP stream is being pushedto.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s InputDestinationRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputDestinationRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The properties for a VPC type input destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputDestinationVpc
type InputDestinationVpc struct {
	_ struct{} `type:"structure"`

	// The availability zone of the Input destination.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The network interface ID of the Input destination in the VPC.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`
}

// String returns the string representation
func (s InputDestinationVpc) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputDestinationVpc) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "availabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkInterfaceId != nil {
		v := *s.NetworkInterfaceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkInterfaceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Input Location
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputLocation
type InputLocation struct {
	_ struct{} `type:"structure"`

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// Uniform Resource Identifier - This should be a path to a file accessible
	// to the Live system (eg. a http:// URI) depending on the output type. For
	// example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
	//
	// Uri is a required field
	Uri *string `locationName:"uri" type:"string" required:"true"`

	// Username if credentials are required to access a file or publishing point.
	// This can be either a plaintext username, or a reference to an AWS parameter
	// store name from which the username can be retrieved. AWS Parameter store
	// format: "ssm://"
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputLocation"}

	if s.Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.PasswordParam != nil {
		v := *s.PasswordParam

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passwordParam", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Uri != nil {
		v := *s.Uri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "uri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Input Loss Behavior
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputLossBehavior
type InputLossBehavior struct {
	_ struct{} `type:"structure"`

	// On input loss, the number of milliseconds to substitute black into the output
	// before switching to the frame specified by inputLossImageType. A value x,
	// where 0 <= x <= 1,000,000 and a value of 1,000,000 will be interpreted as
	// infinite.
	BlackFrameMsec *int64 `locationName:"blackFrameMsec" type:"integer"`

	// When input loss image type is "color" this field specifies the color to use.
	// Value: 6 hex characters representing the values of RGB.
	InputLossImageColor *string `locationName:"inputLossImageColor" min:"6" type:"string"`

	// When input loss image type is "slate" these fields specify the parameters
	// for accessing the slate.
	InputLossImageSlate *InputLocation `locationName:"inputLossImageSlate" type:"structure"`

	// Indicates whether to substitute a solid color or a slate into the output
	// after input loss exceeds blackFrameMsec.
	InputLossImageType InputLossImageType `locationName:"inputLossImageType" type:"string" enum:"true"`

	// On input loss, the number of milliseconds to repeat the previous picture
	// before substituting black into the output. A value x, where 0 <= x <= 1,000,000
	// and a value of 1,000,000 will be interpreted as infinite.
	RepeatFrameMsec *int64 `locationName:"repeatFrameMsec" type:"integer"`
}

// String returns the string representation
func (s InputLossBehavior) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLossBehavior) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputLossBehavior"}
	if s.InputLossImageColor != nil && len(*s.InputLossImageColor) < 6 {
		invalidParams.Add(aws.NewErrParamMinLen("InputLossImageColor", 6))
	}
	if s.InputLossImageSlate != nil {
		if err := s.InputLossImageSlate.Validate(); err != nil {
			invalidParams.AddNested("InputLossImageSlate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputLossBehavior) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlackFrameMsec != nil {
		v := *s.BlackFrameMsec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blackFrameMsec", protocol.Int64Value(v), metadata)
	}
	if s.InputLossImageColor != nil {
		v := *s.InputLossImageColor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputLossImageColor", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InputLossImageSlate != nil {
		v := s.InputLossImageSlate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputLossImageSlate", v, metadata)
	}
	if len(s.InputLossImageType) > 0 {
		v := s.InputLossImageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputLossImageType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RepeatFrameMsec != nil {
		v := *s.RepeatFrameMsec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repeatFrameMsec", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An Input Security Group
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputSecurityGroup
type InputSecurityGroup struct {
	_ struct{} `type:"structure"`

	// Unique ARN of Input Security Group
	Arn *string `locationName:"arn" type:"string"`

	// The Id of the Input Security Group
	Id *string `locationName:"id" type:"string"`

	// The list of inputs currently using this Input Security Group.
	Inputs []string `locationName:"inputs" type:"list"`

	// The current state of the Input Security Group.
	State InputSecurityGroupState `locationName:"state" type:"string" enum:"true"`

	// A collection of key-value pairs.
	Tags map[string]string `locationName:"tags" type:"map"`

	// Whitelist rules and their sync status
	WhitelistRules []InputWhitelistRule `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s InputSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSecurityGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Inputs) > 0 {
		v := s.Inputs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.WhitelistRules) > 0 {
		v := s.WhitelistRules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "whitelistRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Live Event input parameters. There can be multiple inputs in a single Live
// Event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputSettings
type InputSettings struct {
	_ struct{} `type:"structure"`

	// Used to select the audio stream to decode for inputs that have multiple available.
	AudioSelectors []AudioSelector `locationName:"audioSelectors" type:"list"`

	// Used to select the caption input to use for inputs that have multiple available.
	CaptionSelectors []CaptionSelector `locationName:"captionSelectors" type:"list"`

	// Enable or disable the deblock filter when filtering.
	DeblockFilter InputDeblockFilter `locationName:"deblockFilter" type:"string" enum:"true"`

	// Enable or disable the denoise filter when filtering.
	DenoiseFilter InputDenoiseFilter `locationName:"denoiseFilter" type:"string" enum:"true"`

	// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
	FilterStrength *int64 `locationName:"filterStrength" min:"1" type:"integer"`

	// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter
	// enabled by default.1) auto - filtering will be applied depending on input
	// type/quality2) disabled - no filtering will be applied to the input3) forced
	// - filtering will be applied regardless of input type
	InputFilter InputFilter `locationName:"inputFilter" type:"string" enum:"true"`

	// Input settings.
	NetworkInputSettings *NetworkInputSettings `locationName:"networkInputSettings" type:"structure"`

	// Loop input if it is a file. This allows a file input to be streamed indefinitely.
	SourceEndBehavior InputSourceEndBehavior `locationName:"sourceEndBehavior" type:"string" enum:"true"`

	// Informs which video elementary stream to decode for input types that have
	// multiple available.
	VideoSelector *VideoSelector `locationName:"videoSelector" type:"structure"`
}

// String returns the string representation
func (s InputSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputSettings"}
	if s.FilterStrength != nil && *s.FilterStrength < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FilterStrength", 1))
	}
	if s.AudioSelectors != nil {
		for i, v := range s.AudioSelectors {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioSelectors", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.CaptionSelectors != nil {
		for i, v := range s.CaptionSelectors {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionSelectors", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AudioSelectors) > 0 {
		v := s.AudioSelectors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "audioSelectors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.CaptionSelectors) > 0 {
		v := s.CaptionSelectors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "captionSelectors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.DeblockFilter) > 0 {
		v := s.DeblockFilter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deblockFilter", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.DenoiseFilter) > 0 {
		v := s.DenoiseFilter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "denoiseFilter", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FilterStrength != nil {
		v := *s.FilterStrength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filterStrength", protocol.Int64Value(v), metadata)
	}
	if len(s.InputFilter) > 0 {
		v := s.InputFilter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputFilter", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.NetworkInputSettings != nil {
		v := s.NetworkInputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "networkInputSettings", v, metadata)
	}
	if len(s.SourceEndBehavior) > 0 {
		v := s.SourceEndBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceEndBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VideoSelector != nil {
		v := s.VideoSelector

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "videoSelector", v, metadata)
	}
	return nil
}

// The settings for a PULL type input.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputSource
type InputSource struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputSource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSource) MarshalFields(e protocol.FieldEncoder) error {
	if s.PasswordParam != nil {
		v := *s.PasswordParam

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passwordParam", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Settings for for a PULL type input.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputSourceRequest
type InputSourceRequest struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSourceRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.PasswordParam != nil {
		v := *s.PasswordParam

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passwordParam", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputSpecification
type InputSpecification struct {
	_ struct{} `type:"structure"`

	// Input codec
	Codec InputCodec `locationName:"codec" type:"string" enum:"true"`

	// Maximum input bitrate, categorized coarsely
	MaximumBitrate InputMaximumBitrate `locationName:"maximumBitrate" type:"string" enum:"true"`

	// Input resolution, categorized coarsely
	Resolution InputResolution `locationName:"resolution" type:"string" enum:"true"`
}

// String returns the string representation
func (s InputSpecification) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSpecification) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Codec) > 0 {
		v := s.Codec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "codec", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.MaximumBitrate) > 0 {
		v := s.MaximumBitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximumBitrate", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Resolution) > 0 {
		v := s.Resolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resolution", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Settings for the action to switch an input.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputSwitchScheduleActionSettings
type InputSwitchScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The name of the input attachment that should be switched to by this action.
	//
	// InputAttachmentNameReference is a required field
	InputAttachmentNameReference *string `locationName:"inputAttachmentNameReference" type:"string" required:"true"`
}

// String returns the string representation
func (s InputSwitchScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSwitchScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputSwitchScheduleActionSettings"}

	if s.InputAttachmentNameReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputAttachmentNameReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSwitchScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputAttachmentNameReference != nil {
		v := *s.InputAttachmentNameReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputAttachmentNameReference", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Settings for a private VPC Input.When this property is specified, the input
// destination addresses will be created in a VPC rather than with public Internet
// addresses.This property requires setting the roleArn property on Input creation.Not
// compatible with the inputSecurityGroups property.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputVpcRequest
type InputVpcRequest struct {
	_ struct{} `type:"structure"`

	// A list of up to 5 EC2 VPC security group IDs to attach to the Input VPC network
	// interfaces.Requires subnetIds. If none are specified then the VPC default
	// security group will be used.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// A list of 2 VPC subnet IDs from the same VPC.Subnet IDs must be mapped to
	// two unique availability zones (AZ).
	//
	// SubnetIds is a required field
	SubnetIds []string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation
func (s InputVpcRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputVpcRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputVpcRequest"}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputVpcRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.SecurityGroupIds) > 0 {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.SubnetIds) > 0 {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Whitelist rule
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputWhitelistRule
type InputWhitelistRule struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR that's whitelisted.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s InputWhitelistRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputWhitelistRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cidr != nil {
		v := *s.Cidr

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cidr", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An IPv4 CIDR to whitelist.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/InputWhitelistRuleCidr
type InputWhitelistRuleCidr struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR to whitelist.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s InputWhitelistRuleCidr) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputWhitelistRuleCidr) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cidr != nil {
		v := *s.Cidr

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cidr", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Key Provider Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/KeyProviderSettings
type KeyProviderSettings struct {
	_ struct{} `type:"structure"`

	// Static Key Settings
	StaticKeySettings *StaticKeySettings `locationName:"staticKeySettings" type:"structure"`
}

// String returns the string representation
func (s KeyProviderSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyProviderSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KeyProviderSettings"}
	if s.StaticKeySettings != nil {
		if err := s.StaticKeySettings.Validate(); err != nil {
			invalidParams.AddNested("StaticKeySettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeyProviderSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.StaticKeySettings != nil {
		v := s.StaticKeySettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "staticKeySettings", v, metadata)
	}
	return nil
}

// M2ts Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/M2tsSettings
type M2tsSettings struct {
	_ struct{} `type:"structure"`

	// When set to drop, output audio streams will be removed from the program if
	// the selected input audio stream is removed from the input. This allows the
	// output audio configuration to dynamically change based on input configuration.
	// If this is set to encodeSilence, all output audio streams will output encoded
	// silence when not connected to an active input stream.
	AbsentInputAudioBehavior M2tsAbsentInputAudioBehavior `locationName:"absentInputAudioBehavior" type:"string" enum:"true"`

	// When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
	Arib M2tsArib `locationName:"arib" type:"string" enum:"true"`

	// Packet Identifier (PID) for ARIB Captions in the transport stream. Can be
	// entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	AribCaptionsPid *string `locationName:"aribCaptionsPid" type:"string"`

	// If set to auto, pid number used for ARIB Captions will be auto-selected from
	// unused pids. If set to useConfigured, ARIB Captions will be on the configured
	// pid number.
	AribCaptionsPidControl M2tsAribCaptionsPidControl `locationName:"aribCaptionsPidControl" type:"string" enum:"true"`

	// When set to dvb, uses DVB buffer model for Dolby Digital audio. When set
	// to atsc, the ATSC model is used.
	AudioBufferModel M2tsAudioBufferModel `locationName:"audioBufferModel" type:"string" enum:"true"`

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes *int64 `locationName:"audioFramesPerPes" type:"integer"`

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or
	// by comma separation. Can be entered as decimal or hexadecimal values. Each
	// PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	AudioPids *string `locationName:"audioPids" type:"string"`

	// When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87
	// for EAC3. When set to dvb, uses stream type = 0x06.
	AudioStreamType M2tsAudioStreamType `locationName:"audioStreamType" type:"string" enum:"true"`

	// The output bitrate of the transport stream in bits per second. Setting to
	// 0 lets the muxer automatically determine the appropriate bitrate.
	Bitrate *int64 `locationName:"bitrate" type:"integer"`

	// If set to multiplex, use multiplex buffer model for accurate interleaving.
	// Setting to bufferModel to none can lead to lower latency, but low-memory
	// devices may not be able to play back the stream without interruptions.
	BufferModel M2tsBufferModel `locationName:"bufferModel" type:"string" enum:"true"`

	// When set to enabled, generates captionServiceDescriptor in PMT.
	CcDescriptor M2tsCcDescriptor `locationName:"ccDescriptor" type:"string" enum:"true"`

	// Inserts DVB Network Information Table (NIT) at the specified table repetition
	// interval.
	DvbNitSettings *DvbNitSettings `locationName:"dvbNitSettings" type:"structure"`

	// Inserts DVB Service Description Table (SDT) at the specified table repetition
	// interval.
	DvbSdtSettings *DvbSdtSettings `locationName:"dvbSdtSettings" type:"structure"`

	// Packet Identifier (PID) for input source DVB Subtitle data to this output.
	// Multiple values are accepted, and can be entered in ranges and/or by comma
	// separation. Can be entered as decimal or hexadecimal values. Each PID specified
	// must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	DvbSubPids *string `locationName:"dvbSubPids" type:"string"`

	// Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
	DvbTdtSettings *DvbTdtSettings `locationName:"dvbTdtSettings" type:"structure"`

	// Packet Identifier (PID) for input source DVB Teletext data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	DvbTeletextPid *string `locationName:"dvbTeletextPid" type:"string"`

	// If set to passthrough, passes any EBIF data from the input source to this
	// output.
	Ebif M2tsEbifControl `locationName:"ebif" type:"string" enum:"true"`

	// When videoAndFixedIntervals is selected, audio EBP markers will be added
	// to partitions 3 and 4. The interval between these additional markers will
	// be fixed, and will be slightly shorter than the video EBP marker interval.
	// Only available when EBP Cablelabs segmentation markers are selected. Partitions
	// 1 and 2 will always follow the video interval.
	EbpAudioInterval M2tsAudioInterval `locationName:"ebpAudioInterval" type:"string" enum:"true"`

	// When set, enforces that Encoder Boundary Points do not come within the specified
	// time interval of each other by looking ahead at input video. If another EBP
	// is going to come in within the specified time interval, the current EBP is
	// not emitted, and the segment is "stretched" to the next marker. The lookahead
	// value does not add latency to the system. The Live Event must be configured
	// elsewhere to create sufficient latency to make the lookahead accurate.
	EbpLookaheadMs *int64 `locationName:"ebpLookaheadMs" type:"integer"`

	// Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP
	// markers will be placed on the video PID and all audio PIDs. If set to videoPid,
	// EBP markers will be placed on only the video PID.
	EbpPlacement M2tsEbpPlacement `locationName:"ebpPlacement" type:"string" enum:"true"`

	// This field is unused and deprecated.
	EcmPid *string `locationName:"ecmPid" type:"string"`

	// Include or exclude the ES Rate field in the PES header.
	EsRateInPes M2tsEsRateInPes `locationName:"esRateInPes" type:"string" enum:"true"`

	// Packet Identifier (PID) for input source ETV Platform data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	EtvPlatformPid *string `locationName:"etvPlatformPid" type:"string"`

	// Packet Identifier (PID) for input source ETV Signal data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	EtvSignalPid *string `locationName:"etvSignalPid" type:"string"`

	// The length in seconds of each fragment. Only used with EBP markers.
	FragmentTime *float64 `locationName:"fragmentTime" type:"double"`

	// If set to passthrough, passes any KLV data from the input source to this
	// output.
	Klv M2tsKlv `locationName:"klv" type:"string" enum:"true"`

	// Packet Identifier (PID) for input source KLV data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must
	// be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	KlvDataPids *string `locationName:"klvDataPids" type:"string"`

	// Value in bits per second of extra null packets to insert into the transport
	// stream. This can be used if a downstream encryption system requires periodic
	// null packets.
	NullPacketBitrate *float64 `locationName:"nullPacketBitrate" type:"double"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PatInterval *int64 `locationName:"patInterval" type:"integer"`

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted
	// for every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl M2tsPcrControl `locationName:"pcrControl" type:"string" enum:"true"`

	// Maximum time in milliseconds between Program Clock Reference (PCRs) inserted
	// into the transport stream.
	PcrPeriod *int64 `locationName:"pcrPeriod" type:"integer"`

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as
	// the Video PID. Can be entered as a decimal or hexadecimal value. Valid values
	// are 32 (or 0x20)..8182 (or 0x1ff6).
	PcrPid *string `locationName:"pcrPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PmtInterval *int64 `locationName:"pmtInterval" type:"integer"`

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport
	// stream. Can be entered as a decimal or hexadecimal value. Valid values are
	// 32 (or 0x20)..8182 (or 0x1ff6).
	PmtPid *string `locationName:"pmtPid" type:"string"`

	// The value of the program number field in the Program Map Table.
	ProgramNum *int64 `locationName:"programNum" type:"integer"`

	// When vbr, does not insert null packets into transport stream to fill specified
	// bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.
	RateMode M2tsRateMode `locationName:"rateMode" type:"string" enum:"true"`

	// Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must
	// be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	Scte27Pids *string `locationName:"scte27Pids" type:"string"`

	// Optionally pass SCTE-35 signals from the input source to this output.
	Scte35Control M2tsScte35Control `locationName:"scte35Control" type:"string" enum:"true"`

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can
	// be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	Scte35Pid *string `locationName:"scte35Pid" type:"string"`

	// Inserts segmentation markers at each segmentationTime period. raiSegstart
	// sets the Random Access Indicator bit in the adaptation field. raiAdapt sets
	// the RAI bit and adds the current timecode in the private data bytes. psiSegstart
	// inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary
	// Point information to the adaptation field as per OpenCable specification
	// OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to
	// the adaptation field using a legacy proprietary format.
	SegmentationMarkers M2tsSegmentationMarkers `locationName:"segmentationMarkers" type:"string" enum:"true"`

	// The segmentation style parameter controls how segmentation markers are inserted
	// into the transport stream. With avails, it is possible that segments may
	// be truncated, which can influence where future segmentation markers are inserted.When
	// a segmentation style of "resetCadence" is selected and a segment is truncated
	// due to an avail, we will reset the segmentation cadence. This means the subsequent
	// segment will have a duration of $segmentationTime seconds.When a segmentation
	// style of "maintainCadence" is selected and a segment is truncated due to
	// an avail, we will not reset the segmentation cadence. This means the subsequent
	// segment will likely be truncated as well. However, all segments after that
	// will have a duration of $segmentationTime seconds. Note that EBP lookahead
	// is a slight exception to this rule.
	SegmentationStyle M2tsSegmentationStyle `locationName:"segmentationStyle" type:"string" enum:"true"`

	// The length in seconds of each segment. Required unless markers is set to
	// None_.
	SegmentationTime *float64 `locationName:"segmentationTime" type:"double"`

	// When set to passthrough, timed metadata will be passed through from input
	// to output.
	TimedMetadataBehavior M2tsTimedMetadataBehavior `locationName:"timedMetadataBehavior" type:"string" enum:"true"`

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string `locationName:"timedMetadataPid" type:"string"`

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId *int64 `locationName:"transportStreamId" type:"integer"`

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	VideoPid *string `locationName:"videoPid" type:"string"`
}

// String returns the string representation
func (s M2tsSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *M2tsSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "M2tsSettings"}
	if s.DvbNitSettings != nil {
		if err := s.DvbNitSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbNitSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.DvbSdtSettings != nil {
		if err := s.DvbSdtSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSdtSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.DvbTdtSettings != nil {
		if err := s.DvbTdtSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbTdtSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s M2tsSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AbsentInputAudioBehavior) > 0 {
		v := s.AbsentInputAudioBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "absentInputAudioBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Arib) > 0 {
		v := s.Arib

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arib", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AribCaptionsPid != nil {
		v := *s.AribCaptionsPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "aribCaptionsPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AribCaptionsPidControl) > 0 {
		v := s.AribCaptionsPidControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "aribCaptionsPidControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.AudioBufferModel) > 0 {
		v := s.AudioBufferModel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioBufferModel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AudioFramesPerPes != nil {
		v := *s.AudioFramesPerPes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioFramesPerPes", protocol.Int64Value(v), metadata)
	}
	if s.AudioPids != nil {
		v := *s.AudioPids

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioPids", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AudioStreamType) > 0 {
		v := s.AudioStreamType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioStreamType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Bitrate != nil {
		v := *s.Bitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitrate", protocol.Int64Value(v), metadata)
	}
	if len(s.BufferModel) > 0 {
		v := s.BufferModel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bufferModel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.CcDescriptor) > 0 {
		v := s.CcDescriptor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ccDescriptor", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DvbNitSettings != nil {
		v := s.DvbNitSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dvbNitSettings", v, metadata)
	}
	if s.DvbSdtSettings != nil {
		v := s.DvbSdtSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dvbSdtSettings", v, metadata)
	}
	if s.DvbSubPids != nil {
		v := *s.DvbSubPids

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dvbSubPids", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DvbTdtSettings != nil {
		v := s.DvbTdtSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dvbTdtSettings", v, metadata)
	}
	if s.DvbTeletextPid != nil {
		v := *s.DvbTeletextPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dvbTeletextPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Ebif) > 0 {
		v := s.Ebif

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ebif", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.EbpAudioInterval) > 0 {
		v := s.EbpAudioInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ebpAudioInterval", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EbpLookaheadMs != nil {
		v := *s.EbpLookaheadMs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ebpLookaheadMs", protocol.Int64Value(v), metadata)
	}
	if len(s.EbpPlacement) > 0 {
		v := s.EbpPlacement

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ebpPlacement", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EcmPid != nil {
		v := *s.EcmPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ecmPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EsRateInPes) > 0 {
		v := s.EsRateInPes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "esRateInPes", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EtvPlatformPid != nil {
		v := *s.EtvPlatformPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "etvPlatformPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EtvSignalPid != nil {
		v := *s.EtvSignalPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "etvSignalPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FragmentTime != nil {
		v := *s.FragmentTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fragmentTime", protocol.Float64Value(v), metadata)
	}
	if len(s.Klv) > 0 {
		v := s.Klv

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "klv", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.KlvDataPids != nil {
		v := *s.KlvDataPids

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "klvDataPids", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NullPacketBitrate != nil {
		v := *s.NullPacketBitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nullPacketBitrate", protocol.Float64Value(v), metadata)
	}
	if s.PatInterval != nil {
		v := *s.PatInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "patInterval", protocol.Int64Value(v), metadata)
	}
	if len(s.PcrControl) > 0 {
		v := s.PcrControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pcrControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PcrPeriod != nil {
		v := *s.PcrPeriod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pcrPeriod", protocol.Int64Value(v), metadata)
	}
	if s.PcrPid != nil {
		v := *s.PcrPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pcrPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PmtInterval != nil {
		v := *s.PmtInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pmtInterval", protocol.Int64Value(v), metadata)
	}
	if s.PmtPid != nil {
		v := *s.PmtPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pmtPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProgramNum != nil {
		v := *s.ProgramNum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programNum", protocol.Int64Value(v), metadata)
	}
	if len(s.RateMode) > 0 {
		v := s.RateMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rateMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Scte27Pids != nil {
		v := *s.Scte27Pids

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scte27Pids", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Scte35Control) > 0 {
		v := s.Scte35Control

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scte35Control", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Scte35Pid != nil {
		v := *s.Scte35Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scte35Pid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SegmentationMarkers) > 0 {
		v := s.SegmentationMarkers

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationMarkers", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SegmentationStyle) > 0 {
		v := s.SegmentationStyle

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationStyle", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SegmentationTime != nil {
		v := *s.SegmentationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationTime", protocol.Float64Value(v), metadata)
	}
	if len(s.TimedMetadataBehavior) > 0 {
		v := s.TimedMetadataBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimedMetadataPid != nil {
		v := *s.TimedMetadataPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TransportStreamId != nil {
		v := *s.TransportStreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transportStreamId", protocol.Int64Value(v), metadata)
	}
	if s.VideoPid != nil {
		v := *s.VideoPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "videoPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Settings information for the .m3u8 container
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/M3u8Settings
type M3u8Settings struct {
	_ struct{} `type:"structure"`

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes *int64 `locationName:"audioFramesPerPes" type:"integer"`

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or
	// by comma separation. Can be entered as decimal or hexadecimal values.
	AudioPids *string `locationName:"audioPids" type:"string"`

	// This parameter is unused and deprecated.
	EcmPid *string `locationName:"ecmPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of \"0\" writes out the PMT once per segment file.
	PatInterval *int64 `locationName:"patInterval" type:"integer"`

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted
	// for every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl M3u8PcrControl `locationName:"pcrControl" type:"string" enum:"true"`

	// Maximum time in milliseconds between Program Clock References (PCRs) inserted
	// into the transport stream.
	PcrPeriod *int64 `locationName:"pcrPeriod" type:"integer"`

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as
	// the Video PID. Can be entered as a decimal or hexadecimal value.
	PcrPid *string `locationName:"pcrPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of \"0\" writes out the PMT once per segment file.
	PmtInterval *int64 `locationName:"pmtInterval" type:"integer"`

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport
	// stream. Can be entered as a decimal or hexadecimal value.
	PmtPid *string `locationName:"pmtPid" type:"string"`

	// The value of the program number field in the Program Map Table.
	ProgramNum *int64 `locationName:"programNum" type:"integer"`

	// If set to passthrough, passes any SCTE-35 signals from the input source to
	// this output.
	Scte35Behavior M3u8Scte35Behavior `locationName:"scte35Behavior" type:"string" enum:"true"`

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can
	// be entered as a decimal or hexadecimal value.
	Scte35Pid *string `locationName:"scte35Pid" type:"string"`

	// When set to passthrough, timed metadata is passed through from input to output.
	TimedMetadataBehavior M3u8TimedMetadataBehavior `locationName:"timedMetadataBehavior" type:"string" enum:"true"`

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string `locationName:"timedMetadataPid" type:"string"`

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId *int64 `locationName:"transportStreamId" type:"integer"`

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value.
	VideoPid *string `locationName:"videoPid" type:"string"`
}

// String returns the string representation
func (s M3u8Settings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s M3u8Settings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AudioFramesPerPes != nil {
		v := *s.AudioFramesPerPes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioFramesPerPes", protocol.Int64Value(v), metadata)
	}
	if s.AudioPids != nil {
		v := *s.AudioPids

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioPids", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EcmPid != nil {
		v := *s.EcmPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ecmPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PatInterval != nil {
		v := *s.PatInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "patInterval", protocol.Int64Value(v), metadata)
	}
	if len(s.PcrControl) > 0 {
		v := s.PcrControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pcrControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PcrPeriod != nil {
		v := *s.PcrPeriod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pcrPeriod", protocol.Int64Value(v), metadata)
	}
	if s.PcrPid != nil {
		v := *s.PcrPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pcrPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PmtInterval != nil {
		v := *s.PmtInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pmtInterval", protocol.Int64Value(v), metadata)
	}
	if s.PmtPid != nil {
		v := *s.PmtPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pmtPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProgramNum != nil {
		v := *s.ProgramNum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programNum", protocol.Int64Value(v), metadata)
	}
	if len(s.Scte35Behavior) > 0 {
		v := s.Scte35Behavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scte35Behavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Scte35Pid != nil {
		v := *s.Scte35Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scte35Pid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TimedMetadataBehavior) > 0 {
		v := s.TimedMetadataBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimedMetadataPid != nil {
		v := *s.TimedMetadataPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TransportStreamId != nil {
		v := *s.TransportStreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transportStreamId", protocol.Int64Value(v), metadata)
	}
	if s.VideoPid != nil {
		v := *s.VideoPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "videoPid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The settings for a MediaConnect Flow.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MediaConnectFlow
type MediaConnectFlow struct {
	_ struct{} `type:"structure"`

	// The unique ARN of the MediaConnect Flow being used as a source.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s MediaConnectFlow) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MediaConnectFlow) MarshalFields(e protocol.FieldEncoder) error {
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The settings for a MediaConnect Flow.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MediaConnectFlowRequest
type MediaConnectFlowRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the MediaConnect Flow that you want to use as a source.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s MediaConnectFlowRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MediaConnectFlowRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.FlowArn != nil {
		v := *s.FlowArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "flowArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Media Package Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MediaPackageGroupSettings
type MediaPackageGroupSettings struct {
	_ struct{} `type:"structure"`

	// MediaPackage channel destination.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`
}

// String returns the string representation
func (s MediaPackageGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MediaPackageGroupSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MediaPackageGroupSettings"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MediaPackageGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	return nil
}

// Media Package Output Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MediaPackageOutputDestinationSettings
type MediaPackageOutputDestinationSettings struct {
	_ struct{} `type:"structure"`

	// ID of the channel in MediaPackage that is the destination for this output
	// group. You do not need to specify the individual inputs in MediaPackage;
	// MediaLive will handle the connection of the two MediaLive pipelines to the
	// two MediaPackage inputs. The MediaPackage channel and MediaLive channel must
	// be in the same region.
	ChannelId *string `locationName:"channelId" min:"1" type:"string"`
}

// String returns the string representation
func (s MediaPackageOutputDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MediaPackageOutputDestinationSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MediaPackageOutputDestinationSettings"}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MediaPackageOutputDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Media Package Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MediaPackageOutputSettings
type MediaPackageOutputSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MediaPackageOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MediaPackageOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Mp2 Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Mp2Settings
type Mp2Settings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or
	// codingMode20 (for stereo).
	CodingMode Mp2CodingMode `locationName:"codingMode" type:"string" enum:"true"`

	// Sample rate in Hz.
	SampleRate *float64 `locationName:"sampleRate" type:"double"`
}

// String returns the string representation
func (s Mp2Settings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Mp2Settings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bitrate != nil {
		v := *s.Bitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bitrate", protocol.Float64Value(v), metadata)
	}
	if len(s.CodingMode) > 0 {
		v := s.CodingMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "codingMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SampleRate != nil {
		v := *s.SampleRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sampleRate", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Ms Smooth Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MsSmoothGroupSettings
type MsSmoothGroupSettings struct {
	_ struct{} `type:"structure"`

	// The value of the "Acquisition Point Identity" element used in each message
	// placed in the sparse track. Only enabled if sparseTrackType is not "none".
	AcquisitionPointId *string `locationName:"acquisitionPointId" type:"string"`

	// If set to passthrough for an audio-only MS Smooth output, the fragment absolute
	// time will be set to the current timecode. This option does not write timecodes
	// to the audio elementary stream.
	AudioOnlyTimecodeControl SmoothGroupAudioOnlyTimecodeControl `locationName:"audioOnlyTimecodeControl" type:"string" enum:"true"`

	// If set to verifyAuthenticity, verify the https certificate chain to a trusted
	// Certificate Authority (CA). This will cause https outputs to self-signed
	// certificates to fail.
	CertificateMode SmoothGroupCertificateMode `locationName:"certificateMode" type:"string" enum:"true"`

	// Number of seconds to wait before retrying connection to the IIS server if
	// the connection is lost. Content will be cached during this time and the cache
	// will be be delivered to the IIS server once the connection is re-established.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Smooth Streaming publish point on an IIS server. Elemental Live acts as a
	// "Push" encoder to IIS.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// MS Smooth event ID to be sent to the IIS server.Should only be specified
	// if eventIdMode is set to useConfigured.
	EventId *string `locationName:"eventId" type:"string"`

	// Specifies whether or not to send an event ID to the IIS server. If no event
	// ID is sent and the same Live Event is used without changing the publishing
	// point, clients might see cached video from the previous run.Options:- "useConfigured"
	// - use the value provided in eventId- "useTimestamp" - generate and send an
	// event ID based on the current timestamp- "noEventId" - do not send an event
	// ID to the IIS server.
	EventIdMode SmoothGroupEventIdMode `locationName:"eventIdMode" type:"string" enum:"true"`

	// When set to sendEos, send EOS signal to IIS server when stopping the event
	EventStopBehavior SmoothGroupEventStopBehavior `locationName:"eventStopBehavior" type:"string" enum:"true"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Length of mp4 fragments to generate (in seconds). Fragment length must be
	// compatible with GOP size and framerate.
	FragmentLength *int64 `locationName:"fragmentLength" min:"1" type:"integer"`

	// Parameter that control output group behavior on input loss.
	InputLossAction InputLossActionForMsSmoothOut `locationName:"inputLossAction" type:"string" enum:"true"`

	// Number of retry attempts.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// Number of seconds before initiating a restart due to output failure, due
	// to exhausting the numRetries on one segment, or exceeding filecacheDuration.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`

	// useInputSegmentation has been deprecated. The configured segment size is
	// always used.
	SegmentationMode SmoothGroupSegmentationMode `locationName:"segmentationMode" type:"string" enum:"true"`

	// Number of milliseconds to delay the output from the second pipeline.
	SendDelayMs *int64 `locationName:"sendDelayMs" type:"integer"`

	// If set to scte35, use incoming SCTE-35 messages to generate a sparse track
	// in this group of MS-Smooth outputs.
	SparseTrackType SmoothGroupSparseTrackType `locationName:"sparseTrackType" type:"string" enum:"true"`

	// When set to send, send stream manifest so publishing point doesn't start
	// until all streams start.
	StreamManifestBehavior SmoothGroupStreamManifestBehavior `locationName:"streamManifestBehavior" type:"string" enum:"true"`

	// Timestamp offset for the event. Only used if timestampOffsetMode is set to
	// useConfiguredOffset.
	TimestampOffset *string `locationName:"timestampOffset" type:"string"`

	// Type of timestamp date offset to use.- useEventStartDate: Use the date the
	// event was started as the offset- useConfiguredOffset: Use an explicitly configured
	// date as the offset
	TimestampOffsetMode SmoothGroupTimestampOffsetMode `locationName:"timestampOffsetMode" type:"string" enum:"true"`
}

// String returns the string representation
func (s MsSmoothGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MsSmoothGroupSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MsSmoothGroupSettings"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.FragmentLength != nil && *s.FragmentLength < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FragmentLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MsSmoothGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AcquisitionPointId != nil {
		v := *s.AcquisitionPointId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "acquisitionPointId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AudioOnlyTimecodeControl) > 0 {
		v := s.AudioOnlyTimecodeControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioOnlyTimecodeControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.CertificateMode) > 0 {
		v := s.CertificateMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ConnectionRetryInterval != nil {
		v := *s.ConnectionRetryInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionRetryInterval", protocol.Int64Value(v), metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if s.EventId != nil {
		v := *s.EventId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EventIdMode) > 0 {
		v := s.EventIdMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventIdMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.EventStopBehavior) > 0 {
		v := s.EventStopBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventStopBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FilecacheDuration != nil {
		v := *s.FilecacheDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filecacheDuration", protocol.Int64Value(v), metadata)
	}
	if s.FragmentLength != nil {
		v := *s.FragmentLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fragmentLength", protocol.Int64Value(v), metadata)
	}
	if len(s.InputLossAction) > 0 {
		v := s.InputLossAction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputLossAction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.NumRetries != nil {
		v := *s.NumRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numRetries", protocol.Int64Value(v), metadata)
	}
	if s.RestartDelay != nil {
		v := *s.RestartDelay

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restartDelay", protocol.Int64Value(v), metadata)
	}
	if len(s.SegmentationMode) > 0 {
		v := s.SegmentationMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SendDelayMs != nil {
		v := *s.SendDelayMs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sendDelayMs", protocol.Int64Value(v), metadata)
	}
	if len(s.SparseTrackType) > 0 {
		v := s.SparseTrackType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sparseTrackType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.StreamManifestBehavior) > 0 {
		v := s.StreamManifestBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamManifestBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimestampOffset != nil {
		v := *s.TimestampOffset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timestampOffset", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TimestampOffsetMode) > 0 {
		v := s.TimestampOffsetMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timestampOffsetMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Ms Smooth Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MsSmoothOutputSettings
type MsSmoothOutputSettings struct {
	_ struct{} `type:"structure"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s MsSmoothOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MsSmoothOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.NameModifier != nil {
		v := *s.NameModifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nameModifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Network source to transcode. Must be accessible to the Elemental Live node
// that is running the live event through a network connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/NetworkInputSettings
type NetworkInputSettings struct {
	_ struct{} `type:"structure"`

	// Specifies HLS input settings when the uri is for a HLS manifest.
	HlsInputSettings *HlsInputSettings `locationName:"hlsInputSettings" type:"structure"`

	// Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography
	// in the certificate will be checked, but not the server's name. Certain subdomains
	// (notably S3 buckets that use dots in the bucket name) do not strictly match
	// the corresponding certificate's wildcard pattern and would otherwise cause
	// the event to error. This setting is ignored for protocols that do not use
	// https.
	ServerValidation NetworkInputServerValidation `locationName:"serverValidation" type:"string" enum:"true"`
}

// String returns the string representation
func (s NetworkInputSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkInputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.HlsInputSettings != nil {
		v := s.HlsInputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsInputSettings", v, metadata)
	}
	if len(s.ServerValidation) > 0 {
		v := s.ServerValidation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serverValidation", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Reserved resources available for purchase
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Offering
type Offering struct {
	_ struct{} `type:"structure"`

	// Unique offering ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
	Arn *string `locationName:"arn" type:"string"`

	// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	// Lease duration, e.g. '12'
	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits OfferingDurationUnits `locationName:"durationUnits" type:"string" enum:"true"`

	// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard
	// VQ in US West (Oregon)'
	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	// Unique offering ID, e.g. '87654321'
	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType OfferingType `locationName:"offeringType" type:"string" enum:"true"`

	// AWS region, e.g. 'us-west-2'
	Region *string `locationName:"region" type:"string"`

	// Resource configuration details
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	// Recurring usage charge for each reserved resource, e.g. '157.0'
	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation
func (s Offering) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Offering) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CurrencyCode != nil {
		v := *s.CurrencyCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currencyCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "duration", protocol.Int64Value(v), metadata)
	}
	if len(s.DurationUnits) > 0 {
		v := s.DurationUnits

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "durationUnits", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FixedPrice != nil {
		v := *s.FixedPrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fixedPrice", protocol.Float64Value(v), metadata)
	}
	if s.OfferingDescription != nil {
		v := *s.OfferingDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OfferingId != nil {
		v := *s.OfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OfferingType) > 0 {
		v := s.OfferingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceSpecification != nil {
		v := s.ResourceSpecification

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resourceSpecification", v, metadata)
	}
	if s.UsagePrice != nil {
		v := *s.UsagePrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "usagePrice", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Output settings. There can be multiple outputs within a group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Output
type Output struct {
	_ struct{} `type:"structure"`

	// The names of the AudioDescriptions used as audio sources for this output.
	AudioDescriptionNames []string `locationName:"audioDescriptionNames" type:"list"`

	// The names of the CaptionDescriptions used as caption sources for this output.
	CaptionDescriptionNames []string `locationName:"captionDescriptionNames" type:"list"`

	// The name used to identify an output.
	OutputName *string `locationName:"outputName" min:"1" type:"string"`

	// Output type-specific settings.
	//
	// OutputSettings is a required field
	OutputSettings *OutputSettings `locationName:"outputSettings" type:"structure" required:"true"`

	// The name of the VideoDescription used as the source for this output.
	VideoDescriptionName *string `locationName:"videoDescriptionName" type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Output"}
	if s.OutputName != nil && len(*s.OutputName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OutputName", 1))
	}

	if s.OutputSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputSettings"))
	}
	if s.OutputSettings != nil {
		if err := s.OutputSettings.Validate(); err != nil {
			invalidParams.AddNested("OutputSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Output) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AudioDescriptionNames) > 0 {
		v := s.AudioDescriptionNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "audioDescriptionNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.CaptionDescriptionNames) > 0 {
		v := s.CaptionDescriptionNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "captionDescriptionNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.OutputName != nil {
		v := *s.OutputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputSettings != nil {
		v := s.OutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputSettings", v, metadata)
	}
	if s.VideoDescriptionName != nil {
		v := *s.VideoDescriptionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "videoDescriptionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/OutputDestination
type OutputDestination struct {
	_ struct{} `type:"structure"`

	// User-specified id. This is used in an output group or an output.
	Id *string `locationName:"id" type:"string"`

	// Destination settings for a MediaPackage output; one destination for both
	// encoders.
	MediaPackageSettings []MediaPackageOutputDestinationSettings `locationName:"mediaPackageSettings" type:"list"`

	// Destination settings for a standard output; one destination for each redundant
	// encoder.
	Settings []OutputDestinationSettings `locationName:"settings" type:"list"`
}

// String returns the string representation
func (s OutputDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputDestination"}
	if s.MediaPackageSettings != nil {
		for i, v := range s.MediaPackageSettings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaPackageSettings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.MediaPackageSettings) > 0 {
		v := s.MediaPackageSettings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "mediaPackageSettings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Settings) > 0 {
		v := s.Settings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "settings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/OutputDestinationSettings
type OutputDestinationSettings struct {
	_ struct{} `type:"structure"`

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// Stream name for RTMP destinations (URLs of type rtmp://)
	StreamName *string `locationName:"streamName" type:"string"`

	// A URL specifying a destination
	Url *string `locationName:"url" type:"string"`

	// username for destination
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s OutputDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.PasswordParam != nil {
		v := *s.PasswordParam

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passwordParam", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/OutputGroup
type OutputGroup struct {
	_ struct{} `type:"structure"`

	// Custom output group name optionally defined by the user. Only letters, numbers,
	// and the underscore character allowed; only 32 characters allowed.
	Name *string `locationName:"name" type:"string"`

	// Settings associated with the output group.
	//
	// OutputGroupSettings is a required field
	OutputGroupSettings *OutputGroupSettings `locationName:"outputGroupSettings" type:"structure" required:"true"`

	// Outputs is a required field
	Outputs []Output `locationName:"outputs" type:"list" required:"true"`
}

// String returns the string representation
func (s OutputGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputGroup"}

	if s.OutputGroupSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputGroupSettings"))
	}

	if s.Outputs == nil {
		invalidParams.Add(aws.NewErrParamRequired("Outputs"))
	}
	if s.OutputGroupSettings != nil {
		if err := s.OutputGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("OutputGroupSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputGroupSettings != nil {
		v := s.OutputGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputGroupSettings", v, metadata)
	}
	if len(s.Outputs) > 0 {
		v := s.Outputs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "outputs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Output Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/OutputGroupSettings
type OutputGroupSettings struct {
	_ struct{} `type:"structure"`

	// Archive Group Settings
	ArchiveGroupSettings *ArchiveGroupSettings `locationName:"archiveGroupSettings" type:"structure"`

	// Frame Capture Group Settings
	FrameCaptureGroupSettings *FrameCaptureGroupSettings `locationName:"frameCaptureGroupSettings" type:"structure"`

	// Hls Group Settings
	HlsGroupSettings *HlsGroupSettings `locationName:"hlsGroupSettings" type:"structure"`

	// Media Package Group Settings
	MediaPackageGroupSettings *MediaPackageGroupSettings `locationName:"mediaPackageGroupSettings" type:"structure"`

	// Ms Smooth Group Settings
	MsSmoothGroupSettings *MsSmoothGroupSettings `locationName:"msSmoothGroupSettings" type:"structure"`

	// Rtmp Group Settings
	RtmpGroupSettings *RtmpGroupSettings `locationName:"rtmpGroupSettings" type:"structure"`

	// Udp Group Settings
	UdpGroupSettings *UdpGroupSettings `locationName:"udpGroupSettings" type:"structure"`
}

// String returns the string representation
func (s OutputGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputGroupSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputGroupSettings"}
	if s.ArchiveGroupSettings != nil {
		if err := s.ArchiveGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("ArchiveGroupSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.FrameCaptureGroupSettings != nil {
		if err := s.FrameCaptureGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("FrameCaptureGroupSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.HlsGroupSettings != nil {
		if err := s.HlsGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsGroupSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.MediaPackageGroupSettings != nil {
		if err := s.MediaPackageGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("MediaPackageGroupSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.MsSmoothGroupSettings != nil {
		if err := s.MsSmoothGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("MsSmoothGroupSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.RtmpGroupSettings != nil {
		if err := s.RtmpGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("RtmpGroupSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveGroupSettings != nil {
		v := s.ArchiveGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "archiveGroupSettings", v, metadata)
	}
	if s.FrameCaptureGroupSettings != nil {
		v := s.FrameCaptureGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "frameCaptureGroupSettings", v, metadata)
	}
	if s.HlsGroupSettings != nil {
		v := s.HlsGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsGroupSettings", v, metadata)
	}
	if s.MediaPackageGroupSettings != nil {
		v := s.MediaPackageGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "mediaPackageGroupSettings", v, metadata)
	}
	if s.MsSmoothGroupSettings != nil {
		v := s.MsSmoothGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "msSmoothGroupSettings", v, metadata)
	}
	if s.RtmpGroupSettings != nil {
		v := s.RtmpGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "rtmpGroupSettings", v, metadata)
	}
	if s.UdpGroupSettings != nil {
		v := s.UdpGroupSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "udpGroupSettings", v, metadata)
	}
	return nil
}

// Reference to an OutputDestination ID defined in the channel
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/OutputLocationRef
type OutputLocationRef struct {
	_ struct{} `type:"structure"`

	DestinationRefId *string `locationName:"destinationRefId" type:"string"`
}

// String returns the string representation
func (s OutputLocationRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputLocationRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationRefId != nil {
		v := *s.DestinationRefId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationRefId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/OutputSettings
type OutputSettings struct {
	_ struct{} `type:"structure"`

	// Archive Output Settings
	ArchiveOutputSettings *ArchiveOutputSettings `locationName:"archiveOutputSettings" type:"structure"`

	// Frame Capture Output Settings
	FrameCaptureOutputSettings *FrameCaptureOutputSettings `locationName:"frameCaptureOutputSettings" type:"structure"`

	// Hls Output Settings
	HlsOutputSettings *HlsOutputSettings `locationName:"hlsOutputSettings" type:"structure"`

	// Media Package Output Settings
	MediaPackageOutputSettings *MediaPackageOutputSettings `locationName:"mediaPackageOutputSettings" type:"structure"`

	// Ms Smooth Output Settings
	MsSmoothOutputSettings *MsSmoothOutputSettings `locationName:"msSmoothOutputSettings" type:"structure"`

	// Rtmp Output Settings
	RtmpOutputSettings *RtmpOutputSettings `locationName:"rtmpOutputSettings" type:"structure"`

	// Udp Output Settings
	UdpOutputSettings *UdpOutputSettings `locationName:"udpOutputSettings" type:"structure"`
}

// String returns the string representation
func (s OutputSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputSettings"}
	if s.ArchiveOutputSettings != nil {
		if err := s.ArchiveOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("ArchiveOutputSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.HlsOutputSettings != nil {
		if err := s.HlsOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsOutputSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.RtmpOutputSettings != nil {
		if err := s.RtmpOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("RtmpOutputSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.UdpOutputSettings != nil {
		if err := s.UdpOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("UdpOutputSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveOutputSettings != nil {
		v := s.ArchiveOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "archiveOutputSettings", v, metadata)
	}
	if s.FrameCaptureOutputSettings != nil {
		v := s.FrameCaptureOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "frameCaptureOutputSettings", v, metadata)
	}
	if s.HlsOutputSettings != nil {
		v := s.HlsOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsOutputSettings", v, metadata)
	}
	if s.MediaPackageOutputSettings != nil {
		v := s.MediaPackageOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "mediaPackageOutputSettings", v, metadata)
	}
	if s.MsSmoothOutputSettings != nil {
		v := s.MsSmoothOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "msSmoothOutputSettings", v, metadata)
	}
	if s.RtmpOutputSettings != nil {
		v := s.RtmpOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "rtmpOutputSettings", v, metadata)
	}
	if s.UdpOutputSettings != nil {
		v := s.UdpOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "udpOutputSettings", v, metadata)
	}
	return nil
}

// Pass Through Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PassThroughSettings
type PassThroughSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PassThroughSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PassThroughSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Settings for the action to set pause state of a channel.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PauseStateScheduleActionSettings
type PauseStateScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	Pipelines []PipelinePauseStateSettings `locationName:"pipelines" type:"list"`
}

// String returns the string representation
func (s PauseStateScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PauseStateScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PauseStateScheduleActionSettings"}
	if s.Pipelines != nil {
		for i, v := range s.Pipelines {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Pipelines", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PauseStateScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Pipelines) > 0 {
		v := s.Pipelines

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "pipelines", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Settings for pausing a pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PipelinePauseStateSettings
type PipelinePauseStateSettings struct {
	_ struct{} `type:"structure"`

	// Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
	//
	// PipelineId is a required field
	PipelineId PipelineId `locationName:"pipelineId" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PipelinePauseStateSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelinePauseStateSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PipelinePauseStateSettings"}
	if len(s.PipelineId) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PipelineId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PipelinePauseStateSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.PipelineId) > 0 {
		v := s.PipelineId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelineId", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Remix Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RemixSettings
type RemixSettings struct {
	_ struct{} `type:"structure"`

	// Mapping of input channels to output channels, with appropriate gain adjustments.
	//
	// ChannelMappings is a required field
	ChannelMappings []AudioChannelMapping `locationName:"channelMappings" type:"list" required:"true"`

	// Number of input channels to be used.
	ChannelsIn *int64 `locationName:"channelsIn" min:"1" type:"integer"`

	// Number of output channels to be produced.Valid values: 1, 2, 4, 6, 8
	ChannelsOut *int64 `locationName:"channelsOut" min:"1" type:"integer"`
}

// String returns the string representation
func (s RemixSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemixSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemixSettings"}

	if s.ChannelMappings == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelMappings"))
	}
	if s.ChannelsIn != nil && *s.ChannelsIn < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ChannelsIn", 1))
	}
	if s.ChannelsOut != nil && *s.ChannelsOut < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ChannelsOut", 1))
	}
	if s.ChannelMappings != nil {
		for i, v := range s.ChannelMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChannelMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemixSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ChannelMappings) > 0 {
		v := s.ChannelMappings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "channelMappings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ChannelsIn != nil {
		v := *s.ChannelsIn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelsIn", protocol.Int64Value(v), metadata)
	}
	if s.ChannelsOut != nil {
		v := *s.ChannelsOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelsOut", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Reserved resources available to use
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Reservation
type Reservation struct {
	_ struct{} `type:"structure"`

	// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
	Arn *string `locationName:"arn" type:"string"`

	// Number of reserved resources
	Count *int64 `locationName:"count" type:"integer"`

	// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	// Lease duration, e.g. '12'
	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits OfferingDurationUnits `locationName:"durationUnits" type:"string" enum:"true"`

	// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
	End *string `locationName:"end" type:"string"`

	// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	// User specified reservation name
	Name *string `locationName:"name" type:"string"`

	// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard
	// VQ in US West (Oregon)'
	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	// Unique offering ID, e.g. '87654321'
	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType OfferingType `locationName:"offeringType" type:"string" enum:"true"`

	// AWS region, e.g. 'us-west-2'
	Region *string `locationName:"region" type:"string"`

	// Unique reservation ID, e.g. '1234567'
	ReservationId *string `locationName:"reservationId" type:"string"`

	// Resource configuration details
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
	Start *string `locationName:"start" type:"string"`

	// Current state of reservation, e.g. 'ACTIVE'
	State ReservationState `locationName:"state" type:"string" enum:"true"`

	// A collection of key-value pairs
	Tags map[string]string `locationName:"tags" type:"map"`

	// Recurring usage charge for each reserved resource, e.g. '157.0'
	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation
func (s Reservation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Reservation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.CurrencyCode != nil {
		v := *s.CurrencyCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currencyCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "duration", protocol.Int64Value(v), metadata)
	}
	if len(s.DurationUnits) > 0 {
		v := s.DurationUnits

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "durationUnits", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "end", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FixedPrice != nil {
		v := *s.FixedPrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fixedPrice", protocol.Float64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OfferingDescription != nil {
		v := *s.OfferingDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OfferingId != nil {
		v := *s.OfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OfferingType) > 0 {
		v := s.OfferingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReservationId != nil {
		v := *s.ReservationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reservationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceSpecification != nil {
		v := s.ResourceSpecification

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resourceSpecification", v, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UsagePrice != nil {
		v := *s.UsagePrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "usagePrice", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Resource configuration (codec, resolution, bitrate, ...)
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ReservationResourceSpecification
type ReservationResourceSpecification struct {
	_ struct{} `type:"structure"`

	// Channel class, e.g. 'STANDARD'
	ChannelClass ChannelClass `locationName:"channelClass" type:"string" enum:"true"`

	// Codec, e.g. 'AVC'
	Codec ReservationCodec `locationName:"codec" type:"string" enum:"true"`

	// Maximum bitrate, e.g. 'MAX_20_MBPS'
	MaximumBitrate ReservationMaximumBitrate `locationName:"maximumBitrate" type:"string" enum:"true"`

	// Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
	MaximumFramerate ReservationMaximumFramerate `locationName:"maximumFramerate" type:"string" enum:"true"`

	// Resolution, e.g. 'HD'
	Resolution ReservationResolution `locationName:"resolution" type:"string" enum:"true"`

	// Resource type, 'INPUT', 'OUTPUT', or 'CHANNEL'
	ResourceType ReservationResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
	SpecialFeature ReservationSpecialFeature `locationName:"specialFeature" type:"string" enum:"true"`

	// Video quality, e.g. 'STANDARD' (Outputs only)
	VideoQuality ReservationVideoQuality `locationName:"videoQuality" type:"string" enum:"true"`
}

// String returns the string representation
func (s ReservationResourceSpecification) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReservationResourceSpecification) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ChannelClass) > 0 {
		v := s.ChannelClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Codec) > 0 {
		v := s.Codec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "codec", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.MaximumBitrate) > 0 {
		v := s.MaximumBitrate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximumBitrate", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.MaximumFramerate) > 0 {
		v := s.MaximumFramerate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximumFramerate", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Resolution) > 0 {
		v := s.Resolution

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resolution", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.SpecialFeature) > 0 {
		v := s.SpecialFeature

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "specialFeature", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.VideoQuality) > 0 {
		v := s.VideoQuality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "videoQuality", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Rtmp Caption Info Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RtmpCaptionInfoDestinationSettings
type RtmpCaptionInfoDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RtmpCaptionInfoDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RtmpCaptionInfoDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Rtmp Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RtmpGroupSettings
type RtmpGroupSettings struct {
	_ struct{} `type:"structure"`

	// Authentication scheme to use when connecting with CDN
	AuthenticationScheme AuthenticationScheme `locationName:"authenticationScheme" type:"string" enum:"true"`

	// Controls behavior when content cache fills up. If remote origin server stalls
	// the RTMP connection and does not accept content fast enough the 'Media Cache'
	// will fill up. When the cache reaches the duration specified by cacheLength
	// the cache will stop accepting new content. If set to disconnectImmediately,
	// the RTMP output will force a disconnect. Clear the media cache, and reconnect
	// after restartDelay seconds. If set to waitForServer, the RTMP output will
	// wait up to 5 minutes to allow the origin server to begin accepting data again.
	CacheFullBehavior RtmpCacheFullBehavior `locationName:"cacheFullBehavior" type:"string" enum:"true"`

	// Cache length, in seconds, is used to calculate buffer size.
	CacheLength *int64 `locationName:"cacheLength" min:"30" type:"integer"`

	// Controls the types of data that passes to onCaptionInfo outputs. If set to
	// 'all' then 608 and 708 carried DTVCC data will be passed. If set to 'field1AndField2608'
	// then DTVCC data will be stripped out, but 608 data from both fields will
	// be passed. If set to 'field1608' then only the data carried in 608 from field
	// 1 video will be passed.
	CaptionData RtmpCaptionData `locationName:"captionData" type:"string" enum:"true"`

	// Controls the behavior of this RTMP group if input becomes unavailable.- emitOutput:
	// Emit a slate until input returns.- pauseOutput: Stop transmitting data until
	// input returns. This does not close the underlying RTMP connection.
	InputLossAction InputLossActionForRtmpOut `locationName:"inputLossAction" type:"string" enum:"true"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s RtmpGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RtmpGroupSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RtmpGroupSettings"}
	if s.CacheLength != nil && *s.CacheLength < 30 {
		invalidParams.Add(aws.NewErrParamMinValue("CacheLength", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RtmpGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AuthenticationScheme) > 0 {
		v := s.AuthenticationScheme

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authenticationScheme", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.CacheFullBehavior) > 0 {
		v := s.CacheFullBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheFullBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CacheLength != nil {
		v := *s.CacheLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheLength", protocol.Int64Value(v), metadata)
	}
	if len(s.CaptionData) > 0 {
		v := s.CaptionData

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "captionData", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.InputLossAction) > 0 {
		v := s.InputLossAction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputLossAction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RestartDelay != nil {
		v := *s.RestartDelay

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restartDelay", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Rtmp Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RtmpOutputSettings
type RtmpOutputSettings struct {
	_ struct{} `type:"structure"`

	// If set to verifyAuthenticity, verify the tls certificate chain to a trusted
	// Certificate Authority (CA). This will cause rtmps outputs with self-signed
	// certificates to fail.
	CertificateMode RtmpOutputCertificateMode `locationName:"certificateMode" type:"string" enum:"true"`

	// Number of seconds to wait before retrying a connection to the Flash Media
	// server if the connection is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" min:"1" type:"integer"`

	// The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For
	// connection to Akamai, a username and password must be supplied. URI fields
	// accept format identifiers.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Number of retry attempts.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`
}

// String returns the string representation
func (s RtmpOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RtmpOutputSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RtmpOutputSettings"}
	if s.ConnectionRetryInterval != nil && *s.ConnectionRetryInterval < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ConnectionRetryInterval", 1))
	}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RtmpOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CertificateMode) > 0 {
		v := s.CertificateMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ConnectionRetryInterval != nil {
		v := *s.ConnectionRetryInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionRetryInterval", protocol.Int64Value(v), metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if s.NumRetries != nil {
		v := *s.NumRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numRetries", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains information on a single schedule action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ScheduleAction
type ScheduleAction struct {
	_ struct{} `type:"structure"`

	// The name of the action, must be unique within the schedule. This name provides
	// the main reference to an action once it is added to the schedule. A name
	// is unique if it is no longer in the schedule. The schedule is automatically
	// cleaned up to remove actions with a start time of more than 1 hour ago (approximately)
	// so at that point a name can be reused.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" type:"string" required:"true"`

	// Settings for this schedule action.
	//
	// ScheduleActionSettings is a required field
	ScheduleActionSettings *ScheduleActionSettings `locationName:"scheduleActionSettings" type:"structure" required:"true"`

	// The time for the action to start in the channel.
	//
	// ScheduleActionStartSettings is a required field
	ScheduleActionStartSettings *ScheduleActionStartSettings `locationName:"scheduleActionStartSettings" type:"structure" required:"true"`
}

// String returns the string representation
func (s ScheduleAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleAction"}

	if s.ActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActionName"))
	}

	if s.ScheduleActionSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduleActionSettings"))
	}

	if s.ScheduleActionStartSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduleActionStartSettings"))
	}
	if s.ScheduleActionSettings != nil {
		if err := s.ScheduleActionSettings.Validate(); err != nil {
			invalidParams.AddNested("ScheduleActionSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.ScheduleActionStartSettings != nil {
		if err := s.ScheduleActionStartSettings.Validate(); err != nil {
			invalidParams.AddNested("ScheduleActionStartSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ScheduleAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionName != nil {
		v := *s.ActionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScheduleActionSettings != nil {
		v := s.ScheduleActionSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scheduleActionSettings", v, metadata)
	}
	if s.ScheduleActionStartSettings != nil {
		v := s.ScheduleActionStartSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scheduleActionStartSettings", v, metadata)
	}
	return nil
}

// Holds the settings for a single schedule action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ScheduleActionSettings
type ScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Action to insert HLS metadata
	HlsTimedMetadataSettings *HlsTimedMetadataScheduleActionSettings `locationName:"hlsTimedMetadataSettings" type:"structure"`

	// Action to switch the input
	InputSwitchSettings *InputSwitchScheduleActionSettings `locationName:"inputSwitchSettings" type:"structure"`

	// Action to pause or unpause one or both channel pipelines
	PauseStateSettings *PauseStateScheduleActionSettings `locationName:"pauseStateSettings" type:"structure"`

	// Action to insert SCTE-35 return_to_network message
	Scte35ReturnToNetworkSettings *Scte35ReturnToNetworkScheduleActionSettings `locationName:"scte35ReturnToNetworkSettings" type:"structure"`

	// Action to insert SCTE-35 splice_insert message
	Scte35SpliceInsertSettings *Scte35SpliceInsertScheduleActionSettings `locationName:"scte35SpliceInsertSettings" type:"structure"`

	// Action to insert SCTE-35 time_signal message
	Scte35TimeSignalSettings *Scte35TimeSignalScheduleActionSettings `locationName:"scte35TimeSignalSettings" type:"structure"`

	// Action to activate a static image overlay
	StaticImageActivateSettings *StaticImageActivateScheduleActionSettings `locationName:"staticImageActivateSettings" type:"structure"`

	// Action to deactivate a static image overlay
	StaticImageDeactivateSettings *StaticImageDeactivateScheduleActionSettings `locationName:"staticImageDeactivateSettings" type:"structure"`
}

// String returns the string representation
func (s ScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleActionSettings"}
	if s.HlsTimedMetadataSettings != nil {
		if err := s.HlsTimedMetadataSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsTimedMetadataSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputSwitchSettings != nil {
		if err := s.InputSwitchSettings.Validate(); err != nil {
			invalidParams.AddNested("InputSwitchSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.PauseStateSettings != nil {
		if err := s.PauseStateSettings.Validate(); err != nil {
			invalidParams.AddNested("PauseStateSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Scte35ReturnToNetworkSettings != nil {
		if err := s.Scte35ReturnToNetworkSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35ReturnToNetworkSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Scte35SpliceInsertSettings != nil {
		if err := s.Scte35SpliceInsertSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35SpliceInsertSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Scte35TimeSignalSettings != nil {
		if err := s.Scte35TimeSignalSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35TimeSignalSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.StaticImageActivateSettings != nil {
		if err := s.StaticImageActivateSettings.Validate(); err != nil {
			invalidParams.AddNested("StaticImageActivateSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.HlsTimedMetadataSettings != nil {
		v := s.HlsTimedMetadataSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "hlsTimedMetadataSettings", v, metadata)
	}
	if s.InputSwitchSettings != nil {
		v := s.InputSwitchSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputSwitchSettings", v, metadata)
	}
	if s.PauseStateSettings != nil {
		v := s.PauseStateSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "pauseStateSettings", v, metadata)
	}
	if s.Scte35ReturnToNetworkSettings != nil {
		v := s.Scte35ReturnToNetworkSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte35ReturnToNetworkSettings", v, metadata)
	}
	if s.Scte35SpliceInsertSettings != nil {
		v := s.Scte35SpliceInsertSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte35SpliceInsertSettings", v, metadata)
	}
	if s.Scte35TimeSignalSettings != nil {
		v := s.Scte35TimeSignalSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte35TimeSignalSettings", v, metadata)
	}
	if s.StaticImageActivateSettings != nil {
		v := s.StaticImageActivateSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "staticImageActivateSettings", v, metadata)
	}
	if s.StaticImageDeactivateSettings != nil {
		v := s.StaticImageDeactivateSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "staticImageDeactivateSettings", v, metadata)
	}
	return nil
}

// Settings to specify the start time for an action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ScheduleActionStartSettings
type ScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Holds the start time for the action.
	FixedModeScheduleActionStartSettings *FixedModeScheduleActionStartSettings `locationName:"fixedModeScheduleActionStartSettings" type:"structure"`

	// Specifies an action to follow for scheduling this action.
	FollowModeScheduleActionStartSettings *FollowModeScheduleActionStartSettings `locationName:"followModeScheduleActionStartSettings" type:"structure"`
}

// String returns the string representation
func (s ScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleActionStartSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleActionStartSettings"}
	if s.FixedModeScheduleActionStartSettings != nil {
		if err := s.FixedModeScheduleActionStartSettings.Validate(); err != nil {
			invalidParams.AddNested("FixedModeScheduleActionStartSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.FollowModeScheduleActionStartSettings != nil {
		if err := s.FollowModeScheduleActionStartSettings.Validate(); err != nil {
			invalidParams.AddNested("FollowModeScheduleActionStartSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ScheduleActionStartSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.FixedModeScheduleActionStartSettings != nil {
		v := s.FixedModeScheduleActionStartSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "fixedModeScheduleActionStartSettings", v, metadata)
	}
	if s.FollowModeScheduleActionStartSettings != nil {
		v := s.FollowModeScheduleActionStartSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "followModeScheduleActionStartSettings", v, metadata)
	}
	return nil
}

// Scte20 Plus Embedded Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte20PlusEmbeddedDestinationSettings
type Scte20PlusEmbeddedDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Scte20PlusEmbeddedDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte20PlusEmbeddedDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Scte20 Source Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte20SourceSettings
type Scte20SourceSettings struct {
	_ struct{} `type:"structure"`

	// If upconvert, 608 data is both passed through via the "608 compatibility
	// bytes" fields of the 708 wrapper as well as translated into 708. 708 data
	// present in the source content will be discarded.
	Convert608To708 Scte20Convert608To708 `locationName:"convert608To708" type:"string" enum:"true"`

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber *int64 `locationName:"source608ChannelNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s Scte20SourceSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte20SourceSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte20SourceSettings"}
	if s.Source608ChannelNumber != nil && *s.Source608ChannelNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Source608ChannelNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte20SourceSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Convert608To708) > 0 {
		v := s.Convert608To708

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "convert608To708", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Source608ChannelNumber != nil {
		v := *s.Source608ChannelNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "source608ChannelNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Scte27 Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte27DestinationSettings
type Scte27DestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Scte27DestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte27DestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Scte27 Source Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte27SourceSettings
type Scte27SourceSettings struct {
	_ struct{} `type:"structure"`

	// The pid field is used in conjunction with the caption selector languageCode
	// field as follows: - Specify PID and Language: Extracts captions from that
	// PID; the language is "informational". - Specify PID and omit Language: Extracts
	// the specified PID. - Omit PID and specify Language: Extracts the specified
	// language, whichever PID that happens to be. - Omit PID and omit Language:
	// Valid only if source is DVB-Sub that is being passed through; all languages
	// will be passed through.
	Pid *int64 `locationName:"pid" min:"1" type:"integer"`
}

// String returns the string representation
func (s Scte27SourceSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte27SourceSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte27SourceSettings"}
	if s.Pid != nil && *s.Pid < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Pid", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte27SourceSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Pid != nil {
		v := *s.Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pid", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Corresponds to SCTE-35 delivery_not_restricted_flag parameter. To declare
// delivery restrictions, include this element and its four "restriction" flags.
// To declare that there are no restrictions, omit this element.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35DeliveryRestrictions
type Scte35DeliveryRestrictions struct {
	_ struct{} `type:"structure"`

	// Corresponds to SCTE-35 archive_allowed_flag.
	//
	// ArchiveAllowedFlag is a required field
	ArchiveAllowedFlag Scte35ArchiveAllowedFlag `locationName:"archiveAllowedFlag" type:"string" required:"true" enum:"true"`

	// Corresponds to SCTE-35 device_restrictions parameter.
	//
	// DeviceRestrictions is a required field
	DeviceRestrictions Scte35DeviceRestrictions `locationName:"deviceRestrictions" type:"string" required:"true" enum:"true"`

	// Corresponds to SCTE-35 no_regional_blackout_flag parameter.
	//
	// NoRegionalBlackoutFlag is a required field
	NoRegionalBlackoutFlag Scte35NoRegionalBlackoutFlag `locationName:"noRegionalBlackoutFlag" type:"string" required:"true" enum:"true"`

	// Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
	//
	// WebDeliveryAllowedFlag is a required field
	WebDeliveryAllowedFlag Scte35WebDeliveryAllowedFlag `locationName:"webDeliveryAllowedFlag" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Scte35DeliveryRestrictions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35DeliveryRestrictions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35DeliveryRestrictions"}
	if len(s.ArchiveAllowedFlag) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ArchiveAllowedFlag"))
	}
	if len(s.DeviceRestrictions) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DeviceRestrictions"))
	}
	if len(s.NoRegionalBlackoutFlag) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("NoRegionalBlackoutFlag"))
	}
	if len(s.WebDeliveryAllowedFlag) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("WebDeliveryAllowedFlag"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35DeliveryRestrictions) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ArchiveAllowedFlag) > 0 {
		v := s.ArchiveAllowedFlag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "archiveAllowedFlag", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.DeviceRestrictions) > 0 {
		v := s.DeviceRestrictions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deviceRestrictions", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.NoRegionalBlackoutFlag) > 0 {
		v := s.NoRegionalBlackoutFlag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "noRegionalBlackoutFlag", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.WebDeliveryAllowedFlag) > 0 {
		v := s.WebDeliveryAllowedFlag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "webDeliveryAllowedFlag", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Holds one set of SCTE-35 Descriptor Settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35Descriptor
type Scte35Descriptor struct {
	_ struct{} `type:"structure"`

	// SCTE-35 Descriptor Settings.
	//
	// Scte35DescriptorSettings is a required field
	Scte35DescriptorSettings *Scte35DescriptorSettings `locationName:"scte35DescriptorSettings" type:"structure" required:"true"`
}

// String returns the string representation
func (s Scte35Descriptor) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35Descriptor) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35Descriptor"}

	if s.Scte35DescriptorSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("Scte35DescriptorSettings"))
	}
	if s.Scte35DescriptorSettings != nil {
		if err := s.Scte35DescriptorSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte35DescriptorSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35Descriptor) MarshalFields(e protocol.FieldEncoder) error {
	if s.Scte35DescriptorSettings != nil {
		v := s.Scte35DescriptorSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scte35DescriptorSettings", v, metadata)
	}
	return nil
}

// SCTE-35 Descriptor settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35DescriptorSettings
type Scte35DescriptorSettings struct {
	_ struct{} `type:"structure"`

	// SCTE-35 Segmentation Descriptor.
	//
	// SegmentationDescriptorScte35DescriptorSettings is a required field
	SegmentationDescriptorScte35DescriptorSettings *Scte35SegmentationDescriptor `locationName:"segmentationDescriptorScte35DescriptorSettings" type:"structure" required:"true"`
}

// String returns the string representation
func (s Scte35DescriptorSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35DescriptorSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35DescriptorSettings"}

	if s.SegmentationDescriptorScte35DescriptorSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentationDescriptorScte35DescriptorSettings"))
	}
	if s.SegmentationDescriptorScte35DescriptorSettings != nil {
		if err := s.SegmentationDescriptorScte35DescriptorSettings.Validate(); err != nil {
			invalidParams.AddNested("SegmentationDescriptorScte35DescriptorSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35DescriptorSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.SegmentationDescriptorScte35DescriptorSettings != nil {
		v := s.SegmentationDescriptorScte35DescriptorSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "segmentationDescriptorScte35DescriptorSettings", v, metadata)
	}
	return nil
}

// Settings for a SCTE-35 return_to_network message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35ReturnToNetworkScheduleActionSettings
type Scte35ReturnToNetworkScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
	//
	// SpliceEventId is a required field
	SpliceEventId *int64 `locationName:"spliceEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s Scte35ReturnToNetworkScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35ReturnToNetworkScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35ReturnToNetworkScheduleActionSettings"}

	if s.SpliceEventId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpliceEventId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35ReturnToNetworkScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.SpliceEventId != nil {
		v := *s.SpliceEventId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spliceEventId", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Corresponds to SCTE-35 segmentation_descriptor.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35SegmentationDescriptor
type Scte35SegmentationDescriptor struct {
	_ struct{} `type:"structure"`

	// Holds the four SCTE-35 delivery restriction parameters.
	DeliveryRestrictions *Scte35DeliveryRestrictions `locationName:"deliveryRestrictions" type:"structure"`

	// Corresponds to SCTE-35 segment_num. A value that is valid for the specified
	// segmentation_type_id.
	SegmentNum *int64 `locationName:"segmentNum" type:"integer"`

	// Corresponds to SCTE-35 segmentation_event_cancel_indicator.
	//
	// SegmentationCancelIndicator is a required field
	SegmentationCancelIndicator Scte35SegmentationCancelIndicator `locationName:"segmentationCancelIndicator" type:"string" required:"true" enum:"true"`

	// Corresponds to SCTE-35 segmentation_duration. Optional. The duration for
	// the time_signal, in 90 KHz ticks. To convert seconds to ticks, multiple the
	// seconds by 90,000. Enter time in 90 KHz clock ticks. If you do not enter
	// a duration, the time_signal will continue until you insert a cancellation
	// message.
	SegmentationDuration *int64 `locationName:"segmentationDuration" type:"long"`

	// Corresponds to SCTE-35 segmentation_event_id.
	//
	// SegmentationEventId is a required field
	SegmentationEventId *int64 `locationName:"segmentationEventId" type:"long" required:"true"`

	// Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id
	// values listed in the SCTE-35 specification. On the console, enter the ID
	// in decimal (for example, "52"). In the CLI, API, or an SDK, enter the ID
	// in hex (for example, "0x34") or decimal (for example, "52").
	SegmentationTypeId *int64 `locationName:"segmentationTypeId" type:"integer"`

	// Corresponds to SCTE-35 segmentation_upid. Enter a string containing the hexadecimal
	// representation of the characters that make up the SCTE-35 segmentation_upid
	// value. Must contain an even number of hex characters. Do not include spaces
	// between each hex pair. For example, the ASCII "ADS Information" becomes hex
	// "41445320496e666f726d6174696f6e.
	SegmentationUpid *string `locationName:"segmentationUpid" type:"string"`

	// Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one
	// of the types listed in the SCTE-35 specification, converted to a decimal.
	// For example, "0x0C" hex from the specification is "12" in decimal. In the
	// CLI, API, or an SDK, enter one of the types listed in the SCTE-35 specification,
	// in either hex (for example, "0x0C" ) or in decimal (for example, "12").
	SegmentationUpidType *int64 `locationName:"segmentationUpidType" type:"integer"`

	// Corresponds to SCTE-35 segments_expected. A value that is valid for the specified
	// segmentation_type_id.
	SegmentsExpected *int64 `locationName:"segmentsExpected" type:"integer"`

	// Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified
	// segmentation_type_id.
	SubSegmentNum *int64 `locationName:"subSegmentNum" type:"integer"`

	// Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the
	// specified segmentation_type_id.
	SubSegmentsExpected *int64 `locationName:"subSegmentsExpected" type:"integer"`
}

// String returns the string representation
func (s Scte35SegmentationDescriptor) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35SegmentationDescriptor) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35SegmentationDescriptor"}
	if len(s.SegmentationCancelIndicator) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SegmentationCancelIndicator"))
	}

	if s.SegmentationEventId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentationEventId"))
	}
	if s.DeliveryRestrictions != nil {
		if err := s.DeliveryRestrictions.Validate(); err != nil {
			invalidParams.AddNested("DeliveryRestrictions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35SegmentationDescriptor) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeliveryRestrictions != nil {
		v := s.DeliveryRestrictions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deliveryRestrictions", v, metadata)
	}
	if s.SegmentNum != nil {
		v := *s.SegmentNum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentNum", protocol.Int64Value(v), metadata)
	}
	if len(s.SegmentationCancelIndicator) > 0 {
		v := s.SegmentationCancelIndicator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationCancelIndicator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SegmentationDuration != nil {
		v := *s.SegmentationDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationDuration", protocol.Int64Value(v), metadata)
	}
	if s.SegmentationEventId != nil {
		v := *s.SegmentationEventId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationEventId", protocol.Int64Value(v), metadata)
	}
	if s.SegmentationTypeId != nil {
		v := *s.SegmentationTypeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationTypeId", protocol.Int64Value(v), metadata)
	}
	if s.SegmentationUpid != nil {
		v := *s.SegmentationUpid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationUpid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentationUpidType != nil {
		v := *s.SegmentationUpidType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentationUpidType", protocol.Int64Value(v), metadata)
	}
	if s.SegmentsExpected != nil {
		v := *s.SegmentsExpected

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "segmentsExpected", protocol.Int64Value(v), metadata)
	}
	if s.SubSegmentNum != nil {
		v := *s.SubSegmentNum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subSegmentNum", protocol.Int64Value(v), metadata)
	}
	if s.SubSegmentsExpected != nil {
		v := *s.SubSegmentsExpected

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subSegmentsExpected", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Scte35 Splice Insert
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35SpliceInsert
type Scte35SpliceInsert struct {
	_ struct{} `type:"structure"`

	// When specified, this offset (in milliseconds) is added to the input Ad Avail
	// PTS time. This only applies to embedded SCTE 104/35 messages and does not
	// apply to OOB messages.
	AdAvailOffset *int64 `locationName:"adAvailOffset" type:"integer"`

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag Scte35SpliceInsertNoRegionalBlackoutBehavior `locationName:"noRegionalBlackoutFlag" type:"string" enum:"true"`

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag Scte35SpliceInsertWebDeliveryAllowedBehavior `locationName:"webDeliveryAllowedFlag" type:"string" enum:"true"`
}

// String returns the string representation
func (s Scte35SpliceInsert) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35SpliceInsert) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35SpliceInsert"}
	if s.AdAvailOffset != nil && *s.AdAvailOffset < -1000 {
		invalidParams.Add(aws.NewErrParamMinValue("AdAvailOffset", -1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35SpliceInsert) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdAvailOffset != nil {
		v := *s.AdAvailOffset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adAvailOffset", protocol.Int64Value(v), metadata)
	}
	if len(s.NoRegionalBlackoutFlag) > 0 {
		v := s.NoRegionalBlackoutFlag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "noRegionalBlackoutFlag", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.WebDeliveryAllowedFlag) > 0 {
		v := s.WebDeliveryAllowedFlag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "webDeliveryAllowedFlag", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Settings for a SCTE-35 splice_insert message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35SpliceInsertScheduleActionSettings
type Scte35SpliceInsertScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Optional, the duration for the splice_insert, in 90 KHz ticks. To convert
	// seconds to ticks, multiple the seconds by 90,000. If you enter a duration,
	// there is an expectation that the downstream system can read the duration
	// and cue in at that time. If you do not enter a duration, the splice_insert
	// will continue indefinitely and there is an expectation that you will enter
	// a return_to_network to end the splice_insert at the appropriate time.
	Duration *int64 `locationName:"duration" type:"long"`

	// The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
	//
	// SpliceEventId is a required field
	SpliceEventId *int64 `locationName:"spliceEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s Scte35SpliceInsertScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35SpliceInsertScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35SpliceInsertScheduleActionSettings"}

	if s.SpliceEventId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpliceEventId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35SpliceInsertScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "duration", protocol.Int64Value(v), metadata)
	}
	if s.SpliceEventId != nil {
		v := *s.SpliceEventId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spliceEventId", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Scte35 Time Signal Apos
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35TimeSignalApos
type Scte35TimeSignalApos struct {
	_ struct{} `type:"structure"`

	// When specified, this offset (in milliseconds) is added to the input Ad Avail
	// PTS time. This only applies to embedded SCTE 104/35 messages and does not
	// apply to OOB messages.
	AdAvailOffset *int64 `locationName:"adAvailOffset" type:"integer"`

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag Scte35AposNoRegionalBlackoutBehavior `locationName:"noRegionalBlackoutFlag" type:"string" enum:"true"`

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag Scte35AposWebDeliveryAllowedBehavior `locationName:"webDeliveryAllowedFlag" type:"string" enum:"true"`
}

// String returns the string representation
func (s Scte35TimeSignalApos) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35TimeSignalApos) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35TimeSignalApos"}
	if s.AdAvailOffset != nil && *s.AdAvailOffset < -1000 {
		invalidParams.Add(aws.NewErrParamMinValue("AdAvailOffset", -1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35TimeSignalApos) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdAvailOffset != nil {
		v := *s.AdAvailOffset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adAvailOffset", protocol.Int64Value(v), metadata)
	}
	if len(s.NoRegionalBlackoutFlag) > 0 {
		v := s.NoRegionalBlackoutFlag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "noRegionalBlackoutFlag", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.WebDeliveryAllowedFlag) > 0 {
		v := s.WebDeliveryAllowedFlag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "webDeliveryAllowedFlag", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Settings for a SCTE-35 time_signal.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/Scte35TimeSignalScheduleActionSettings
type Scte35TimeSignalScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The list of SCTE-35 descriptors accompanying the SCTE-35 time_signal.
	//
	// Scte35Descriptors is a required field
	Scte35Descriptors []Scte35Descriptor `locationName:"scte35Descriptors" type:"list" required:"true"`
}

// String returns the string representation
func (s Scte35TimeSignalScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35TimeSignalScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scte35TimeSignalScheduleActionSettings"}

	if s.Scte35Descriptors == nil {
		invalidParams.Add(aws.NewErrParamRequired("Scte35Descriptors"))
	}
	if s.Scte35Descriptors != nil {
		for i, v := range s.Scte35Descriptors {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Scte35Descriptors", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Scte35TimeSignalScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Scte35Descriptors) > 0 {
		v := s.Scte35Descriptors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "scte35Descriptors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Smpte Tt Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/SmpteTtDestinationSettings
type SmpteTtDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SmpteTtDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SmpteTtDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Standard Hls Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StandardHlsSettings
type StandardHlsSettings struct {
	_ struct{} `type:"structure"`

	// List all the audio groups that are used with the video output stream. Input
	// all the audio GROUP-IDs that are associated to the video, separate by ','.
	AudioRenditionSets *string `locationName:"audioRenditionSets" type:"string"`

	// Settings information for the .m3u8 container
	//
	// M3u8Settings is a required field
	M3u8Settings *M3u8Settings `locationName:"m3u8Settings" type:"structure" required:"true"`
}

// String returns the string representation
func (s StandardHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardHlsSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StandardHlsSettings"}

	if s.M3u8Settings == nil {
		invalidParams.Add(aws.NewErrParamRequired("M3u8Settings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StandardHlsSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.AudioRenditionSets != nil {
		v := *s.AudioRenditionSets

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "audioRenditionSets", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.M3u8Settings != nil {
		v := s.M3u8Settings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "m3u8Settings", v, metadata)
	}
	return nil
}

// Settings for the action to activate a static image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StaticImageActivateScheduleActionSettings
type StaticImageActivateScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The duration in milliseconds for the image to remain on the video. If omitted
	// or set to 0 the duration is unlimited and the image will remain until it
	// is explicitly deactivated.
	Duration *int64 `locationName:"duration" type:"integer"`

	// The time in milliseconds for the image to fade in. The fade-in starts at
	// the start time of the overlay. Default is 0 (no fade-in).
	FadeIn *int64 `locationName:"fadeIn" type:"integer"`

	// Applies only if a duration is specified. The time in milliseconds for the
	// image to fade out. The fade-out starts when the duration time is hit, so
	// it effectively extends the duration. Default is 0 (no fade-out).
	FadeOut *int64 `locationName:"fadeOut" type:"integer"`

	// The height of the image when inserted into the video, in pixels. The overlay
	// will be scaled up or down to the specified height. Leave blank to use the
	// native height of the overlay.
	Height *int64 `locationName:"height" min:"1" type:"integer"`

	// The location and filename of the image file to overlay on the video. The
	// file must be a 32-bit BMP, PNG, or TGA file, and must not be larger (in pixels)
	// than the input video.
	//
	// Image is a required field
	Image *InputLocation `locationName:"image" type:"structure" required:"true"`

	// Placement of the left edge of the overlay relative to the left edge of the
	// video frame, in pixels. 0 (the default) is the left edge of the frame. If
	// the placement causes the overlay to extend beyond the right edge of the underlying
	// video, then the overlay is cropped on the right.
	ImageX *int64 `locationName:"imageX" type:"integer"`

	// Placement of the top edge of the overlay relative to the top edge of the
	// video frame, in pixels. 0 (the default) is the top edge of the frame. If
	// the placement causes the overlay to extend beyond the bottom edge of the
	// underlying video, then the overlay is cropped on the bottom.
	ImageY *int64 `locationName:"imageY" type:"integer"`

	// The number of the layer, 0 to 7. There are 8 layers that can be overlaid
	// on the video, each layer with a different image. The layers are in Z order,
	// which means that overlays with higher values of layer are inserted on top
	// of overlays with lower values of layer. Default is 0.
	Layer *int64 `locationName:"layer" type:"integer"`

	// Opacity of image where 0 is transparent and 100 is fully opaque. Default
	// is 100.
	Opacity *int64 `locationName:"opacity" type:"integer"`

	// The width of the image when inserted into the video, in pixels. The overlay
	// will be scaled up or down to the specified width. Leave blank to use the
	// native width of the overlay.
	Width *int64 `locationName:"width" min:"1" type:"integer"`
}

// String returns the string representation
func (s StaticImageActivateScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticImageActivateScheduleActionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StaticImageActivateScheduleActionSettings"}
	if s.Height != nil && *s.Height < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Height", 1))
	}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}
	if s.Width != nil && *s.Width < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Width", 1))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StaticImageActivateScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "duration", protocol.Int64Value(v), metadata)
	}
	if s.FadeIn != nil {
		v := *s.FadeIn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fadeIn", protocol.Int64Value(v), metadata)
	}
	if s.FadeOut != nil {
		v := *s.FadeOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fadeOut", protocol.Int64Value(v), metadata)
	}
	if s.Height != nil {
		v := *s.Height

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "height", protocol.Int64Value(v), metadata)
	}
	if s.Image != nil {
		v := s.Image

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "image", v, metadata)
	}
	if s.ImageX != nil {
		v := *s.ImageX

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageX", protocol.Int64Value(v), metadata)
	}
	if s.ImageY != nil {
		v := *s.ImageY

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageY", protocol.Int64Value(v), metadata)
	}
	if s.Layer != nil {
		v := *s.Layer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "layer", protocol.Int64Value(v), metadata)
	}
	if s.Opacity != nil {
		v := *s.Opacity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "opacity", protocol.Int64Value(v), metadata)
	}
	if s.Width != nil {
		v := *s.Width

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "width", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Settings for the action to deactivate the image in a specific layer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StaticImageDeactivateScheduleActionSettings
type StaticImageDeactivateScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
	FadeOut *int64 `locationName:"fadeOut" type:"integer"`

	// The image overlay layer to deactivate, 0 to 7. Default is 0.
	Layer *int64 `locationName:"layer" type:"integer"`
}

// String returns the string representation
func (s StaticImageDeactivateScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StaticImageDeactivateScheduleActionSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.FadeOut != nil {
		v := *s.FadeOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fadeOut", protocol.Int64Value(v), metadata)
	}
	if s.Layer != nil {
		v := *s.Layer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "layer", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Static Key Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StaticKeySettings
type StaticKeySettings struct {
	_ struct{} `type:"structure"`

	// The URL of the license server used for protecting content.
	KeyProviderServer *InputLocation `locationName:"keyProviderServer" type:"structure"`

	// Static key value as a 32 character hexadecimal string.
	//
	// StaticKeyValue is a required field
	StaticKeyValue *string `locationName:"staticKeyValue" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s StaticKeySettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticKeySettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StaticKeySettings"}

	if s.StaticKeyValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("StaticKeyValue"))
	}
	if s.StaticKeyValue != nil && len(*s.StaticKeyValue) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("StaticKeyValue", 32))
	}
	if s.KeyProviderServer != nil {
		if err := s.KeyProviderServer.Validate(); err != nil {
			invalidParams.AddNested("KeyProviderServer", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StaticKeySettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.KeyProviderServer != nil {
		v := s.KeyProviderServer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "keyProviderServer", v, metadata)
	}
	if s.StaticKeyValue != nil {
		v := *s.StaticKeyValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "staticKeyValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Teletext Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TeletextDestinationSettings
type TeletextDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TeletextDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TeletextDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Teletext Source Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TeletextSourceSettings
type TeletextSourceSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the teletext page number within the data stream from which to extract
	// captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should
	// be specified as a hexadecimal string with no "0x" prefix.
	PageNumber *string `locationName:"pageNumber" type:"string"`
}

// String returns the string representation
func (s TeletextSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TeletextSourceSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.PageNumber != nil {
		v := *s.PageNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pageNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Timecode Config
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TimecodeConfig
type TimecodeConfig struct {
	_ struct{} `type:"structure"`

	// Identifies the source for the timecode that will be associated with the events
	// outputs.-Embedded (embedded): Initialize the output timecode with timecode
	// from the the source. If no embedded timecode is detected in the source, the
	// system falls back to using "Start at 0" (zerobased).-System Clock (systemclock):
	// Use the UTC time.-Start at 0 (zerobased): The time of the first frame of
	// the event will be 00:00:00:00.
	//
	// Source is a required field
	Source TimecodeConfigSource `locationName:"source" type:"string" required:"true" enum:"true"`

	// Threshold in frames beyond which output timecode is resynchronized to the
	// input timecode. Discrepancies below this threshold are permitted to avoid
	// unnecessary discontinuities in the output timecode. No timecode sync when
	// this is not specified.
	SyncThreshold *int64 `locationName:"syncThreshold" min:"1" type:"integer"`
}

// String returns the string representation
func (s TimecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimecodeConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TimecodeConfig"}
	if len(s.Source) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.SyncThreshold != nil && *s.SyncThreshold < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("SyncThreshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TimecodeConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Source) > 0 {
		v := s.Source

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "source", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SyncThreshold != nil {
		v := *s.SyncThreshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "syncThreshold", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Ttml Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TtmlDestinationSettings
type TtmlDestinationSettings struct {
	_ struct{} `type:"structure"`

	// When set to passthrough, passes through style and position information from
	// a TTML-like input source (TTML, SMPTE-TT, CFF-TT) to the CFF-TT output or
	// TTML output.
	StyleControl TtmlDestinationStyleControl `locationName:"styleControl" type:"string" enum:"true"`
}

// String returns the string representation
func (s TtmlDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TtmlDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.StyleControl) > 0 {
		v := s.StyleControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "styleControl", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Udp Container Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UdpContainerSettings
type UdpContainerSettings struct {
	_ struct{} `type:"structure"`

	// M2ts Settings
	M2tsSettings *M2tsSettings `locationName:"m2tsSettings" type:"structure"`
}

// String returns the string representation
func (s UdpContainerSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UdpContainerSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UdpContainerSettings"}
	if s.M2tsSettings != nil {
		if err := s.M2tsSettings.Validate(); err != nil {
			invalidParams.AddNested("M2tsSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UdpContainerSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.M2tsSettings != nil {
		v := s.M2tsSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "m2tsSettings", v, metadata)
	}
	return nil
}

// Udp Group Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UdpGroupSettings
type UdpGroupSettings struct {
	_ struct{} `type:"structure"`

	// Specifies behavior of last resort when input video is lost, and no more backup
	// inputs are available. When dropTs is selected the entire transport stream
	// will stop being emitted. When dropProgram is selected the program can be
	// dropped from the transport stream (and replaced with null packets to meet
	// the TS bitrate requirement). Or, when emitProgram is chosen the transport
	// stream will continue to be produced normally with repeat frames, black frames,
	// or slate frames substituted for the absent input video.
	InputLossAction InputLossActionForUdpOut `locationName:"inputLossAction" type:"string" enum:"true"`

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame UdpTimedMetadataId3Frame `locationName:"timedMetadataId3Frame" type:"string" enum:"true"`

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period *int64 `locationName:"timedMetadataId3Period" type:"integer"`
}

// String returns the string representation
func (s UdpGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UdpGroupSettings) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.InputLossAction) > 0 {
		v := s.InputLossAction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputLossAction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TimedMetadataId3Frame) > 0 {
		v := s.TimedMetadataId3Frame

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataId3Frame", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimedMetadataId3Period != nil {
		v := *s.TimedMetadataId3Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timedMetadataId3Period", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Udp Output Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UdpOutputSettings
type UdpOutputSettings struct {
	_ struct{} `type:"structure"`

	// UDP output buffering in milliseconds. Larger values increase latency through
	// the transcoder but simultaneously assist the transcoder in maintaining a
	// constant, low-jitter UDP/RTP output while accommodating clock recovery, input
	// switching, input disruptions, picture reordering, etc.
	BufferMsec *int64 `locationName:"bufferMsec" type:"integer"`

	// Udp Container Settings
	//
	// ContainerSettings is a required field
	ContainerSettings *UdpContainerSettings `locationName:"containerSettings" type:"structure" required:"true"`

	// Destination address and port number for RTP or UDP packets. Can be unicast
	// or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Settings for enabling and adjusting Forward Error Correction on UDP outputs.
	FecOutputSettings *FecOutputSettings `locationName:"fecOutputSettings" type:"structure"`
}

// String returns the string representation
func (s UdpOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UdpOutputSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UdpOutputSettings"}

	if s.ContainerSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerSettings"))
	}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.ContainerSettings != nil {
		if err := s.ContainerSettings.Validate(); err != nil {
			invalidParams.AddNested("ContainerSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.FecOutputSettings != nil {
		if err := s.FecOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("FecOutputSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UdpOutputSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.BufferMsec != nil {
		v := *s.BufferMsec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bufferMsec", protocol.Int64Value(v), metadata)
	}
	if s.ContainerSettings != nil {
		v := s.ContainerSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "containerSettings", v, metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if s.FecOutputSettings != nil {
		v := s.FecOutputSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "fecOutputSettings", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ValidationError
type ValidationError struct {
	_ struct{} `type:"structure"`

	ElementPath *string `locationName:"elementPath" type:"string"`

	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s ValidationError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ValidationError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ElementPath != nil {
		v := *s.ElementPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "elementPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Video Codec Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/VideoCodecSettings
type VideoCodecSettings struct {
	_ struct{} `type:"structure"`

	// Frame Capture Settings
	FrameCaptureSettings *FrameCaptureSettings `locationName:"frameCaptureSettings" type:"structure"`

	// H264 Settings
	H264Settings *H264Settings `locationName:"h264Settings" type:"structure"`
}

// String returns the string representation
func (s VideoCodecSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoCodecSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VideoCodecSettings"}
	if s.FrameCaptureSettings != nil {
		if err := s.FrameCaptureSettings.Validate(); err != nil {
			invalidParams.AddNested("FrameCaptureSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.H264Settings != nil {
		if err := s.H264Settings.Validate(); err != nil {
			invalidParams.AddNested("H264Settings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VideoCodecSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.FrameCaptureSettings != nil {
		v := s.FrameCaptureSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "frameCaptureSettings", v, metadata)
	}
	if s.H264Settings != nil {
		v := s.H264Settings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "h264Settings", v, metadata)
	}
	return nil
}

// Video settings for this stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/VideoDescription
type VideoDescription struct {
	_ struct{} `type:"structure"`

	// Video codec settings.
	CodecSettings *VideoCodecSettings `locationName:"codecSettings" type:"structure"`

	// Output video height, in pixels. Must be an even number. For most codecs,
	// you can leave this field and width blank in order to use the height and width
	// (resolution) from the source. Note, however, that leaving blank is not recommended.
	// For the Frame Capture codec, height and width are required.
	Height *int64 `locationName:"height" type:"integer"`

	// The name of this VideoDescription. Outputs will use this name to uniquely
	// identify this Description. Description names should be unique within this
	// Live Event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Indicates how to respond to the AFD values in the input stream. RESPOND causes
	// input video to be clipped, depending on the AFD value, input display aspect
	// ratio, and output display aspect ratio, and (except for FRAMECAPTURE codec)
	// includes the values in the output. PASSTHROUGH (does not apply to FRAMECAPTURE
	// codec) ignores the AFD values and includes the values in the output, so input
	// video is not clipped. NONE ignores the AFD values and does not include the
	// values through to the output, so input video is not clipped.
	RespondToAfd VideoDescriptionRespondToAfd `locationName:"respondToAfd" type:"string" enum:"true"`

	// STRETCHTOOUTPUT configures the output position to stretch the video to the
	// specified output resolution (height and width). This option will override
	// any position value. DEFAULT may insert black boxes (pillar boxes or letter
	// boxes) around the video to provide the specified output resolution.
	ScalingBehavior VideoDescriptionScalingBehavior `locationName:"scalingBehavior" type:"string" enum:"true"`

	// Changes the strength of the anti-alias filter used for scaling. 0 is the
	// softest setting, 100 is the sharpest. A setting of 50 is recommended for
	// most content.
	Sharpness *int64 `locationName:"sharpness" type:"integer"`

	// Output video width, in pixels. Must be an even number. For most codecs, you
	// can leave this field and height blank in order to use the height and width
	// (resolution) from the source. Note, however, that leaving blank is not recommended.
	// For the Frame Capture codec, height and width are required.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation
func (s VideoDescription) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoDescription) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VideoDescription"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.CodecSettings != nil {
		if err := s.CodecSettings.Validate(); err != nil {
			invalidParams.AddNested("CodecSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VideoDescription) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodecSettings != nil {
		v := s.CodecSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "codecSettings", v, metadata)
	}
	if s.Height != nil {
		v := *s.Height

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "height", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.RespondToAfd) > 0 {
		v := s.RespondToAfd

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "respondToAfd", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ScalingBehavior) > 0 {
		v := s.ScalingBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scalingBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Sharpness != nil {
		v := *s.Sharpness

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sharpness", protocol.Int64Value(v), metadata)
	}
	if s.Width != nil {
		v := *s.Width

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "width", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Specifies a particular video stream within an input source. An input may
// have only a single video selector.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/VideoSelector
type VideoSelector struct {
	_ struct{} `type:"structure"`

	// Specifies the colorspace of an input. This setting works in tandem with colorSpaceConversion
	// to determine if any conversion will be performed.
	ColorSpace VideoSelectorColorSpace `locationName:"colorSpace" type:"string" enum:"true"`

	// Applies only if colorSpace is a value other than follow. This field controls
	// how the value in the colorSpace field will be used. fallback means that when
	// the input does include color space data, that data will be used, but when
	// the input has no color space data, the value in colorSpace will be used.
	// Choose fallback if your input is sometimes missing color space data, but
	// when it does have color space data, that data is correct. force means to
	// always use the value in colorSpace. Choose force if your input usually has
	// no color space data or might have unreliable color space data.
	ColorSpaceUsage VideoSelectorColorSpaceUsage `locationName:"colorSpaceUsage" type:"string" enum:"true"`

	// The video selector settings.
	SelectorSettings *VideoSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s VideoSelector) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VideoSelector) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ColorSpace) > 0 {
		v := s.ColorSpace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "colorSpace", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ColorSpaceUsage) > 0 {
		v := s.ColorSpaceUsage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "colorSpaceUsage", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SelectorSettings != nil {
		v := s.SelectorSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "selectorSettings", v, metadata)
	}
	return nil
}

// Video Selector Pid
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/VideoSelectorPid
type VideoSelectorPid struct {
	_ struct{} `type:"structure"`

	// Selects a specific PID from within a video source.
	Pid *int64 `locationName:"pid" type:"integer"`
}

// String returns the string representation
func (s VideoSelectorPid) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VideoSelectorPid) MarshalFields(e protocol.FieldEncoder) error {
	if s.Pid != nil {
		v := *s.Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pid", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Video Selector Program Id
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/VideoSelectorProgramId
type VideoSelectorProgramId struct {
	_ struct{} `type:"structure"`

	// Selects a specific program from within a multi-program transport stream.
	// If the program doesn't exist, the first program within the transport stream
	// will be selected by default.
	ProgramId *int64 `locationName:"programId" type:"integer"`
}

// String returns the string representation
func (s VideoSelectorProgramId) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VideoSelectorProgramId) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProgramId != nil {
		v := *s.ProgramId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programId", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Video Selector Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/VideoSelectorSettings
type VideoSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Video Selector Pid
	VideoSelectorPid *VideoSelectorPid `locationName:"videoSelectorPid" type:"structure"`

	// Video Selector Program Id
	VideoSelectorProgramId *VideoSelectorProgramId `locationName:"videoSelectorProgramId" type:"structure"`
}

// String returns the string representation
func (s VideoSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VideoSelectorSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.VideoSelectorPid != nil {
		v := s.VideoSelectorPid

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "videoSelectorPid", v, metadata)
	}
	if s.VideoSelectorProgramId != nil {
		v := s.VideoSelectorProgramId

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "videoSelectorProgramId", v, metadata)
	}
	return nil
}

// Webvtt Destination Settings
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/WebvttDestinationSettings
type WebvttDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s WebvttDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WebvttDestinationSettings) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}
