// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Amazon Device Messaging channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ADMChannelRequest
type ADMChannelRequest struct {
	_ struct{} `type:"structure"`

	// The Client ID that you obtained from the Amazon App Distribution Portal.
	ClientId *string `type:"string"`

	// The Client Secret that you obtained from the Amazon App Distribution Portal.
	ClientSecret *string `type:"string"`

	// Indicates whether or not the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ADMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ADMChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientId != nil {
		v := *s.ClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientSecret != nil {
		v := *s.ClientSecret

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientSecret", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Amazon Device Messaging channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ADMChannelResponse
type ADMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the channel applies.
	ApplicationId *string `type:"string"`

	// The date and time when this channel was created.
	CreationDate *string `type:"string"`

	// Indicates whether or not the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the channel. Retained for backwards compatibility.
	Id *string `type:"string"`

	// Indicates whether or not the channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last updated this channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when this channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The platform type. For this channel, the value is always "ADM."
	Platform *string `type:"string"`

	// The channel version.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ADMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ADMChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// ADM Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ADMMessage
type ADMMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action Action `type:"string" enum:"true"`

	// The message body of the notification.
	Body *string `type:"string"`

	// Optional. Arbitrary string used to indicate multiple messages are logically
	// the same and that ADM is allowed to drop previously enqueued messages in
	// favor of this one.
	ConsolidationKey *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]string `type:"map"`

	// Optional. Number of seconds ADM should retain the message if the device is
	// offline
	ExpiresAfter *string `type:"string"`

	// The icon image name of the asset saved in your application.
	IconReference *string `type:"string"`

	// The URL that points to an image used as the large icon to the notification
	// content view.
	ImageIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// Optional. Base-64-encoded MD5 checksum of the data parameter. Used to verify
	// data integrity
	MD5 *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The URL that points to an image used as the small icon for the notification
	// which will be used to represent the notification in the status bar and content
	// view
	SmallImageIconUrl *string `type:"string"`

	// Indicates a sound to play when the device receives the notification. Supports
	// default, or the filename of a sound resource bundled in the app. Android
	// sound files must reside in /res/raw/
	Sound *string `type:"string"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s ADMMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ADMMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConsolidationKey != nil {
		v := *s.ConsolidationKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConsolidationKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Data) > 0 {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ExpiresAfter != nil {
		v := *s.ExpiresAfter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpiresAfter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IconReference != nil {
		v := *s.IconReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IconReference", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MD5 != nil {
		v := *s.MD5

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MD5", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.SmallImageIconUrl != nil {
		v := *s.SmallImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmallImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Apple Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSChannelRequest
type APNSChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Apple Distribution Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSChannelResponse
type APNSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application that the channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when this channel was created.
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// Indicates whether the channel is configured with a key for APNs token authentication.
	// Provide a token key by setting the TokenKey attribute.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the channel. Retained for backwards compatibility.
	Id *string `type:"string"`

	// Indicates whether or not the channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last updated this channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when this channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The platform type. For this channel, the value is always "ADM."
	Platform *string `type:"string"`

	// The channel version.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// APNS Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSMessage
type APNSMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action Action `type:"string" enum:"true"`

	// Include this key when you want the system to modify the badge of your app
	// icon. If this key is not included in the dictionary, the badge is not changed.
	// To remove the badge, set the value of this key to 0.
	Badge *int64 `type:"integer"`

	// The message body of the notification.
	Body *string `type:"string"`

	// Provide this key with a string value that represents the notification's type.
	// This value corresponds to the value in the identifier property of one of
	// your app's registered categories.
	Category *string `type:"string"`

	// An ID that, if assigned to multiple messages, causes APNs to coalesce the
	// messages into a single push notification instead of delivering each message
	// individually. The value must not exceed 64 bytes. Amazon Pinpoint uses this
	// value to set the apns-collapse-id request header when it sends the message
	// to APNs.
	CollapseId *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]string `type:"map"`

	// A URL that refers to the location of an image or video that you want to display
	// in the push notification.
	MediaUrl *string `type:"string"`

	// The preferred authentication method, either "CERTIFICATE" or "TOKEN"
	PreferredAuthenticationMethod *string `type:"string"`

	// The message priority. Amazon Pinpoint uses this value to set the apns-priority
	// request header when it sends the message to APNs. Accepts the following values:"5"
	// - Low priority. Messages might be delayed, delivered in groups, and throttled."10"
	// - High priority. Messages are sent immediately. High priority messages must
	// cause an alert, sound, or badge on the receiving device.The default value
	// is "10".The equivalent values for FCM or GCM messages are "normal" and "high".
	// Amazon Pinpoint accepts these values for APNs messages and converts them.For
	// more information about the apns-priority parameter, see Communicating with
	// APNs in the APNs Local and Remote Notification Programming Guide.
	Priority *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// Include this key when you want the system to play a sound. The value of this
	// key is the name of a sound file in your app's main bundle or in the Library/Sounds
	// folder of your app's data container. If the sound file cannot be found, or
	// if you specify defaultfor the value, the system plays the default alert sound.
	Sound *string `type:"string"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`

	// Provide this key with a string value that represents the app-specific identifier
	// for grouping notifications. If you provide a Notification Content app extension,
	// you can use this value to group your notifications together.
	ThreadId *string `type:"string"`

	// The length of time (in seconds) that APNs stores and attempts to deliver
	// the message. If the value is 0, APNs does not store the message or attempt
	// to deliver it more than once. Amazon Pinpoint uses this value to set the
	// apns-expiration request header when it sends the message to APNs.
	TimeToLive *int64 `type:"integer"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s APNSMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Badge != nil {
		v := *s.Badge

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Badge", protocol.Int64Value(v), metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Category != nil {
		v := *s.Category

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Category", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CollapseId != nil {
		v := *s.CollapseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CollapseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Data) > 0 {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.MediaUrl != nil {
		v := *s.MediaUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MediaUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PreferredAuthenticationMethod != nil {
		v := *s.PreferredAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PreferredAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.ThreadId != nil {
		v := *s.ThreadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThreadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Apple Development Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSSandboxChannelRequest
type APNSSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSSandboxChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Apple Development Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSSandboxChannelResponse
type APNSSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the channel applies.
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// Indicates whether the channel is configured with a key for APNs token authentication.
	// Provide a token key by setting the TokenKey attribute.
	HasTokenKey *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS_SANDBOX.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSSandboxChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Apple VoIP Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSVoipChannelRequest
type APNSVoipChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Apple VoIP Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSVoipChannelResponse
type APNSVoipChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// If the channel is registered with a token key for authentication.
	HasTokenKey *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Apple VoIP Developer Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSVoipSandboxChannelRequest
type APNSVoipSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipSandboxChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.PrivateKey != nil {
		v := *s.PrivateKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TeamId != nil {
		v := *s.TeamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TeamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKey != nil {
		v := *s.TokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TokenKeyId != nil {
		v := *s.TokenKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TokenKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Apple VoIP Developer Push Notification Service channel definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/APNSVoipSandboxChannelResponse
type APNSVoipSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// If the channel is registered with a token key for authentication.
	HasTokenKey *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s APNSVoipSandboxChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultAuthenticationMethod != nil {
		v := *s.DefaultAuthenticationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAuthenticationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.HasTokenKey != nil {
		v := *s.HasTokenKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasTokenKey", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Activities for campaign.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ActivitiesResponse
type ActivitiesResponse struct {
	_ struct{} `type:"structure"`

	// List of campaign activities
	Item []ActivityResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ActivitiesResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActivitiesResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Activity definition
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ActivityResponse
type ActivityResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the campaign applies.
	ApplicationId *string `type:"string"`

	// The ID of the campaign to which the activity applies.
	CampaignId *string `type:"string"`

	// The actual time the activity was marked CANCELLED or COMPLETED. Provided
	// in ISO 8601 format.
	End *string `type:"string"`

	// The unique activity ID.
	Id *string `type:"string"`

	// Indicates whether the activity succeeded.Valid values: SUCCESS, FAIL
	Result *string `type:"string"`

	// The scheduled start time for the activity in ISO 8601 format.
	ScheduledStart *string `type:"string"`

	// The actual start time of the activity in ISO 8601 format.
	Start *string `type:"string"`

	// The state of the activity.Valid values: PENDING, INITIALIZING, RUNNING, PAUSED,
	// CANCELLED, COMPLETED
	State *string `type:"string"`

	// The total number of endpoints to which the campaign successfully delivered
	// messages.
	SuccessfulEndpointCount *int64 `type:"integer"`

	// The total number of timezones completed.
	TimezonesCompletedCount *int64 `type:"integer"`

	// The total number of unique timezones present in the segment.
	TimezonesTotalCount *int64 `type:"integer"`

	// The total number of endpoints to which the campaign attempts to deliver messages.
	TotalEndpointCount *int64 `type:"integer"`

	// The ID of a variation of the campaign used for A/B testing.
	TreatmentId *string `type:"string"`
}

// String returns the string representation
func (s ActivityResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActivityResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CampaignId != nil {
		v := *s.CampaignId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CampaignId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "End", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Result != nil {
		v := *s.Result

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Result", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScheduledStart != nil {
		v := *s.ScheduledStart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScheduledStart", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SuccessfulEndpointCount != nil {
		v := *s.SuccessfulEndpointCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SuccessfulEndpointCount", protocol.Int64Value(v), metadata)
	}
	if s.TimezonesCompletedCount != nil {
		v := *s.TimezonesCompletedCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimezonesCompletedCount", protocol.Int64Value(v), metadata)
	}
	if s.TimezonesTotalCount != nil {
		v := *s.TimezonesTotalCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimezonesTotalCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalEndpointCount != nil {
		v := *s.TotalEndpointCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalEndpointCount", protocol.Int64Value(v), metadata)
	}
	if s.TreatmentId != nil {
		v := *s.TreatmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Address configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/AddressConfiguration
type AddressConfiguration struct {
	_ struct{} `type:"structure"`

	// Body override. If specified will override default body.
	BodyOverride *string `type:"string"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType ChannelType `type:"string" enum:"true"`

	// A map of custom attributes to attributes to be attached to the message for
	// this address. This payload is added to the push notification's 'data.pinpoint'
	// object or added to the email/sms delivery receipt event attributes.
	Context map[string]string `type:"map"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// A map of substitution values for the message to be merged with the DefaultMessage's
	// substitutions. Substitutions on this map take precedence over the all other
	// substitutions.
	Substitutions map[string][]string `type:"map"`

	// Title override. If specified will override default title if applicable.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s AddressConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddressConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BodyOverride != nil {
		v := *s.BodyOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BodyOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Context) > 0 {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TitleOverride != nil {
		v := *s.TitleOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TitleOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Application Response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ApplicationResponse
type ApplicationResponse struct {
	_ struct{} `type:"structure"`

	// The arn for the application.
	Arn *string `type:"string"`

	// The unique application ID.
	Id *string `type:"string"`

	// The display name of the application.
	Name *string `type:"string"`

	// The Tags for the application.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ApplicationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Application settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ApplicationSettingsResource
type ApplicationSettingsResource struct {
	_ struct{} `type:"structure"`

	// The unique ID for the application.
	ApplicationId *string `type:"string"`

	// Default campaign hook.
	CampaignHook *CampaignHook `type:"structure"`

	// The date that the settings were last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The default campaign limits for the app. These limits apply to each campaign
	// for the app, unless the campaign overrides the default with limits of its
	// own.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for the app. Campaigns in the app don't send messages
	// to endpoints during the quiet time.Note: Make sure that your endpoints include
	// the Demographics.Timezone attribute if you plan to enable a quiet time for
	// your app. If your endpoints don't include this attribute, they'll receive
	// the messages that you send them, even if quiet time is enabled.When you set
	// up an app to use quiet time, campaigns in that app don't send messages during
	// the time range you specified, as long as all of the following are true:-
	// The endpoint includes a valid Demographic.Timezone attribute.- The current
	// time in the endpoint's time zone is later than or equal to the time specified
	// in the QuietTime.Start attribute for the app (or campaign, if applicable).-
	// The current time in the endpoint's time zone is earlier than or equal to
	// the time specified in the QuietTime.End attribute for the app (or campaign,
	// if applicable).Individual campaigns within the app can have their own quiet
	// time settings, which override the quiet time settings at the app level.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s ApplicationSettingsResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationSettingsResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CampaignHook != nil {
		v := s.CampaignHook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CampaignHook", v, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	return nil
}

// Get Applications Result.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ApplicationsResponse
type ApplicationsResponse struct {
	_ struct{} `type:"structure"`

	// List of applications returned in this page.
	Item []ApplicationResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ApplicationsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApplicationsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Custom attibute dimension
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/AttributeDimension
type AttributeDimension struct {
	_ struct{} `type:"structure"`

	// The type of dimension:INCLUSIVE - Endpoints that match the criteria are included
	// in the segment.EXCLUSIVE - Endpoints that match the criteria are excluded
	// from the segment.
	AttributeType AttributeType `type:"string" enum:"true"`

	// The criteria values for the segment dimension. Endpoints with matching attribute
	// values are included or excluded from the segment, depending on the setting
	// for Type.
	Values []string `type:"list"`
}

// String returns the string representation
func (s AttributeDimension) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributeDimension) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AttributeType) > 0 {
		v := s.AttributeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttributeType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Values) > 0 {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Attributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/AttributesResource
type AttributesResource struct {
	_ struct{} `type:"structure"`

	// The unique ID for the application.
	ApplicationId *string `type:"string"`

	// The attribute type for the application.
	AttributeType *string `type:"string"`

	// The attributes for the application.
	Attributes []string `type:"list"`
}

// String returns the string representation
func (s AttributesResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AttributesResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AttributeType != nil {
		v := *s.AttributeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttributeType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Baidu Cloud Push credentials
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/BaiduChannelRequest
type BaiduChannelRequest struct {
	_ struct{} `type:"structure"`

	// Platform credential API key from Baidu.
	ApiKey *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Platform credential Secret key from Baidu.
	SecretKey *string `type:"string"`
}

// String returns the string representation
func (s BaiduChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BaiduChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKey != nil {
		v := *s.ApiKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApiKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.SecretKey != nil {
		v := *s.SecretKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SecretKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Baidu Cloud Messaging channel definition
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/BaiduChannelResponse
type BaiduChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The Baidu API key from Baidu.
	Credential *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be BAIDU
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s BaiduChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BaiduChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Credential != nil {
		v := *s.Credential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Credential", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Baidu Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/BaiduMessage
type BaiduMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action Action `type:"string" enum:"true"`

	// The message body of the notification.
	Body *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]string `type:"map"`

	// The icon image name of the asset saved in your application.
	IconReference *string `type:"string"`

	// The URL that points to an image used as the large icon to the notification
	// content view.
	ImageIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The URL that points to an image used as the small icon for the notification
	// which will be used to represent the notification in the status bar and content
	// view
	SmallImageIconUrl *string `type:"string"`

	// Indicates a sound to play when the device receives the notification. Supports
	// default, or the filename of a sound resource bundled in the app. Android
	// sound files must reside in /res/raw/
	Sound *string `type:"string"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`

	// This parameter specifies how long (in seconds) the message should be kept
	// in Baidu storage if the device is offline. The and the default value and
	// the maximum time to live supported is 7 days (604800 seconds)
	TimeToLive *int64 `type:"integer"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s BaiduMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BaiduMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Data) > 0 {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.IconReference != nil {
		v := *s.IconReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IconReference", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.SmallImageIconUrl != nil {
		v := *s.SmallImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmallImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The email message configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignEmailMessage
type CampaignEmailMessage struct {
	_ struct{} `type:"structure"`

	// The email text body.
	Body *string `type:"string"`

	// The email address used to send the email from. Defaults to use FromAddress
	// specified in the Email Channel.
	FromAddress *string `type:"string"`

	// The email html body.
	HtmlBody *string `type:"string"`

	// The email title (Or subject).
	Title *string `type:"string"`
}

// String returns the string representation
func (s CampaignEmailMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignEmailMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HtmlBody != nil {
		v := *s.HtmlBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HtmlBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that defines the events that cause the campaign to be sent.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignEventFilter
type CampaignEventFilter struct {
	_ struct{} `type:"structure"`

	// An object that defines the dimensions for the event filter.
	Dimensions *EventDimensions `type:"structure"`

	// The type of event that causes the campaign to be sent. Possible values:SYSTEM
	// - Send the campaign when a system event occurs. See the System resource for
	// more information.ENDPOINT - Send the campaign when an endpoint event occurs.
	// See the Event resource for more information.
	FilterType FilterType `type:"string" enum:"true"`
}

// String returns the string representation
func (s CampaignEventFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignEventFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	if len(s.FilterType) > 0 {
		v := s.FilterType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FilterType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Campaign hook information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignHook
type CampaignHook struct {
	_ struct{} `type:"structure"`

	// Lambda function name or arn to be called for delivery
	LambdaFunctionName *string `type:"string"`

	// What mode Lambda should be invoked in.
	Mode Mode `type:"string" enum:"true"`

	// Web URL to call for hook. If the URL has authentication specified it will
	// be added as authentication to the request
	WebUrl *string `type:"string"`
}

// String returns the string representation
func (s CampaignHook) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignHook) MarshalFields(e protocol.FieldEncoder) error {
	if s.LambdaFunctionName != nil {
		v := *s.LambdaFunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LambdaFunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.WebUrl != nil {
		v := *s.WebUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Campaign Limits are used to limit the number of messages that can be sent
// to a single endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignLimits
type CampaignLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that each campaign can send to a single endpoint
	// in a 24-hour period.
	Daily *int64 `type:"integer"`

	// The length of time (in seconds) that the campaign can run before it ends
	// and message deliveries stop. This duration begins at the scheduled start
	// time for the campaign. The minimum value is 60.
	MaximumDuration *int64 `type:"integer"`

	// The number of messages that the campaign can send per second. The minimum
	// value is 50, and the maximum is 20000.
	MessagesPerSecond *int64 `type:"integer"`

	// The maximum number of messages that an individual campaign can send to a
	// single endpoint over the course of the campaign.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignLimits) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignLimits) MarshalFields(e protocol.FieldEncoder) error {
	if s.Daily != nil {
		v := *s.Daily

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Daily", protocol.Int64Value(v), metadata)
	}
	if s.MaximumDuration != nil {
		v := *s.MaximumDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumDuration", protocol.Int64Value(v), metadata)
	}
	if s.MessagesPerSecond != nil {
		v := *s.MessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.Total != nil {
		v := *s.Total

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Total", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Campaign definition
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignResponse
type CampaignResponse struct {
	_ struct{} `type:"structure"`

	// Treatments that are defined in addition to the default treatment.
	AdditionalTreatments []TreatmentResource `type:"list"`

	// The ID of the application to which the campaign applies.
	ApplicationId *string `type:"string"`

	// The arn for the campaign.
	Arn *string `type:"string"`

	// The date the campaign was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The status of the campaign's default treatment. Only present for A/B test
	// campaigns.
	DefaultState *CampaignState `type:"structure"`

	// A description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of end users who will not receive messages from
	// this campaign.
	HoldoutPercent *int64 `type:"integer"`

	// Campaign hook information.
	Hook *CampaignHook `type:"structure"`

	// The unique campaign ID.
	Id *string `type:"string"`

	// Indicates whether the campaign is paused. A paused campaign does not send
	// messages unless you resume it by setting IsPaused to false.
	IsPaused *bool `type:"boolean"`

	// The date the campaign was last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The campaign limits settings.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The ID of the segment to which the campaign sends messages.
	SegmentId *string `type:"string"`

	// The version of the segment to which the campaign sends messages.
	SegmentVersion *int64 `type:"integer"`

	// The campaign status.An A/B test campaign will have a status of COMPLETED
	// only when all treatments have a status of COMPLETED.
	State *CampaignState `type:"structure"`

	// The Tags for the campaign.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`

	// The campaign version number.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdditionalTreatments) > 0 {
		v := s.AdditionalTreatments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AdditionalTreatments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DefaultState != nil {
		v := s.DefaultState

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultState", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HoldoutPercent != nil {
		v := *s.HoldoutPercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HoldoutPercent", protocol.Int64Value(v), metadata)
	}
	if s.Hook != nil {
		v := s.Hook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Hook", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsPaused != nil {
		v := *s.IsPaused

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPaused", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "State", v, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// SMS message configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignSmsMessage
type CampaignSmsMessage struct {
	_ struct{} `type:"structure"`

	// The SMS text body.
	Body *string `type:"string"`

	// Is this is a transactional SMS message, otherwise a promotional message.
	MessageType MessageType `type:"string" enum:"true"`

	// Sender ID of sent message.
	SenderId *string `type:"string"`
}

// String returns the string representation
func (s CampaignSmsMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignSmsMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.MessageType) > 0 {
		v := s.MessageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// State of the Campaign
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignState
type CampaignState struct {
	_ struct{} `type:"structure"`

	// The status of the campaign, or the status of a treatment that belongs to
	// an A/B test campaign.Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN,
	// COMPLETED, PAUSED
	CampaignStatus CampaignStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s CampaignState) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignState) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CampaignStatus) > 0 {
		v := s.CampaignStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CampaignStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// List of available campaigns.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CampaignsResponse
type CampaignsResponse struct {
	_ struct{} `type:"structure"`

	// A list of campaigns.
	Item []CampaignResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s CampaignsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CampaignsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Base definition for channel response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ChannelResponse
type ChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Get channels definition
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ChannelsResponse
type ChannelsResponse struct {
	_ struct{} `type:"structure"`

	// A map of channels, with the ChannelType as the key and the Channel as the
	// value.
	Channels map[string]ChannelResponse `type:"map"`
}

// String returns the string representation
func (s ChannelsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Channels) > 0 {
		v := s.Channels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Channels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Application Request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApplicationRequest
type CreateApplicationRequest struct {
	_ struct{} `type:"structure"`

	// The display name of the application. Used in the Amazon Pinpoint console.
	Name *string `type:"string"`

	// The Tags for the app.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateApplicationRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApplicationRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The default message to use across all channels.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DefaultMessage
type DefaultMessage struct {
	_ struct{} `type:"structure"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`
}

// String returns the string representation
func (s DefaultMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	return nil
}

// Default Push Notification Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DefaultPushNotificationMessage
type DefaultPushNotificationMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action Action `type:"string" enum:"true"`

	// The message body of the notification.
	Body *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]string `type:"map"`

	// Indicates if the message should display on the recipient's device. You can
	// use silent pushes for remote configuration or to deliver messages to in-app
	// notification centers.
	SilentPush *bool `type:"boolean"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DefaultPushNotificationMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultPushNotificationMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Data) > 0 {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Message definitions for the default message and any messages that are tailored
// for specific channels.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DirectMessageConfiguration
type DirectMessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message to ADM channels. Overrides the default push notification message.
	ADMMessage *ADMMessage `type:"structure"`

	// The message to APNS channels. Overrides the default push notification message.
	APNSMessage *APNSMessage `type:"structure"`

	// The message to Baidu GCM channels. Overrides the default push notification
	// message.
	BaiduMessage *BaiduMessage `type:"structure"`

	// The default message for all channels.
	DefaultMessage *DefaultMessage `type:"structure"`

	// The default push notification message for all push channels.
	DefaultPushNotificationMessage *DefaultPushNotificationMessage `type:"structure"`

	// The message to Email channels. Overrides the default message.
	EmailMessage *EmailMessage `type:"structure"`

	// The message to GCM channels. Overrides the default push notification message.
	GCMMessage *GCMMessage `type:"structure"`

	// The message to SMS channels. Overrides the default message.
	SMSMessage *SMSMessage `type:"structure"`

	// The message to Voice channels. Overrides the default message.
	VoiceMessage *VoiceMessage `type:"structure"`
}

// String returns the string representation
func (s DirectMessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DirectMessageConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADMMessage != nil {
		v := s.ADMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ADMMessage", v, metadata)
	}
	if s.APNSMessage != nil {
		v := s.APNSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "APNSMessage", v, metadata)
	}
	if s.BaiduMessage != nil {
		v := s.BaiduMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BaiduMessage", v, metadata)
	}
	if s.DefaultMessage != nil {
		v := s.DefaultMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultMessage", v, metadata)
	}
	if s.DefaultPushNotificationMessage != nil {
		v := s.DefaultPushNotificationMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultPushNotificationMessage", v, metadata)
	}
	if s.EmailMessage != nil {
		v := s.EmailMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EmailMessage", v, metadata)
	}
	if s.GCMMessage != nil {
		v := s.GCMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GCMMessage", v, metadata)
	}
	if s.SMSMessage != nil {
		v := s.SMSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SMSMessage", v, metadata)
	}
	if s.VoiceMessage != nil {
		v := s.VoiceMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceMessage", v, metadata)
	}
	return nil
}

// Email Channel Request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EmailChannelRequest
type EmailChannelRequest struct {
	_ struct{} `type:"structure"`

	// The configuration set that you want to use when you send email using the
	// Pinpoint Email API.
	ConfigurationSet *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The email address used to send emails from.
	FromAddress *string `type:"string"`

	// The ARN of an identity verified with SES.
	Identity *string `type:"string"`

	// The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion
	// service
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s EmailChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigurationSet != nil {
		v := *s.ConfigurationSet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationSet", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Identity != nil {
		v := *s.Identity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Identity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Email Channel Response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EmailChannelResponse
type EmailChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the email channel belongs.
	ApplicationId *string `type:"string"`

	// The configuration set that you want to use when you send email using the
	// Pinpoint Email API.
	ConfigurationSet *string `type:"string"`

	// The date that the settings were last updated in ISO 8601 format.
	CreationDate *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The email address used to send emails from.
	FromAddress *string `type:"string"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// The ARN of an identity verified with SES.
	Identity *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// Messages per second that can be sent
	MessagesPerSecond *int64 `type:"integer"`

	// Platform type. Will be "EMAIL"
	Platform *string `type:"string"`

	// The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion
	// service
	RoleArn *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s EmailChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationSet != nil {
		v := *s.ConfigurationSet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationSet", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Identity != nil {
		v := *s.Identity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Identity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessagesPerSecond != nil {
		v := *s.MessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Email Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EmailMessage
type EmailMessage struct {
	_ struct{} `type:"structure"`

	// The body of the email message.
	Body *string `type:"string"`

	// The email address that bounces and complaints will be forwarded to when feedback
	// forwarding is enabled.
	FeedbackForwardingAddress *string `type:"string"`

	// The email address used to send the email from. Defaults to use FromAddress
	// specified in the Email Channel.
	FromAddress *string `type:"string"`

	// An email represented as a raw MIME message.
	RawEmail *RawEmail `type:"structure"`

	// The reply-to email address(es) for the email. If the recipient replies to
	// the email, each reply-to address will receive the reply.
	ReplyToAddresses []string `type:"list"`

	// An email composed of a subject, a text part and a html part.
	SimpleEmail *SimpleEmail `type:"structure"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`
}

// String returns the string representation
func (s EmailMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FeedbackForwardingAddress != nil {
		v := *s.FeedbackForwardingAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FeedbackForwardingAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawEmail != nil {
		v := s.RawEmail

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RawEmail", v, metadata)
	}
	if len(s.ReplyToAddresses) > 0 {
		v := s.ReplyToAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ReplyToAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SimpleEmail != nil {
		v := s.SimpleEmail

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SimpleEmail", v, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	return nil
}

// Endpoint update request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointBatchItem
type EndpointBatchItem struct {
	_ struct{} `type:"structure"`

	// The destination for messages that you send to this endpoint. The address
	// varies by channel. For mobile push channels, use the token provided by the
	// push notification service, such as the APNs device token or the FCM registration
	// token. For the SMS channel, use a phone number in E.164 format, such as +12065550100.
	// For the email channel, use an email address.
	Address *string `type:"string"`

	// Custom attributes that describe the endpoint by associating a name with an
	// array of values. For example, an attribute named "interests" might have the
	// values ["science", "politics", "travel"]. You can use these attributes as
	// selection criteria when you create a segment of users to engage with a messaging
	// campaign.The following characters are not recommended in attribute names:
	// # : ? \ /. The Amazon Pinpoint console does not display attributes that include
	// these characters in the name. This limitation does not apply to attribute
	// values.
	Attributes map[string][]string `type:"map"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType ChannelType `type:"string" enum:"true"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The last time the endpoint was updated. Provided in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// Unused.
	EndpointStatus *string `type:"string"`

	// The unique Id for the Endpoint in the batch.
	Id *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint.
	Metrics map[string]float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL - User has opted out of all messages.NONE - Users
	// has not opted out and receives all messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointBatchItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointBatchItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if len(s.Metrics) > 0 {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Endpoint batch update request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointBatchRequest
type EndpointBatchRequest struct {
	_ struct{} `type:"structure"`

	// List of items to update. Maximum 100 items
	Item []EndpointBatchItem `type:"list"`
}

// String returns the string representation
func (s EndpointBatchRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointBatchRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Demographic information about the endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointDemographic
type EndpointDemographic struct {
	_ struct{} `type:"structure"`

	// The version of the application associated with the endpoint.
	AppVersion *string `type:"string"`

	// The endpoint locale in the following format: The ISO 639-1 alpha-2 code,
	// followed by an underscore, followed by an ISO 3166-1 alpha-2 value.
	Locale *string `type:"string"`

	// The manufacturer of the endpoint device, such as Apple or Samsung.
	Make *string `type:"string"`

	// The model name or number of the endpoint device, such as iPhone.
	Model *string `type:"string"`

	// The model version of the endpoint device.
	ModelVersion *string `type:"string"`

	// The platform of the endpoint device, such as iOS or Android.
	Platform *string `type:"string"`

	// The platform version of the endpoint device.
	PlatformVersion *string `type:"string"`

	// The timezone of the endpoint. Specified as a tz database value, such as Americas/Los_Angeles.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EndpointDemographic) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointDemographic) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppVersion != nil {
		v := *s.AppVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Locale != nil {
		v := *s.Locale

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Locale", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Make != nil {
		v := *s.Make

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Make", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Model != nil {
		v := *s.Model

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Model", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelVersion != nil {
		v := *s.ModelVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ModelVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PlatformVersion != nil {
		v := *s.PlatformVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PlatformVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timezone != nil {
		v := *s.Timezone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timezone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A complex object that holds the status code and message as a result of processing
// an endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointItemResponse
type EndpointItemResponse struct {
	_ struct{} `type:"structure"`

	// A custom message associated with the registration of an endpoint when issuing
	// a response.
	Message *string `type:"string"`

	// The status code associated with the merging of an endpoint when issuing a
	// response.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EndpointItemResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointItemResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Location data for the endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointLocation
type EndpointLocation struct {
	_ struct{} `type:"structure"`

	// The city where the endpoint is located.
	City *string `type:"string"`

	// The two-letter code for the country or region of the endpoint. Specified
	// as an ISO 3166-1 alpha-2 code, such as "US" for the United States.
	Country *string `type:"string"`

	// The latitude of the endpoint location, rounded to one decimal place.
	Latitude *float64 `type:"double"`

	// The longitude of the endpoint location, rounded to one decimal place.
	Longitude *float64 `type:"double"`

	// The postal code or zip code of the endpoint.
	PostalCode *string `type:"string"`

	// The region of the endpoint location. For example, in the United States, this
	// corresponds to a state.
	Region *string `type:"string"`
}

// String returns the string representation
func (s EndpointLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.City != nil {
		v := *s.City

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "City", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Country != nil {
		v := *s.Country

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Country", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Latitude != nil {
		v := *s.Latitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Latitude", protocol.Float64Value(v), metadata)
	}
	if s.Longitude != nil {
		v := *s.Longitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Longitude", protocol.Float64Value(v), metadata)
	}
	if s.PostalCode != nil {
		v := *s.PostalCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PostalCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result from sending a message to an endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointMessageResult
type EndpointMessageResult struct {
	_ struct{} `type:"structure"`

	// Address that endpoint message was delivered to.
	Address *string `type:"string"`

	// The delivery status of the message. Possible values:SUCCESS - The message
	// was successfully delivered to the endpoint.TRANSIENT_FAILURE - A temporary
	// error occurred. Amazon Pinpoint will attempt to deliver the message again
	// later.FAILURE_PERMANENT - An error occurred when delivering the message to
	// the endpoint. Amazon Pinpoint won't attempt to send the message again.TIMEOUT
	// - The message couldn't be sent within the timeout period.QUIET_TIME - The
	// local time for the endpoint was within the QuietTime for the campaign or
	// app.DAILY_CAP - The endpoint has received the maximum number of messages
	// it can receive within a 24-hour period.HOLDOUT - The endpoint was in a hold
	// out treatment for the campaign.THROTTLED - Amazon Pinpoint throttled sending
	// to this endpoint.EXPIRED - The endpoint address is expired.CAMPAIGN_CAP -
	// The endpoint received the maximum number of messages allowed by the campaign.SERVICE_FAILURE
	// - A service-level failure prevented Amazon Pinpoint from delivering the message.UNKNOWN
	// - An unknown error occurred.
	DeliveryStatus DeliveryStatus `type:"string" enum:"true"`

	// Unique message identifier associated with the message that was sent.
	MessageId *string `type:"string"`

	// Downstream service status code.
	StatusCode *int64 `type:"integer"`

	// Status message for message delivery.
	StatusMessage *string `type:"string"`

	// If token was updated as part of delivery. (This is GCM Specific)
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s EndpointMessageResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointMessageResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DeliveryStatus) > 0 {
		v := s.DeliveryStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeliveryStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedToken != nil {
		v := *s.UpdatedToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An endpoint update request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointRequest
type EndpointRequest struct {
	_ struct{} `type:"structure"`

	// The destination for messages that you send to this endpoint. The address
	// varies by channel. For mobile push channels, use the token provided by the
	// push notification service, such as the APNs device token or the FCM registration
	// token. For the SMS channel, use a phone number in E.164 format, such as +12065550100.
	// For the email channel, use an email address.
	Address *string `type:"string"`

	// Custom attributes that describe the endpoint by associating a name with an
	// array of values. For example, an attribute named "interests" might have the
	// values ["science", "politics", "travel"]. You can use these attributes as
	// selection criteria when you create a segment of users to engage with a messaging
	// campaign.The following characters are not recommended in attribute names:
	// # : ? \ /. The Amazon Pinpoint console does not display attributes that include
	// these characters in the name. This limitation does not apply to attribute
	// values.
	Attributes map[string][]string `type:"map"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType ChannelType `type:"string" enum:"true"`

	// Demographic attributes for the endpoint.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time when the endpoint was updated, shown in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// Unused.
	EndpointStatus *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint.
	Metrics map[string]float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL - User has opted out of all messages.NONE - Users
	// has not opted out and receives all messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if len(s.Metrics) > 0 {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Endpoint response
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointResponse
type EndpointResponse struct {
	_ struct{} `type:"structure"`

	// The address of the endpoint as provided by your push provider. For example,
	// the DeviceToken or RegistrationId.
	Address *string `type:"string"`

	// The ID of the application that is associated with the endpoint.
	ApplicationId *string `type:"string"`

	// Custom attributes that describe the endpoint by associating a name with an
	// array of values. For example, an attribute named "interests" might have the
	// following values: ["science", "politics", "travel"]. You can use these attributes
	// as selection criteria when you create segments.The Amazon Pinpoint console
	// can't display attribute names that include the following characters: hash/pound
	// sign (#), colon (:), question mark (?), backslash (\), and forward slash
	// (/). For this reason, you should avoid using these characters in the names
	// of custom attributes.
	Attributes map[string][]string `type:"map"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType ChannelType `type:"string" enum:"true"`

	// A number from 0-99 that represents the cohort the endpoint is assigned to.
	// Endpoints are grouped into cohorts randomly, and each cohort contains approximately
	// 1 percent of the endpoints for an app. Amazon Pinpoint assigns cohorts to
	// the holdout or treatment allocations for a campaign.
	CohortId *string `type:"string"`

	// The date and time when the endpoint was created, shown in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time when the endpoint was last updated, shown in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// Unused.
	EndpointStatus *string `type:"string"`

	// The unique ID that you assigned to the endpoint. The ID should be a globally
	// unique identifier (GUID) to ensure that it doesn't conflict with other endpoint
	// IDs associated with the application.
	Id *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint.
	Metrics map[string]float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL - User has opted out of all messages.NONE - Users
	// has not opted out and receives all messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CohortId != nil {
		v := *s.CohortId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CohortId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if len(s.Metrics) > 0 {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Endpoint send configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointSendConfiguration
type EndpointSendConfiguration struct {
	_ struct{} `type:"structure"`

	// Body override. If specified will override default body.
	BodyOverride *string `type:"string"`

	// A map of custom attributes to attributes to be attached to the message for
	// this address. This payload is added to the push notification's 'data.pinpoint'
	// object or added to the email/sms delivery receipt event attributes.
	Context map[string]string `type:"map"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// A map of substitution values for the message to be merged with the DefaultMessage's
	// substitutions. Substitutions on this map take precedence over the all other
	// substitutions.
	Substitutions map[string][]string `type:"map"`

	// Title override. If specified will override default title if applicable.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s EndpointSendConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointSendConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BodyOverride != nil {
		v := *s.BodyOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BodyOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Context) > 0 {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TitleOverride != nil {
		v := *s.TitleOverride

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TitleOverride", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Endpoint user specific custom userAttributes
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointUser
type EndpointUser struct {
	_ struct{} `type:"structure"`

	// Custom attributes that describe the user by associating a name with an array
	// of values. For example, an attribute named "interests" might have the following
	// values: ["science", "politics", "travel"]. You can use these attributes as
	// selection criteria when you create segments.The Amazon Pinpoint console can't
	// display attribute names that include the following characters: hash/pound
	// sign (#), colon (:), question mark (?), backslash (\), and forward slash
	// (/). For this reason, you should avoid using these characters in the names
	// of custom attributes.
	UserAttributes map[string][]string `type:"map"`

	// The unique ID of the user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s EndpointUser) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointUser) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.UserAttributes) > 0 {
		v := s.UserAttributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserAttributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// List of endpoints
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EndpointsResponse
type EndpointsResponse struct {
	_ struct{} `type:"structure"`

	// The list of endpoints.
	Item []EndpointResponse `type:"list"`
}

// String returns the string representation
func (s EndpointsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Model for creating or updating events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/Event
type Event struct {
	_ struct{} `type:"structure"`

	// The package name associated with the app that's recording the event.
	AppPackageName *string `type:"string"`

	// The title of the app that's recording the event.
	AppTitle *string `type:"string"`

	// The version number of the app that's recording the event.
	AppVersionCode *string `type:"string"`

	// Custom attributes that are associated with the event you're adding or updating.
	Attributes map[string]string `type:"map"`

	// The version of the SDK that's running on the client device.
	ClientSdkVersion *string `type:"string"`

	// The name of the custom event that you're recording.
	EventType *string `type:"string"`

	// Custom metrics related to the event.
	Metrics map[string]float64 `type:"map"`

	// The name of the SDK that's being used to record the event.
	SdkName *string `type:"string"`

	// Information about the session in which the event occurred.
	Session *Session `type:"structure"`

	// The date and time when the event occurred, in ISO 8601 format.
	Timestamp *string `type:"string"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Event) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppPackageName != nil {
		v := *s.AppPackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppPackageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppTitle != nil {
		v := *s.AppTitle

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppTitle", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppVersionCode != nil {
		v := *s.AppVersionCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AppVersionCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ClientSdkVersion != nil {
		v := *s.ClientSdkVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientSdkVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventType != nil {
		v := *s.EventType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Metrics) > 0 {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.SdkName != nil {
		v := *s.SdkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SdkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Session != nil {
		v := s.Session

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Session", v, metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Event dimensions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EventDimensions
type EventDimensions struct {
	_ struct{} `type:"structure"`

	// Custom attributes that your app reports to Amazon Pinpoint. You can use these
	// attributes as selection criteria when you create an event filter.
	Attributes map[string]AttributeDimension `type:"map"`

	// The name of the event that causes the campaign to be sent. This can be a
	// standard event type that Amazon Pinpoint generates, such as _session.start,
	// or a custom event that's specific to your app.
	EventType *SetDimension `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint. You can use these
	// attributes as selection criteria when you create an event filter.
	Metrics map[string]MetricDimension `type:"map"`
}

// String returns the string representation
func (s EventDimensions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventDimensions) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.EventType != nil {
		v := s.EventType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EventType", v, metadata)
	}
	if len(s.Metrics) > 0 {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// A complex object that holds the status code and message as a result of processing
// an event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EventItemResponse
type EventItemResponse struct {
	_ struct{} `type:"structure"`

	// A custom message that is associated with the processing of an event.
	Message *string `type:"string"`

	// The status returned in the response as a result of processing the event.Possible
	// values: 400 (for invalid events) and 202 (for events that were accepted).
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EventItemResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventItemResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Model for an event publishing subscription export.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EventStream
type EventStream struct {
	_ struct{} `type:"structure"`

	// The ID of the application from which events should be published.
	ApplicationId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery
	// stream to which you want to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME
	// Kinesis ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
	DestinationStreamArn *string `type:"string"`

	// (Deprecated) Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The date the event stream was last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The IAM user who last modified the event stream.
	LastUpdatedBy *string `type:"string"`

	// The IAM role that authorizes Amazon Pinpoint to publish events to the stream
	// in your account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s EventStream) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventStream) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationStreamArn != nil {
		v := *s.DestinationStreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationStreamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedBy != nil {
		v := *s.LastUpdatedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A batch of PublicEndpoints and Events to process.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EventsBatch
type EventsBatch struct {
	_ struct{} `type:"structure"`

	// The PublicEndpoint attached to the EndpointId from the request.
	Endpoint *PublicEndpoint `type:"structure"`

	// An object that contains a set of events associated with the endpoint.
	Events map[string]Event `type:"map"`
}

// String returns the string representation
func (s EventsBatch) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventsBatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.Endpoint != nil {
		v := s.Endpoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Endpoint", v, metadata)
	}
	if len(s.Events) > 0 {
		v := s.Events

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Events", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// A set of events to process.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EventsRequest
type EventsRequest struct {
	_ struct{} `type:"structure"`

	// A batch of events to process. Each BatchItem consists of an endpoint ID as
	// the key, and an EventsBatch object as the value.
	BatchItem map[string]EventsBatch `type:"map"`
}

// String returns the string representation
func (s EventsRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventsRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.BatchItem) > 0 {
		v := s.BatchItem

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "BatchItem", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Custom messages associated with events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/EventsResponse
type EventsResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a multipart response for each endpoint. Each item in
	// this object uses the endpoint ID as the key, and the item response as the
	// value.If no item response exists, the value can also be one of the following:
	// 202 (if the request was processed successfully) or 400 (if the payload was
	// invalid, or required fields were missing).
	Results map[string]ItemResponse `type:"map"`
}

// String returns the string representation
func (s EventsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Results) > 0 {
		v := s.Results

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Results", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Export job request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ExportJobRequest
type ExportJobRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that endpoints will be exported to.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that will receive
	// the export. The location is typically a folder with multiple files.The URL
	// should follow this format: s3://bucket-name/folder-name/Amazon Pinpoint will
	// export endpoints to this location.
	S3UrlPrefix *string `type:"string"`

	// The ID of the segment to export endpoints from. If not present, Amazon Pinpoint
	// exports all of the endpoints that belong to the application.
	SegmentId *string `type:"string"`

	// The version of the segment to export if specified.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3UrlPrefix != nil {
		v := *s.S3UrlPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3UrlPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Export job resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ExportJobResource
type ExportJobResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that endpoints will be exported to.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that will receive
	// the export. The location is typically a folder with multiple files.The URL
	// should follow this format: s3://bucket-name/folder-name/Amazon Pinpoint will
	// export endpoints to this location.
	S3UrlPrefix *string `type:"string"`

	// The ID of the segment to export endpoints from. If not present, Amazon Pinpoint
	// exports all of the endpoints that belong to the application.
	SegmentId *string `type:"string"`

	// The version of the segment to export if specified.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3UrlPrefix != nil {
		v := *s.S3UrlPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3UrlPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Export job response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ExportJobResponse
type ExportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application associated with the export job.
	ApplicationId *string `type:"string"`

	// The number of pieces that have successfully completed as of the time of the
	// request.
	CompletedPieces *int64 `type:"integer"`

	// The date the job completed in ISO 8601 format.
	CompletionDate *string `type:"string"`

	// The date the job was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The export job settings.
	Definition *ExportJobResource `type:"structure"`

	// The number of pieces that failed to be processed as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// Provides up to 100 of the first failed entries for the job, if any exist.
	Failures []string `type:"list"`

	// The unique ID of the job.
	Id *string `type:"string"`

	// The status of the job.Valid values: CREATED, INITIALIZING, PROCESSING, COMPLETING,
	// COMPLETED, FAILING, FAILEDThe job status is FAILED if one or more pieces
	// failed.
	JobStatus JobStatus `type:"string" enum:"true"`

	// The number of endpoints that were not processed; for example, because of
	// syntax errors.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to finish the job. Each
	// piece is an approximately equal portion of the endpoints.
	TotalPieces *int64 `type:"integer"`

	// The number of endpoints that were processed by the job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. Will be 'EXPORT'.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ExportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CompletedPieces != nil {
		v := *s.CompletedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletedPieces", protocol.Int64Value(v), metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Definition != nil {
		v := s.Definition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Definition", v, metadata)
	}
	if s.FailedPieces != nil {
		v := *s.FailedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailedPieces", protocol.Int64Value(v), metadata)
	}
	if len(s.Failures) > 0 {
		v := s.Failures

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Failures", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.JobStatus) > 0 {
		v := s.JobStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TotalFailures != nil {
		v := *s.TotalFailures

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalFailures", protocol.Int64Value(v), metadata)
	}
	if s.TotalPieces != nil {
		v := *s.TotalPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalPieces", protocol.Int64Value(v), metadata)
	}
	if s.TotalProcessed != nil {
		v := *s.TotalProcessed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalProcessed", protocol.Int64Value(v), metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Export job list.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ExportJobsResponse
type ExportJobsResponse struct {
	_ struct{} `type:"structure"`

	// A list of export jobs for the application.
	Item []ExportJobResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ExportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportJobsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Google Cloud Messaging credentials
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GCMChannelRequest
type GCMChannelRequest struct {
	_ struct{} `type:"structure"`

	// Platform credential API key from Google.
	ApiKey *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GCMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GCMChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKey != nil {
		v := *s.ApiKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApiKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Google Cloud Messaging channel definition
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GCMChannelResponse
type GCMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the channel applies.
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The GCM API key from Google.
	Credential *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used. Present only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be GCM
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s GCMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GCMChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Credential != nil {
		v := *s.Credential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Credential", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// GCM Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GCMMessage
type GCMMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action Action `type:"string" enum:"true"`

	// The message body of the notification.
	Body *string `type:"string"`

	// This parameter identifies a group of messages (e.g., with collapse_key: "Updates
	// Available") that can be collapsed, so that only the last message gets sent
	// when delivery can be resumed. This is intended to avoid sending too many
	// of the same messages when the device comes back online or becomes active.
	CollapseKey *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]string `type:"map"`

	// The icon image name of the asset saved in your application.
	IconReference *string `type:"string"`

	// The URL that points to an image used as the large icon to the notification
	// content view.
	ImageIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// The message priority. Amazon Pinpoint uses this value to set the FCM or GCM
	// priority parameter when it sends the message. Accepts the following values:"Normal"
	// - Messages might be delayed. Delivery is optimized for battery usage on the
	// receiving device. Use normal priority unless immediate delivery is required."High"
	// - Messages are sent immediately and might wake a sleeping device.The equivalent
	// values for APNs messages are "5" and "10". Amazon Pinpoint accepts these
	// values here and converts them.For more information, see About FCM Messages
	// in the Firebase documentation.
	Priority *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// This parameter specifies the package name of the application where the registration
	// tokens must match in order to receive the message.
	RestrictedPackageName *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The URL that points to an image used as the small icon for the notification
	// which will be used to represent the notification in the status bar and content
	// view
	SmallImageIconUrl *string `type:"string"`

	// Indicates a sound to play when the device receives the notification. Supports
	// default, or the filename of a sound resource bundled in the app. Android
	// sound files must reside in /res/raw/
	Sound *string `type:"string"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`

	// The length of time (in seconds) that FCM or GCM stores and attempts to deliver
	// the message. If unspecified, the value defaults to the maximum, which is
	// 2,419,200 seconds (28 days). Amazon Pinpoint uses this value to set the FCM
	// or GCM time_to_live parameter.
	TimeToLive *int64 `type:"integer"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s GCMMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GCMMessage) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CollapseKey != nil {
		v := *s.CollapseKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CollapseKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Data) > 0 {
		v := s.Data

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Data", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.IconReference != nil {
		v := *s.IconReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IconReference", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestrictedPackageName != nil {
		v := *s.RestrictedPackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestrictedPackageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.SmallImageIconUrl != nil {
		v := *s.SmallImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SmallImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sound != nil {
		v := *s.Sound

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Sound", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// GPS coordinates
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GPSCoordinates
type GPSCoordinates struct {
	_ struct{} `type:"structure"`

	// Latitude
	Latitude *float64 `type:"double"`

	// Longitude
	Longitude *float64 `type:"double"`
}

// String returns the string representation
func (s GPSCoordinates) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GPSCoordinates) MarshalFields(e protocol.FieldEncoder) error {
	if s.Latitude != nil {
		v := *s.Latitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Latitude", protocol.Float64Value(v), metadata)
	}
	if s.Longitude != nil {
		v := *s.Longitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Longitude", protocol.Float64Value(v), metadata)
	}
	return nil
}

// GPS point location dimension
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GPSPointDimension
type GPSPointDimension struct {
	_ struct{} `type:"structure"`

	// Coordinate to measure distance from.
	Coordinates *GPSCoordinates `type:"structure"`

	// Range in kilometers from the coordinate.
	RangeInKilometers *float64 `type:"double"`
}

// String returns the string representation
func (s GPSPointDimension) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GPSPointDimension) MarshalFields(e protocol.FieldEncoder) error {
	if s.Coordinates != nil {
		v := s.Coordinates

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Coordinates", v, metadata)
	}
	if s.RangeInKilometers != nil {
		v := *s.RangeInKilometers

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RangeInKilometers", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Import job request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ImportJobRequest
type ImportJobRequest struct {
	_ struct{} `type:"structure"`

	// Sets whether the endpoints create a segment when they are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions.Valid values:
	// CSV, JSON
	Format Format `type:"string" enum:"true"`

	// Sets whether the endpoints are registered with Amazon Pinpoint when they
	// are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that contains the endpoints to import.
	RoleArn *string `type:"string"`

	// The URL of the S3 bucket that contains the segment information to import.
	// The location can be a folder or a single file. The URL should use the following
	// format: s3://bucket-name/folder-name/file-nameAmazon Pinpoint imports endpoints
	// from this location and any subfolders it contains.
	S3Url *string `type:"string"`

	// The ID of the segment to update if the import job is meant to update an existing
	// segment.
	SegmentId *string `type:"string"`

	// A custom name for the segment created by the import job. Use if DefineSegment
	// is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefineSegment != nil {
		v := *s.DefineSegment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefineSegment", protocol.BoolValue(v), metadata)
	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RegisterEndpoints != nil {
		v := *s.RegisterEndpoints

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegisterEndpoints", protocol.BoolValue(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Url != nil {
		v := *s.S3Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentName != nil {
		v := *s.SegmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Import job resource
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ImportJobResource
type ImportJobResource struct {
	_ struct{} `type:"structure"`

	// Sets whether the endpoints create a segment when they are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions.Valid values:
	// CSV, JSON
	Format Format `type:"string" enum:"true"`

	// Sets whether the endpoints are registered with Amazon Pinpoint when they
	// are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that contains the endpoints to import.
	RoleArn *string `type:"string"`

	// The URL of the S3 bucket that contains the segment information to import.
	// The location can be a folder or a single file. The URL should use the following
	// format: s3://bucket-name/folder-name/file-nameAmazon Pinpoint imports endpoints
	// from this location and any subfolders it contains.
	S3Url *string `type:"string"`

	// The ID of the segment to update if the import job is meant to update an existing
	// segment.
	SegmentId *string `type:"string"`

	// A custom name for the segment created by the import job. Use if DefineSegment
	// is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefineSegment != nil {
		v := *s.DefineSegment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefineSegment", protocol.BoolValue(v), metadata)
	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RegisterEndpoints != nil {
		v := *s.RegisterEndpoints

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegisterEndpoints", protocol.BoolValue(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Url != nil {
		v := *s.S3Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentName != nil {
		v := *s.SegmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Import job response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ImportJobResponse
type ImportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the import job applies.
	ApplicationId *string `type:"string"`

	// The number of pieces that have successfully imported as of the time of the
	// request.
	CompletedPieces *int64 `type:"integer"`

	// The date the import job completed in ISO 8601 format.
	CompletionDate *string `type:"string"`

	// The date the import job was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The import job settings.
	Definition *ImportJobResource `type:"structure"`

	// The number of pieces that have failed to import as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// Provides up to 100 of the first failed entries for the job, if any exist.
	Failures []string `type:"list"`

	// The unique ID of the import job.
	Id *string `type:"string"`

	// The status of the import job.Valid values: CREATED, INITIALIZING, PROCESSING,
	// COMPLETING, COMPLETED, FAILING, FAILEDThe job status is FAILED if one or
	// more pieces failed to import.
	JobStatus JobStatus `type:"string" enum:"true"`

	// The number of endpoints that failed to import; for example, because of syntax
	// errors.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be imported to finish the job. Each
	// piece is an approximately equal portion of the endpoints to import.
	TotalPieces *int64 `type:"integer"`

	// The number of endpoints that were processed by the import job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. Will be Import.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CompletedPieces != nil {
		v := *s.CompletedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletedPieces", protocol.Int64Value(v), metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Definition != nil {
		v := s.Definition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Definition", v, metadata)
	}
	if s.FailedPieces != nil {
		v := *s.FailedPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailedPieces", protocol.Int64Value(v), metadata)
	}
	if len(s.Failures) > 0 {
		v := s.Failures

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Failures", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.JobStatus) > 0 {
		v := s.JobStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JobStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TotalFailures != nil {
		v := *s.TotalFailures

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalFailures", protocol.Int64Value(v), metadata)
	}
	if s.TotalPieces != nil {
		v := *s.TotalPieces

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalPieces", protocol.Int64Value(v), metadata)
	}
	if s.TotalProcessed != nil {
		v := *s.TotalProcessed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalProcessed", protocol.Int64Value(v), metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Import job list.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ImportJobsResponse
type ImportJobsResponse struct {
	_ struct{} `type:"structure"`

	// A list of import jobs for the application.
	Item []ImportJobResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ImportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportJobsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The response that's provided after registering the endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ItemResponse
type ItemResponse struct {
	_ struct{} `type:"structure"`

	// The response received after the endpoint was accepted.
	EndpointItemResponse *EndpointItemResponse `type:"structure"`

	// A multipart response object that contains a key and value for each event
	// ID in the request. In each object, the event ID is the key, and an EventItemResponse
	// object is the value.
	EventsItemResponse map[string]EventItemResponse `type:"map"`
}

// String returns the string representation
func (s ItemResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ItemResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndpointItemResponse != nil {
		v := s.EndpointItemResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EndpointItemResponse", v, metadata)
	}
	if len(s.EventsItemResponse) > 0 {
		v := s.EventsItemResponse

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "EventsItemResponse", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Message to send
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/Message
type Message struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign:OPEN_APP - Your app launches, or it becomes the foreground app
	// if it has been sent to the background. This is the default action.DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app.URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	Action Action `type:"string" enum:"true"`

	// The message body. Can include up to 140 characters.
	Body *string `type:"string"`

	// The URL that points to the icon image for the push notification icon, for
	// example, the app icon.
	ImageIconUrl *string `type:"string"`

	// The URL that points to the small icon image for the push notification icon,
	// for example, the app icon.
	ImageSmallIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// The JSON payload used for a silent push.
	JsonBody *string `type:"string"`

	// A URL that refers to the location of an image or video that you want to display
	// in the push notification.
	MediaUrl *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device.Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// This parameter specifies how long (in seconds) the message should be kept
	// if the service is unable to deliver the notification the first time. If the
	// value is 0, it treats the notification as if it expires immediately and does
	// not store the notification or attempt to redeliver it. This value is converted
	// to the expiration field when sent to the service. It only applies to APNs
	// and GCM
	TimeToLive *int64 `type:"integer"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Message) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageIconUrl != nil {
		v := *s.ImageIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageSmallIconUrl != nil {
		v := *s.ImageSmallIconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageSmallIconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JsonBody != nil {
		v := *s.JsonBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JsonBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MediaUrl != nil {
		v := *s.MediaUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MediaUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RawContent != nil {
		v := *s.RawContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RawContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SilentPush != nil {
		v := *s.SilentPush

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SilentPush", protocol.BoolValue(v), metadata)
	}
	if s.TimeToLive != nil {
		v := *s.TimeToLive

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TimeToLive", protocol.Int64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Simple message object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/MessageBody
type MessageBody struct {
	_ struct{} `type:"structure"`

	// The error message that's returned from the API.
	Message *string `type:"string"`

	// The unique message body ID.
	RequestID *string `type:"string"`
}

// String returns the string representation
func (s MessageBody) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageBody) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestID != nil {
		v := *s.RequestID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Message configuration for a campaign.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/MessageConfiguration
type MessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message that the campaign delivers to ADM channels. Overrides the default
	// message.
	ADMMessage *Message `type:"structure"`

	// The message that the campaign delivers to APNS channels. Overrides the default
	// message.
	APNSMessage *Message `type:"structure"`

	// The message that the campaign delivers to Baidu channels. Overrides the default
	// message.
	BaiduMessage *Message `type:"structure"`

	// The default message for all channels.
	DefaultMessage *Message `type:"structure"`

	// The email message configuration.
	EmailMessage *CampaignEmailMessage `type:"structure"`

	// The message that the campaign delivers to GCM channels. Overrides the default
	// message.
	GCMMessage *Message `type:"structure"`

	// The SMS message configuration.
	SMSMessage *CampaignSmsMessage `type:"structure"`
}

// String returns the string representation
func (s MessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADMMessage != nil {
		v := s.ADMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ADMMessage", v, metadata)
	}
	if s.APNSMessage != nil {
		v := s.APNSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "APNSMessage", v, metadata)
	}
	if s.BaiduMessage != nil {
		v := s.BaiduMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BaiduMessage", v, metadata)
	}
	if s.DefaultMessage != nil {
		v := s.DefaultMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultMessage", v, metadata)
	}
	if s.EmailMessage != nil {
		v := s.EmailMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EmailMessage", v, metadata)
	}
	if s.GCMMessage != nil {
		v := s.GCMMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GCMMessage", v, metadata)
	}
	if s.SMSMessage != nil {
		v := s.SMSMessage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SMSMessage", v, metadata)
	}
	return nil
}

// Send message request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/MessageRequest
type MessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of key-value pairs, where each key is an address and each value is
	// an AddressConfiguration object. An address can be a push notification token,
	// a phone number, or an email address.
	Addresses map[string]AddressConfiguration `type:"map"`

	// A map of custom attributes to attributes to be attached to the message. This
	// payload is added to the push notification's 'data.pinpoint' object or added
	// to the email/sms delivery receipt event attributes.
	Context map[string]string `type:"map"`

	// A map of key-value pairs, where each key is an endpoint ID and each value
	// is an EndpointSendConfiguration object. Within an EndpointSendConfiguration
	// object, you can tailor the message for an endpoint by specifying message
	// overrides or substitutions.
	Endpoints map[string]EndpointSendConfiguration `type:"map"`

	// Message configuration.
	MessageConfiguration *DirectMessageConfiguration `type:"structure"`

	// A unique ID that you can use to trace a message. This ID is visible to recipients.
	TraceId *string `type:"string"`
}

// String returns the string representation
func (s MessageRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Addresses) > 0 {
		v := s.Addresses

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Addresses", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if len(s.Context) > 0 {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Endpoints) > 0 {
		v := s.Endpoints

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Endpoints", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.TraceId != nil {
		v := *s.TraceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TraceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Send message response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/MessageResponse
type MessageResponse struct {
	_ struct{} `type:"structure"`

	// Application id of the message.
	ApplicationId *string `type:"string"`

	// A map containing a multi part response for each address, with the endpointId
	// as the key and the result as the value.
	EndpointResult map[string]EndpointMessageResult `type:"map"`

	// Original request Id for which this message was delivered.
	RequestId *string `type:"string"`

	// A map containing a multi part response for each address, with the address
	// as the key(Email address, phone number or push token) and the result as the
	// value.
	Result map[string]MessageResult `type:"map"`
}

// String returns the string representation
func (s MessageResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EndpointResult) > 0 {
		v := s.EndpointResult

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "EndpointResult", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Result) > 0 {
		v := s.Result

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Result", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// The result from sending a message to an address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/MessageResult
type MessageResult struct {
	_ struct{} `type:"structure"`

	// The delivery status of the message. Possible values:SUCCESS - The message
	// was successfully delivered to the endpoint.TRANSIENT_FAILURE - A temporary
	// error occurred. Amazon Pinpoint will attempt to deliver the message again
	// later.FAILURE_PERMANENT - An error occurred when delivering the message to
	// the endpoint. Amazon Pinpoint won't attempt to send the message again.TIMEOUT
	// - The message couldn't be sent within the timeout period.QUIET_TIME - The
	// local time for the endpoint was within the QuietTime for the campaign or
	// app.DAILY_CAP - The endpoint has received the maximum number of messages
	// it can receive within a 24-hour period.HOLDOUT - The endpoint was in a hold
	// out treatment for the campaign.THROTTLED - Amazon Pinpoint throttled sending
	// to this endpoint.EXPIRED - The endpoint address is expired.CAMPAIGN_CAP -
	// The endpoint received the maximum number of messages allowed by the campaign.SERVICE_FAILURE
	// - A service-level failure prevented Amazon Pinpoint from delivering the message.UNKNOWN
	// - An unknown error occurred.
	DeliveryStatus DeliveryStatus `type:"string" enum:"true"`

	// Unique message identifier associated with the message that was sent.
	MessageId *string `type:"string"`

	// Downstream service status code.
	StatusCode *int64 `type:"integer"`

	// Status message for message delivery.
	StatusMessage *string `type:"string"`

	// If token was updated as part of delivery. (This is GCM Specific)
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s MessageResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageResult) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DeliveryStatus) > 0 {
		v := s.DeliveryStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeliveryStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusCode", protocol.Int64Value(v), metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedToken != nil {
		v := *s.UpdatedToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Custom metric dimension
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/MetricDimension
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The operator that you're using to compare metric values. Possible values:
	// GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, or EQUAL
	ComparisonOperator *string `type:"string"`

	// The value to be compared.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricDimension) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComparisonOperator != nil {
		v := *s.ComparisonOperator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ComparisonOperator", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Phone Number Validate request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/NumberValidateRequest
type NumberValidateRequest struct {
	_ struct{} `type:"structure"`

	// (Optional) The two-character ISO country code for the country or region where
	// the phone number was originally registered.
	IsoCountryCode *string `type:"string"`

	// The phone number to get information about. The phone number that you provide
	// should include a country code. If the number doesn't include a valid country
	// code, the operation might result in an error.
	PhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NumberValidateRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsoCountryCode != nil {
		v := *s.IsoCountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsoCountryCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumber != nil {
		v := *s.PhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Phone Number Validate response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/NumberValidateResponse
type NumberValidateResponse struct {
	_ struct{} `type:"structure"`

	// The carrier or servive provider that the phone number is currently registered
	// with.
	Carrier *string `type:"string"`

	// The city where the phone number was originally registered.
	City *string `type:"string"`

	// The cleansed phone number, shown in E.164 format.
	CleansedPhoneNumberE164 *string `type:"string"`

	// The cleansed phone number, shown in the local phone number format.
	CleansedPhoneNumberNational *string `type:"string"`

	// The country or region where the phone number was originally registered.
	Country *string `type:"string"`

	// The two-character ISO code for the country or region where the phone number
	// was originally registered.
	CountryCodeIso2 *string `type:"string"`

	// The numeric code for the country or region where the phone number was originally
	// registered.
	CountryCodeNumeric *string `type:"string"`

	// The county where the phone number was originally registered.
	County *string `type:"string"`

	// The two-character code (in ISO 3166-1 alpha-2 format) for the country or
	// region in the request body.
	OriginalCountryCodeIso2 *string `type:"string"`

	// The phone number that you included in the request body.
	OriginalPhoneNumber *string `type:"string"`

	// A description of the phone type. Possible values are MOBILE, LANDLINE, VOIP,
	// INVALID, PREPAID, and OTHER.
	PhoneType *string `type:"string"`

	// The phone type, represented by an integer. Possible values include 0 (MOBILE),
	// 1 (LANDLINE), 2 (VOIP), 3 (INVALID), 4 (OTHER), and 5 (PREPAID).
	PhoneTypeCode *int64 `type:"integer"`

	// The time zone for the location where the phone number was originally registered.
	Timezone *string `type:"string"`

	// The postal code for the location where the phone number was originally registered.
	ZipCode *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NumberValidateResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Carrier != nil {
		v := *s.Carrier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Carrier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.City != nil {
		v := *s.City

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "City", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CleansedPhoneNumberE164 != nil {
		v := *s.CleansedPhoneNumberE164

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CleansedPhoneNumberE164", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CleansedPhoneNumberNational != nil {
		v := *s.CleansedPhoneNumberNational

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CleansedPhoneNumberNational", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Country != nil {
		v := *s.Country

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Country", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CountryCodeIso2 != nil {
		v := *s.CountryCodeIso2

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryCodeIso2", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CountryCodeNumeric != nil {
		v := *s.CountryCodeNumeric

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryCodeNumeric", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.County != nil {
		v := *s.County

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "County", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginalCountryCodeIso2 != nil {
		v := *s.OriginalCountryCodeIso2

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginalCountryCodeIso2", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginalPhoneNumber != nil {
		v := *s.OriginalPhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginalPhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneType != nil {
		v := *s.PhoneType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneTypeCode != nil {
		v := *s.PhoneTypeCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneTypeCode", protocol.Int64Value(v), metadata)
	}
	if s.Timezone != nil {
		v := *s.Timezone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timezone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipCode != nil {
		v := *s.ZipCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Public endpoint attributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PublicEndpoint
type PublicEndpoint struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the recipient. For example, an address could be
	// a device token, email address, or mobile phone number.
	Address *string `type:"string"`

	// Custom attributes that your app reports to Amazon Pinpoint. You can use these
	// attributes as selection criteria when you create a segment.
	Attributes map[string][]string `type:"map"`

	// The channel type.Valid values: APNS, GCM
	ChannelType ChannelType `type:"string" enum:"true"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time when the endpoint was last updated, in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// The status of the endpoint. If the update fails, the value is INACTIVE. If
	// the endpoint is updated successfully, the value is ACTIVE.
	EndpointStatus *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint.
	Metrics map[string]float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL - User has opted out of all messages.NONE - Users
	// has not opted out and receives all messages.
	OptOut *string `type:"string"`

	// A unique identifier that is generated each time the endpoint is updated.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s PublicEndpoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.ChannelType) > 0 {
		v := s.ChannelType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.EffectiveDate != nil {
		v := *s.EffectiveDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EffectiveDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointStatus != nil {
		v := *s.EndpointStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndpointStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if len(s.Metrics) > 0 {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	if s.OptOut != nil {
		v := *s.OptOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OptOut", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

// Quiet Time
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/QuietTime
type QuietTime struct {
	_ struct{} `type:"structure"`

	// The time at which quiet time should end. The value that you specify has to
	// be in HH:mm format, where HH is the hour in 24-hour format (with a leading
	// zero, if applicable), and mm is the minutes. For example, use 02:30 to represent
	// 2:30 AM, or 14:30 to represent 2:30 PM.
	End *string `type:"string"`

	// The time at which quiet time should begin. The value that you specify has
	// to be in HH:mm format, where HH is the hour in 24-hour format (with a leading
	// zero, if applicable), and mm is the minutes. For example, use 02:30 to represent
	// 2:30 AM, or 14:30 to represent 2:30 PM.
	Start *string `type:"string"`
}

// String returns the string representation
func (s QuietTime) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QuietTime) MarshalFields(e protocol.FieldEncoder) error {
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "End", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An email represented as a raw MIME message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RawEmail
type RawEmail struct {
	_ struct{} `type:"structure"`

	// The raw email message itself. Then entire message must be base64-encoded.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	Data []byte `type:"blob"`
}

// String returns the string representation
func (s RawEmail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RawEmail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Data", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// Define how a segment based on recency of use.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RecencyDimension
type RecencyDimension struct {
	_ struct{} `type:"structure"`

	// The length of time during which users have been active or inactive with your
	// app.Valid values: HR_24, DAY_7, DAY_14, DAY_30
	Duration Duration `type:"string" enum:"true"`

	// The recency dimension type:ACTIVE - Users who have used your app within the
	// specified duration are included in the segment.INACTIVE - Users who have
	// not used your app within the specified duration are included in the segment.
	RecencyType RecencyType `type:"string" enum:"true"`
}

// String returns the string representation
func (s RecencyDimension) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecencyDimension) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Duration) > 0 {
		v := s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.RecencyType) > 0 {
		v := s.RecencyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecencyType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// SMS Channel Request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SMSChannelRequest
type SMSChannelRequest struct {
	_ struct{} `type:"structure"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Sender identifier of your messages.
	SenderId *string `type:"string"`

	// ShortCode registered with phone provider.
	ShortCode *string `type:"string"`
}

// String returns the string representation
func (s SMSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ShortCode != nil {
		v := *s.ShortCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ShortCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// SMS Channel Response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SMSChannelResponse
type SMSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the SMS channel belongs.
	ApplicationId *string `type:"string"`

	// The date that the settings were last updated in ISO 8601 format.
	CreationDate *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Not used. Retained for backwards compatibility.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// Platform type. Will be "SMS"
	Platform *string `type:"string"`

	// Promotional messages per second that can be sent
	PromotionalMessagesPerSecond *int64 `type:"integer"`

	// Sender identifier of your messages.
	SenderId *string `type:"string"`

	// The short code registered with the phone provider.
	ShortCode *string `type:"string"`

	// Transactional messages per second that can be sent
	TransactionalMessagesPerSecond *int64 `type:"integer"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SMSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PromotionalMessagesPerSecond != nil {
		v := *s.PromotionalMessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PromotionalMessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ShortCode != nil {
		v := *s.ShortCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ShortCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TransactionalMessagesPerSecond != nil {
		v := *s.TransactionalMessagesPerSecond

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TransactionalMessagesPerSecond", protocol.Int64Value(v), metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// SMS Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SMSMessage
type SMSMessage struct {
	_ struct{} `type:"structure"`

	// The body of the SMS message.
	Body *string `type:"string"`

	// The SMS program name that you provided to AWS Support when you requested
	// your dedicated number.
	Keyword *string `type:"string"`

	// Is this a transaction priority message or lower priority.
	MessageType MessageType `type:"string" enum:"true"`

	// The phone number that the SMS message originates from. Specify one of the
	// dedicated long codes or short codes that you requested from AWS Support and
	// that is assigned to your account. If this attribute is not specified, Amazon
	// Pinpoint randomly assigns a long code.
	OriginationNumber *string `type:"string"`

	// The sender ID that is shown as the message sender on the recipient's device.
	// Support for sender IDs varies by country or region.
	SenderId *string `type:"string"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`
}

// String returns the string representation
func (s SMSMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SMSMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Keyword != nil {
		v := *s.Keyword

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Keyword", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.MessageType) > 0 {
		v := s.MessageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OriginationNumber != nil {
		v := *s.OriginationNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginationNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SenderId != nil {
		v := *s.SenderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SenderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	return nil
}

// Shcedule that defines when a campaign is run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/Schedule
type Schedule struct {
	_ struct{} `type:"structure"`

	// The scheduled time that the campaign ends in ISO 8601 format.
	EndTime *string `type:"string"`

	// Defines the type of events that can trigger the campaign. Used when the Frequency
	// is set to EVENT.
	EventFilter *CampaignEventFilter `type:"structure"`

	// How often the campaign delivers messages.Valid values:ONCEHOURLYDAILYWEEKLYMONTHLYEVENT
	Frequency Frequency `type:"string" enum:"true"`

	// Indicates whether the campaign schedule takes effect according to each user's
	// local time.
	IsLocalTime *bool `type:"boolean"`

	// The default quiet time for the campaign. The campaign doesn't send messages
	// to endpoints during the quiet time.Note: Make sure that your endpoints include
	// the Demographics.Timezone attribute if you plan to enable a quiet time for
	// your campaign. If your endpoints don't include this attribute, they'll receive
	// the messages that you send them, even if quiet time is enabled.When you set
	// up a campaign to use quiet time, the campaign doesn't send messages during
	// the time range you specified, as long as all of the following are true:-
	// The endpoint includes a valid Demographic.Timezone attribute.- The current
	// time in the endpoint's time zone is later than or equal to the time specified
	// in the QuietTime.Start attribute for the campaign.- The current time in the
	// endpoint's time zone is earlier than or equal to the time specified in the
	// QuietTime.End attribute for the campaign.
	QuietTime *QuietTime `type:"structure"`

	// The scheduled time that the campaign begins in ISO 8601 format.
	StartTime *string `type:"string"`

	// The starting UTC offset for the schedule if the value for isLocalTime is
	// trueValid values: UTCUTC+01UTC+02UTC+03UTC+03:30UTC+04UTC+04:30UTC+05UTC+05:30UTC+05:45UTC+06UTC+06:30UTC+07UTC+08UTC+09UTC+09:30UTC+10UTC+10:30UTC+11UTC+12UTC+13UTC-02UTC-03UTC-04UTC-05UTC-06UTC-07UTC-08UTC-09UTC-10UTC-11
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Schedule) MarshalFields(e protocol.FieldEncoder) error {
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventFilter != nil {
		v := s.EventFilter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EventFilter", v, metadata)
	}
	if len(s.Frequency) > 0 {
		v := s.Frequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Frequency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IsLocalTime != nil {
		v := *s.IsLocalTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLocalTime", protocol.BoolValue(v), metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timezone != nil {
		v := *s.Timezone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timezone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Segment behavior dimensions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentBehaviors
type SegmentBehaviors struct {
	_ struct{} `type:"structure"`

	// The recency of use.
	Recency *RecencyDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentBehaviors) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentBehaviors) MarshalFields(e protocol.FieldEncoder) error {
	if s.Recency != nil {
		v := s.Recency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Recency", v, metadata)
	}
	return nil
}

// Segment demographic dimensions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentDemographics
type SegmentDemographics struct {
	_ struct{} `type:"structure"`

	// The app version criteria for the segment.
	AppVersion *SetDimension `type:"structure"`

	// The channel criteria for the segment.
	Channel *SetDimension `type:"structure"`

	// The device type criteria for the segment.
	DeviceType *SetDimension `type:"structure"`

	// The device make criteria for the segment.
	Make *SetDimension `type:"structure"`

	// The device model criteria for the segment.
	Model *SetDimension `type:"structure"`

	// The device platform criteria for the segment.
	Platform *SetDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentDemographics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentDemographics) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppVersion != nil {
		v := s.AppVersion

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AppVersion", v, metadata)
	}
	if s.Channel != nil {
		v := s.Channel

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Channel", v, metadata)
	}
	if s.DeviceType != nil {
		v := s.DeviceType

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeviceType", v, metadata)
	}
	if s.Make != nil {
		v := s.Make

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Make", v, metadata)
	}
	if s.Model != nil {
		v := s.Model

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Model", v, metadata)
	}
	if s.Platform != nil {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Platform", v, metadata)
	}
	return nil
}

// Segment dimensions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentDimensions
type SegmentDimensions struct {
	_ struct{} `type:"structure"`

	// Custom segment attributes.
	Attributes map[string]AttributeDimension `type:"map"`

	// The segment behaviors attributes.
	Behavior *SegmentBehaviors `type:"structure"`

	// The segment demographics attributes.
	Demographic *SegmentDemographics `type:"structure"`

	// The segment location attributes.
	Location *SegmentLocation `type:"structure"`

	// Custom segment metrics.
	Metrics map[string]MetricDimension `type:"map"`

	// Custom segment user attributes.
	UserAttributes map[string]AttributeDimension `type:"map"`
}

// String returns the string representation
func (s SegmentDimensions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentDimensions) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.Behavior != nil {
		v := s.Behavior

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Behavior", v, metadata)
	}
	if s.Demographic != nil {
		v := s.Demographic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Demographic", v, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if len(s.Metrics) > 0 {
		v := s.Metrics

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metrics", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if len(s.UserAttributes) > 0 {
		v := s.UserAttributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserAttributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Segment group definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentGroup
type SegmentGroup struct {
	_ struct{} `type:"structure"`

	// List of dimensions to include or exclude.
	Dimensions []SegmentDimensions `type:"list"`

	// The base segment that you build your segment on. The source segment defines
	// the starting "universe" of endpoints. When you add dimensions to the segment,
	// it filters the source segment based on the dimensions that you specify. You
	// can specify more than one dimensional segment. You can only specify one imported
	// segment.NOTE: If you specify an imported segment for this attribute, the
	// segment size estimate that appears in the Amazon Pinpoint console shows the
	// size of the imported segment, without any filters applied to it.
	SourceSegments []SegmentReference `type:"list"`

	// Specify how to handle multiple source segments. For example, if you specify
	// three source segments, should the resulting segment be based on any or all
	// of the segments? Acceptable values: ANY or ALL.
	SourceType SourceType `type:"string" enum:"true"`

	// Specify how to handle multiple segment dimensions. For example, if you specify
	// three dimensions, should the resulting segment include endpoints that are
	// matched by all, any, or none of the dimensions? Acceptable values: ALL, ANY,
	// or NONE.
	Type Type `type:"string" enum:"true"`
}

// String returns the string representation
func (s SegmentGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentGroup) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Dimensions) > 0 {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Dimensions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SourceSegments) > 0 {
		v := s.SourceSegments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SourceSegments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SourceType) > 0 {
		v := s.SourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Segment group definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentGroupList
type SegmentGroupList struct {
	_ struct{} `type:"structure"`

	// A set of segment criteria to evaluate.
	Groups []SegmentGroup `type:"list"`

	// Specify how to handle multiple segment groups. For example, if the segment
	// includes three segment groups, should the resulting segment include endpoints
	// that are matched by all, any, or none of the segment groups you created.
	// Acceptable values: ALL, ANY, or NONE.
	Include Include `type:"string" enum:"true"`
}

// String returns the string representation
func (s SegmentGroupList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentGroupList) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Groups) > 0 {
		v := s.Groups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Groups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Include) > 0 {
		v := s.Include

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Include", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Segment import definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentImportResource
type SegmentImportResource struct {
	_ struct{} `type:"structure"`

	// The number of channel types in the imported segment.
	ChannelCounts map[string]int64 `type:"map"`

	// (Deprecated) Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the endpoint files that were imported to create this segment.Valid
	// values: CSV, JSON
	Format Format `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the endpoints in Amazon S3.
	RoleArn *string `type:"string"`

	// The URL of the S3 bucket that the segment was imported from.
	S3Url *string `type:"string"`

	// The number of endpoints that were successfully imported to create this segment.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentImportResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentImportResource) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ChannelCounts) > 0 {
		v := s.ChannelCounts

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "ChannelCounts", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Int64Value(v1))
		}
		ms0.End()

	}
	if s.ExternalId != nil {
		v := *s.ExternalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Url != nil {
		v := *s.S3Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Segment location dimensions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentLocation
type SegmentLocation struct {
	_ struct{} `type:"structure"`

	// The country or region, in ISO 3166-1 alpha-2 format.
	Country *SetDimension `type:"structure"`

	// The GPS Point dimension.
	GPSPoint *GPSPointDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Country != nil {
		v := s.Country

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Country", v, metadata)
	}
	if s.GPSPoint != nil {
		v := s.GPSPoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GPSPoint", v, metadata)
	}
	return nil
}

// Segment reference.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentReference
type SegmentReference struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the segment.
	Id *string `type:"string"`

	// If specified contains a specific version of the segment included.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentReference) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Segment definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentResponse
type SegmentResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application that the segment applies to.
	ApplicationId *string `type:"string"`

	// The arn for the segment.
	Arn *string `type:"string"`

	// The date and time when the segment was created.
	CreationDate *string `type:"string"`

	// The segment dimensions attributes.
	Dimensions *SegmentDimensions `type:"structure"`

	// The unique segment ID.
	Id *string `type:"string"`

	// The import job settings.
	ImportDefinition *SegmentImportResource `type:"structure"`

	// The date and time when the segment was last modified.
	LastModifiedDate *string `type:"string"`

	// The name of the segment.
	Name *string `type:"string"`

	// A segment group, which consists of zero or more source segments, plus dimensions
	// that are applied to those source segments.
	SegmentGroups *SegmentGroupList `type:"structure"`

	// The segment type:DIMENSIONAL - A dynamic segment built from selection criteria
	// based on endpoint data reported by your app. You create this type of segment
	// by using the segment builder in the Amazon Pinpoint console or by making
	// a POST request to the segments resource.IMPORT - A static segment built from
	// an imported set of endpoint definitions. You create this type of segment
	// by importing a segment in the Amazon Pinpoint console or by making a POST
	// request to the jobs/import resource.
	SegmentType SegmentType `type:"string" enum:"true"`

	// The Tags for the segment.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The segment version number.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImportDefinition != nil {
		v := s.ImportDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ImportDefinition", v, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentGroups != nil {
		v := s.SegmentGroups

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SegmentGroups", v, metadata)
	}
	if len(s.SegmentType) > 0 {
		v := s.SegmentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Segments in your account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SegmentsResponse
type SegmentsResponse struct {
	_ struct{} `type:"structure"`

	// The list of segments.
	Item []SegmentResponse `type:"list"`

	// An identifier used to retrieve the next page of results. The token is null
	// if no additional pages exist.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SegmentsResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SegmentsResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Item) > 0 {
		v := s.Item

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Send message request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessageRequest
type SendUsersMessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of custom attribute-value pairs. Amazon Pinpoint adds these attributes
	// to the data.pinpoint object in the body of the push notification payload.
	// Amazon Pinpoint also provides these attributes in the events that it generates
	// for users-messages deliveries.
	Context map[string]string `type:"map"`

	// Message definitions for the default message and any messages that are tailored
	// for specific channels.
	MessageConfiguration *DirectMessageConfiguration `type:"structure"`

	// A unique ID that you can use to trace a message. This ID is visible to recipients.
	TraceId *string `type:"string"`

	// A map that associates user IDs with EndpointSendConfiguration objects. Within
	// an EndpointSendConfiguration object, you can tailor the message for a user
	// by specifying message overrides or substitutions.
	Users map[string]EndpointSendConfiguration `type:"map"`
}

// String returns the string representation
func (s SendUsersMessageRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendUsersMessageRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Context) > 0 {
		v := s.Context

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Context", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.TraceId != nil {
		v := *s.TraceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TraceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Users) > 0 {
		v := s.Users

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Users", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// User send message response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessageResponse
type SendUsersMessageResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the Amazon Pinpoint project used to send the message.
	ApplicationId *string `type:"string"`

	// The unique ID assigned to the users-messages request.
	RequestId *string `type:"string"`

	// An object that shows the endpoints that were messaged for each user. The
	// object provides a list of user IDs. For each user ID, it provides the endpoint
	// IDs that were messaged. For each endpoint ID, it provides an EndpointMessageResult
	// object.
	Result map[string]map[string]EndpointMessageResult `type:"map"`
}

// String returns the string representation
func (s SendUsersMessageResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendUsersMessageResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Result) > 0 {
		v := s.Result

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Result", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms1 := ms0.Map(k1)
			ms1.Start()
			for k2, v2 := range v1 {
				ms1.MapSetFields(k2, v2)
			}
			ms1.End()
		}
		ms0.End()

	}
	return nil
}

// Information about a session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/Session
type Session struct {
	_ struct{} `type:"structure"`

	// The duration of the session, in milliseconds.
	Duration *int64 `type:"integer"`

	// A unique identifier for the session.
	Id *string `type:"string"`

	// The date and time when the session began.
	StartTimestamp *string `type:"string"`

	// The date and time when the session ended.
	StopTimestamp *string `type:"string"`
}

// String returns the string representation
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Session) MarshalFields(e protocol.FieldEncoder) error {
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.Int64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTimestamp != nil {
		v := *s.StartTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StopTimestamp != nil {
		v := *s.StopTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StopTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Dimension specification of a segment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SetDimension
type SetDimension struct {
	_ struct{} `type:"structure"`

	// The type of dimension:INCLUSIVE - Endpoints that match the criteria are included
	// in the segment.EXCLUSIVE - Endpoints that match the criteria are excluded
	// from the segment.
	DimensionType DimensionType `type:"string" enum:"true"`

	// The criteria values for the segment dimension. Endpoints with matching attribute
	// values are included or excluded from the segment, depending on the setting
	// for Type.
	Values []string `type:"list"`
}

// String returns the string representation
func (s SetDimension) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SetDimension) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DimensionType) > 0 {
		v := s.DimensionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DimensionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Values) > 0 {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An email composed of a subject, a text part and a html part.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SimpleEmail
type SimpleEmail struct {
	_ struct{} `type:"structure"`

	// The content of the message, in HTML format. Use this for email clients that
	// can process HTML. You can include clickable links, formatted text, and much
	// more in an HTML message.
	HtmlPart *SimpleEmailPart `type:"structure"`

	// The subject of the message: A short summary of the content, which will appear
	// in the recipient's inbox.
	Subject *SimpleEmailPart `type:"structure"`

	// The content of the message, in text format. Use this for text-based email
	// clients, or clients on high-latency networks (such as mobile devices).
	TextPart *SimpleEmailPart `type:"structure"`
}

// String returns the string representation
func (s SimpleEmail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimpleEmail) MarshalFields(e protocol.FieldEncoder) error {
	if s.HtmlPart != nil {
		v := s.HtmlPart

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HtmlPart", v, metadata)
	}
	if s.Subject != nil {
		v := s.Subject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Subject", v, metadata)
	}
	if s.TextPart != nil {
		v := s.TextPart

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TextPart", v, metadata)
	}
	return nil
}

// Textual email data, plus an optional character set specification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SimpleEmailPart
type SimpleEmailPart struct {
	_ struct{} `type:"structure"`

	// The character set of the content.
	Charset *string `type:"string"`

	// The textual data of the content.
	Data *string `type:"string"`
}

// String returns the string representation
func (s SimpleEmailPart) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimpleEmailPart) MarshalFields(e protocol.FieldEncoder) error {
	if s.Charset != nil {
		v := *s.Charset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Charset", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := *s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Data", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagsModel
type TagsModel struct {
	_ struct{} `type:"structure"`

	// Tags is a required field
	Tags map[string]string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagsModel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagsModel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagsModel"}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagsModel) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Treatment resource
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TreatmentResource
type TreatmentResource struct {
	_ struct{} `type:"structure"`

	// The unique treatment ID.
	Id *string `type:"string"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users for this treatment.
	SizePercent *int64 `type:"integer"`

	// The treatment status.
	State *CampaignState `type:"structure"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s TreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TreatmentResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SizePercent != nil {
		v := *s.SizePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SizePercent", protocol.Int64Value(v), metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "State", v, metadata)
	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Update attributes request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAttributesRequest
type UpdateAttributesRequest struct {
	_ struct{} `type:"structure"`

	// The GLOB wildcard for removing the attributes in the application
	Blacklist []string `type:"list"`
}

// String returns the string representation
func (s UpdateAttributesRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAttributesRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Blacklist) > 0 {
		v := s.Blacklist

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Blacklist", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Voice Channel Request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/VoiceChannelRequest
type VoiceChannelRequest struct {
	_ struct{} `type:"structure"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s VoiceChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceChannelRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Voice Channel Response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/VoiceChannelResponse
type VoiceChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// The date that the settings were last updated in ISO 8601 format.
	CreationDate *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// Platform type. Will be "Voice"
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s VoiceChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceChannelResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.HasCredential != nil {
		v := *s.HasCredential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HasCredential", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsArchived != nil {
		v := *s.IsArchived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsArchived", protocol.BoolValue(v), metadata)
	}
	if s.LastModifiedBy != nil {
		v := *s.LastModifiedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Voice Message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/VoiceMessage
type VoiceMessage struct {
	_ struct{} `type:"structure"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// Language of sent message
	LanguageCode *string `type:"string"`

	// Is the number from the pool or messaging service to send from.
	OriginationNumber *string `type:"string"`

	// Default message substitutions. Can be overridden by individual address substitutions.
	Substitutions map[string][]string `type:"map"`

	// Voice ID of sent message.
	VoiceId *string `type:"string"`
}

// String returns the string representation
func (s VoiceMessage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LanguageCode != nil {
		v := *s.LanguageCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LanguageCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginationNumber != nil {
		v := *s.OriginationNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginationNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Substitutions) > 0 {
		v := s.Substitutions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Substitutions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.VoiceId != nil {
		v := *s.VoiceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VoiceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Creating application setting request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/WriteApplicationSettingsRequest
type WriteApplicationSettingsRequest struct {
	_ struct{} `type:"structure"`

	// Default campaign hook information.
	CampaignHook *CampaignHook `type:"structure"`

	// The CloudWatchMetrics settings for the app.
	CloudWatchMetricsEnabled *bool `type:"boolean"`

	// The limits that apply to each campaign in the project by default. Campaigns
	// can also have their own limits, which override the settings at the project
	// level.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for the app. Campaigns in the app don't send messages
	// to endpoints during the quiet time.Note: Make sure that your endpoints include
	// the Demographics.Timezone attribute if you plan to enable a quiet time for
	// your app. If your endpoints don't include this attribute, they'll receive
	// the messages that you send them, even if quiet time is enabled.When you set
	// up an app to use quiet time, campaigns in that app don't send messages during
	// the time range you specified, as long as all of the following are true:-
	// The endpoint includes a valid Demographic.Timezone attribute.- The current
	// time in the endpoint's time zone is later than or equal to the time specified
	// in the QuietTime.Start attribute for the app (or campaign, if applicable).-
	// The current time in the endpoint's time zone is earlier than or equal to
	// the time specified in the QuietTime.End attribute for the app (or campaign,
	// if applicable).Individual campaigns within the app can have their own quiet
	// time settings, which override the quiet time settings at the app level.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s WriteApplicationSettingsRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteApplicationSettingsRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.CampaignHook != nil {
		v := s.CampaignHook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CampaignHook", v, metadata)
	}
	if s.CloudWatchMetricsEnabled != nil {
		v := *s.CloudWatchMetricsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudWatchMetricsEnabled", protocol.BoolValue(v), metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.QuietTime != nil {
		v := s.QuietTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QuietTime", v, metadata)
	}
	return nil
}

// Used to create a campaign.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/WriteCampaignRequest
type WriteCampaignRequest struct {
	_ struct{} `type:"structure"`

	// Treatments that are defined in addition to the default treatment.
	AdditionalTreatments []WriteTreatmentResource `type:"list"`

	// A description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of end users who will not receive messages from
	// this campaign.
	HoldoutPercent *int64 `type:"integer"`

	// Campaign hook information.
	Hook *CampaignHook `type:"structure"`

	// Indicates whether the campaign is paused. A paused campaign does not send
	// messages unless you resume it by setting IsPaused to false.
	IsPaused *bool `type:"boolean"`

	// The campaign limits settings.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The ID of the segment to which the campaign sends messages.
	SegmentId *string `type:"string"`

	// The version of the segment to which the campaign sends messages.
	SegmentVersion *int64 `type:"integer"`

	// The Tags for the campaign.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteCampaignRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteCampaignRequest) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdditionalTreatments) > 0 {
		v := s.AdditionalTreatments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AdditionalTreatments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HoldoutPercent != nil {
		v := *s.HoldoutPercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HoldoutPercent", protocol.Int64Value(v), metadata)
	}
	if s.Hook != nil {
		v := s.Hook

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Hook", v, metadata)
	}
	if s.IsPaused != nil {
		v := *s.IsPaused

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPaused", protocol.BoolValue(v), metadata)
	}
	if s.Limits != nil {
		v := s.Limits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Limits", v, metadata)
	}
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentVersion != nil {
		v := *s.SegmentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SegmentVersion", protocol.Int64Value(v), metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Request to save an EventStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/WriteEventStream
type WriteEventStream struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery
	// stream to which you want to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME
	// Kinesis ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
	DestinationStreamArn *string `type:"string"`

	// The IAM role that authorizes Amazon Pinpoint to publish events to the stream
	// in your account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s WriteEventStream) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteEventStream) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationStreamArn != nil {
		v := *s.DestinationStreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationStreamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Segment definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/WriteSegmentRequest
type WriteSegmentRequest struct {
	_ struct{} `type:"structure"`

	// The segment dimensions attributes.
	Dimensions *SegmentDimensions `type:"structure"`

	// The name of segment
	Name *string `type:"string"`

	// A segment group, which consists of zero or more source segments, plus dimensions
	// that are applied to those source segments. Your request can only include
	// one segment group. Your request can include either a SegmentGroups object
	// or a Dimensions object, but not both.
	SegmentGroups *SegmentGroupList `type:"structure"`

	// The Tags for the segments.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s WriteSegmentRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteSegmentRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentGroups != nil {
		v := s.SegmentGroups

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SegmentGroups", v, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Used to create a campaign treatment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/WriteTreatmentResource
type WriteTreatmentResource struct {
	_ struct{} `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users for this treatment.
	SizePercent *int64 `type:"integer"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteTreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WriteTreatmentResource) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageConfiguration != nil {
		v := s.MessageConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MessageConfiguration", v, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SizePercent != nil {
		v := *s.SizePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SizePercent", protocol.Int64Value(v), metadata)
	}
	if s.TreatmentDescription != nil {
		v := *s.TreatmentDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TreatmentName != nil {
		v := *s.TreatmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TreatmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
