// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The result of the DescribeSnapshotCopyGrants action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrantsMessage
type DescribeSnapshotCopyGrantsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the SnapshotCopyGrantName parameter or
	// the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/SnapshotCopyGrantMessage
type DescribeSnapshotCopyGrantsOutput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the SnapshotCopyGrantName parameter or
	// the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The list of SnapshotCopyGrant objects.
	SnapshotCopyGrants []SnapshotCopyGrant `locationNameList:"SnapshotCopyGrant" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSnapshotCopyGrants = "DescribeSnapshotCopyGrants"

// DescribeSnapshotCopyGrantsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns a list of snapshot copy grants owned by the AWS account in the destination
// region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using DescribeSnapshotCopyGrantsRequest.
//    req := client.DescribeSnapshotCopyGrantsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants
func (c *Client) DescribeSnapshotCopyGrantsRequest(input *DescribeSnapshotCopyGrantsInput) DescribeSnapshotCopyGrantsRequest {
	op := &aws.Operation{
		Name:       opDescribeSnapshotCopyGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotCopyGrantsInput{}
	}

	req := c.newRequest(op, input, &DescribeSnapshotCopyGrantsOutput{})
	return DescribeSnapshotCopyGrantsRequest{Request: req, Input: input, Copy: c.DescribeSnapshotCopyGrantsRequest}
}

// DescribeSnapshotCopyGrantsRequest is the request type for the
// DescribeSnapshotCopyGrants API operation.
type DescribeSnapshotCopyGrantsRequest struct {
	*aws.Request
	Input *DescribeSnapshotCopyGrantsInput
	Copy  func(*DescribeSnapshotCopyGrantsInput) DescribeSnapshotCopyGrantsRequest
}

// Send marshals and sends the DescribeSnapshotCopyGrants API request.
func (r DescribeSnapshotCopyGrantsRequest) Send(ctx context.Context) (*DescribeSnapshotCopyGrantsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSnapshotCopyGrantsResponse{
		DescribeSnapshotCopyGrantsOutput: r.Request.Data.(*DescribeSnapshotCopyGrantsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSnapshotCopyGrantsResponse is the response type for the
// DescribeSnapshotCopyGrants API operation.
type DescribeSnapshotCopyGrantsResponse struct {
	*DescribeSnapshotCopyGrantsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSnapshotCopyGrants request.
func (r *DescribeSnapshotCopyGrantsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
