// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// A complex type that contains information about the Amazon Route 53 DNS records
// that you want AWS Cloud Map to create when you register an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsConfig
type DnsConfig struct {
	_ struct{} `type:"structure"`

	// An array that contains one DnsRecord object for each Route 53 DNS record
	// that you want AWS Cloud Map to create when you register an instance.
	//
	// DnsRecords is a required field
	DnsRecords []DnsRecord `type:"list" required:"true"`

	// The ID of the namespace to use for DNS configuration.
	NamespaceId *string `deprecated:"true" type:"string"`

	// The routing policy that you want to apply to all Route 53 DNS records that
	// AWS Cloud Map creates when you register an instance and specify this service.
	//
	// If you want to use this service to register instances that create alias records,
	// specify WEIGHTED for the routing policy.
	//
	// You can specify the following values:
	//
	// MULTIVALUE
	//
	// If you define a health check for the service and the health check is healthy,
	// Route 53 returns the applicable value for up to eight instances.
	//
	// For example, suppose the service includes configurations for one A record
	// and a health check, and you use the service to register 10 instances. Route
	// 53 responds to DNS queries with IP addresses for up to eight healthy instances.
	// If fewer than eight instances are healthy, Route 53 responds to every DNS
	// query with the IP addresses for all of the healthy instances.
	//
	// If you don't define a health check for the service, Route 53 assumes that
	// all instances are healthy and returns the values for up to eight instances.
	//
	// For more information about the multivalue routing policy, see Multivalue
	// Answer Routing (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue)
	// in the Route 53 Developer Guide.
	//
	// WEIGHTED
	//
	// Route 53 returns the applicable value from one randomly selected instance
	// from among the instances that you registered using the same service. Currently,
	// all records have the same weight, so you can't route more or less traffic
	// to any instances.
	//
	// For example, suppose the service includes configurations for one A record
	// and a health check, and you use the service to register 10 instances. Route
	// 53 responds to DNS queries with the IP address for one randomly selected
	// instance from among the healthy instances. If no instances are healthy, Route
	// 53 responds to DNS queries as if all of the instances were healthy.
	//
	// If you don't define a health check for the service, Route 53 assumes that
	// all instances are healthy and returns the applicable value for one randomly
	// selected instance.
	//
	// For more information about the weighted routing policy, see Weighted Routing
	// (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted)
	// in the Route 53 Developer Guide.
	RoutingPolicy RoutingPolicy `type:"string" enum:"true"`
}

// String returns the string representation
func (s DnsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DnsConfig"}

	if s.DnsRecords == nil {
		invalidParams.Add(aws.NewErrParamRequired("DnsRecords"))
	}
	if s.DnsRecords != nil {
		for i, v := range s.DnsRecords {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DnsRecords", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about changes to the Route 53 DNS
// records that AWS Cloud Map creates when you register an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsConfigChange
type DnsConfigChange struct {
	_ struct{} `type:"structure"`

	// An array that contains one DnsRecord object for each Route 53 record that
	// you want AWS Cloud Map to create when you register an instance.
	//
	// DnsRecords is a required field
	DnsRecords []DnsRecord `type:"list" required:"true"`
}

// String returns the string representation
func (s DnsConfigChange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsConfigChange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DnsConfigChange"}

	if s.DnsRecords == nil {
		invalidParams.Add(aws.NewErrParamRequired("DnsRecords"))
	}
	if s.DnsRecords != nil {
		for i, v := range s.DnsRecords {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DnsRecords", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains the ID for the Route 53 hosted zone that AWS
// Cloud Map creates when you create a namespace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsProperties
type DnsProperties struct {
	_ struct{} `type:"structure"`

	// The ID for the Route 53 hosted zone that AWS Cloud Map creates when you create
	// a namespace.
	HostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s DnsProperties) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains information about the Route 53 DNS records that
// you want AWS Cloud Map to create when you register an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DnsRecord
type DnsRecord struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, that you want DNS resolvers to cache the
	// settings for this record.
	//
	// Alias records don't include a TTL because Route 53 uses the TTL for the AWS
	// resource that an alias record routes traffic to. If you include the AWS_ALIAS_DNS_NAME
	// attribute when you submit a RegisterInstance request, the TTL value is ignored.
	// Always specify a TTL for the service; you can use a service to register instances
	// that create either alias or non-alias records.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The type of the resource, which indicates the type of value that Route 53
	// returns in response to DNS queries.
	//
	// Note the following:
	//
	//    * A, AAAA, and SRV records: You can specify settings for a maximum of
	//    one A, one AAAA, and one SRV record. You can specify them in any combination.
	//
	//    * CNAME records: If you specify CNAME for Type, you can't define any other
	//    records. This is a limitation of DNS: you can't create a CNAME record
	//    and any other type of record that has the same name as a CNAME record.
	//
	//    * Alias records: If you want AWS Cloud Map to create a Route 53 alias
	//    record when you register an instance, specify A or AAAA for Type.
	//
	//    * All records: You specify settings other than TTL and Type when you register
	//    an instance.
	//
	// The following values are supported:
	//
	// A
	//
	// Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
	//
	// AAAA
	//
	// Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	// CNAME
	//
	// Route 53 returns the domain name of the resource, such as www.example.com.
	// Note the following:
	//
	//    * You specify the domain name that you want to route traffic to when you
	//    register an instance. For more information, see RegisterInstanceRequest$Attributes.
	//
	//    * You must specify WEIGHTED for the value of RoutingPolicy.
	//
	//    * You can't specify both CNAME for Type and settings for HealthCheckConfig.
	//    If you do, the request will fail with an InvalidInput error.
	//
	// SRV
	//
	// Route 53 returns the value for an SRV record. The value for an SRV record
	// uses the following values:
	//
	// priority weight port service-hostname
	//
	// Note the following about the values:
	//
	//    * The values of priority and weight are both set to 1 and can't be changed.
	//
	//    * The value of port comes from the value that you specify for the AWS_INSTANCE_PORT
	//    attribute when you submit a RegisterInstance request.
	//
	//    * The value of service-hostname is a concatenation of the following values:
	//    The value that you specify for InstanceId when you register an instance.
	//    The name of the service. The name of the namespace. For example, if the
	//    value of InstanceId is test, the name of the service is backend, and the
	//    name of the namespace is example.com, the value of service-hostname is:
	//    test.backend.example.com
	//
	// If you specify settings for an SRV record and if you specify values for AWS_INSTANCE_IPV4,
	// AWS_INSTANCE_IPV6, or both in the RegisterInstance request, AWS Cloud Map
	// automatically creates A and/or AAAA records that have the same name as the
	// value of service-hostname in the SRV record. You can ignore these records.
	//
	// Type is a required field
	Type RecordType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DnsRecord) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsRecord) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DnsRecord"}

	if s.TTL == nil {
		invalidParams.Add(aws.NewErrParamRequired("TTL"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Public DNS namespaces only. A complex type that contains settings for an
// optional health check. If you specify settings for a health check, AWS Cloud
// Map associates the health check with the records that you specify in DnsConfig.
//
// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
// or HealthCheckConfig but not both.
//
// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
// For information about pricing for health checks, see Amazon Route 53 Pricing
// (http://aws.amazon.com/route53/pricing/).
//
// Note the following about configuring health checks.
//
// A and AAAA records
//
// If DnsConfig includes configurations for both A and AAAA records, AWS Cloud
// Map creates a health check that uses the IPv4 address to check the health
// of the resource. If the endpoint that is specified by the IPv4 address is
// unhealthy, Route 53 considers both the A and AAAA records to be unhealthy.
//
// CNAME records
//
// You can't specify settings for HealthCheckConfig when the DNSConfig includes
// CNAME for the value of Type. If you do, the CreateService request will fail
// with an InvalidInput error.
//
// Request interval
//
// A Route 53 health checker in each health-checking region sends a health check
// request to an endpoint every 30 seconds. On average, your endpoint receives
// a health check request about every two seconds. However, health checkers
// don't coordinate with one another, so you'll sometimes see several requests
// per second followed by a few seconds with no health checks at all.
//
// Health checking regions
//
// Health checkers perform checks from all Route 53 health-checking regions.
// For a list of the current regions, see Regions (http://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions).
//
// Alias records
//
// When you register an instance, if you include the AWS_ALIAS_DNS_NAME attribute,
// AWS Cloud Map creates a Route 53 alias record. Note the following:
//
//    * Route 53 automatically sets EvaluateTargetHealth to true for alias records.
//    When EvaluateTargetHealth is true, the alias record inherits the health
//    of the referenced AWS resource. such as an ELB load balancer. For more
//    information, see EvaluateTargetHealth (http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth).
//
//    * If you include HealthCheckConfig and then use the service to register
//    an instance that creates an alias record, Route 53 doesn't create the
//    health check.
//
// Charges for health checks
//
// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
// For information about pricing for health checks, see Amazon Route 53 Pricing
// (http://aws.amazon.com/route53/pricing/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/HealthCheckConfig
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Route 53 Determines
	// Whether an Endpoint Is Healthy (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Route 53 Developer Guide.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// The path that you want Route 53 to request when performing health checks.
	// The path can be any value for which your endpoint will return an HTTP status
	// code of 2xx or 3xx when the endpoint is healthy, such as the file /docs/route53-health-check.html.
	// Route 53 automatically adds the DNS name for the service. If you don't specify
	// a value for ResourcePath, the default value is /.
	//
	// If you specify TCP for Type, you must not specify a value for ResourcePath.
	ResourcePath *string `type:"string"`

	// The type of health check that you want to create, which indicates how Route
	// 53 determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//    * HTTP: Route 53 tries to establish a TCP connection. If successful, Route
	//    53 submits an HTTP request and waits for an HTTP status code of 200 or
	//    greater and less than 400.
	//
	//    * HTTPS: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTPS request and waits for an HTTP status code of
	//    200 or greater and less than 400. If you specify HTTPS for the value of
	//    Type, the endpoint must support TLS v1.0 or later.
	//
	//    * TCP: Route 53 tries to establish a TCP connection. If you specify TCP
	//    for Type, don't specify a value for ResourcePath.
	//
	// For more information, see How Route 53 Determines Whether an Endpoint Is
	// Healthy (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Route 53 Developer Guide.
	//
	// Type is a required field
	Type HealthCheckType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HealthCheckConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FailureThreshold", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about an optional custom health
// check. A custom health check, which requires that you use a third-party health
// checker to evaluate the health of your resources, is useful in the following
// circumstances:
//
//    * You can't use a health check that is defined by HealthCheckConfig because
//    the resource isn't available over the internet. For example, you can use
//    a custom health check when the instance is in an Amazon VPC. (To check
//    the health of resources in a VPC, the health checker must also be in the
//    VPC.)
//
//    * You want to use a third-party health checker regardless of where your
//    resources are.
//
// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
// or HealthCheckConfig but not both.
//
// To change the status of a custom health check, submit an UpdateInstanceCustomHealthStatus
// request. Cloud Map doesn't monitor the status of the resource, it just keeps
// a record of the status specified in the most recent UpdateInstanceCustomHealthStatus
// request.
//
// Here's how custom health checks work:
//
// You create a service and specify a value for FailureThreshold.
//
// The failure threshold indicates the number of 30-second intervals you want
// AWS Cloud Map to wait between the time that your application sends an UpdateInstanceCustomHealthStatus
// request and the time that AWS Cloud Map stops routing internet traffic to
// the corresponding resource.
//
// You register an instance.
//
// You configure a third-party health checker to monitor the resource that is
// associated with the new instance.
//
// AWS Cloud Map doesn't check the health of the resource directly.
//
// The third-party health-checker determines that the resource is unhealthy
// and notifies your application.
//
// Your application submits an UpdateInstanceCustomHealthStatus request.
//
// AWS Cloud Map waits for (FailureThreshold x 30) seconds.
//
// If another UpdateInstanceCustomHealthStatus request doesn't arrive during
// that time to change the status back to healthy, AWS Cloud Map stops routing
// traffic to the resource.
//
// Note the following about configuring custom health checks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/HealthCheckCustomConfig
type HealthCheckCustomConfig struct {
	_ struct{} `type:"structure"`

	// The number of 30-second intervals that you want Cloud Map to wait after receiving
	// an UpdateInstanceCustomHealthStatus request before it changes the health
	// status of a service instance. For example, suppose you specify a value of
	// 2 for FailureTheshold, and then your application sends an UpdateInstanceCustomHealthStatus
	// request. Cloud Map waits for approximately 60 seconds (2 x 30) before changing
	// the status of the service instance based on that request.
	//
	// Sending a second or subsequent UpdateInstanceCustomHealthStatus request with
	// the same value before FailureThreshold x 30 seconds has passed doesn't accelerate
	// the change. Cloud Map still waits FailureThreshold x 30 seconds after the
	// first request to make the change.
	FailureThreshold *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s HealthCheckCustomConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckCustomConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HealthCheckCustomConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FailureThreshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// In a response to a DiscoverInstance request, HttpInstanceSummary contains
// information about one instance that matches the values that you specified
// in the request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/HttpInstanceSummary
type HttpInstanceSummary struct {
	_ struct{} `type:"structure"`

	// If you included any attributes when you registered the instance, the values
	// of those attributes.
	Attributes map[string]string `type:"map"`

	// If you configured health checking in the service, the current health status
	// of the service instance.
	HealthStatus HealthStatus `type:"string" enum:"true"`

	// The ID of an instance that matches the values that you specified in the request.
	InstanceId *string `type:"string"`

	// The name of the namespace that you specified when you registered the instance.
	NamespaceName *string `type:"string"`

	// The name of the service that you specified when you registered the instance.
	ServiceName *string `type:"string"`
}

// String returns the string representation
func (s HttpInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains the name of an HTTP namespace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/HttpProperties
type HttpProperties struct {
	_ struct{} `type:"structure"`

	// The name of an HTTP namespace.
	HttpName *string `type:"string"`
}

// String returns the string representation
func (s HttpProperties) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains information about an instance that AWS Cloud
// Map creates when you submit a RegisterInstance request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// A string map that contains the following information for the service that
	// you specify in ServiceId:
	//
	//    * The attributes that apply to the records that are defined in the service.
	//
	//    * For each attribute, the applicable value.
	//
	// Supported attribute keys include the following:
	//
	// AWS_ALIAS_DNS_NAME
	//
	// If you want AWS Cloud Map to create a Route 53 alias record that routes traffic
	// to an Elastic Load Balancing load balancer, specify the DNS name that is
	// associated with the load balancer. For information about how to get the DNS
	// name, see "DNSName" in the topic AliasTarget (http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html).
	//
	// Note the following:
	//
	//    * The configuration for the service that is specified by ServiceId must
	//    include settings for an A record, an AAAA record, or both.
	//
	//    * In the service that is specified by ServiceId, the value of RoutingPolicy
	//    must be WEIGHTED.
	//
	//    * If the service that is specified by ServiceId includes HealthCheckConfig
	//    settings, AWS Cloud Map will create the health check, but it won't associate
	//    the health check with the alias record.
	//
	//    * Auto naming currently doesn't support creating alias records that route
	//    traffic to AWS resources other than ELB load balancers.
	//
	//    * If you specify a value for AWS_ALIAS_DNS_NAME, don't specify values
	//    for any of the AWS_INSTANCE attributes.
	//
	// AWS_INSTANCE_CNAME
	//
	// If the service configuration includes a CNAME record, the domain name that
	// you want Route 53 to return in response to DNS queries, for example, example.com.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an CNAME record.
	//
	// AWS_INSTANCE_IPV4
	//
	// If the service configuration includes an A record, the IPv4 address that
	// you want Route 53 to return in response to DNS queries, for example, 192.0.2.44.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an A record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_IPV6
	//
	// If the service configuration includes an AAAA record, the IPv6 address that
	// you want Route 53 to return in response to DNS queries, for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an AAAA record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_PORT
	//
	// If the service includes an SRV record, the value that you want Route 53 to
	// return for the port.
	//
	// If the service includes HealthCheckConfig, the port on the endpoint that
	// you want Route 53 to send requests to.
	//
	// This value is required if you specified settings for an SRV record when you
	// created the service.
	Attributes map[string]string `type:"map"`

	// A unique string that identifies the request and that allows failed RegisterInstance
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CreatorRequestId string every time you submit a RegisterInstance
	// request if you're registering additional instances for the same namespace
	// and service. CreatorRequestId can be any unique string, for example, a date/time
	// stamp.
	CreatorRequestId *string `type:"string"`

	// An identifier that you want to associate with the instance. Note the following:
	//
	//    * If the service that is specified by ServiceId includes settings for
	//    an SRV record, the value of InstanceId is automatically included as part
	//    of the value for the SRV record. For more information, see DnsRecord$Type.
	//
	//    * You can use this value to update an existing instance.
	//
	//    * To register a new instance, you must specify a value that is unique
	//    among instances that you register by using the same service.
	//
	//    * If you specify an existing InstanceId and ServiceId, AWS Cloud Map updates
	//    the existing DNS records. If there's also an existing health check, AWS
	//    Cloud Map deletes the old health check and creates a new one. The health
	//    check isn't deleted immediately, so it will still appear for a while if
	//    you submit a ListHealthChecks request, for example.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains information about the instances that you registered
// by using a specified service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/InstanceSummary
type InstanceSummary struct {
	_ struct{} `type:"structure"`

	// A string map that contains the following information:
	//
	//    * The attributes that are associate with the instance.
	//
	//    * For each attribute, the applicable value.
	//
	// Supported attribute keys include the following:
	//
	//    * AWS_ALIAS_DNS_NAME: For an alias record that routes traffic to an Elastic
	//    Load Balancing load balancer, the DNS name that is associated with the
	//    load balancer.
	//
	//    * AWS_INSTANCE_CNAME: For a CNAME record, the domain name that Route 53
	//    returns in response to DNS queries, for example, example.com.
	//
	//    * AWS_INSTANCE_IPV4: For an A record, the IPv4 address that Route 53 returns
	//    in response to DNS queries, for example, 192.0.2.44.
	//
	//    * AWS_INSTANCE_IPV6: For an AAAA record, the IPv6 address that Route 53
	//    returns in response to DNS queries, for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	//    * AWS_INSTANCE_PORT: For an SRV record, the value that Route 53 returns
	//    for the port. In addition, if the service includes HealthCheckConfig,
	//    the port on the endpoint that Route 53 sends requests to.
	Attributes map[string]string `type:"map"`

	// The ID for an instance that you created by using a specified service.
	Id *string `type:"string"`
}

// String returns the string representation
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains information about a specified namespace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Namespace
type Namespace struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the namespace
	// when you create it.
	Arn *string `type:"string"`

	// The date that the namespace was created, in Unix date/time format and Coordinated
	// Universal Time (UTC). The value of CreateDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing an operation twice.
	CreatorRequestId *string `type:"string"`

	// The description that you specify for the namespace when you create it.
	Description *string `type:"string"`

	// The ID of a namespace.
	Id *string `type:"string"`

	// The name of the namespace, such as example.com.
	Name *string `type:"string"`

	// A complex type that contains information that's specific to the type of the
	// namespace.
	Properties *NamespaceProperties `type:"structure"`

	// The number of services that are associated with the namespace.
	ServiceCount *int64 `type:"integer"`

	// The type of the namespace. Valid values are DNS_PUBLIC and DNS_PRIVATE.
	Type NamespaceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Namespace) String() string {
	return awsutil.Prettify(s)
}

// A complex type that identifies the namespaces that you want to list. You
// can choose to list public or private namespaces.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/NamespaceFilter
type NamespaceFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether ListNamespaces returns
	// a namespace. Valid values for condition include:
	//
	//    * EQ: When you specify EQ for the condition, you can choose to list only
	//    public namespaces or private namespaces, but not both. EQ is the default
	//    condition and can be omitted.
	//
	//    * IN: When you specify IN for the condition, you can choose to list public
	//    namespaces, private namespaces, or both.
	//
	//    * BETWEEN: Not applicable
	Condition FilterCondition `type:"string" enum:"true"`

	// Specify TYPE.
	//
	// Name is a required field
	Name NamespaceFilterName `type:"string" required:"true" enum:"true"`

	// If you specify EQ for Condition, specify either DNS_PUBLIC or DNS_PRIVATE.
	//
	// If you specify IN for Condition, you can specify DNS_PUBLIC, DNS_PRIVATE,
	// or both.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s NamespaceFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NamespaceFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NamespaceFilter"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information that is specific to the namespace
// type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/NamespaceProperties
type NamespaceProperties struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID for the Route 53 hosted zone that AWS
	// Cloud Map creates when you create a namespace.
	DnsProperties *DnsProperties `type:"structure"`

	// A complex type that contains the name of an HTTP namespace.
	HttpProperties *HttpProperties `type:"structure"`
}

// String returns the string representation
func (s NamespaceProperties) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains information about a namespace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/NamespaceSummary
type NamespaceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the namespace
	// when you create it.
	Arn *string `type:"string"`

	// The date and time that the namespace was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The ID of the namespace.
	Id *string `type:"string"`

	// The name of the namespace. When you create a namespace, AWS Cloud Map automatically
	// creates a Route 53 hosted zone that has the same name as the namespace.
	Name *string `type:"string"`

	// A complex type that contains information that is specific to the namespace
	// type.
	Properties *NamespaceProperties `type:"structure"`

	// The number of services that were created using the namespace.
	ServiceCount *int64 `type:"integer"`

	// The type of the namespace, either public or private.
	Type NamespaceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s NamespaceSummary) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains information about a specified operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Operation
type Operation struct {
	_ struct{} `type:"structure"`

	// The date and time that the request was submitted, in Unix date/time format
	// and Coordinated Universal Time (UTC). The value of CreateDate is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The code associated with ErrorMessage. Values for ErrorCode include the following:
	//
	//    * ACCESS_DENIED
	//
	//    * CANNOT_CREATE_HOSTED_ZONE
	//
	//    * EXPIRED_TOKEN
	//
	//    * HOSTED_ZONE_NOT_FOUND
	//
	//    * INTERNAL_FAILURE
	//
	//    * INVALID_CHANGE_BATCH
	//
	//    * THROTTLED_REQUEST
	ErrorCode *string `type:"string"`

	// If the value of Status is FAIL, the reason that the operation failed.
	ErrorMessage *string `type:"string"`

	// The ID of the operation that you want to get information about.
	Id *string `type:"string"`

	// The status of the operation. Values include the following:
	//
	//    * SUBMITTED: This is the initial state immediately after you submit a
	//    request.
	//
	//    * PENDING: AWS Cloud Map is performing the operation.
	//
	//    * SUCCESS: The operation succeeded.
	//
	//    * FAIL: The operation failed. For the failure reason, see ErrorMessage.
	Status OperationStatus `type:"string" enum:"true"`

	// The name of the target entity that is associated with the operation:
	//
	//    * NAMESPACE: The namespace ID is returned in the ResourceId property.
	//
	//    * SERVICE: The service ID is returned in the ResourceId property.
	//
	//    * INSTANCE: The instance ID is returned in the ResourceId property.
	Targets map[string]string `type:"map"`

	// The name of the operation that is associated with the specified ID.
	Type OperationType `type:"string" enum:"true"`

	// The date and time that the value of Status changed to the current value,
	// in Unix date/time format and Coordinated Universal Time (UTC). The value
	// of UpdateDate is accurate to milliseconds. For example, the value 1516925490.087
	// represents Friday, January 26, 2018 12:11:30.087 AM.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Operation) String() string {
	return awsutil.Prettify(s)
}

// A complex type that lets you select the operations that you want to list.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/OperationFilter
type OperationFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether an operation matches
	// the specified value. Valid values for condition include:
	//
	//    * EQ: When you specify EQ for the condition, you can specify only one
	//    value. EQ is supported for NAMESPACE_ID, SERVICE_ID, STATUS, and TYPE.
	//    EQ is the default condition and can be omitted.
	//
	//    * IN: When you specify IN for the condition, you can specify a list of
	//    one or more values. IN is supported for STATUS and TYPE. An operation
	//    must match one of the specified values to be returned in the response.
	//
	//    * BETWEEN: Specify a start date and an end date in Unix date/time format
	//    and Coordinated Universal Time (UTC). The start date must be the first
	//    value. BETWEEN is supported for UPDATE_DATE.
	Condition FilterCondition `type:"string" enum:"true"`

	// Specify the operations that you want to get:
	//
	//    * NAMESPACE_ID: Gets operations related to specified namespaces.
	//
	//    * SERVICE_ID: Gets operations related to specified services.
	//
	//    * STATUS: Gets operations based on the status of the operations: SUBMITTED,
	//    PENDING, SUCCEED, or FAIL.
	//
	//    * TYPE: Gets specified types of operation.
	//
	//    * UPDATE_DATE: Gets operations that changed status during a specified
	//    date/time range.
	//
	// Name is a required field
	Name OperationFilterName `type:"string" required:"true" enum:"true"`

	// Specify values that are applicable to the value that you specify for Name:
	//
	//    * NAMESPACE_ID: Specify one namespace ID.
	//
	//    * SERVICE_ID: Specify one service ID.
	//
	//    * STATUS: Specify one or more statuses: SUBMITTED, PENDING, SUCCEED, or
	//    FAIL.
	//
	//    * TYPE: Specify one or more of the following types: CREATE_NAMESPACE,
	//    DELETE_NAMESPACE, UPDATE_SERVICE, REGISTER_INSTANCE, or DEREGISTER_INSTANCE.
	//
	//    * UPDATE_DATE: Specify a start date and an end date in Unix date/time
	//    format and Coordinated Universal Time (UTC). The start date must be the
	//    first value.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s OperationFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OperationFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OperationFilter"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about an operation that matches
// the criteria that you specified in a ListOperations request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/OperationSummary
type OperationSummary struct {
	_ struct{} `type:"structure"`

	// The ID for an operation.
	Id *string `type:"string"`

	// The status of the operation. Values include the following:
	//
	//    * SUBMITTED: This is the initial state immediately after you submit a
	//    request.
	//
	//    * PENDING: AWS Cloud Map is performing the operation.
	//
	//    * SUCCESS: The operation succeeded.
	//
	//    * FAIL: The operation failed. For the failure reason, see ErrorMessage.
	Status OperationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s OperationSummary) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains information about the specified service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/Service
type Service struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service
	// when you create it.
	Arn *string `type:"string"`

	// The date and time that the service was created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreateDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string"`

	// The description of the service.
	Description *string `type:"string"`

	// A complex type that contains information about the Route 53 DNS records that
	// you want AWS Cloud Map to create when you register an instance.
	DnsConfig *DnsConfig `type:"structure"`

	// Public DNS namespaces only. A complex type that contains settings for an
	// optional health check. If you specify settings for a health check, AWS Cloud
	// Map associates the health check with the records that you specify in DnsConfig.
	//
	// For information about the charges for health checks, see Amazon Route 53
	// Pricing (http://aws.amazon.com/route53/pricing/).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`

	// A complex type that contains information about an optional custom health
	// check.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	HealthCheckCustomConfig *HealthCheckCustomConfig `type:"structure"`

	// The ID that AWS Cloud Map assigned to the service when you created it.
	Id *string `type:"string"`

	// The number of instances that are currently associated with the service. Instances
	// that were previously associated with the service but that have been deleted
	// are not included in the count.
	InstanceCount *int64 `type:"integer"`

	// The name of the service.
	Name *string `type:"string"`

	// The ID of the namespace that was used to create the service.
	NamespaceId *string `type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// A complex type that contains changes to an existing service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ServiceChange
type ServiceChange struct {
	_ struct{} `type:"structure"`

	// A description for the service.
	Description *string `type:"string"`

	// A complex type that contains information about the Route 53 DNS records that
	// you want AWS Cloud Map to create when you register an instance.
	//
	// DnsConfig is a required field
	DnsConfig *DnsConfigChange `type:"structure" required:"true"`

	// Public DNS namespaces only. A complex type that contains settings for an
	// optional health check. If you specify settings for a health check, AWS Cloud
	// Map associates the health check with the records that you specify in DnsConfig.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	//
	// Note the following about configuring health checks.
	//
	// A and AAAA records
	//
	// If DnsConfig includes configurations for both A and AAAA records, AWS Cloud
	// Map creates a health check that uses the IPv4 address to check the health
	// of the resource. If the endpoint that is specified by the IPv4 address is
	// unhealthy, Route 53 considers both the A and AAAA records to be unhealthy.
	//
	// CNAME records
	//
	// You can't specify settings for HealthCheckConfig when the DNSConfig includes
	// CNAME for the value of Type. If you do, the CreateService request will fail
	// with an InvalidInput error.
	//
	// Request interval
	//
	// A Route 53 health checker in each health-checking region sends a health check
	// request to an endpoint every 30 seconds. On average, your endpoint receives
	// a health check request about every two seconds. However, health checkers
	// don't coordinate with one another, so you'll sometimes see several requests
	// per second followed by a few seconds with no health checks at all.
	//
	// Health checking regions
	//
	// Health checkers perform checks from all Route 53 health-checking regions.
	// For a list of the current regions, see Regions (http://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions).
	//
	// Alias records
	//
	// When you register an instance, if you include the AWS_ALIAS_DNS_NAME attribute,
	// AWS Cloud Map creates a Route 53 alias record. Note the following:
	//
	//    * Route 53 automatically sets EvaluateTargetHealth to true for alias records.
	//    When EvaluateTargetHealth is true, the alias record inherits the health
	//    of the referenced AWS resource. such as an ELB load balancer. For more
	//    information, see EvaluateTargetHealth (http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth).
	//
	//    * If you include HealthCheckConfig and then use the service to register
	//    an instance that creates an alias record, Route 53 doesn't create the
	//    health check.
	//
	// Charges for health checks
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`
}

// String returns the string representation
func (s ServiceChange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceChange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceChange"}

	if s.DnsConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("DnsConfig"))
	}
	if s.DnsConfig != nil {
		if err := s.DnsConfig.Validate(); err != nil {
			invalidParams.AddNested("DnsConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.HealthCheckConfig != nil {
		if err := s.HealthCheckConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that lets you specify the namespaces that you want to list
// services for.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ServiceFilter
type ServiceFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether a service is returned
	// by ListServices. Valid values for Condition include the following:
	//
	//    * EQ: When you specify EQ, specify one namespace ID for Values. EQ is
	//    the default condition and can be omitted.
	//
	//    * IN: When you specify IN, specify a list of the IDs for the namespaces
	//    that you want ListServices to return a list of services for.
	//
	//    * BETWEEN: Not applicable.
	Condition FilterCondition `type:"string" enum:"true"`

	// Specify NAMESPACE_ID.
	//
	// Name is a required field
	Name ServiceFilterName `type:"string" required:"true" enum:"true"`

	// The values that are applicable to the value that you specify for Condition
	// to filter the list of services.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s ServiceFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceFilter"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A complex type that contains information about a specified service.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ServiceSummary
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service
	// when you create it.
	Arn *string `type:"string"`

	// The date and time that the service was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description that you specify when you create the service.
	Description *string `type:"string"`

	// A complex type that contains information about the Amazon Route 53 DNS records
	// that you want AWS Cloud Map to create when you register an instance.
	DnsConfig *DnsConfig `type:"structure"`

	// Public DNS namespaces only. A complex type that contains settings for an
	// optional health check. If you specify settings for a health check, AWS Cloud
	// Map associates the health check with the records that you specify in DnsConfig.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	//
	// Note the following about configuring health checks.
	//
	// A and AAAA records
	//
	// If DnsConfig includes configurations for both A and AAAA records, AWS Cloud
	// Map creates a health check that uses the IPv4 address to check the health
	// of the resource. If the endpoint that is specified by the IPv4 address is
	// unhealthy, Route 53 considers both the A and AAAA records to be unhealthy.
	//
	// CNAME records
	//
	// You can't specify settings for HealthCheckConfig when the DNSConfig includes
	// CNAME for the value of Type. If you do, the CreateService request will fail
	// with an InvalidInput error.
	//
	// Request interval
	//
	// A Route 53 health checker in each health-checking region sends a health check
	// request to an endpoint every 30 seconds. On average, your endpoint receives
	// a health check request about every two seconds. However, health checkers
	// don't coordinate with one another, so you'll sometimes see several requests
	// per second followed by a few seconds with no health checks at all.
	//
	// Health checking regions
	//
	// Health checkers perform checks from all Route 53 health-checking regions.
	// For a list of the current regions, see Regions (http://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions).
	//
	// Alias records
	//
	// When you register an instance, if you include the AWS_ALIAS_DNS_NAME attribute,
	// AWS Cloud Map creates a Route 53 alias record. Note the following:
	//
	//    * Route 53 automatically sets EvaluateTargetHealth to true for alias records.
	//    When EvaluateTargetHealth is true, the alias record inherits the health
	//    of the referenced AWS resource. such as an ELB load balancer. For more
	//    information, see EvaluateTargetHealth (http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth).
	//
	//    * If you include HealthCheckConfig and then use the service to register
	//    an instance that creates an alias record, Route 53 doesn't create the
	//    health check.
	//
	// Charges for health checks
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`

	// A complex type that contains information about an optional custom health
	// check. A custom health check, which requires that you use a third-party health
	// checker to evaluate the health of your resources, is useful in the following
	// circumstances:
	//
	//    * You can't use a health check that is defined by HealthCheckConfig because
	//    the resource isn't available over the internet. For example, you can use
	//    a custom health check when the instance is in an Amazon VPC. (To check
	//    the health of resources in a VPC, the health checker must also be in the
	//    VPC.)
	//
	//    * You want to use a third-party health checker regardless of where your
	//    resources are.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// To change the status of a custom health check, submit an UpdateInstanceCustomHealthStatus
	// request. Cloud Map doesn't monitor the status of the resource, it just keeps
	// a record of the status specified in the most recent UpdateInstanceCustomHealthStatus
	// request.
	//
	// Here's how custom health checks work:
	//
	// You create a service and specify a value for FailureThreshold.
	//
	// The failure threshold indicates the number of 30-second intervals you want
	// AWS Cloud Map to wait between the time that your application sends an UpdateInstanceCustomHealthStatus
	// request and the time that AWS Cloud Map stops routing internet traffic to
	// the corresponding resource.
	//
	// You register an instance.
	//
	// You configure a third-party health checker to monitor the resource that is
	// associated with the new instance.
	//
	// AWS Cloud Map doesn't check the health of the resource directly.
	//
	// The third-party health-checker determines that the resource is unhealthy
	// and notifies your application.
	//
	// Your application submits an UpdateInstanceCustomHealthStatus request.
	//
	// AWS Cloud Map waits for (FailureThreshold x 30) seconds.
	//
	// If another UpdateInstanceCustomHealthStatus request doesn't arrive during
	// that time to change the status back to healthy, AWS Cloud Map stops routing
	// traffic to the resource.
	//
	// Note the following about configuring custom health checks.
	HealthCheckCustomConfig *HealthCheckCustomConfig `type:"structure"`

	// The ID that AWS Cloud Map assigned to the service when you created it.
	Id *string `type:"string"`

	// The number of instances that are currently associated with the service. Instances
	// that were previously associated with the service but that have been deleted
	// are not included in the count.
	InstanceCount *int64 `type:"integer"`

	// The name of the service.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}
