// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/waf"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRateBasedRuleRequest
type UpdateRateBasedRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The maximum number of requests, which have an identical value in the field
	// specified by the RateKey, allowed in a five-minute period. If the number
	// of requests exceeds the RateLimit and the other predicates specified in the
	// rule are also met, AWS WAF triggers the action that is specified for this
	// rule.
	//
	// RateLimit is a required field
	RateLimit *int64 `min:"2000" type:"long" required:"true"`

	// The RuleId of the RateBasedRule that you want to update. RuleId is returned
	// by CreateRateBasedRule and by ListRateBasedRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`

	// An array of RuleUpdate objects that you want to insert into or delete from
	// a RateBasedRule.
	//
	// Updates is a required field
	Updates []waf.RuleUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRateBasedRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRateBasedRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRateBasedRuleInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.RateLimit == nil {
		invalidParams.Add(aws.NewErrParamRequired("RateLimit"))
	}
	if s.RateLimit != nil && *s.RateLimit < 2000 {
		invalidParams.Add(aws.NewErrParamMinValue("RateLimit", 2000))
	}

	if s.RuleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleId", 1))
	}

	if s.Updates == nil {
		invalidParams.Add(aws.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRateBasedRuleResponse
type UpdateRateBasedRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateRateBasedRule request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRateBasedRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRateBasedRule = "UpdateRateBasedRule"

// UpdateRateBasedRuleRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Inserts or deletes Predicate objects in a rule and updates the RateLimit
// in the rule.
//
// Each Predicate object identifies a predicate, such as a ByteMatchSet or an
// IPSet, that specifies the web requests that you want to block or count. The
// RateLimit specifies the number of requests every five minutes that triggers
// the rule.
//
// If you add more than one predicate to a RateBasedRule, a request must match
// all the predicates and exceed the RateLimit to be counted or blocked. For
// example, suppose you add the following to a RateBasedRule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// Further, you specify a RateLimit of 15,000.
//
// You then add the RateBasedRule to a WebACL and specify that you want to block
// requests that satisfy the rule. For a request to be blocked, it must come
// from the IP address 192.0.2.44 and the User-Agent header in the request must
// contain the value BadBot. Further, requests that match these two conditions
// much be received at a rate of more than 15,000 every five minutes. If the
// rate drops below this limit, AWS WAF no longer blocks the requests.
//
// As a second example, suppose you want to limit requests to a particular page
// on your site. To do this, you could add the following to a RateBasedRule:
//
//    * A ByteMatchSet with FieldToMatch of URI
//
//    * A PositionalConstraint of STARTS_WITH
//
//    * A TargetString of login
//
// Further, you specify a RateLimit of 15,000.
//
// By adding this RateBasedRule to a WebACL, you could limit requests to your
// login page without affecting the rest of your site.
//
//    // Example sending a request using UpdateRateBasedRuleRequest.
//    req := client.UpdateRateBasedRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRateBasedRule
func (c *Client) UpdateRateBasedRuleRequest(input *UpdateRateBasedRuleInput) UpdateRateBasedRuleRequest {
	op := &aws.Operation{
		Name:       opUpdateRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRateBasedRuleInput{}
	}

	req := c.newRequest(op, input, &UpdateRateBasedRuleOutput{})
	return UpdateRateBasedRuleRequest{Request: req, Input: input, Copy: c.UpdateRateBasedRuleRequest}
}

// UpdateRateBasedRuleRequest is the request type for the
// UpdateRateBasedRule API operation.
type UpdateRateBasedRuleRequest struct {
	*aws.Request
	Input *UpdateRateBasedRuleInput
	Copy  func(*UpdateRateBasedRuleInput) UpdateRateBasedRuleRequest
}

// Send marshals and sends the UpdateRateBasedRule API request.
func (r UpdateRateBasedRuleRequest) Send(ctx context.Context) (*UpdateRateBasedRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRateBasedRuleResponse{
		UpdateRateBasedRuleOutput: r.Request.Data.(*UpdateRateBasedRuleOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRateBasedRuleResponse is the response type for the
// UpdateRateBasedRule API operation.
type UpdateRateBasedRuleResponse struct {
	*UpdateRateBasedRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRateBasedRule request.
func (r *UpdateRateBasedRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
