// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateGroupRequest
type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The filter expression defining criteria by which to group traces.
	FilterExpression *string `type:"string"`

	// The case-sensitive name of the new group. Default is a reserved name and
	// names must be unique.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGroupInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGroupInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FilterExpression != nil {
		v := *s.FilterExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FilterExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateGroupResult
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The group that was created. Contains the name of the group that was created,
	// the ARN of the group that was generated based on the group name, and the
	// filter expression that was assigned to the group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Group != nil {
		v := s.Group

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Group", v, metadata)
	}
	return nil
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Creates a group resource with a name and a filter expression.
//
//    // Example sending a request using CreateGroupRequest.
//    req := client.CreateGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateGroup
func (c *Client) CreateGroupRequest(input *CreateGroupInput) CreateGroupRequest {
	op := &aws.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateGroup",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	req := c.newRequest(op, input, &CreateGroupOutput{})
	return CreateGroupRequest{Request: req, Input: input, Copy: c.CreateGroupRequest}
}

// CreateGroupRequest is the request type for the
// CreateGroup API operation.
type CreateGroupRequest struct {
	*aws.Request
	Input *CreateGroupInput
	Copy  func(*CreateGroupInput) CreateGroupRequest
}

// Send marshals and sends the CreateGroup API request.
func (r CreateGroupRequest) Send(ctx context.Context) (*CreateGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGroupResponse{
		CreateGroupOutput: r.Request.Data.(*CreateGroupOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGroupResponse is the response type for the
// CreateGroup API operation.
type CreateGroupResponse struct {
	*CreateGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGroup request.
func (r *CreateGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
