// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelDataRepositoryTask = "CancelDataRepositoryTask"

// CancelDataRepositoryTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelDataRepositoryTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelDataRepositoryTask for more information on using the CancelDataRepositoryTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelDataRepositoryTaskRequest method.
//    req, resp := client.CancelDataRepositoryTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CancelDataRepositoryTask
func (c *FSx) CancelDataRepositoryTaskRequest(input *CancelDataRepositoryTaskInput) (req *request.Request, output *CancelDataRepositoryTaskOutput) {
	op := &request.Operation{
		Name:       opCancelDataRepositoryTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelDataRepositoryTaskInput{}
	}

	output = &CancelDataRepositoryTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelDataRepositoryTask API operation for Amazon FSx.
//
// Cancels an existing Amazon FSx for Lustre data repository task if that task
// is in either the PENDING or EXECUTING state. When you cancel a task, Amazon
// FSx does the following.
//
//    * Any files that FSx has already exported are not reverted.
//
//    * FSx continues to export any files that are "in-flight" when the cancel
//    operation is received.
//
//    * FSx does not export any files that have not yet been exported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CancelDataRepositoryTask for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * UnsupportedOperation
//   The requested operation is not supported for this resource or API.
//
//   * DataRepositoryTaskNotFound
//   The data repository task or tasks you specified could not be found.
//
//   * DataRepositoryTaskEnded
//   The data repository task could not be canceled because the task has already
//   ended.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CancelDataRepositoryTask
func (c *FSx) CancelDataRepositoryTask(input *CancelDataRepositoryTaskInput) (*CancelDataRepositoryTaskOutput, error) {
	req, out := c.CancelDataRepositoryTaskRequest(input)
	return out, req.Send()
}

// CancelDataRepositoryTaskWithContext is the same as CancelDataRepositoryTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelDataRepositoryTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CancelDataRepositoryTaskWithContext(ctx aws.Context, input *CancelDataRepositoryTaskInput, opts ...request.Option) (*CancelDataRepositoryTaskOutput, error) {
	req, out := c.CancelDataRepositoryTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackup = "CreateBackup"

// CreateBackupRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackup for more information on using the CreateBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackupRequest method.
//    req, resp := client.CreateBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateBackup
func (c *FSx) CreateBackupRequest(input *CreateBackupInput) (req *request.Request, output *CreateBackupOutput) {
	op := &request.Operation{
		Name:       opCreateBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBackupInput{}
	}

	output = &CreateBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackup API operation for Amazon FSx.
//
// Creates a backup of an existing Amazon FSx for Windows File Server file system.
// Creating regular backups for your file system is a best practice that complements
// the replication that Amazon FSx for Windows File Server performs for your
// file system. It also enables you to restore from user modification of data.
//
// If a backup with the specified client request token exists, and the parameters
// match, this operation returns the description of the existing backup. If
// a backup specified client request token exists, and the parameters don't
// match, this operation returns IncompatibleParameterError. If a backup with
// the specified client request token doesn't exist, CreateBackup does the following:
//
//    * Creates a new Amazon FSx backup with an assigned ID, and an initial
//    lifecycle state of CREATING.
//
//    * Returns the description of the backup.
//
// By using the idempotent operation, you can retry a CreateBackup operation
// without the risk of creating an extra backup. This approach can be useful
// when an initial call fails in a way that makes it unclear whether a backup
// was created. If you use the same client request token and the initial call
// created a backup, the operation returns a successful result because all the
// parameters are the same.
//
// The CreateFileSystem operation returns while the backup's lifecycle state
// is still CREATING. You can check the file system creation status by calling
// the DescribeBackups operation, which returns the backup state along with
// other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CreateBackup for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * UnsupportedOperation
//   The requested operation is not supported for this resource or API.
//
//   * FileSystemNotFound
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * BackupInProgress
//   Another backup is already under way. Wait for completion before initiating
//   additional backups of this file system.
//
//   * IncompatibleParameterError
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ServiceLimitExceeded
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateBackup
func (c *FSx) CreateBackup(input *CreateBackupInput) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	return out, req.Send()
}

// CreateBackupWithContext is the same as CreateBackup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CreateBackupWithContext(ctx aws.Context, input *CreateBackupInput, opts ...request.Option) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataRepositoryTask = "CreateDataRepositoryTask"

// CreateDataRepositoryTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataRepositoryTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataRepositoryTask for more information on using the CreateDataRepositoryTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataRepositoryTaskRequest method.
//    req, resp := client.CreateDataRepositoryTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateDataRepositoryTask
func (c *FSx) CreateDataRepositoryTaskRequest(input *CreateDataRepositoryTaskInput) (req *request.Request, output *CreateDataRepositoryTaskOutput) {
	op := &request.Operation{
		Name:       opCreateDataRepositoryTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataRepositoryTaskInput{}
	}

	output = &CreateDataRepositoryTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataRepositoryTask API operation for Amazon FSx.
//
// Creates an Amazon FSx for Lustre data repository task. You use data repository
// tasks to perform bulk operations between your Amazon FSx file system and
// its linked data repository. An example of a data repository task is exporting
// any data and metadata changes, including POSIX metadata, to files, directories,
// and symbolic links (symlinks) from your FSx file system to its linked data
// repository. A CreateDataRepositoryTask operation will fail if a data repository
// is not linked to the FSx file system. To learn more about data repository
// tasks, see Using Data Repository Tasks (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html).
// To learn more about linking a data repository to your file system, see Setting
// the Export Prefix (https://docs.aws.amazon.com/fsx/latest/LustreGuide/export-data-repository.html#export-prefix).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CreateDataRepositoryTask for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * UnsupportedOperation
//   The requested operation is not supported for this resource or API.
//
//   * FileSystemNotFound
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * IncompatibleParameterError
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * ServiceLimitExceeded
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
//   * DataRepositoryTaskExecuting
//   An existing data repository task is currently executing on the file system.
//   Wait until the existing task has completed, then create the new task.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateDataRepositoryTask
func (c *FSx) CreateDataRepositoryTask(input *CreateDataRepositoryTaskInput) (*CreateDataRepositoryTaskOutput, error) {
	req, out := c.CreateDataRepositoryTaskRequest(input)
	return out, req.Send()
}

// CreateDataRepositoryTaskWithContext is the same as CreateDataRepositoryTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataRepositoryTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CreateDataRepositoryTaskWithContext(ctx aws.Context, input *CreateDataRepositoryTaskInput, opts ...request.Option) (*CreateDataRepositoryTaskOutput, error) {
	req, out := c.CreateDataRepositoryTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFileSystem = "CreateFileSystem"

// CreateFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the CreateFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFileSystem for more information on using the CreateFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFileSystemRequest method.
//    req, resp := client.CreateFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystem
func (c *FSx) CreateFileSystemRequest(input *CreateFileSystemInput) (req *request.Request, output *CreateFileSystemOutput) {
	op := &request.Operation{
		Name:       opCreateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFileSystemInput{}
	}

	output = &CreateFileSystemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFileSystem API operation for Amazon FSx.
//
// Creates a new, empty Amazon FSx file system.
//
// If a file system with the specified client request token exists and the parameters
// match, CreateFileSystem returns the description of the existing file system.
// If a file system specified client request token exists and the parameters
// don't match, this call returns IncompatibleParameterError. If a file system
// with the specified client request token doesn't exist, CreateFileSystem does
// the following:
//
//    * Creates a new, empty Amazon FSx file system with an assigned ID, and
//    an initial lifecycle state of CREATING.
//
//    * Returns the description of the file system.
//
// This operation requires a client request token in the request that Amazon
// FSx uses to ensure idempotent creation. This means that calling the operation
// multiple times with the same client request token has no effect. By using
// the idempotent operation, you can retry a CreateFileSystem operation without
// the risk of creating an extra file system. This approach can be useful when
// an initial call fails in a way that makes it unclear whether a file system
// was created. Examples are if a transport level timeout occurred, or your
// connection was reset. If you use the same client request token and the initial
// call created a file system, the client receives success as long as the parameters
// are the same.
//
// The CreateFileSystem call returns while the file system's lifecycle state
// is still CREATING. You can check the file-system creation status by calling
// the DescribeFileSystems operation, which returns the file system state along
// with other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CreateFileSystem for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * ActiveDirectoryError
//   An Active Directory error.
//
//   * IncompatibleParameterError
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * InvalidImportPath
//   The path provided for data repository import isn't valid.
//
//   * InvalidExportPath
//   The path provided for data repository export isn't valid.
//
//   * InvalidNetworkSettings
//   One or more network settings specified in the request are invalid. InvalidVpcId
//   means that the ID passed for the virtual private cloud (VPC) is invalid.
//   InvalidSubnetIds returns the list of IDs for subnets that are either invalid
//   or not part of the VPC specified. InvalidSecurityGroupIds returns the list
//   of IDs for security groups that are either invalid or not part of the VPC
//   specified.
//
//   * InvalidPerUnitStorageThroughput
//   An invalid value for PerUnitStorageThroughput was provided. Please create
//   your file system again, using a valid value.
//
//   * ServiceLimitExceeded
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
//   * MissingFileSystemConfiguration
//   A file system configuration is required for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystem
func (c *FSx) CreateFileSystem(input *CreateFileSystemInput) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	return out, req.Send()
}

// CreateFileSystemWithContext is the same as CreateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CreateFileSystemWithContext(ctx aws.Context, input *CreateFileSystemInput, opts ...request.Option) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFileSystemFromBackup = "CreateFileSystemFromBackup"

// CreateFileSystemFromBackupRequest generates a "aws/request.Request" representing the
// client's request for the CreateFileSystemFromBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFileSystemFromBackup for more information on using the CreateFileSystemFromBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFileSystemFromBackupRequest method.
//    req, resp := client.CreateFileSystemFromBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemFromBackup
func (c *FSx) CreateFileSystemFromBackupRequest(input *CreateFileSystemFromBackupInput) (req *request.Request, output *CreateFileSystemFromBackupOutput) {
	op := &request.Operation{
		Name:       opCreateFileSystemFromBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFileSystemFromBackupInput{}
	}

	output = &CreateFileSystemFromBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFileSystemFromBackup API operation for Amazon FSx.
//
// Creates a new Amazon FSx file system from an existing Amazon FSx for Windows
// File Server backup.
//
// If a file system with the specified client request token exists and the parameters
// match, this operation returns the description of the file system. If a client
// request token specified by the file system exists and the parameters don't
// match, this call returns IncompatibleParameterError. If a file system with
// the specified client request token doesn't exist, this operation does the
// following:
//
//    * Creates a new Amazon FSx file system from backup with an assigned ID,
//    and an initial lifecycle state of CREATING.
//
//    * Returns the description of the file system.
//
// Parameters like Active Directory, default share name, automatic backup, and
// backup settings default to the parameters of the file system that was backed
// up, unless overridden. You can explicitly supply other settings.
//
// By using the idempotent operation, you can retry a CreateFileSystemFromBackup
// call without the risk of creating an extra file system. This approach can
// be useful when an initial call fails in a way that makes it unclear whether
// a file system was created. Examples are if a transport level timeout occurred,
// or your connection was reset. If you use the same client request token and
// the initial call created a file system, the client receives success as long
// as the parameters are the same.
//
// The CreateFileSystemFromBackup call returns while the file system's lifecycle
// state is still CREATING. You can check the file-system creation status by
// calling the DescribeFileSystems operation, which returns the file system
// state along with other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation CreateFileSystemFromBackup for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * ActiveDirectoryError
//   An Active Directory error.
//
//   * IncompatibleParameterError
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * InvalidNetworkSettings
//   One or more network settings specified in the request are invalid. InvalidVpcId
//   means that the ID passed for the virtual private cloud (VPC) is invalid.
//   InvalidSubnetIds returns the list of IDs for subnets that are either invalid
//   or not part of the VPC specified. InvalidSecurityGroupIds returns the list
//   of IDs for security groups that are either invalid or not part of the VPC
//   specified.
//
//   * ServiceLimitExceeded
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * BackupNotFound
//   No Amazon FSx backups were found based upon the supplied parameters.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
//   * MissingFileSystemConfiguration
//   A file system configuration is required for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemFromBackup
func (c *FSx) CreateFileSystemFromBackup(input *CreateFileSystemFromBackupInput) (*CreateFileSystemFromBackupOutput, error) {
	req, out := c.CreateFileSystemFromBackupRequest(input)
	return out, req.Send()
}

// CreateFileSystemFromBackupWithContext is the same as CreateFileSystemFromBackup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystemFromBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) CreateFileSystemFromBackupWithContext(ctx aws.Context, input *CreateFileSystemFromBackupInput, opts ...request.Option) (*CreateFileSystemFromBackupOutput, error) {
	req, out := c.CreateFileSystemFromBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackup = "DeleteBackup"

// DeleteBackupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackup for more information on using the DeleteBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackupRequest method.
//    req, resp := client.DeleteBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteBackup
func (c *FSx) DeleteBackupRequest(input *DeleteBackupInput) (req *request.Request, output *DeleteBackupOutput) {
	op := &request.Operation{
		Name:       opDeleteBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBackupInput{}
	}

	output = &DeleteBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackup API operation for Amazon FSx.
//
// Deletes an Amazon FSx for Windows File Server backup, deleting its contents.
// After deletion, the backup no longer exists, and its data is gone.
//
// The DeleteBackup call returns instantly. The backup will not show up in later
// DescribeBackups calls.
//
// The data in a deleted backup is also deleted and can't be recovered by any
// means.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DeleteBackup for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * BackupInProgress
//   Another backup is already under way. Wait for completion before initiating
//   additional backups of this file system.
//
//   * BackupNotFound
//   No Amazon FSx backups were found based upon the supplied parameters.
//
//   * BackupRestoring
//   You can't delete a backup while it's being used to restore a file system.
//
//   * IncompatibleParameterError
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteBackup
func (c *FSx) DeleteBackup(input *DeleteBackupInput) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	return out, req.Send()
}

// DeleteBackupWithContext is the same as DeleteBackup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DeleteBackupWithContext(ctx aws.Context, input *DeleteBackupInput, opts ...request.Option) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFileSystem = "DeleteFileSystem"

// DeleteFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFileSystem for more information on using the DeleteFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFileSystemRequest method.
//    req, resp := client.DeleteFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem
func (c *FSx) DeleteFileSystemRequest(input *DeleteFileSystemInput) (req *request.Request, output *DeleteFileSystemOutput) {
	op := &request.Operation{
		Name:       opDeleteFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFileSystemInput{}
	}

	output = &DeleteFileSystemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFileSystem API operation for Amazon FSx.
//
// Deletes a file system, deleting its contents. After deletion, the file system
// no longer exists, and its data is gone. Any existing automatic backups will
// also be deleted.
//
// By default, when you delete an Amazon FSx for Windows File Server file system,
// a final backup is created upon deletion. This final backup is not subject
// to the file system's retention policy, and must be manually deleted.
//
// The DeleteFileSystem action returns while the file system has the DELETING
// status. You can check the file system deletion status by calling the DescribeFileSystems
// action, which returns a list of file systems in your account. If you pass
// the file system ID for a deleted file system, the DescribeFileSystems returns
// a FileSystemNotFound error.
//
// Deleting an Amazon FSx for Lustre file system will fail with a 400 BadRequest
// if a data repository task is in a PENDING or EXECUTING state.
//
// The data in a deleted file system is also deleted and can't be recovered
// by any means.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DeleteFileSystem for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * IncompatibleParameterError
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * FileSystemNotFound
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * ServiceLimitExceeded
//   An error indicating that a particular service limit was exceeded. You can
//   increase some service limits by contacting AWS Support.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem
func (c *FSx) DeleteFileSystem(input *DeleteFileSystemInput) (*DeleteFileSystemOutput, error) {
	req, out := c.DeleteFileSystemRequest(input)
	return out, req.Send()
}

// DeleteFileSystemWithContext is the same as DeleteFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DeleteFileSystemWithContext(ctx aws.Context, input *DeleteFileSystemInput, opts ...request.Option) (*DeleteFileSystemOutput, error) {
	req, out := c.DeleteFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackups = "DescribeBackups"

// DescribeBackupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackups for more information on using the DescribeBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBackupsRequest method.
//    req, resp := client.DescribeBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups
func (c *FSx) DescribeBackupsRequest(input *DescribeBackupsInput) (req *request.Request, output *DescribeBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBackupsInput{}
	}

	output = &DescribeBackupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBackups API operation for Amazon FSx.
//
// Returns the description of specific Amazon FSx for Windows File Server backups,
// if a BackupIds value is provided for that backup. Otherwise, it returns all
// backups owned by your AWS account in the AWS Region of the endpoint that
// you're calling.
//
// When retrieving all backups, you can optionally specify the MaxResults parameter
// to limit the number of backups in a response. If more backups remain, Amazon
// FSx returns a NextToken value in the response. In this case, send a later
// request with the NextToken request parameter set to the value of NextToken
// from the last response.
//
// This action is used in an iterative process to retrieve a list of your backups.
// DescribeBackups is called first without a NextTokenvalue. Then the action
// continues to be called with the NextToken parameter set to the value of the
// last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of backups returned in the response of one DescribeBackups
//    call and the order of backups returned across the responses of a multi-call
//    iteration is unspecified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DescribeBackups for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * FileSystemNotFound
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * BackupNotFound
//   No Amazon FSx backups were found based upon the supplied parameters.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeBackups
func (c *FSx) DescribeBackups(input *DescribeBackupsInput) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	return out, req.Send()
}

// DescribeBackupsWithContext is the same as DescribeBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeBackupsWithContext(ctx aws.Context, input *DescribeBackupsInput, opts ...request.Option) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeBackupsPages iterates over the pages of a DescribeBackups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeBackups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeBackups operation.
//    pageNum := 0
//    err := client.DescribeBackupsPages(params,
//        func(page *fsx.DescribeBackupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FSx) DescribeBackupsPages(input *DescribeBackupsInput, fn func(*DescribeBackupsOutput, bool) bool) error {
	return c.DescribeBackupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeBackupsPagesWithContext same as DescribeBackupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeBackupsPagesWithContext(ctx aws.Context, input *DescribeBackupsInput, fn func(*DescribeBackupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeBackupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBackupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeBackupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDataRepositoryTasks = "DescribeDataRepositoryTasks"

// DescribeDataRepositoryTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataRepositoryTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataRepositoryTasks for more information on using the DescribeDataRepositoryTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataRepositoryTasksRequest method.
//    req, resp := client.DescribeDataRepositoryTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeDataRepositoryTasks
func (c *FSx) DescribeDataRepositoryTasksRequest(input *DescribeDataRepositoryTasksInput) (req *request.Request, output *DescribeDataRepositoryTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeDataRepositoryTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDataRepositoryTasksInput{}
	}

	output = &DescribeDataRepositoryTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataRepositoryTasks API operation for Amazon FSx.
//
// Returns the description of specific Amazon FSx for Lustre data repository
// tasks, if one or more TaskIds values are provided in the request, or if filters
// are used in the request. You can use filters to narrow the response to include
// just tasks for specific file systems, or tasks in a specific lifecycle state.
// Otherwise, it returns all data repository tasks owned by your AWS account
// in the AWS Region of the endpoint that you're calling.
//
// When retrieving all tasks, you can paginate the response by using the optional
// MaxResults parameter to limit the number of tasks returned in a response.
// If more tasks remain, Amazon FSx returns a NextToken value in the response.
// In this case, send a later request with the NextToken request parameter set
// to the value of NextToken from the last response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DescribeDataRepositoryTasks for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * FileSystemNotFound
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * DataRepositoryTaskNotFound
//   The data repository task or tasks you specified could not be found.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeDataRepositoryTasks
func (c *FSx) DescribeDataRepositoryTasks(input *DescribeDataRepositoryTasksInput) (*DescribeDataRepositoryTasksOutput, error) {
	req, out := c.DescribeDataRepositoryTasksRequest(input)
	return out, req.Send()
}

// DescribeDataRepositoryTasksWithContext is the same as DescribeDataRepositoryTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataRepositoryTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeDataRepositoryTasksWithContext(ctx aws.Context, input *DescribeDataRepositoryTasksInput, opts ...request.Option) (*DescribeDataRepositoryTasksOutput, error) {
	req, out := c.DescribeDataRepositoryTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDataRepositoryTasksPages iterates over the pages of a DescribeDataRepositoryTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDataRepositoryTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDataRepositoryTasks operation.
//    pageNum := 0
//    err := client.DescribeDataRepositoryTasksPages(params,
//        func(page *fsx.DescribeDataRepositoryTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FSx) DescribeDataRepositoryTasksPages(input *DescribeDataRepositoryTasksInput, fn func(*DescribeDataRepositoryTasksOutput, bool) bool) error {
	return c.DescribeDataRepositoryTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDataRepositoryTasksPagesWithContext same as DescribeDataRepositoryTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeDataRepositoryTasksPagesWithContext(ctx aws.Context, input *DescribeDataRepositoryTasksInput, fn func(*DescribeDataRepositoryTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDataRepositoryTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDataRepositoryTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDataRepositoryTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFileSystems = "DescribeFileSystems"

// DescribeFileSystemsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFileSystems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFileSystems for more information on using the DescribeFileSystems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFileSystemsRequest method.
//    req, resp := client.DescribeFileSystemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems
func (c *FSx) DescribeFileSystemsRequest(input *DescribeFileSystemsInput) (req *request.Request, output *DescribeFileSystemsOutput) {
	op := &request.Operation{
		Name:       opDescribeFileSystems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFileSystemsInput{}
	}

	output = &DescribeFileSystemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFileSystems API operation for Amazon FSx.
//
// Returns the description of specific Amazon FSx file systems, if a FileSystemIds
// value is provided for that file system. Otherwise, it returns descriptions
// of all file systems owned by your AWS account in the AWS Region of the endpoint
// that you're calling.
//
// When retrieving all file system descriptions, you can optionally specify
// the MaxResults parameter to limit the number of descriptions in a response.
// If more file system descriptions remain, Amazon FSx returns a NextToken value
// in the response. In this case, send a later request with the NextToken request
// parameter set to the value of NextToken from the last response.
//
// This action is used in an iterative process to retrieve a list of your file
// system descriptions. DescribeFileSystems is called first without a NextTokenvalue.
// Then the action continues to be called with the NextToken parameter set to
// the value of the last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of file systems returned in the response of one DescribeFileSystems
//    call and the order of file systems returned across the responses of a
//    multicall iteration is unspecified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation DescribeFileSystems for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * FileSystemNotFound
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems
func (c *FSx) DescribeFileSystems(input *DescribeFileSystemsInput) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	return out, req.Send()
}

// DescribeFileSystemsWithContext is the same as DescribeFileSystems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFileSystems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeFileSystemsWithContext(ctx aws.Context, input *DescribeFileSystemsInput, opts ...request.Option) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFileSystemsPages iterates over the pages of a DescribeFileSystems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFileSystems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeFileSystems operation.
//    pageNum := 0
//    err := client.DescribeFileSystemsPages(params,
//        func(page *fsx.DescribeFileSystemsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FSx) DescribeFileSystemsPages(input *DescribeFileSystemsInput, fn func(*DescribeFileSystemsOutput, bool) bool) error {
	return c.DescribeFileSystemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFileSystemsPagesWithContext same as DescribeFileSystemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) DescribeFileSystemsPagesWithContext(ctx aws.Context, input *DescribeFileSystemsInput, fn func(*DescribeFileSystemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFileSystemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFileSystemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFileSystemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/ListTagsForResource
func (c *FSx) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon FSx.
//
// Lists tags for an Amazon FSx file systems and backups in the case of Amazon
// FSx for Windows File Server.
//
// When retrieving all tags, you can optionally specify the MaxResults parameter
// to limit the number of tags in a response. If more tags remain, Amazon FSx
// returns a NextToken value in the response. In this case, send a later request
// with the NextToken request parameter set to the value of NextToken from the
// last response.
//
// This action is used in an iterative process to retrieve a list of your tags.
// ListTagsForResource is called first without a NextTokenvalue. Then the action
// continues to be called with the NextToken parameter set to the value of the
// last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of tags returned in the response of one ListTagsForResource
//    call and the order of tags returned across the responses of a multi-call
//    iteration is unspecified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
//   * ResourceNotFound
//   The resource specified by the Amazon Resource Name (ARN) can't be found.
//
//   * NotServiceResourceError
//   The resource specified for the tagging operation is not a resource type owned
//   by Amazon FSx. Use the API of the relevant service to perform the operation.
//
//   * ResourceDoesNotSupportTagging
//   The resource specified does not support tagging.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/ListTagsForResource
func (c *FSx) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/TagResource
func (c *FSx) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon FSx.
//
// Tags an Amazon FSx resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
//   * ResourceNotFound
//   The resource specified by the Amazon Resource Name (ARN) can't be found.
//
//   * NotServiceResourceError
//   The resource specified for the tagging operation is not a resource type owned
//   by Amazon FSx. Use the API of the relevant service to perform the operation.
//
//   * ResourceDoesNotSupportTagging
//   The resource specified does not support tagging.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/TagResource
func (c *FSx) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UntagResource
func (c *FSx) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon FSx.
//
// This action removes a tag from an Amazon FSx resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
//   * ResourceNotFound
//   The resource specified by the Amazon Resource Name (ARN) can't be found.
//
//   * NotServiceResourceError
//   The resource specified for the tagging operation is not a resource type owned
//   by Amazon FSx. Use the API of the relevant service to perform the operation.
//
//   * ResourceDoesNotSupportTagging
//   The resource specified does not support tagging.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UntagResource
func (c *FSx) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFileSystem = "UpdateFileSystem"

// UpdateFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFileSystem for more information on using the UpdateFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFileSystemRequest method.
//    req, resp := client.UpdateFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystem
func (c *FSx) UpdateFileSystemRequest(input *UpdateFileSystemInput) (req *request.Request, output *UpdateFileSystemOutput) {
	op := &request.Operation{
		Name:       opUpdateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFileSystemInput{}
	}

	output = &UpdateFileSystemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFileSystem API operation for Amazon FSx.
//
// Updates a file system configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon FSx's
// API operation UpdateFileSystem for usage and error information.
//
// Returned Error Types:
//   * BadRequest
//   A generic error indicating a failure with a client request.
//
//   * UnsupportedOperation
//   The requested operation is not supported for this resource or API.
//
//   * IncompatibleParameterError
//   The error returned when a second request is received with the same client
//   request token but different parameters settings. A client request token should
//   always uniquely identify a single request.
//
//   * InternalServerError
//   A generic error indicating a server-side failure.
//
//   * FileSystemNotFound
//   No Amazon FSx file systems were found based upon supplied parameters.
//
//   * MissingFileSystemConfiguration
//   A file system configuration is required for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystem
func (c *FSx) UpdateFileSystem(input *UpdateFileSystemInput) (*UpdateFileSystemOutput, error) {
	req, out := c.UpdateFileSystemRequest(input)
	return out, req.Send()
}

// UpdateFileSystemWithContext is the same as UpdateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FSx) UpdateFileSystemWithContext(ctx aws.Context, input *UpdateFileSystemInput, opts ...request.Option) (*UpdateFileSystemOutput, error) {
	req, out := c.UpdateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The Microsoft AD attributes of the Amazon FSx for Windows File Server file
// system.
type ActiveDirectoryBackupAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS Managed Microsoft Active Directory instance to which the
	// file system is joined.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ActiveDirectoryBackupAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveDirectoryBackupAttributes) GoString() string {
	return s.String()
}

// SetActiveDirectoryId sets the ActiveDirectoryId field's value.
func (s *ActiveDirectoryBackupAttributes) SetActiveDirectoryId(v string) *ActiveDirectoryBackupAttributes {
	s.ActiveDirectoryId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ActiveDirectoryBackupAttributes) SetDomainName(v string) *ActiveDirectoryBackupAttributes {
	s.DomainName = &v
	return s
}

// An Active Directory error.
type ActiveDirectoryError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The directory ID of the directory that an error pertains to.
	//
	// ActiveDirectoryId is a required field
	ActiveDirectoryId *string `min:"12" type:"string" required:"true"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The type of Active Directory error.
	Type *string `type:"string" enum:"ActiveDirectoryErrorType"`
}

// String returns the string representation
func (s ActiveDirectoryError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveDirectoryError) GoString() string {
	return s.String()
}

func newErrorActiveDirectoryError(v protocol.ResponseMetadata) error {
	return &ActiveDirectoryError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ActiveDirectoryError) Code() string {
	return "ActiveDirectoryError"
}

// Message returns the exception's message.
func (s *ActiveDirectoryError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ActiveDirectoryError) OrigErr() error {
	return nil
}

func (s *ActiveDirectoryError) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ActiveDirectoryError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ActiveDirectoryError) RequestID() string {
	return s.RespMetadata.RequestID
}

// A backup of an Amazon FSx for Windows File Server file system. You can create
// a new file system from a backup to protect against data loss.
type Backup struct {
	_ struct{} `type:"structure"`

	// The ID of the backup.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// The time when a particular backup was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The configuration of the self-managed Microsoft Active Directory (AD) to
	// which the Windows File Server instance is joined.
	DirectoryInformation *ActiveDirectoryBackupAttributes `type:"structure"`

	// Details explaining any failures that occur when creating a backup.
	FailureDetails *BackupFailureDetails `type:"structure"`

	// Metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// FileSystem is a required field
	FileSystem *FileSystem `type:"structure" required:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt this
	// backup of the Amazon FSx for Windows file system's data at rest. Amazon FSx
	// for Lustre does not support KMS encryption.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the backup.
	//
	// Lifecycle is a required field
	Lifecycle *string `type:"string" required:"true" enum:"BackupLifecycle"`

	// The current percent of progress of an asynchronous task.
	ProgressPercent *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string `min:"8" type:"string"`

	// Tags associated with a particular file system.
	Tags []*Tag `min:"1" type:"list"`

	// The type of the backup.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"BackupType"`
}

// String returns the string representation
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Backup) GoString() string {
	return s.String()
}

// SetBackupId sets the BackupId field's value.
func (s *Backup) SetBackupId(v string) *Backup {
	s.BackupId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Backup) SetCreationTime(v time.Time) *Backup {
	s.CreationTime = &v
	return s
}

// SetDirectoryInformation sets the DirectoryInformation field's value.
func (s *Backup) SetDirectoryInformation(v *ActiveDirectoryBackupAttributes) *Backup {
	s.DirectoryInformation = v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *Backup) SetFailureDetails(v *BackupFailureDetails) *Backup {
	s.FailureDetails = v
	return s
}

// SetFileSystem sets the FileSystem field's value.
func (s *Backup) SetFileSystem(v *FileSystem) *Backup {
	s.FileSystem = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Backup) SetKmsKeyId(v string) *Backup {
	s.KmsKeyId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *Backup) SetLifecycle(v string) *Backup {
	s.Lifecycle = &v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *Backup) SetProgressPercent(v int64) *Backup {
	s.ProgressPercent = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *Backup) SetResourceARN(v string) *Backup {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Backup) SetTags(v []*Tag) *Backup {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Backup) SetType(v string) *Backup {
	s.Type = &v
	return s
}

// If backup creation fails, this structure contains the details of that failure.
type BackupFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing the backup creation failure.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BackupFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupFailureDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *BackupFailureDetails) SetMessage(v string) *BackupFailureDetails {
	s.Message = &v
	return s
}

// Another backup is already under way. Wait for completion before initiating
// additional backups of this file system.
type BackupInProgress struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s BackupInProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupInProgress) GoString() string {
	return s.String()
}

func newErrorBackupInProgress(v protocol.ResponseMetadata) error {
	return &BackupInProgress{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BackupInProgress) Code() string {
	return "BackupInProgress"
}

// Message returns the exception's message.
func (s *BackupInProgress) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BackupInProgress) OrigErr() error {
	return nil
}

func (s *BackupInProgress) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BackupInProgress) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BackupInProgress) RequestID() string {
	return s.RespMetadata.RequestID
}

// No Amazon FSx backups were found based upon the supplied parameters.
type BackupNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s BackupNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupNotFound) GoString() string {
	return s.String()
}

func newErrorBackupNotFound(v protocol.ResponseMetadata) error {
	return &BackupNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BackupNotFound) Code() string {
	return "BackupNotFound"
}

// Message returns the exception's message.
func (s *BackupNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BackupNotFound) OrigErr() error {
	return nil
}

func (s *BackupNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BackupNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BackupNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// You can't delete a backup while it's being used to restore a file system.
type BackupRestoring struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The ID of a file system being restored from the backup.
	FileSystemId *string `min:"11" type:"string"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s BackupRestoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupRestoring) GoString() string {
	return s.String()
}

func newErrorBackupRestoring(v protocol.ResponseMetadata) error {
	return &BackupRestoring{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BackupRestoring) Code() string {
	return "BackupRestoring"
}

// Message returns the exception's message.
func (s *BackupRestoring) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BackupRestoring) OrigErr() error {
	return nil
}

func (s *BackupRestoring) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BackupRestoring) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BackupRestoring) RequestID() string {
	return s.RespMetadata.RequestID
}

// A generic error indicating a failure with a client request.
type BadRequest struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s BadRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequest) GoString() string {
	return s.String()
}

func newErrorBadRequest(v protocol.ResponseMetadata) error {
	return &BadRequest{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequest) Code() string {
	return "BadRequest"
}

// Message returns the exception's message.
func (s *BadRequest) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequest) OrigErr() error {
	return nil
}

func (s *BadRequest) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequest) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequest) RequestID() string {
	return s.RespMetadata.RequestID
}

// Cancels a data repository task.
type CancelDataRepositoryTaskInput struct {
	_ struct{} `type:"structure"`

	// Specifies the data repository task to cancel.
	//
	// TaskId is a required field
	TaskId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelDataRepositoryTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelDataRepositoryTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelDataRepositoryTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelDataRepositoryTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *CancelDataRepositoryTaskInput) SetTaskId(v string) *CancelDataRepositoryTaskInput {
	s.TaskId = &v
	return s
}

type CancelDataRepositoryTaskOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle status of the data repository task, as follows:
	//
	//    * PENDING - Amazon FSx has not started the task.
	//
	//    * EXECUTING - Amazon FSx is processing the task.
	//
	//    * FAILED - Amazon FSx was not able to complete the task. For example,
	//    there may be files the task failed to process. The DataRepositoryTaskFailureDetails
	//    property provides more information about task failures.
	//
	//    * SUCCEEDED - FSx completed the task successfully.
	//
	//    * CANCELED - Amazon FSx canceled the task and it did not complete.
	//
	//    * CANCELING - FSx is in process of canceling the task.
	Lifecycle *string `type:"string" enum:"DataRepositoryTaskLifecycle"`

	// The ID of the task being canceled.
	TaskId *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CancelDataRepositoryTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelDataRepositoryTaskOutput) GoString() string {
	return s.String()
}

// SetLifecycle sets the Lifecycle field's value.
func (s *CancelDataRepositoryTaskOutput) SetLifecycle(v string) *CancelDataRepositoryTaskOutput {
	s.Lifecycle = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *CancelDataRepositoryTaskOutput) SetTaskId(v string) *CancelDataRepositoryTaskOutput {
	s.TaskId = &v
	return s
}

// Provides a report detailing the data repository task results of the files
// processed that match the criteria specified in the report Scope parameter.
// FSx delivers the report to the file system's linked data repository in Amazon
// S3, using the path specified in the report Path parameter. You can specify
// whether or not a report gets generated for a task using the Enabled parameter.
type CompletionReport struct {
	_ struct{} `type:"structure"`

	// Set Enabled to True to generate a CompletionReport when the task completes.
	// If set to true, then you need to provide a report Scope, Path, and Format.
	// Set Enabled to False if you do not want a CompletionReport generated when
	// the task completes.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Required if Enabled is set to true. Specifies the format of the CompletionReport.
	// REPORT_CSV_20191124 is the only format currently supported. When Format is
	// set to REPORT_CSV_20191124, the CompletionReport is provided in CSV format,
	// and is delivered to {path}/task-{id}/failures.csv.
	Format *string `type:"string" enum:"ReportFormat"`

	// Required if Enabled is set to true. Specifies the location of the report
	// on the file system's linked S3 data repository. An absolute path that defines
	// where the completion report will be stored in the destination location. The
	// Path you provide must be located within the file system’s ExportPath. An
	// example Path value is "s3://myBucket/myExportPath/optionalPrefix". The report
	// provides the following information for each file in the report: FilePath,
	// FileStatus, and ErrorCode. To learn more about a file system's ExportPath,
	// see .
	Path *string `min:"3" type:"string"`

	// Required if Enabled is set to true. Specifies the scope of the CompletionReport;
	// FAILED_FILES_ONLY is the only scope currently supported. When Scope is set
	// to FAILED_FILES_ONLY, the CompletionReport only contains information about
	// files that the data repository task failed to process.
	Scope *string `type:"string" enum:"ReportScope"`
}

// String returns the string representation
func (s CompletionReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletionReport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompletionReport) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompletionReport"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Path != nil && len(*s.Path) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CompletionReport) SetEnabled(v bool) *CompletionReport {
	s.Enabled = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CompletionReport) SetFormat(v string) *CompletionReport {
	s.Format = &v
	return s
}

// SetPath sets the Path field's value.
func (s *CompletionReport) SetPath(v string) *CompletionReport {
	s.Path = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *CompletionReport) SetScope(v string) *CompletionReport {
	s.Scope = &v
	return s
}

// The request object for the CreateBackup operation.
type CreateBackupInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent creation. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the file system to back up.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The tags to apply to the backup at backup creation. The key value of the
	// Name tag appears in the console as the backup name.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackupInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateBackupInput) SetClientRequestToken(v string) *CreateBackupInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateBackupInput) SetFileSystemId(v string) *CreateBackupInput {
	s.FileSystemId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBackupInput) SetTags(v []*Tag) *CreateBackupInput {
	s.Tags = v
	return s
}

// The response object for the CreateBackup operation.
type CreateBackupOutput struct {
	_ struct{} `type:"structure"`

	// A description of the backup.
	Backup *Backup `type:"structure"`
}

// String returns the string representation
func (s CreateBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupOutput) GoString() string {
	return s.String()
}

// SetBackup sets the Backup field's value.
func (s *CreateBackupOutput) SetBackup(v *Backup) *CreateBackupOutput {
	s.Backup = v
	return s
}

type CreateDataRepositoryTaskInput struct {
	_ struct{} `type:"structure"`

	// (Optional) An idempotency token for resource creation, in a string of up
	// to 64 ASCII characters. This token is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// (Optional) The path or paths on the Amazon FSx file system to use when the
	// data repository task is processed. The default path is the file system root
	// directory. The paths you provide need to be relative to the mount point of
	// the file system. If the mount point is /mnt/fsx and /mnt/fsx/path1 is a directory
	// or file on the file system you want to export, then the path to provide is
	// path1. If a path that you provide isn't valid, the task fails.
	Paths []*string `type:"list"`

	// Defines whether or not Amazon FSx provides a CompletionReport once the task
	// has completed. A CompletionReport provides a detailed report on the files
	// that Amazon FSx processed that meet the criteria specified by the Scope parameter.
	// For more information, see Working with Task Completion Reports (https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html).
	//
	// Report is a required field
	Report *CompletionReport `type:"structure" required:"true"`

	// A list of Tag values, with a maximum of 50 elements.
	Tags []*Tag `min:"1" type:"list"`

	// Specifies the type of data repository task to create.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataRepositoryTaskType"`
}

// String returns the string representation
func (s CreateDataRepositoryTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataRepositoryTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataRepositoryTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataRepositoryTaskInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.Report == nil {
		invalidParams.Add(request.NewErrParamRequired("Report"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Report != nil {
		if err := s.Report.Validate(); err != nil {
			invalidParams.AddNested("Report", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDataRepositoryTaskInput) SetClientRequestToken(v string) *CreateDataRepositoryTaskInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateDataRepositoryTaskInput) SetFileSystemId(v string) *CreateDataRepositoryTaskInput {
	s.FileSystemId = &v
	return s
}

// SetPaths sets the Paths field's value.
func (s *CreateDataRepositoryTaskInput) SetPaths(v []*string) *CreateDataRepositoryTaskInput {
	s.Paths = v
	return s
}

// SetReport sets the Report field's value.
func (s *CreateDataRepositoryTaskInput) SetReport(v *CompletionReport) *CreateDataRepositoryTaskInput {
	s.Report = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataRepositoryTaskInput) SetTags(v []*Tag) *CreateDataRepositoryTaskInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataRepositoryTaskInput) SetType(v string) *CreateDataRepositoryTaskInput {
	s.Type = &v
	return s
}

type CreateDataRepositoryTaskOutput struct {
	_ struct{} `type:"structure"`

	// The description of the data repository task that you just created.
	DataRepositoryTask *DataRepositoryTask `type:"structure"`
}

// String returns the string representation
func (s CreateDataRepositoryTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataRepositoryTaskOutput) GoString() string {
	return s.String()
}

// SetDataRepositoryTask sets the DataRepositoryTask field's value.
func (s *CreateDataRepositoryTaskOutput) SetDataRepositoryTask(v *DataRepositoryTask) *CreateDataRepositoryTaskOutput {
	s.DataRepositoryTask = v
	return s
}

// The request object for the CreateFileSystemFromBackup operation.
type CreateFileSystemFromBackupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup. Specifies the backup to use if you're creating a file
	// system from an existing backup.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent creation. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A list of IDs for the security groups that apply to the specified network
	// interfaces created for file system access. These security groups apply to
	// all network interfaces. This value isn't returned in later DescribeFileSystem
	// requests.
	SecurityGroupIds []*string `type:"list"`

	// Sets the storage type for the Windows file system you're creating from a
	// backup. Valid values are SSD and HDD.
	//
	//    * Set to SSD to use solid state drive storage. Supported on all Windows
	//    deployment types.
	//
	//    * Set to HDD to use hard disk drive storage. Supported on SINGLE_AZ_2
	//    and MULTI_AZ_1 Windows file system deployment types.
	//
	// Default value is SSD.
	//
	// HDD and SSD storage types have different minimum storage capacity requirements.
	// A restored file system's storage capacity is tied to the file system that
	// was backed up. You can create a file system that uses HDD storage from a
	// backup of a file system that used SSD storage only if the original SSD file
	// system had a storage capacity of at least 2000 GiB.
	StorageType *string `type:"string" enum:"StorageType"`

	// Specifies the IDs of the subnets that the file system will be accessible
	// from. For Windows MULTI_AZ_1 file system deployment types, provide exactly
	// two subnet IDs, one for the preferred file server and one for the standby
	// file server. You specify one of these subnets as the preferred subnet using
	// the WindowsConfiguration > PreferredSubnetID property.
	//
	// For Windows SINGLE_AZ_1 and SINGLE_AZ_2 deployment types and Lustre file
	// systems, provide exactly one subnet ID. The file server is launched in that
	// subnet's Availability Zone.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The tags to be applied to the file system at file system creation. The key
	// value of the Name tag appears in the console as the file system name.
	Tags []*Tag `min:"1" type:"list"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *CreateFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemFromBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemFromBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemFromBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemFromBackupInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}
	if s.BackupId != nil && len(*s.BackupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("BackupId", 12))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *CreateFileSystemFromBackupInput) SetBackupId(v string) *CreateFileSystemFromBackupInput {
	s.BackupId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFileSystemFromBackupInput) SetClientRequestToken(v string) *CreateFileSystemFromBackupInput {
	s.ClientRequestToken = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateFileSystemFromBackupInput) SetSecurityGroupIds(v []*string) *CreateFileSystemFromBackupInput {
	s.SecurityGroupIds = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateFileSystemFromBackupInput) SetStorageType(v string) *CreateFileSystemFromBackupInput {
	s.StorageType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateFileSystemFromBackupInput) SetSubnetIds(v []*string) *CreateFileSystemFromBackupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemFromBackupInput) SetTags(v []*Tag) *CreateFileSystemFromBackupInput {
	s.Tags = v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *CreateFileSystemFromBackupInput) SetWindowsConfiguration(v *CreateFileSystemWindowsConfiguration) *CreateFileSystemFromBackupInput {
	s.WindowsConfiguration = v
	return s
}

// The response object for the CreateFileSystemFromBackup operation.
type CreateFileSystemFromBackupOutput struct {
	_ struct{} `type:"structure"`

	// A description of the file system.
	FileSystem *FileSystem `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemFromBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemFromBackupOutput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *CreateFileSystemFromBackupOutput) SetFileSystem(v *FileSystem) *CreateFileSystemFromBackupOutput {
	s.FileSystem = v
	return s
}

// The request object used to create a new Amazon FSx file system.
type CreateFileSystemInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent creation. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The type of Amazon FSx file system to create, either WINDOWS or LUSTRE.
	//
	// FileSystemType is a required field
	FileSystemType *string `type:"string" required:"true" enum:"FileSystemType"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the
	// file system's data for Amazon FSx for Windows File Server file systems and
	// Amazon FSx for Lustre PERSISTENT_1 file systems at rest. In either case,
	// if not specified, the Amazon FSx managed key is used. The Amazon FSx for
	// Lustre SCRATCH_1 and SCRATCH_2 file systems are always encrypted at rest
	// using Amazon FSx managed keys. For more information, see Encrypt (https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html)
	// in the AWS Key Management Service API Reference.
	KmsKeyId *string `min:"1" type:"string"`

	// The Lustre configuration for the file system being created.
	LustreConfiguration *CreateFileSystemLustreConfiguration `type:"structure"`

	// A list of IDs specifying the security groups to apply to all network interfaces
	// created for file system access. This list isn't returned in later requests
	// to describe the file system.
	SecurityGroupIds []*string `type:"list"`

	// Sets the storage capacity of the file system that you're creating.
	//
	// For Lustre file systems:
	//
	//    * For SCRATCH_2 and PERSISTENT_1 deployment types, valid values are 1.2,
	//    2.4, and increments of 2.4 TiB.
	//
	//    * For SCRATCH_1 deployment type, valid values are 1.2, 2.4, and increments
	//    of 3.6 TiB.
	//
	// For Windows file systems:
	//
	//    * If StorageType=SSD, valid values are 32 GiB - 65,536 GiB (64 TiB).
	//
	//    * If StorageType=HDD, valid values are 2000 GiB - 65,536 GiB (64 TiB).
	//
	// StorageCapacity is a required field
	StorageCapacity *int64 `type:"integer" required:"true"`

	// Sets the storage type for the Amazon FSx for Windows file system you're creating.
	// Valid values are SSD and HDD.
	//
	//    * Set to SSD to use solid state drive storage. SSD is supported on all
	//    Windows deployment types.
	//
	//    * Set to HDD to use hard disk drive storage. HDD is supported on SINGLE_AZ_2
	//    and MULTI_AZ_1 Windows file system deployment types.
	//
	// Default value is SSD. For more information, see Storage Type Options (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-tco.html#saz-maz-storage-type)
	// in the Amazon FSx for Windows User Guide.
	StorageType *string `type:"string" enum:"StorageType"`

	// Specifies the IDs of the subnets that the file system will be accessible
	// from. For Windows MULTI_AZ_1 file system deployment types, provide exactly
	// two subnet IDs, one for the preferred file server and one for the standby
	// file server. You specify one of these subnets as the preferred subnet using
	// the WindowsConfiguration > PreferredSubnetID property.
	//
	// For Windows SINGLE_AZ_1 and SINGLE_AZ_2 file system deployment types and
	// Lustre file systems, provide exactly one subnet ID. The file server is launched
	// in that subnet's Availability Zone.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The tags to apply to the file system being created. The key value of the
	// Name tag appears in the console as the file system name.
	Tags []*Tag `min:"1" type:"list"`

	// The Microsoft Windows configuration for the file system being created.
	WindowsConfiguration *CreateFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemType == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemType"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.StorageCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageCapacity"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.LustreConfiguration != nil {
		if err := s.LustreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFileSystemInput) SetClientRequestToken(v string) *CreateFileSystemInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *CreateFileSystemInput) SetFileSystemType(v string) *CreateFileSystemInput {
	s.FileSystemType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateFileSystemInput) SetKmsKeyId(v string) *CreateFileSystemInput {
	s.KmsKeyId = &v
	return s
}

// SetLustreConfiguration sets the LustreConfiguration field's value.
func (s *CreateFileSystemInput) SetLustreConfiguration(v *CreateFileSystemLustreConfiguration) *CreateFileSystemInput {
	s.LustreConfiguration = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateFileSystemInput) SetSecurityGroupIds(v []*string) *CreateFileSystemInput {
	s.SecurityGroupIds = v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *CreateFileSystemInput) SetStorageCapacity(v int64) *CreateFileSystemInput {
	s.StorageCapacity = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateFileSystemInput) SetStorageType(v string) *CreateFileSystemInput {
	s.StorageType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateFileSystemInput) SetSubnetIds(v []*string) *CreateFileSystemInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemInput) SetTags(v []*Tag) *CreateFileSystemInput {
	s.Tags = v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *CreateFileSystemInput) SetWindowsConfiguration(v *CreateFileSystemWindowsConfiguration) *CreateFileSystemInput {
	s.WindowsConfiguration = v
	return s
}

// The Lustre configuration for the file system being created.
type CreateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// (Optional) Choose SCRATCH_1 and SCRATCH_2 deployment types when you need
	// temporary storage and shorter-term processing of data. The SCRATCH_2 deployment
	// type provides in-transit encryption of data and higher burst throughput capacity
	// than SCRATCH_1.
	//
	// Choose PERSISTENT_1 deployment type for longer-term storage and workloads
	// and encryption of data in transit. To learn more about deployment types,
	// see FSx for Lustre Deployment Options (https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
	//
	// Encryption of data in-transit is automatically enabled when you access a
	// SCRATCH_2 or PERSISTENT_1 file system from Amazon EC2 instances that support
	// this feature (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html).
	// (Default = SCRATCH_1)
	//
	// Encryption of data in-transit for SCRATCH_2 and PERSISTENT_1 deployment types
	// is supported when accessed from supported instance types in supported AWS
	// Regions. To learn more, Encrypting Data in Transit (https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html).
	DeploymentType *string `type:"string" enum:"LustreDeploymentType"`

	// (Optional) The path in Amazon S3 where the root of your Amazon FSx file system
	// is exported. The path must use the same Amazon S3 bucket as specified in
	// ImportPath. You can provide an optional prefix to which new and changed data
	// is to be exported from your Amazon FSx for Lustre file system. If an ExportPath
	// value is not provided, Amazon FSx sets a default export path, s3://import-bucket/FSxLustre[creation-timestamp].
	// The timestamp is in UTC format, for example s3://import-bucket/FSxLustre20181105T222312Z.
	//
	// The Amazon S3 export bucket must be the same as the import bucket specified
	// by ImportPath. If you only specify a bucket name, such as s3://import-bucket,
	// you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping
	// means that the input data in S3 is overwritten on export. If you provide
	// a custom prefix in the export path, such as s3://import-bucket/[custom-optional-prefix],
	// Amazon FSx exports the contents of your file system to that export prefix
	// in the Amazon S3 bucket.
	ExportPath *string `min:"3" type:"string"`

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix)
	// that you're using as the data repository for your Amazon FSx for Lustre file
	// system. The root of your FSx for Lustre file system will be mapped to the
	// root of the Amazon S3 bucket you select. An example is s3://import-bucket/optional-prefix.
	// If you specify a prefix after the Amazon S3 bucket name, only object keys
	// with that prefix are loaded into the file system.
	ImportPath *string `min:"3" type:"string"`

	// (Optional) For files imported from a data repository, this value determines
	// the stripe count and maximum amount of data per file (in MiB) stored on a
	// single physical disk. The maximum number of disks that a single file can
	// be striped across is limited by the total number of disks that make up the
	// file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`

	// Required for the PERSISTENT_1 deployment type, describes the amount of read
	// and write throughput for each 1 tebibyte of storage, in MB/s/TiB. File system
	// throughput capacity is calculated by multiplying ﬁle system storage capacity
	// (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB ﬁle system,
	// provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 117 MB/s of ﬁle
	// system throughput. You pay for the amount of throughput that you provision.
	//
	// Valid values are 50, 100, 200.
	PerUnitStorageThroughput *int64 `min:"50" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemLustreConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemLustreConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemLustreConfiguration"}
	if s.ExportPath != nil && len(*s.ExportPath) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ExportPath", 3))
	}
	if s.ImportPath != nil && len(*s.ImportPath) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ImportPath", 3))
	}
	if s.ImportedFileChunkSize != nil && *s.ImportedFileChunkSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ImportedFileChunkSize", 1))
	}
	if s.PerUnitStorageThroughput != nil && *s.PerUnitStorageThroughput < 50 {
		invalidParams.Add(request.NewErrParamMinValue("PerUnitStorageThroughput", 50))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *CreateFileSystemLustreConfiguration) SetDeploymentType(v string) *CreateFileSystemLustreConfiguration {
	s.DeploymentType = &v
	return s
}

// SetExportPath sets the ExportPath field's value.
func (s *CreateFileSystemLustreConfiguration) SetExportPath(v string) *CreateFileSystemLustreConfiguration {
	s.ExportPath = &v
	return s
}

// SetImportPath sets the ImportPath field's value.
func (s *CreateFileSystemLustreConfiguration) SetImportPath(v string) *CreateFileSystemLustreConfiguration {
	s.ImportPath = &v
	return s
}

// SetImportedFileChunkSize sets the ImportedFileChunkSize field's value.
func (s *CreateFileSystemLustreConfiguration) SetImportedFileChunkSize(v int64) *CreateFileSystemLustreConfiguration {
	s.ImportedFileChunkSize = &v
	return s
}

// SetPerUnitStorageThroughput sets the PerUnitStorageThroughput field's value.
func (s *CreateFileSystemLustreConfiguration) SetPerUnitStorageThroughput(v int64) *CreateFileSystemLustreConfiguration {
	s.PerUnitStorageThroughput = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *CreateFileSystemLustreConfiguration) SetWeeklyMaintenanceStartTime(v string) *CreateFileSystemLustreConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The response object returned after the file system is created.
type CreateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// The configuration of the file system that was created.
	FileSystem *FileSystem `type:"structure"`
}

// String returns the string representation
func (s CreateFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *CreateFileSystemOutput) SetFileSystem(v *FileSystem) *CreateFileSystemOutput {
	s.FileSystem = v
	return s
}

// The configuration object for the Microsoft Windows file system used in CreateFileSystem
// and CreateFileSystemFromBackup operations.
type CreateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing AWS Managed Microsoft Active Directory (AD) instance
	// that the file system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. The default is to retain
	// backups for 7 days. Setting this value to 0 disables the creation of automatic
	// backups. The maximum retention period for backups is 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags for the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags for
	// the file system are copied to all automatic and user-initiated backups where
	// the user doesn't specify tags. If this value is true, and you specify one
	// or more tags, only the specified tags are copied to backups. If you specify
	// one or more tags when creating a user-initiated backup, no tags are copied
	// from the file system, regardless of this value.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, formatted HH:MM in the
	// UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// Specifies the file system deployment type, valid values are the following:
	//
	//    * MULTI_AZ_1 - Deploys a high availability file system that is configured
	//    for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
	//    You can only deploy a Multi-AZ file system in AWS Regions that have a
	//    minimum of three Availability Zones. Also supports HDD storage type
	//
	//    * SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured
	//    for single AZ redundancy.
	//
	//    * SINGLE_AZ_2 - The latest generation Single AZ file system. Specifies
	//    a file system that is configured for single AZ redundancy and supports
	//    HDD storage type.
	//
	// For more information, see Availability and Durability: Single-AZ and Multi-AZ
	// File Systems (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType *string `type:"string" enum:"WindowsDeploymentType"`

	// Required when DeploymentType is set to MULTI_AZ_1. This specifies the subnet
	// in which you want the preferred file server to be located. For in-AWS applications,
	// we recommend that you launch your clients in the same Availability Zone (AZ)
	// as your preferred file server to reduce cross-AZ data transfer costs and
	// minimize latency.
	PreferredSubnetId *string `min:"15" type:"string"`

	// The configuration that Amazon FSx uses to join the Windows File Server instance
	// to your self-managed (including on-premises) Microsoft Active Directory (AD)
	// directory.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration `type:"structure"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second,
	// in 2 to the nth increments, between 2^3 (8) and 2^11 (2048).
	//
	// ThroughputCapacity is a required field
	ThroughputCapacity *int64 `min:"8" type:"integer" required:"true"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemWindowsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemWindowsConfiguration"}
	if s.ActiveDirectoryId != nil && len(*s.ActiveDirectoryId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ActiveDirectoryId", 12))
	}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.PreferredSubnetId != nil && len(*s.PreferredSubnetId) < 15 {
		invalidParams.Add(request.NewErrParamMinLen("PreferredSubnetId", 15))
	}
	if s.ThroughputCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ThroughputCapacity"))
	}
	if s.ThroughputCapacity != nil && *s.ThroughputCapacity < 8 {
		invalidParams.Add(request.NewErrParamMinValue("ThroughputCapacity", 8))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}
	if s.SelfManagedActiveDirectoryConfiguration != nil {
		if err := s.SelfManagedActiveDirectoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveDirectoryId sets the ActiveDirectoryId field's value.
func (s *CreateFileSystemWindowsConfiguration) SetActiveDirectoryId(v string) *CreateFileSystemWindowsConfiguration {
	s.ActiveDirectoryId = &v
	return s
}

// SetAutomaticBackupRetentionDays sets the AutomaticBackupRetentionDays field's value.
func (s *CreateFileSystemWindowsConfiguration) SetAutomaticBackupRetentionDays(v int64) *CreateFileSystemWindowsConfiguration {
	s.AutomaticBackupRetentionDays = &v
	return s
}

// SetCopyTagsToBackups sets the CopyTagsToBackups field's value.
func (s *CreateFileSystemWindowsConfiguration) SetCopyTagsToBackups(v bool) *CreateFileSystemWindowsConfiguration {
	s.CopyTagsToBackups = &v
	return s
}

// SetDailyAutomaticBackupStartTime sets the DailyAutomaticBackupStartTime field's value.
func (s *CreateFileSystemWindowsConfiguration) SetDailyAutomaticBackupStartTime(v string) *CreateFileSystemWindowsConfiguration {
	s.DailyAutomaticBackupStartTime = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *CreateFileSystemWindowsConfiguration) SetDeploymentType(v string) *CreateFileSystemWindowsConfiguration {
	s.DeploymentType = &v
	return s
}

// SetPreferredSubnetId sets the PreferredSubnetId field's value.
func (s *CreateFileSystemWindowsConfiguration) SetPreferredSubnetId(v string) *CreateFileSystemWindowsConfiguration {
	s.PreferredSubnetId = &v
	return s
}

// SetSelfManagedActiveDirectoryConfiguration sets the SelfManagedActiveDirectoryConfiguration field's value.
func (s *CreateFileSystemWindowsConfiguration) SetSelfManagedActiveDirectoryConfiguration(v *SelfManagedActiveDirectoryConfiguration) *CreateFileSystemWindowsConfiguration {
	s.SelfManagedActiveDirectoryConfiguration = v
	return s
}

// SetThroughputCapacity sets the ThroughputCapacity field's value.
func (s *CreateFileSystemWindowsConfiguration) SetThroughputCapacity(v int64) *CreateFileSystemWindowsConfiguration {
	s.ThroughputCapacity = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *CreateFileSystemWindowsConfiguration) SetWeeklyMaintenanceStartTime(v string) *CreateFileSystemWindowsConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The data repository configuration object for Lustre file systems returned
// in the response of the CreateFileSystem operation.
type DataRepositoryConfiguration struct {
	_ struct{} `type:"structure"`

	// The export path to the Amazon S3 bucket (and prefix) that you are using to
	// store new and changed Lustre file system files in S3.
	ExportPath *string `min:"3" type:"string"`

	// The import path to the Amazon S3 bucket (and optional prefix) that you're
	// using as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix. If a prefix is specified after the Amazon
	// S3 bucket name, only object keys with that prefix are loaded into the file
	// system.
	ImportPath *string `min:"3" type:"string"`

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across
	// is limited by the total number of disks that make up the file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DataRepositoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryConfiguration) GoString() string {
	return s.String()
}

// SetExportPath sets the ExportPath field's value.
func (s *DataRepositoryConfiguration) SetExportPath(v string) *DataRepositoryConfiguration {
	s.ExportPath = &v
	return s
}

// SetImportPath sets the ImportPath field's value.
func (s *DataRepositoryConfiguration) SetImportPath(v string) *DataRepositoryConfiguration {
	s.ImportPath = &v
	return s
}

// SetImportedFileChunkSize sets the ImportedFileChunkSize field's value.
func (s *DataRepositoryConfiguration) SetImportedFileChunkSize(v int64) *DataRepositoryConfiguration {
	s.ImportedFileChunkSize = &v
	return s
}

// A description of the data repository task. You use data repository tasks
// to perform bulk transfer operations between your Amazon FSx file system and
// its linked data repository.
type DataRepositoryTask struct {
	_ struct{} `type:"structure"`

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time that Amazon FSx completed processing the task, populated after the
	// task is complete.
	EndTime *time.Time `type:"timestamp"`

	// Failure message describing why the task failed, it is populated only when
	// Lifecycle is set to FAILED.
	FailureDetails *DataRepositoryTaskFailureDetails `type:"structure"`

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The lifecycle status of the data repository task, as follows:
	//
	//    * PENDING - Amazon FSx has not started the task.
	//
	//    * EXECUTING - Amazon FSx is processing the task.
	//
	//    * FAILED - Amazon FSx was not able to complete the task. For example,
	//    there may be files the task failed to process. The DataRepositoryTaskFailureDetails
	//    property provides more information about task failures.
	//
	//    * SUCCEEDED - FSx completed the task successfully.
	//
	//    * CANCELED - Amazon FSx canceled the task and it did not complete.
	//
	//    * CANCELING - FSx is in process of canceling the task.
	//
	// You cannot delete an FSx for Lustre file system if there are data repository
	// tasks for the file system in the PENDING or EXECUTING states. Please retry
	// when the data repository task is finished (with a status of CANCELED, SUCCEEDED,
	// or FAILED). You can use the DescribeDataRepositoryTask action to monitor
	// the task status. Contact the FSx team if you need to delete your file system
	// immediately.
	//
	// Lifecycle is a required field
	Lifecycle *string `type:"string" required:"true" enum:"DataRepositoryTaskLifecycle"`

	// An array of paths on the Amazon FSx for Lustre file system that specify the
	// data for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY
	// task, the paths specify which data to export to the linked data repository.
	//
	// (Default) If Paths is not specified, Amazon FSx uses the file system root
	// directory.
	Paths []*string `type:"list"`

	// Provides a report detailing the data repository task results of the files
	// processed that match the criteria specified in the report Scope parameter.
	// FSx delivers the report to the file system's linked data repository in Amazon
	// S3, using the path specified in the report Path parameter. You can specify
	// whether or not a report gets generated for a task using the Enabled parameter.
	Report *CompletionReport `type:"structure"`

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// AWS resources. We require an ARN when you need to specify a resource unambiguously
	// across all of AWS. For more information, see Amazon Resource Names (ARNs)
	// and AWS Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	ResourceARN *string `min:"8" type:"string"`

	// The time that Amazon FSx began processing the task.
	StartTime *time.Time `type:"timestamp"`

	// Provides the status of the number of files that the task has processed successfully
	// and failed to process.
	Status *DataRepositoryTaskStatus `type:"structure"`

	// A list of Tag values, with a maximum of 50 elements.
	Tags []*Tag `min:"1" type:"list"`

	// The system-generated, unique 17-digit ID of the data repository task.
	//
	// TaskId is a required field
	TaskId *string `min:"12" type:"string" required:"true"`

	// The type of data repository task; EXPORT_TO_REPOSITORY is the only type currently
	// supported.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataRepositoryTaskType"`
}

// String returns the string representation
func (s DataRepositoryTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryTask) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DataRepositoryTask) SetCreationTime(v time.Time) *DataRepositoryTask {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DataRepositoryTask) SetEndTime(v time.Time) *DataRepositoryTask {
	s.EndTime = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *DataRepositoryTask) SetFailureDetails(v *DataRepositoryTaskFailureDetails) *DataRepositoryTask {
	s.FailureDetails = v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DataRepositoryTask) SetFileSystemId(v string) *DataRepositoryTask {
	s.FileSystemId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *DataRepositoryTask) SetLifecycle(v string) *DataRepositoryTask {
	s.Lifecycle = &v
	return s
}

// SetPaths sets the Paths field's value.
func (s *DataRepositoryTask) SetPaths(v []*string) *DataRepositoryTask {
	s.Paths = v
	return s
}

// SetReport sets the Report field's value.
func (s *DataRepositoryTask) SetReport(v *CompletionReport) *DataRepositoryTask {
	s.Report = v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *DataRepositoryTask) SetResourceARN(v string) *DataRepositoryTask {
	s.ResourceARN = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DataRepositoryTask) SetStartTime(v time.Time) *DataRepositoryTask {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataRepositoryTask) SetStatus(v *DataRepositoryTaskStatus) *DataRepositoryTask {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DataRepositoryTask) SetTags(v []*Tag) *DataRepositoryTask {
	s.Tags = v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *DataRepositoryTask) SetTaskId(v string) *DataRepositoryTask {
	s.TaskId = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataRepositoryTask) SetType(v string) *DataRepositoryTask {
	s.Type = &v
	return s
}

// The data repository task could not be canceled because the task has already
// ended.
type DataRepositoryTaskEnded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s DataRepositoryTaskEnded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryTaskEnded) GoString() string {
	return s.String()
}

func newErrorDataRepositoryTaskEnded(v protocol.ResponseMetadata) error {
	return &DataRepositoryTaskEnded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataRepositoryTaskEnded) Code() string {
	return "DataRepositoryTaskEnded"
}

// Message returns the exception's message.
func (s *DataRepositoryTaskEnded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataRepositoryTaskEnded) OrigErr() error {
	return nil
}

func (s *DataRepositoryTaskEnded) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataRepositoryTaskEnded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataRepositoryTaskEnded) RequestID() string {
	return s.RespMetadata.RequestID
}

// An existing data repository task is currently executing on the file system.
// Wait until the existing task has completed, then create the new task.
type DataRepositoryTaskExecuting struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s DataRepositoryTaskExecuting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryTaskExecuting) GoString() string {
	return s.String()
}

func newErrorDataRepositoryTaskExecuting(v protocol.ResponseMetadata) error {
	return &DataRepositoryTaskExecuting{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataRepositoryTaskExecuting) Code() string {
	return "DataRepositoryTaskExecuting"
}

// Message returns the exception's message.
func (s *DataRepositoryTaskExecuting) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataRepositoryTaskExecuting) OrigErr() error {
	return nil
}

func (s *DataRepositoryTaskExecuting) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataRepositoryTaskExecuting) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataRepositoryTaskExecuting) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about why a data repository task failed. Only populated
// when the task Lifecycle is set to FAILED.
type DataRepositoryTaskFailureDetails struct {
	_ struct{} `type:"structure"`

	// A detailed error message.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DataRepositoryTaskFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryTaskFailureDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DataRepositoryTaskFailureDetails) SetMessage(v string) *DataRepositoryTaskFailureDetails {
	s.Message = &v
	return s
}

// (Optional) An array of filter objects you can use to filter the response
// of data repository tasks you will see in the the response. You can filter
// the tasks returned in the response by one or more file system IDs, task lifecycles,
// and by task type. A filter object consists of a filter Name, and one or more
// Values for the filter.
type DataRepositoryTaskFilter struct {
	_ struct{} `type:"structure"`

	// Name of the task property to use in filtering the tasks returned in the response.
	//
	//    * Use file-system-id to retrieve data repository tasks for specific file
	//    systems.
	//
	//    * Use task-lifecycle to retrieve data repository tasks with one or more
	//    specific lifecycle states, as follows: CANCELED, EXECUTING, FAILED, PENDING,
	//    and SUCCEEDED.
	Name *string `type:"string" enum:"DataRepositoryTaskFilterName"`

	// Use Values to include the specific file system IDs and task lifecycle states
	// for the filters you are using.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s DataRepositoryTaskFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryTaskFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DataRepositoryTaskFilter) SetName(v string) *DataRepositoryTaskFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DataRepositoryTaskFilter) SetValues(v []*string) *DataRepositoryTaskFilter {
	s.Values = v
	return s
}

// The data repository task or tasks you specified could not be found.
type DataRepositoryTaskNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s DataRepositoryTaskNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryTaskNotFound) GoString() string {
	return s.String()
}

func newErrorDataRepositoryTaskNotFound(v protocol.ResponseMetadata) error {
	return &DataRepositoryTaskNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DataRepositoryTaskNotFound) Code() string {
	return "DataRepositoryTaskNotFound"
}

// Message returns the exception's message.
func (s *DataRepositoryTaskNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DataRepositoryTaskNotFound) OrigErr() error {
	return nil
}

func (s *DataRepositoryTaskNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DataRepositoryTaskNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DataRepositoryTaskNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides the task status showing a running total of the total number of files
// to be processed, the number successfully processed, and the number of files
// the task failed to process.
type DataRepositoryTaskStatus struct {
	_ struct{} `type:"structure"`

	// A running total of the number of files that the task failed to process.
	FailedCount *int64 `type:"long"`

	// The time at which the task status was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A running total of the number of files that the task has successfully processed.
	SucceededCount *int64 `type:"long"`

	// The total number of files that the task will process. While a task is executing,
	// the sum of SucceededCount plus FailedCount may not equal TotalCount. When
	// the task is complete, TotalCount equals the sum of SucceededCount plus FailedCount.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s DataRepositoryTaskStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRepositoryTaskStatus) GoString() string {
	return s.String()
}

// SetFailedCount sets the FailedCount field's value.
func (s *DataRepositoryTaskStatus) SetFailedCount(v int64) *DataRepositoryTaskStatus {
	s.FailedCount = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataRepositoryTaskStatus) SetLastUpdatedTime(v time.Time) *DataRepositoryTaskStatus {
	s.LastUpdatedTime = &v
	return s
}

// SetSucceededCount sets the SucceededCount field's value.
func (s *DataRepositoryTaskStatus) SetSucceededCount(v int64) *DataRepositoryTaskStatus {
	s.SucceededCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DataRepositoryTaskStatus) SetTotalCount(v int64) *DataRepositoryTaskStatus {
	s.TotalCount = &v
	return s
}

// The request object for DeleteBackup operation.
type DeleteBackupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup you want to delete.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent deletion. This is automatically filled on your behalf when
	// using the AWS CLI or SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}
	if s.BackupId != nil && len(*s.BackupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("BackupId", 12))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *DeleteBackupInput) SetBackupId(v string) *DeleteBackupInput {
	s.BackupId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteBackupInput) SetClientRequestToken(v string) *DeleteBackupInput {
	s.ClientRequestToken = &v
	return s
}

// The response object for DeleteBackup operation.
type DeleteBackupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup deleted.
	BackupId *string `min:"12" type:"string"`

	// The lifecycle of the backup. Should be DELETED.
	Lifecycle *string `type:"string" enum:"BackupLifecycle"`
}

// String returns the string representation
func (s DeleteBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupOutput) GoString() string {
	return s.String()
}

// SetBackupId sets the BackupId field's value.
func (s *DeleteBackupOutput) SetBackupId(v string) *DeleteBackupOutput {
	s.BackupId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *DeleteBackupOutput) SetLifecycle(v string) *DeleteBackupOutput {
	s.Lifecycle = &v
	return s
}

// The request object for DeleteFileSystem operation.
type DeleteFileSystemInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent deletion. This is automatically filled on your behalf when
	// using the AWS CLI or SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the file system you want to delete.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The configuration object for the Microsoft Windows file system used in the
	// DeleteFileSystem operation.
	WindowsConfiguration *DeleteFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s DeleteFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteFileSystemInput) SetClientRequestToken(v string) *DeleteFileSystemInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DeleteFileSystemInput) SetFileSystemId(v string) *DeleteFileSystemInput {
	s.FileSystemId = &v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *DeleteFileSystemInput) SetWindowsConfiguration(v *DeleteFileSystemWindowsConfiguration) *DeleteFileSystemInput {
	s.WindowsConfiguration = v
	return s
}

// The response object for the DeleteFileSystem operation.
type DeleteFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system being deleted.
	FileSystemId *string `min:"11" type:"string"`

	// The file system lifecycle for the deletion request. Should be DELETING.
	Lifecycle *string `type:"string" enum:"FileSystemLifecycle"`

	// The response object for the Microsoft Windows file system used in the DeleteFileSystem
	// operation.
	WindowsResponse *DeleteFileSystemWindowsResponse `type:"structure"`
}

// String returns the string representation
func (s DeleteFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DeleteFileSystemOutput) SetFileSystemId(v string) *DeleteFileSystemOutput {
	s.FileSystemId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *DeleteFileSystemOutput) SetLifecycle(v string) *DeleteFileSystemOutput {
	s.Lifecycle = &v
	return s
}

// SetWindowsResponse sets the WindowsResponse field's value.
func (s *DeleteFileSystemOutput) SetWindowsResponse(v *DeleteFileSystemWindowsResponse) *DeleteFileSystemOutput {
	s.WindowsResponse = v
	return s
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of tags for your final backup.
	FinalBackupTags []*Tag `min:"1" type:"list"`

	// By default, Amazon FSx for Windows takes a final backup on your behalf when
	// the DeleteFileSystem operation is invoked. Doing this helps protect you from
	// data loss, and we highly recommend taking the final backup. If you want to
	// skip this backup, use this flag to do so.
	SkipFinalBackup *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemWindowsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemWindowsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileSystemWindowsConfiguration"}
	if s.FinalBackupTags != nil && len(s.FinalBackupTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FinalBackupTags", 1))
	}
	if s.FinalBackupTags != nil {
		for i, v := range s.FinalBackupTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FinalBackupTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFinalBackupTags sets the FinalBackupTags field's value.
func (s *DeleteFileSystemWindowsConfiguration) SetFinalBackupTags(v []*Tag) *DeleteFileSystemWindowsConfiguration {
	s.FinalBackupTags = v
	return s
}

// SetSkipFinalBackup sets the SkipFinalBackup field's value.
func (s *DeleteFileSystemWindowsConfiguration) SetSkipFinalBackup(v bool) *DeleteFileSystemWindowsConfiguration {
	s.SkipFinalBackup = &v
	return s
}

// The response object for the Microsoft Windows file system used in the DeleteFileSystem
// operation.
type DeleteFileSystemWindowsResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the final backup for this file system.
	FinalBackupId *string `min:"12" type:"string"`

	// The set of tags applied to the final backup.
	FinalBackupTags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileSystemWindowsResponse) GoString() string {
	return s.String()
}

// SetFinalBackupId sets the FinalBackupId field's value.
func (s *DeleteFileSystemWindowsResponse) SetFinalBackupId(v string) *DeleteFileSystemWindowsResponse {
	s.FinalBackupId = &v
	return s
}

// SetFinalBackupTags sets the FinalBackupTags field's value.
func (s *DeleteFileSystemWindowsResponse) SetFinalBackupTags(v []*Tag) *DeleteFileSystemWindowsResponse {
	s.FinalBackupTags = v
	return s
}

// The request object for DescribeBackups operation.
type DescribeBackupsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) IDs of the backups you want to retrieve (String). This overrides
	// any filters. If any IDs are not found, BackupNotFound will be thrown.
	BackupIds []*string `type:"list"`

	// (Optional) Filters structure. Supported names are file-system-id and backup-type.
	Filters []*Filter `type:"list"`

	// (Optional) Maximum number of backups to return in the response (integer).
	// This parameter value must be greater than 0. The number of items that Amazon
	// FSx returns is the minimum of the MaxResults parameter specified in the request
	// and the service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous DescribeBackups
	// operation (String). If a token present, the action continues the list from
	// where the returning call left off.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupIds sets the BackupIds field's value.
func (s *DescribeBackupsInput) SetBackupIds(v []*string) *DescribeBackupsInput {
	s.BackupIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeBackupsInput) SetFilters(v []*Filter) *DescribeBackupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBackupsInput) SetMaxResults(v int64) *DescribeBackupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsInput) SetNextToken(v string) *DescribeBackupsInput {
	s.NextToken = &v
	return s
}

// Response object for DescribeBackups operation.
type DescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Any array of backups.
	Backups []*Backup `type:"list"`

	// This is present if there are more backups than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the backups.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackups sets the Backups field's value.
func (s *DescribeBackupsOutput) SetBackups(v []*Backup) *DescribeBackupsOutput {
	s.Backups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsOutput) SetNextToken(v string) *DescribeBackupsOutput {
	s.NextToken = &v
	return s
}

type DescribeDataRepositoryTasksInput struct {
	_ struct{} `type:"structure"`

	// (Optional) You can use filters to narrow the DescribeDataRepositoryTasks
	// response to include just tasks for specific file systems, or tasks in a specific
	// lifecycle state.
	Filters []*DataRepositoryTaskFilter `type:"list"`

	// The maximum number of resources to return in the response. This value must
	// be an integer greater than zero.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing
	// the request, where the previous NextToken value left off.
	NextToken *string `min:"1" type:"string"`

	// (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
	TaskIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeDataRepositoryTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataRepositoryTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataRepositoryTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataRepositoryTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeDataRepositoryTasksInput) SetFilters(v []*DataRepositoryTaskFilter) *DescribeDataRepositoryTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDataRepositoryTasksInput) SetMaxResults(v int64) *DescribeDataRepositoryTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDataRepositoryTasksInput) SetNextToken(v string) *DescribeDataRepositoryTasksInput {
	s.NextToken = &v
	return s
}

// SetTaskIds sets the TaskIds field's value.
func (s *DescribeDataRepositoryTasksInput) SetTaskIds(v []*string) *DescribeDataRepositoryTasksInput {
	s.TaskIds = v
	return s
}

type DescribeDataRepositoryTasksOutput struct {
	_ struct{} `type:"structure"`

	// The collection of data repository task descriptions returned.
	DataRepositoryTasks []*DataRepositoryTask `type:"list"`

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing
	// the request, where the previous NextToken value left off.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDataRepositoryTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataRepositoryTasksOutput) GoString() string {
	return s.String()
}

// SetDataRepositoryTasks sets the DataRepositoryTasks field's value.
func (s *DescribeDataRepositoryTasksOutput) SetDataRepositoryTasks(v []*DataRepositoryTask) *DescribeDataRepositoryTasksOutput {
	s.DataRepositoryTasks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDataRepositoryTasksOutput) SetNextToken(v string) *DescribeDataRepositoryTasksOutput {
	s.NextToken = &v
	return s
}

// The request object for DescribeFileSystems operation.
type DescribeFileSystemsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) IDs of the file systems whose descriptions you want to retrieve
	// (String).
	FileSystemIds []*string `type:"list"`

	// (Optional) Maximum number of file systems to return in the response (integer).
	// This parameter value must be greater than 0. The number of items that Amazon
	// FSx returns is the minimum of the MaxResults parameter specified in the request
	// and the service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous DescribeFileSystems
	// operation (String). If a token present, the action continues the list from
	// where the returning call left off.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFileSystemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFileSystemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFileSystemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFileSystemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemIds sets the FileSystemIds field's value.
func (s *DescribeFileSystemsInput) SetFileSystemIds(v []*string) *DescribeFileSystemsInput {
	s.FileSystemIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeFileSystemsInput) SetMaxResults(v int64) *DescribeFileSystemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFileSystemsInput) SetNextToken(v string) *DescribeFileSystemsInput {
	s.NextToken = &v
	return s
}

// The response object for DescribeFileSystems operation.
type DescribeFileSystemsOutput struct {
	_ struct{} `type:"structure"`

	// An array of file system descriptions.
	FileSystems []*FileSystem `type:"list"`

	// Present if there are more file systems than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the descriptions.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFileSystemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFileSystemsOutput) GoString() string {
	return s.String()
}

// SetFileSystems sets the FileSystems field's value.
func (s *DescribeFileSystemsOutput) SetFileSystems(v []*FileSystem) *DescribeFileSystemsOutput {
	s.FileSystems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFileSystemsOutput) SetNextToken(v string) *DescribeFileSystemsOutput {
	s.NextToken = &v
	return s
}

// A description of a specific Amazon FSx file system.
type FileSystem struct {
	_ struct{} `type:"structure"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time `type:"timestamp"`

	// The DNS name for the file system.
	DNSName *string `min:"16" type:"string"`

	// A structure providing details of any failures that occur when creating the
	// file system has failed.
	FailureDetails *FileSystemFailureDetails `type:"structure"`

	// The system-generated, unique 17-digit ID of the file system.
	FileSystemId *string `min:"11" type:"string"`

	// The type of Amazon FSx file system, either LUSTRE or WINDOWS.
	FileSystemType *string `type:"string" enum:"FileSystemType"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the
	// file system's data for Amazon FSx for Windows File Server file systems and
	// persistent Amazon FSx for Lustre file systems at rest. In either case, if
	// not specified, the Amazon FSx managed key is used. The scratch Amazon FSx
	// for Lustre file systems are always encrypted at rest using Amazon FSx managed
	// keys. For more information, see Encrypt (https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html)
	// in the AWS Key Management Service API Reference.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the file system, following are the possible values
	// and what they mean:
	//
	//    * AVAILABLE - The file system is in a healthy state, and is reachable
	//    and available for use.
	//
	//    * CREATING - Amazon FSx is creating the new file system.
	//
	//    * DELETING - Amazon FSx is deleting an existing file system.
	//
	//    * FAILED - An existing file system has experienced an unrecoverable failure.
	//    When creating a new file system, Amazon FSx was unable to create the file
	//    system.
	//
	//    * MISCONFIGURED indicates that the file system is in a failed but recoverable
	//    state.
	//
	//    * UPDATING indicates that the file system is undergoing a customer initiated
	//    update.
	Lifecycle *string `type:"string" enum:"FileSystemLifecycle"`

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration `type:"structure"`

	// The IDs of the elastic network interface from which a specific file system
	// is accessible. The elastic network interface is automatically created in
	// the same VPC that the Amazon FSx file system was created in. For more information,
	// see Elastic Network Interfaces (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html)
	// in the Amazon EC2 User Guide.
	//
	// For an Amazon FSx for Windows File Server file system, you can have one network
	// interface ID. For an Amazon FSx for Lustre file system, you can have more
	// than one.
	NetworkInterfaceIds []*string `type:"list"`

	// The AWS account that created the file system. If the file system was created
	// by an AWS Identity and Access Management (IAM) user, the AWS account to which
	// the IAM user belongs is the owner.
	OwnerId *string `min:"12" type:"string"`

	// The Amazon Resource Name (ARN) for the file system resource.
	ResourceARN *string `min:"8" type:"string"`

	// The storage capacity of the file system in gigabytes (GB).
	StorageCapacity *int64 `type:"integer"`

	// The storage type of the file system. Valid values are SSD and HDD. If set
	// to SSD, the file system uses solid state drive storage. If set to HDD, the
	// file system uses hard disk drive storage.
	StorageType *string `type:"string" enum:"StorageType"`

	// Specifies the IDs of the subnets that the file system is accessible from.
	// For Windows MULTI_AZ_1 file system deployment type, there are two subnet
	// IDs, one for the preferred file server and one for the standby file server.
	// The preferred file server subnet identified in the PreferredSubnetID property.
	// All other file systems have only one subnet ID.
	//
	// For Lustre file systems, and Single-AZ Windows file systems, this is the
	// ID of the subnet that contains the endpoint for the file system. For MULTI_AZ_1
	// Windows file systems, the endpoint for the file system is available in the
	// PreferredSubnetID.
	SubnetIds []*string `type:"list"`

	// The tags to associate with the file system. For more information, see Tagging
	// Your Amazon EC2 Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
	// in the Amazon EC2 User Guide.
	Tags []*Tag `min:"1" type:"list"`

	// The ID of the primary VPC for the file system.
	VpcId *string `min:"12" type:"string"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *WindowsFileSystemConfiguration `type:"structure"`
}

// String returns the string representation
func (s FileSystem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileSystem) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *FileSystem) SetCreationTime(v time.Time) *FileSystem {
	s.CreationTime = &v
	return s
}

// SetDNSName sets the DNSName field's value.
func (s *FileSystem) SetDNSName(v string) *FileSystem {
	s.DNSName = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *FileSystem) SetFailureDetails(v *FileSystemFailureDetails) *FileSystem {
	s.FailureDetails = v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FileSystem) SetFileSystemId(v string) *FileSystem {
	s.FileSystemId = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *FileSystem) SetFileSystemType(v string) *FileSystem {
	s.FileSystemType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *FileSystem) SetKmsKeyId(v string) *FileSystem {
	s.KmsKeyId = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *FileSystem) SetLifecycle(v string) *FileSystem {
	s.Lifecycle = &v
	return s
}

// SetLustreConfiguration sets the LustreConfiguration field's value.
func (s *FileSystem) SetLustreConfiguration(v *LustreFileSystemConfiguration) *FileSystem {
	s.LustreConfiguration = v
	return s
}

// SetNetworkInterfaceIds sets the NetworkInterfaceIds field's value.
func (s *FileSystem) SetNetworkInterfaceIds(v []*string) *FileSystem {
	s.NetworkInterfaceIds = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *FileSystem) SetOwnerId(v string) *FileSystem {
	s.OwnerId = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *FileSystem) SetResourceARN(v string) *FileSystem {
	s.ResourceARN = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *FileSystem) SetStorageCapacity(v int64) *FileSystem {
	s.StorageCapacity = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *FileSystem) SetStorageType(v string) *FileSystem {
	s.StorageType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *FileSystem) SetSubnetIds(v []*string) *FileSystem {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *FileSystem) SetTags(v []*Tag) *FileSystem {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *FileSystem) SetVpcId(v string) *FileSystem {
	s.VpcId = &v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *FileSystem) SetWindowsConfiguration(v *WindowsFileSystemConfiguration) *FileSystem {
	s.WindowsConfiguration = v
	return s
}

// A structure providing details of any failures that occur when creating the
// file system has failed.
type FileSystemFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing any failures that occurred during file system creation.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FileSystemFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileSystemFailureDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *FileSystemFailureDetails) SetMessage(v string) *FileSystemFailureDetails {
	s.Message = &v
	return s
}

// No Amazon FSx file systems were found based upon supplied parameters.
type FileSystemNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s FileSystemNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileSystemNotFound) GoString() string {
	return s.String()
}

func newErrorFileSystemNotFound(v protocol.ResponseMetadata) error {
	return &FileSystemNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FileSystemNotFound) Code() string {
	return "FileSystemNotFound"
}

// Message returns the exception's message.
func (s *FileSystemNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FileSystemNotFound) OrigErr() error {
	return nil
}

func (s *FileSystemNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FileSystemNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FileSystemNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name for this filter.
	Name *string `type:"string" enum:"FilterName"`

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// The error returned when a second request is received with the same client
// request token but different parameters settings. A client request token should
// always uniquely identify a single request.
type IncompatibleParameterError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// A parameter that is incompatible with the earlier request.
	//
	// Parameter is a required field
	Parameter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IncompatibleParameterError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncompatibleParameterError) GoString() string {
	return s.String()
}

func newErrorIncompatibleParameterError(v protocol.ResponseMetadata) error {
	return &IncompatibleParameterError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncompatibleParameterError) Code() string {
	return "IncompatibleParameterError"
}

// Message returns the exception's message.
func (s *IncompatibleParameterError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncompatibleParameterError) OrigErr() error {
	return nil
}

func (s *IncompatibleParameterError) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncompatibleParameterError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncompatibleParameterError) RequestID() string {
	return s.RespMetadata.RequestID
}

// A generic error indicating a server-side failure.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The path provided for data repository export isn't valid.
type InvalidExportPath struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidExportPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidExportPath) GoString() string {
	return s.String()
}

func newErrorInvalidExportPath(v protocol.ResponseMetadata) error {
	return &InvalidExportPath{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidExportPath) Code() string {
	return "InvalidExportPath"
}

// Message returns the exception's message.
func (s *InvalidExportPath) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidExportPath) OrigErr() error {
	return nil
}

func (s *InvalidExportPath) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidExportPath) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidExportPath) RequestID() string {
	return s.RespMetadata.RequestID
}

// The path provided for data repository import isn't valid.
type InvalidImportPath struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidImportPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidImportPath) GoString() string {
	return s.String()
}

func newErrorInvalidImportPath(v protocol.ResponseMetadata) error {
	return &InvalidImportPath{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidImportPath) Code() string {
	return "InvalidImportPath"
}

// Message returns the exception's message.
func (s *InvalidImportPath) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidImportPath) OrigErr() error {
	return nil
}

func (s *InvalidImportPath) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidImportPath) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidImportPath) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more network settings specified in the request are invalid. InvalidVpcId
// means that the ID passed for the virtual private cloud (VPC) is invalid.
// InvalidSubnetIds returns the list of IDs for subnets that are either invalid
// or not part of the VPC specified. InvalidSecurityGroupIds returns the list
// of IDs for security groups that are either invalid or not part of the VPC
// specified.
type InvalidNetworkSettings struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The ID of your Amazon EC2 security group. This ID is used to control network
	// access to the endpoint that Amazon FSx creates on your behalf in each subnet.
	// For more information, see Amazon EC2 Security Groups for Linux Instances
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
	// in the Amazon EC2 User Guide.
	InvalidSecurityGroupId *string `min:"11" type:"string"`

	// The ID for a subnet. A subnet is a range of IP addresses in your virtual
	// private cloud (VPC). For more information, see VPC and Subnets (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
	// in the Amazon VPC User Guide.
	InvalidSubnetId *string `min:"15" type:"string"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidNetworkSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNetworkSettings) GoString() string {
	return s.String()
}

func newErrorInvalidNetworkSettings(v protocol.ResponseMetadata) error {
	return &InvalidNetworkSettings{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNetworkSettings) Code() string {
	return "InvalidNetworkSettings"
}

// Message returns the exception's message.
func (s *InvalidNetworkSettings) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNetworkSettings) OrigErr() error {
	return nil
}

func (s *InvalidNetworkSettings) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNetworkSettings) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNetworkSettings) RequestID() string {
	return s.RespMetadata.RequestID
}

// An invalid value for PerUnitStorageThroughput was provided. Please create
// your file system again, using a valid value.
type InvalidPerUnitStorageThroughput struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidPerUnitStorageThroughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPerUnitStorageThroughput) GoString() string {
	return s.String()
}

func newErrorInvalidPerUnitStorageThroughput(v protocol.ResponseMetadata) error {
	return &InvalidPerUnitStorageThroughput{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPerUnitStorageThroughput) Code() string {
	return "InvalidPerUnitStorageThroughput"
}

// Message returns the exception's message.
func (s *InvalidPerUnitStorageThroughput) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPerUnitStorageThroughput) OrigErr() error {
	return nil
}

func (s *InvalidPerUnitStorageThroughput) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPerUnitStorageThroughput) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPerUnitStorageThroughput) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request object for ListTagsForResource operation.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Maximum number of tags to return in the response (integer). This
	// parameter value must be greater than 0. The number of items that Amazon FSx
	// returns is the minimum of the MaxResults parameter specified in the request
	// and the service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous ListTagsForResource
	// operation (String). If a token present, the action continues the list from
	// where the returning call left off.
	NextToken *string `min:"1" type:"string"`

	// The ARN of the Amazon FSx resource that will have its tags listed.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

// The response object for ListTagsForResource operation.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// This is present if there are more tags than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the tags.
	NextToken *string `min:"1" type:"string"`

	// A list of tags on the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The configuration for the Amazon FSx for Lustre file system.
type LustreFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The data repository configuration object for Lustre file systems returned
	// in the response of the CreateFileSystem operation.
	DataRepositoryConfiguration *DataRepositoryConfiguration `type:"structure"`

	// The deployment type of the FSX for Lustre file system.
	DeploymentType *string `type:"string" enum:"LustreDeploymentType"`

	// You use the MountName value when mounting the file system.
	//
	// For the SCRATCH_1 deployment type, this value is always "fsx". For SCRATCH_2
	// and PERSISTENT_1 deployment types, this value is a string that is unique
	// within an AWS Region.
	MountName *string `min:"1" type:"string"`

	// Per unit storage throughput represents the megabytes per second of read or
	// write throughput per 1 tebibyte of storage provisioned. File system throughput
	// capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB).
	// This option is only valid for PERSISTENT_1 deployment types. Valid values
	// are 50, 100, 200.
	PerUnitStorageThroughput *int64 `min:"50" type:"integer"`

	// The UTC time that you want to begin your weekly maintenance window.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s LustreFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LustreFileSystemConfiguration) GoString() string {
	return s.String()
}

// SetDataRepositoryConfiguration sets the DataRepositoryConfiguration field's value.
func (s *LustreFileSystemConfiguration) SetDataRepositoryConfiguration(v *DataRepositoryConfiguration) *LustreFileSystemConfiguration {
	s.DataRepositoryConfiguration = v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *LustreFileSystemConfiguration) SetDeploymentType(v string) *LustreFileSystemConfiguration {
	s.DeploymentType = &v
	return s
}

// SetMountName sets the MountName field's value.
func (s *LustreFileSystemConfiguration) SetMountName(v string) *LustreFileSystemConfiguration {
	s.MountName = &v
	return s
}

// SetPerUnitStorageThroughput sets the PerUnitStorageThroughput field's value.
func (s *LustreFileSystemConfiguration) SetPerUnitStorageThroughput(v int64) *LustreFileSystemConfiguration {
	s.PerUnitStorageThroughput = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *LustreFileSystemConfiguration) SetWeeklyMaintenanceStartTime(v string) *LustreFileSystemConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// A file system configuration is required for this operation.
type MissingFileSystemConfiguration struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s MissingFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MissingFileSystemConfiguration) GoString() string {
	return s.String()
}

func newErrorMissingFileSystemConfiguration(v protocol.ResponseMetadata) error {
	return &MissingFileSystemConfiguration{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingFileSystemConfiguration) Code() string {
	return "MissingFileSystemConfiguration"
}

// Message returns the exception's message.
func (s *MissingFileSystemConfiguration) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingFileSystemConfiguration) OrigErr() error {
	return nil
}

func (s *MissingFileSystemConfiguration) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingFileSystemConfiguration) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingFileSystemConfiguration) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource specified for the tagging operation is not a resource type owned
// by Amazon FSx. Use the API of the relevant service to perform the operation.
type NotServiceResourceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the non-Amazon FSx resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`
}

// String returns the string representation
func (s NotServiceResourceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotServiceResourceError) GoString() string {
	return s.String()
}

func newErrorNotServiceResourceError(v protocol.ResponseMetadata) error {
	return &NotServiceResourceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotServiceResourceError) Code() string {
	return "NotServiceResourceError"
}

// Message returns the exception's message.
func (s *NotServiceResourceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotServiceResourceError) OrigErr() error {
	return nil
}

func (s *NotServiceResourceError) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotServiceResourceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotServiceResourceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource specified does not support tagging.
type ResourceDoesNotSupportTagging struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource that doesn't support tagging.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceDoesNotSupportTagging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDoesNotSupportTagging) GoString() string {
	return s.String()
}

func newErrorResourceDoesNotSupportTagging(v protocol.ResponseMetadata) error {
	return &ResourceDoesNotSupportTagging{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceDoesNotSupportTagging) Code() string {
	return "ResourceDoesNotSupportTagging"
}

// Message returns the exception's message.
func (s *ResourceDoesNotSupportTagging) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceDoesNotSupportTagging) OrigErr() error {
	return nil
}

func (s *ResourceDoesNotSupportTagging) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceDoesNotSupportTagging) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceDoesNotSupportTagging) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource specified by the Amazon Resource Name (ARN) can't be found.
type ResourceNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The resource ARN of the resource that can't be found.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFound) GoString() string {
	return s.String()
}

func newErrorResourceNotFound(v protocol.ResponseMetadata) error {
	return &ResourceNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFound) Code() string {
	return "ResourceNotFound"
}

// Message returns the exception's message.
func (s *ResourceNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFound) OrigErr() error {
	return nil
}

func (s *ResourceNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration of the self-managed Microsoft Active Directory (AD) directory
// to which the Windows File Server instance is joined.
type SelfManagedActiveDirectoryAttributes struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory.
	DnsIps []*string `min:"1" type:"list"`

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string `min:"1" type:"string"`

	// The name of the domain group whose members have administrative privileges
	// for the FSx file system.
	FileSystemAdministratorsGroup *string `min:"1" type:"string"`

	// The fully qualified distinguished name of the organizational unit within
	// the self-managed AD directory to which the Windows File Server instance is
	// joined.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// The user name for the service account on your self-managed AD domain that
	// FSx uses to join to your AD domain.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelfManagedActiveDirectoryAttributes) GoString() string {
	return s.String()
}

// SetDnsIps sets the DnsIps field's value.
func (s *SelfManagedActiveDirectoryAttributes) SetDnsIps(v []*string) *SelfManagedActiveDirectoryAttributes {
	s.DnsIps = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *SelfManagedActiveDirectoryAttributes) SetDomainName(v string) *SelfManagedActiveDirectoryAttributes {
	s.DomainName = &v
	return s
}

// SetFileSystemAdministratorsGroup sets the FileSystemAdministratorsGroup field's value.
func (s *SelfManagedActiveDirectoryAttributes) SetFileSystemAdministratorsGroup(v string) *SelfManagedActiveDirectoryAttributes {
	s.FileSystemAdministratorsGroup = &v
	return s
}

// SetOrganizationalUnitDistinguishedName sets the OrganizationalUnitDistinguishedName field's value.
func (s *SelfManagedActiveDirectoryAttributes) SetOrganizationalUnitDistinguishedName(v string) *SelfManagedActiveDirectoryAttributes {
	s.OrganizationalUnitDistinguishedName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *SelfManagedActiveDirectoryAttributes) SetUserName(v string) *SelfManagedActiveDirectoryAttributes {
	s.UserName = &v
	return s
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to your self-managed (including on-premises) Microsoft Active Directory (AD)
// directory.
type SelfManagedActiveDirectoryConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory. The IP addresses need to be either in the
	// same VPC CIDR range as the one in which your Amazon FSx file system is being
	// created, or in the private IP version 4 (IPv4) address ranges, as specified
	// in RFC 1918 (http://www.faqs.org/rfcs/rfc1918.html):
	//
	//    * 10.0.0.0 - 10.255.255.255 (10/8 prefix)
	//
	//    * 172.16.0.0 - 172.31.255.255 (172.16/12 prefix)
	//
	//    * 192.168.0.0 - 192.168.255.255 (192.168/16 prefix)
	//
	// DnsIps is a required field
	DnsIps []*string `min:"1" type:"list" required:"true"`

	// The fully qualified domain name of the self-managed AD directory, such as
	// corp.example.com.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// (Optional) The name of the domain group whose members are granted administrative
	// privileges for the file system. Administrative privileges include taking
	// ownership of files and folders, setting audit controls (audit ACLs) on files
	// and folders, and administering the file system remotely by using the FSx
	// Remote PowerShell. The group that you specify must already exist in your
	// domain. If you don't provide one, your AD domain's Domain Admins group is
	// used.
	FileSystemAdministratorsGroup *string `min:"1" type:"string"`

	// (Optional) The fully qualified distinguished name of the organizational unit
	// within your self-managed AD directory that the Windows File Server instance
	// will join. Amazon FSx only accepts OU as the direct parent of the file system.
	// An example is OU=FSx,DC=yourdomain,DC=corp,DC=com. To learn more, see RFC
	// 2253 (https://tools.ietf.org/html/rfc2253). If none is provided, the FSx
	// file system is created in the default location of your self-managed AD directory.
	//
	// Only Organizational Unit (OU) objects can be the direct parent of the file
	// system that you're creating.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// The password for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user name for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain. This account must have the
	// permission to join computers to the domain in the organizational unit provided
	// in OrganizationalUnitDistinguishedName, or in the default location of your
	// AD domain.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelfManagedActiveDirectoryConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManagedActiveDirectoryConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelfManagedActiveDirectoryConfiguration"}
	if s.DnsIps == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsIps"))
	}
	if s.DnsIps != nil && len(s.DnsIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DnsIps", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FileSystemAdministratorsGroup != nil && len(*s.FileSystemAdministratorsGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemAdministratorsGroup", 1))
	}
	if s.OrganizationalUnitDistinguishedName != nil && len(*s.OrganizationalUnitDistinguishedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationalUnitDistinguishedName", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnsIps sets the DnsIps field's value.
func (s *SelfManagedActiveDirectoryConfiguration) SetDnsIps(v []*string) *SelfManagedActiveDirectoryConfiguration {
	s.DnsIps = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *SelfManagedActiveDirectoryConfiguration) SetDomainName(v string) *SelfManagedActiveDirectoryConfiguration {
	s.DomainName = &v
	return s
}

// SetFileSystemAdministratorsGroup sets the FileSystemAdministratorsGroup field's value.
func (s *SelfManagedActiveDirectoryConfiguration) SetFileSystemAdministratorsGroup(v string) *SelfManagedActiveDirectoryConfiguration {
	s.FileSystemAdministratorsGroup = &v
	return s
}

// SetOrganizationalUnitDistinguishedName sets the OrganizationalUnitDistinguishedName field's value.
func (s *SelfManagedActiveDirectoryConfiguration) SetOrganizationalUnitDistinguishedName(v string) *SelfManagedActiveDirectoryConfiguration {
	s.OrganizationalUnitDistinguishedName = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *SelfManagedActiveDirectoryConfiguration) SetPassword(v string) *SelfManagedActiveDirectoryConfiguration {
	s.Password = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *SelfManagedActiveDirectoryConfiguration) SetUserName(v string) *SelfManagedActiveDirectoryConfiguration {
	s.UserName = &v
	return s
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to the self-managed Microsoft Active Directory (AD) directory.
type SelfManagedActiveDirectoryConfigurationUpdates struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory.
	DnsIps []*string `min:"1" type:"list"`

	// The password for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain.
	Password *string `min:"1" type:"string" sensitive:"true"`

	// The user name for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain. This account must have the
	// permission to join computers to the domain in the organizational unit provided
	// in OrganizationalUnitDistinguishedName.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryConfigurationUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelfManagedActiveDirectoryConfigurationUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManagedActiveDirectoryConfigurationUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelfManagedActiveDirectoryConfigurationUpdates"}
	if s.DnsIps != nil && len(s.DnsIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DnsIps", 1))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnsIps sets the DnsIps field's value.
func (s *SelfManagedActiveDirectoryConfigurationUpdates) SetDnsIps(v []*string) *SelfManagedActiveDirectoryConfigurationUpdates {
	s.DnsIps = v
	return s
}

// SetPassword sets the Password field's value.
func (s *SelfManagedActiveDirectoryConfigurationUpdates) SetPassword(v string) *SelfManagedActiveDirectoryConfigurationUpdates {
	s.Password = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *SelfManagedActiveDirectoryConfigurationUpdates) SetUserName(v string) *SelfManagedActiveDirectoryConfigurationUpdates {
	s.UserName = &v
	return s
}

// An error indicating that a particular service limit was exceeded. You can
// increase some service limits by contacting AWS Support.
type ServiceLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Enumeration of the service limit that was exceeded.
	//
	// Limit is a required field
	Limit *string `type:"string" required:"true" enum:"ServiceLimit"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ServiceLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceLimitExceeded) GoString() string {
	return s.String()
}

func newErrorServiceLimitExceeded(v protocol.ResponseMetadata) error {
	return &ServiceLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLimitExceeded) Code() string {
	return "ServiceLimitExceeded"
}

// Message returns the exception's message.
func (s *ServiceLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLimitExceeded) OrigErr() error {
	return nil
}

func (s *ServiceLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies a key-value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// A value that specifies the TagKey, the name of the tag. Tag keys must be
	// unique for the resource to which they are attached.
	Key *string `min:"1" type:"string"`

	// A value that specifies the TagValue, the value assigned to the corresponding
	// tag key. Tag values can be null and don't have to be unique in a tag set.
	// For example, you can have a key-value pair in a tag set of finances : April
	// and also of payroll : April.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The request object for the TagResource operation.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to
	// tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`

	// A list of tags for the resource. If a tag with a given key already exists,
	// the value is replaced by the one specified in this parameter.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 8))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

// The response object for the TagResource operation.
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The requested operation is not supported for this resource or API.
type UnsupportedOperation struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A detailed error message.
	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s UnsupportedOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedOperation) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperation(v protocol.ResponseMetadata) error {
	return &UnsupportedOperation{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperation) Code() string {
	return "UnsupportedOperation"
}

// Message returns the exception's message.
func (s *UnsupportedOperation) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperation) OrigErr() error {
	return nil
}

func (s *UnsupportedOperation) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperation) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperation) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request object for UntagResource action.
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon FSx resource to untag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"8" type:"string" required:"true"`

	// A list of keys of tags on the resource to untag. In case the tag key doesn't
	// exist, the call will still succeed to be idempotent.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 8))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The response object for UntagResource action.
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The request object for the UpdateFileSystem operation.
type UpdateFileSystemInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
	// ensure idempotent updates. This string is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The configuration object for Amazon FSx for Lustre file systems used in the
	// UpdateFileSystem operation.
	LustreConfiguration *UpdateFileSystemLustreConfiguration `type:"structure"`

	// The configuration update for this Microsoft Windows file system. The only
	// supported options are for backup and maintenance and for self-managed Active
	// Directory configuration.
	WindowsConfiguration *UpdateFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.LustreConfiguration != nil {
		if err := s.LustreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateFileSystemInput) SetClientRequestToken(v string) *UpdateFileSystemInput {
	s.ClientRequestToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *UpdateFileSystemInput) SetFileSystemId(v string) *UpdateFileSystemInput {
	s.FileSystemId = &v
	return s
}

// SetLustreConfiguration sets the LustreConfiguration field's value.
func (s *UpdateFileSystemInput) SetLustreConfiguration(v *UpdateFileSystemLustreConfiguration) *UpdateFileSystemInput {
	s.LustreConfiguration = v
	return s
}

// SetWindowsConfiguration sets the WindowsConfiguration field's value.
func (s *UpdateFileSystemInput) SetWindowsConfiguration(v *UpdateFileSystemWindowsConfiguration) *UpdateFileSystemInput {
	s.WindowsConfiguration = v
	return s
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
type UpdateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemLustreConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemLustreConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFileSystemLustreConfiguration"}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *UpdateFileSystemLustreConfiguration) SetWeeklyMaintenanceStartTime(v string) *UpdateFileSystemLustreConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The response object for the UpdateFileSystem operation.
type UpdateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// A description of the file system that was updated.
	FileSystem *FileSystem `type:"structure"`
}

// String returns the string representation
func (s UpdateFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *UpdateFileSystemOutput) SetFileSystem(v *FileSystem) *UpdateFileSystemOutput {
	s.FileSystem = v
	return s
}

// Updates the Microsoft Windows configuration for an existing Amazon FSx for
// Windows File Server file system. Amazon FSx overwrites existing properties
// with non-null values provided in the request. If you don't specify a non-null
// value for a property, that property is not updated.
type UpdateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The configuration Amazon FSx uses to join the Windows File Server instance
	// to the self-managed Microsoft AD directory.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates `type:"structure"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFileSystemWindowsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFileSystemWindowsConfiguration"}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}
	if s.SelfManagedActiveDirectoryConfiguration != nil {
		if err := s.SelfManagedActiveDirectoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticBackupRetentionDays sets the AutomaticBackupRetentionDays field's value.
func (s *UpdateFileSystemWindowsConfiguration) SetAutomaticBackupRetentionDays(v int64) *UpdateFileSystemWindowsConfiguration {
	s.AutomaticBackupRetentionDays = &v
	return s
}

// SetDailyAutomaticBackupStartTime sets the DailyAutomaticBackupStartTime field's value.
func (s *UpdateFileSystemWindowsConfiguration) SetDailyAutomaticBackupStartTime(v string) *UpdateFileSystemWindowsConfiguration {
	s.DailyAutomaticBackupStartTime = &v
	return s
}

// SetSelfManagedActiveDirectoryConfiguration sets the SelfManagedActiveDirectoryConfiguration field's value.
func (s *UpdateFileSystemWindowsConfiguration) SetSelfManagedActiveDirectoryConfiguration(v *SelfManagedActiveDirectoryConfigurationUpdates) *UpdateFileSystemWindowsConfiguration {
	s.SelfManagedActiveDirectoryConfiguration = v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *UpdateFileSystemWindowsConfiguration) SetWeeklyMaintenanceStartTime(v string) *UpdateFileSystemWindowsConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The configuration for this Microsoft Windows file system.
type WindowsFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing Microsoft Active Directory instance that the file
	// system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags on
	// the file system are copied to all automatic backups and any user-initiated
	// backups where the user doesn't specify any tags. If this value is true, and
	// you specify one or more tags, only the specified tags are copied to backups.
	// If you specify one or more tags when creating a user-initiated backup, no
	// tags are copied from the file system, regardless of this value.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// Specifies the file system deployment type, valid values are the following:
	//
	//    * MULTI_AZ_1 - Specifies a high availability file system that is configured
	//    for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability,
	//    and supports SSD and HDD storage.
	//
	//    * SINGLE_AZ_1 - (Default) Specifies a file system that is configured for
	//    single AZ redundancy, only supports SSD storage.
	//
	//    * SINGLE_AZ_2 - Latest generation Single AZ file system. Specifies a file
	//    system that is configured for single AZ redundancy and supports SSD and
	//    HDD storage.
	//
	// For more information, see Single-AZ and Multi-AZ File Systems (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType *string `type:"string" enum:"WindowsDeploymentType"`

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []*string `type:"list"`

	// For MULTI_AZ_1 deployment types, the IP address of the primary, or preferred,
	// file server.
	//
	// Use this IP address when mounting the file system on Linux SMB clients or
	// Windows SMB clients that are not joined to a Microsoft Active Directory.
	// Applicable for all Windows file system deployment types. This IP address
	// is temporarily unavailable when the file system is undergoing maintenance.
	// For Linux and Windows SMB clients that are joined to an Active Directory,
	// use the file system's DNSName instead. For more information on mapping and
	// mounting file shares, see Accessing File Shares (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html).
	PreferredFileServerIp *string `min:"7" type:"string"`

	// For MULTI_AZ_1 deployment types, it specifies the ID of the subnet where
	// the preferred file server is located. Must be one of the two subnet IDs specified
	// in SubnetIds property. Amazon FSx serves traffic from this subnet except
	// in the event of a failover to the secondary file server.
	//
	// For SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this value is the same
	// as that for SubnetIDs. For more information, see Availability and Durability:
	// Single-AZ and Multi-AZ File Systems (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources)
	PreferredSubnetId *string `min:"15" type:"string"`

	// For MULTI_AZ_1 deployment types, use this endpoint when performing administrative
	// tasks on the file system using Amazon FSx Remote PowerShell.
	//
	// For SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this is the DNS name of
	// the file system.
	//
	// This endpoint is temporarily unavailable when the file system is undergoing
	// maintenance.
	RemoteAdministrationEndpoint *string `min:"16" type:"string"`

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server instance is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes `type:"structure"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int64 `min:"8" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s WindowsFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WindowsFileSystemConfiguration) GoString() string {
	return s.String()
}

// SetActiveDirectoryId sets the ActiveDirectoryId field's value.
func (s *WindowsFileSystemConfiguration) SetActiveDirectoryId(v string) *WindowsFileSystemConfiguration {
	s.ActiveDirectoryId = &v
	return s
}

// SetAutomaticBackupRetentionDays sets the AutomaticBackupRetentionDays field's value.
func (s *WindowsFileSystemConfiguration) SetAutomaticBackupRetentionDays(v int64) *WindowsFileSystemConfiguration {
	s.AutomaticBackupRetentionDays = &v
	return s
}

// SetCopyTagsToBackups sets the CopyTagsToBackups field's value.
func (s *WindowsFileSystemConfiguration) SetCopyTagsToBackups(v bool) *WindowsFileSystemConfiguration {
	s.CopyTagsToBackups = &v
	return s
}

// SetDailyAutomaticBackupStartTime sets the DailyAutomaticBackupStartTime field's value.
func (s *WindowsFileSystemConfiguration) SetDailyAutomaticBackupStartTime(v string) *WindowsFileSystemConfiguration {
	s.DailyAutomaticBackupStartTime = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *WindowsFileSystemConfiguration) SetDeploymentType(v string) *WindowsFileSystemConfiguration {
	s.DeploymentType = &v
	return s
}

// SetMaintenanceOperationsInProgress sets the MaintenanceOperationsInProgress field's value.
func (s *WindowsFileSystemConfiguration) SetMaintenanceOperationsInProgress(v []*string) *WindowsFileSystemConfiguration {
	s.MaintenanceOperationsInProgress = v
	return s
}

// SetPreferredFileServerIp sets the PreferredFileServerIp field's value.
func (s *WindowsFileSystemConfiguration) SetPreferredFileServerIp(v string) *WindowsFileSystemConfiguration {
	s.PreferredFileServerIp = &v
	return s
}

// SetPreferredSubnetId sets the PreferredSubnetId field's value.
func (s *WindowsFileSystemConfiguration) SetPreferredSubnetId(v string) *WindowsFileSystemConfiguration {
	s.PreferredSubnetId = &v
	return s
}

// SetRemoteAdministrationEndpoint sets the RemoteAdministrationEndpoint field's value.
func (s *WindowsFileSystemConfiguration) SetRemoteAdministrationEndpoint(v string) *WindowsFileSystemConfiguration {
	s.RemoteAdministrationEndpoint = &v
	return s
}

// SetSelfManagedActiveDirectoryConfiguration sets the SelfManagedActiveDirectoryConfiguration field's value.
func (s *WindowsFileSystemConfiguration) SetSelfManagedActiveDirectoryConfiguration(v *SelfManagedActiveDirectoryAttributes) *WindowsFileSystemConfiguration {
	s.SelfManagedActiveDirectoryConfiguration = v
	return s
}

// SetThroughputCapacity sets the ThroughputCapacity field's value.
func (s *WindowsFileSystemConfiguration) SetThroughputCapacity(v int64) *WindowsFileSystemConfiguration {
	s.ThroughputCapacity = &v
	return s
}

// SetWeeklyMaintenanceStartTime sets the WeeklyMaintenanceStartTime field's value.
func (s *WindowsFileSystemConfiguration) SetWeeklyMaintenanceStartTime(v string) *WindowsFileSystemConfiguration {
	s.WeeklyMaintenanceStartTime = &v
	return s
}

// The type of error relating to Microsoft Active Directory. NOT_FOUND means
// that no directory was found by specifying the given directory. INCOMPATIBLE_MODE
// means that the directory specified is not a Microsoft AD directory. WRONG_VPC
// means that the specified directory isn't accessible from the specified VPC.
// WRONG_STAGE means that the specified directory isn't currently in the ACTIVE
// state.
const (
	// ActiveDirectoryErrorTypeDomainNotFound is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeDomainNotFound = "DOMAIN_NOT_FOUND"

	// ActiveDirectoryErrorTypeIncompatibleDomainMode is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeIncompatibleDomainMode = "INCOMPATIBLE_DOMAIN_MODE"

	// ActiveDirectoryErrorTypeWrongVpc is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeWrongVpc = "WRONG_VPC"

	// ActiveDirectoryErrorTypeInvalidDomainStage is a ActiveDirectoryErrorType enum value
	ActiveDirectoryErrorTypeInvalidDomainStage = "INVALID_DOMAIN_STAGE"
)

// The lifecycle status of the backup.
const (
	// BackupLifecycleAvailable is a BackupLifecycle enum value
	BackupLifecycleAvailable = "AVAILABLE"

	// BackupLifecycleCreating is a BackupLifecycle enum value
	BackupLifecycleCreating = "CREATING"

	// BackupLifecycleDeleted is a BackupLifecycle enum value
	BackupLifecycleDeleted = "DELETED"

	// BackupLifecycleFailed is a BackupLifecycle enum value
	BackupLifecycleFailed = "FAILED"
)

// The type of the backup.
const (
	// BackupTypeAutomatic is a BackupType enum value
	BackupTypeAutomatic = "AUTOMATIC"

	// BackupTypeUserInitiated is a BackupType enum value
	BackupTypeUserInitiated = "USER_INITIATED"
)

const (
	// DataRepositoryTaskFilterNameFileSystemId is a DataRepositoryTaskFilterName enum value
	DataRepositoryTaskFilterNameFileSystemId = "file-system-id"

	// DataRepositoryTaskFilterNameTaskLifecycle is a DataRepositoryTaskFilterName enum value
	DataRepositoryTaskFilterNameTaskLifecycle = "task-lifecycle"
)

const (
	// DataRepositoryTaskLifecyclePending is a DataRepositoryTaskLifecycle enum value
	DataRepositoryTaskLifecyclePending = "PENDING"

	// DataRepositoryTaskLifecycleExecuting is a DataRepositoryTaskLifecycle enum value
	DataRepositoryTaskLifecycleExecuting = "EXECUTING"

	// DataRepositoryTaskLifecycleFailed is a DataRepositoryTaskLifecycle enum value
	DataRepositoryTaskLifecycleFailed = "FAILED"

	// DataRepositoryTaskLifecycleSucceeded is a DataRepositoryTaskLifecycle enum value
	DataRepositoryTaskLifecycleSucceeded = "SUCCEEDED"

	// DataRepositoryTaskLifecycleCanceled is a DataRepositoryTaskLifecycle enum value
	DataRepositoryTaskLifecycleCanceled = "CANCELED"

	// DataRepositoryTaskLifecycleCanceling is a DataRepositoryTaskLifecycle enum value
	DataRepositoryTaskLifecycleCanceling = "CANCELING"
)

const (
	// DataRepositoryTaskTypeExportToRepository is a DataRepositoryTaskType enum value
	DataRepositoryTaskTypeExportToRepository = "EXPORT_TO_REPOSITORY"
)

// The lifecycle status of the file system.
const (
	// FileSystemLifecycleAvailable is a FileSystemLifecycle enum value
	FileSystemLifecycleAvailable = "AVAILABLE"

	// FileSystemLifecycleCreating is a FileSystemLifecycle enum value
	FileSystemLifecycleCreating = "CREATING"

	// FileSystemLifecycleFailed is a FileSystemLifecycle enum value
	FileSystemLifecycleFailed = "FAILED"

	// FileSystemLifecycleDeleting is a FileSystemLifecycle enum value
	FileSystemLifecycleDeleting = "DELETING"

	// FileSystemLifecycleMisconfigured is a FileSystemLifecycle enum value
	FileSystemLifecycleMisconfigured = "MISCONFIGURED"

	// FileSystemLifecycleUpdating is a FileSystemLifecycle enum value
	FileSystemLifecycleUpdating = "UPDATING"
)

// An enumeration specifying the currently ongoing maintenance operation.
const (
	// FileSystemMaintenanceOperationPatching is a FileSystemMaintenanceOperation enum value
	FileSystemMaintenanceOperationPatching = "PATCHING"

	// FileSystemMaintenanceOperationBackingUp is a FileSystemMaintenanceOperation enum value
	FileSystemMaintenanceOperationBackingUp = "BACKING_UP"
)

// The type of file system.
const (
	// FileSystemTypeWindows is a FileSystemType enum value
	FileSystemTypeWindows = "WINDOWS"

	// FileSystemTypeLustre is a FileSystemType enum value
	FileSystemTypeLustre = "LUSTRE"
)

// The name for a filter.
const (
	// FilterNameFileSystemId is a FilterName enum value
	FilterNameFileSystemId = "file-system-id"

	// FilterNameBackupType is a FilterName enum value
	FilterNameBackupType = "backup-type"
)

const (
	// LustreDeploymentTypeScratch1 is a LustreDeploymentType enum value
	LustreDeploymentTypeScratch1 = "SCRATCH_1"

	// LustreDeploymentTypeScratch2 is a LustreDeploymentType enum value
	LustreDeploymentTypeScratch2 = "SCRATCH_2"

	// LustreDeploymentTypePersistent1 is a LustreDeploymentType enum value
	LustreDeploymentTypePersistent1 = "PERSISTENT_1"
)

const (
	// ReportFormatReportCsv20191124 is a ReportFormat enum value
	ReportFormatReportCsv20191124 = "REPORT_CSV_20191124"
)

const (
	// ReportScopeFailedFilesOnly is a ReportScope enum value
	ReportScopeFailedFilesOnly = "FAILED_FILES_ONLY"
)

// The types of limits on your service utilization. Limits include file system
// count, total throughput capacity, total storage, and total user-initiated
// backups. These limits apply for a specific account in a specific AWS Region.
// You can increase some of them by contacting AWS Support.
const (
	// ServiceLimitFileSystemCount is a ServiceLimit enum value
	ServiceLimitFileSystemCount = "FILE_SYSTEM_COUNT"

	// ServiceLimitTotalThroughputCapacity is a ServiceLimit enum value
	ServiceLimitTotalThroughputCapacity = "TOTAL_THROUGHPUT_CAPACITY"

	// ServiceLimitTotalStorage is a ServiceLimit enum value
	ServiceLimitTotalStorage = "TOTAL_STORAGE"

	// ServiceLimitTotalUserInitiatedBackups is a ServiceLimit enum value
	ServiceLimitTotalUserInitiatedBackups = "TOTAL_USER_INITIATED_BACKUPS"
)

// The storage type for your Amazon FSx file system.
const (
	// StorageTypeSsd is a StorageType enum value
	StorageTypeSsd = "SSD"

	// StorageTypeHdd is a StorageType enum value
	StorageTypeHdd = "HDD"
)

const (
	// WindowsDeploymentTypeMultiAz1 is a WindowsDeploymentType enum value
	WindowsDeploymentTypeMultiAz1 = "MULTI_AZ_1"

	// WindowsDeploymentTypeSingleAz1 is a WindowsDeploymentType enum value
	WindowsDeploymentTypeSingleAz1 = "SINGLE_AZ_1"

	// WindowsDeploymentTypeSingleAz2 is a WindowsDeploymentType enum value
	WindowsDeploymentTypeSingleAz2 = "SINGLE_AZ_2"
)
