%{
// Copyright (c) 2014 The lex Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// WARNING: If this file is parser.go then DO NOT EDIT.
// parser.go is generated by goyacc from parser.y (see the Makefile).


package lex


import (
	"fmt"
	"strings"

	"go/token"
)


var	(
	defNamePos0 token.Position
)


%}


%union {
	str  string
	strs []string
}


%token
	tSECTION_DIV
	tBLANKS
	tVERBATIM_OPEN
	tVERBATIM_CLOSE
	tSTARTS
	tSSTART
	tXSTART
	tYYT
	tYYB
	tYYC
	tYYN
	tYYM
	tOPTION


%token <str>
	tDEF_NAME
	tDEFINITION
	tUNINDENTED_COMMENT
	tINDENTED_TEXT
	tVERBATIM_LINE
	tPATTERN_LINE
	tUSER_CODE_LINE
	tNAME
	tSTARTS_PATTERN_LINE


%type <str>
	verbatim_lines
	user_code
	def_body


%type <strs>
	start_list_def
	start_list_ref


%%


goal:
	obligatory
|	obligatory
	tSECTION_DIV
	{
		sc(yylex).Begin(_USER)
	}
	user_code
	{
		usrCode = $4
	}


blanks_opt:
|	tBLANKS


def_body:
	{
		sc(yylex).PushState(_DEF_NAME)
	}
	blanks_opt
	tDEFINITION
	{
		sc(yylex).PopState()
	}
	'\n'
	{
		$$ = $3
	}

def_section_item:
	'\n'
|	tDEF_NAME
	{
		defNamePos0 = sc(yylex).TokenStart()
		sc(yylex).PushState(_DEF_NAME)
	}
	blanks_opt
	tDEFINITION
	{
		if _, ok := defs[$1]; ok {
			logErr(fmt.Sprintf("%s:%q redefined", defNamePos0, $1))
		}

		defs[$1] = $4
		defPos[$1] = sc(yylex).TokenStart()
		sc(yylex).PopState()
	}
	'\n'
|	tUNINDENTED_COMMENT
	{
		defCode = append(defCode, $1 + "\n")
	}
|	tINDENTED_TEXT
	{
		defCode = append(defCode, $1 + "\n")
	}
|	tVERBATIM_OPEN
	{
		sc(yylex).PushState(_VERBATIM)
	}
	verbatim_lines
	tVERBATIM_CLOSE
	{	
		defCode = append(defCode, $3 + "\n")
		sc(yylex).PopState()
	}
|	tSSTART
	{
		sc(yylex).PushState(_DEF_STARTS)
	}
	start_list_def
	{
		sStarts = append(sStarts, $3...)
		sc(yylex).PopState()
	}
|	tXSTART
	{
		sc(yylex).PushState(_DEF_STARTS)
	}
	start_list_def
	{
		xStarts = append(xStarts, $3...)
		for _, start := range $3 {
			isXStart[start] = true
		}
		sc(yylex).PopState()
	}
|	tYYT
	def_body
	{
		_yyt = $2
	}
|	tYYB
	def_body
	{
		_yyb = $2
	}
|	tYYC
	def_body
	{
		_yyc = $2
	}
|	tYYN
	def_body
	{
		_yyn = $2
	}
|	tYYM
	def_body
	{
		_yym = $2
	}
|	tOPTION
	{
		switch s := strings.TrimSpace($<str>1[len("%option"):]); s {
		case "case-insensitive":
			caseless = true
		default:
			logErr(fmt.Sprintf("%s: unknown %%option %q", sc(yylex).TokenStart(), s))
		}
	}


def_section:
|	def_section def_section_item


obligatory:
	def_section
	tSECTION_DIV
	rules_section
	{
		for s := range unrefStarts {
			logErr(fmt.Sprintf("%s:start condition %q declared and not used", sc(yylex).TokenStart(), s))
		}
		if len(rules) == 1 {
			logErr(fmt.Sprintf("%s:no rules defined", sc(yylex).TokenStart()))
		}
	}


rules_section_item:
	'\n'
|	tINDENTED_TEXT
	{
		moreAction($1)
	}
|	tVERBATIM_OPEN
	{
		sc(yylex).PushState(_VERBATIM)
	}
	verbatim_lines
	tVERBATIM_CLOSE
	{	
		moreAction($3)
		sc(yylex).PopState()
	}
|	tPATTERN_LINE
	{
		rulePos = append(rulePos, sc(yylex).TokenStart())
		pat, re, action, bol, eol := parsePattern(sc(yylex).TokenStart(), $1, map[string]bool{})
		unreachableRules[len(rules)] = true
		rules = append(rules, rule{nil, pat, re, action, nil, nil, bol, eol})
	}
|	tSTARTS
	{
		sc(yylex).PushState(_STARTS)
	}
	start_list_ref
	'>'
	{
		sc(yylex).PopState()
	}
	tSTARTS_PATTERN_LINE
	{
		rulePos = append(rulePos, sc(yylex).TokenStart())
		pat, re, action, bol, eol := parsePattern(sc(yylex).TokenStart(), $6, map[string]bool{})
		unreachableRules[len(rules)] = true
		rules = append(rules, rule{$3, pat, re, action, nil, nil, bol, eol})
	}


rules_section:
	{
		sc(yylex).PushState(_RULES)
	}
|	rules_section rules_section_item


start_list_def:
	tBLANKS tNAME
	{
		if !addStartSet($2) {
			logErr(fmt.Sprintf("%s:start condition %q redeclared", sc(yylex).TokenStart(), $2))
		}
		$$ = append($$, $2)
	}
| start_list_def tBLANKS tNAME
	{
		if !addStartSet($3) {
			logErr(fmt.Sprintf("%s:start condition %q redeclared", sc(yylex).TokenStart(), $3))
		}
		$$ = append($$, $3)
	}


start_list_ref:
	tNAME
	{
		if _, ok := defStarts[$1]; !ok {
			logErr(fmt.Sprintf("%s:start condition %q undefined", sc(yylex).TokenStart(), $1))
		}
		delete(unrefStarts, $1)
		$$ = append($$, $1)
	}
|	start_list_ref ',' tNAME
	{
		if _, ok := defStarts[$3]; !ok {
			logErr(fmt.Sprintf("%s:start condition %q undefined", sc(yylex).TokenStart(), $3))
		}
		delete(unrefStarts, $3)
		$$ = append($$, $3)
	}
|	'*'
	{
		$$ = append($$, "*")
	}


user_code:
	{
		$$ = ""
	}
|	user_code tUSER_CODE_LINE
	{
		$$ += $2
	}


verbatim_lines:
	{
		$$ = ""
	}
|	verbatim_lines tVERBATIM_LINE
	{
		$$ += $2
	}


%%
