// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceRequest
type DeleteDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device for which to request details.
	//
	// DeviceArn is a required field
	DeviceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDeviceInput"}

	if s.DeviceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceResponse
type DeleteDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDevice = "DeleteDevice"

// DeleteDeviceRequest returns a request value for making API operation for
// Alexa For Business.
//
// Removes a device from Alexa For Business.
//
//    // Example sending a request using DeleteDeviceRequest.
//    req := client.DeleteDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice
func (c *Client) DeleteDeviceRequest(input *DeleteDeviceInput) DeleteDeviceRequest {
	op := &aws.Operation{
		Name:       opDeleteDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeviceInput{}
	}

	req := c.newRequest(op, input, &DeleteDeviceOutput{})
	return DeleteDeviceRequest{Request: req, Input: input, Copy: c.DeleteDeviceRequest}
}

// DeleteDeviceRequest is the request type for the
// DeleteDevice API operation.
type DeleteDeviceRequest struct {
	*aws.Request
	Input *DeleteDeviceInput
	Copy  func(*DeleteDeviceInput) DeleteDeviceRequest
}

// Send marshals and sends the DeleteDevice API request.
func (r DeleteDeviceRequest) Send(ctx context.Context) (*DeleteDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDeviceResponse{
		DeleteDeviceOutput: r.Request.Data.(*DeleteDeviceOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDeviceResponse is the response type for the
// DeleteDevice API operation.
type DeleteDeviceResponse struct {
	*DeleteDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDevice request.
func (r *DeleteDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
