// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfigurationRequest
type GetInvitationConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetInvitationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfigurationResponse
type GetInvitationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The email ID of the organization or individual contact that the enrolled
	// user can use.
	ContactEmail *string `min:"1" type:"string"`

	// The name of the organization sending the enrollment invite to a user.
	OrganizationName *string `min:"1" type:"string"`

	// The list of private skill IDs that you want to recommend to the user to enable
	// in the invitation.
	PrivateSkillIds []string `type:"list"`
}

// String returns the string representation
func (s GetInvitationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetInvitationConfiguration = "GetInvitationConfiguration"

// GetInvitationConfigurationRequest returns a request value for making API operation for
// Alexa For Business.
//
// Retrieves the configured values for the user enrollment invitation email
// template.
//
//    // Example sending a request using GetInvitationConfigurationRequest.
//    req := client.GetInvitationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration
func (c *Client) GetInvitationConfigurationRequest(input *GetInvitationConfigurationInput) GetInvitationConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetInvitationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInvitationConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetInvitationConfigurationOutput{})
	return GetInvitationConfigurationRequest{Request: req, Input: input, Copy: c.GetInvitationConfigurationRequest}
}

// GetInvitationConfigurationRequest is the request type for the
// GetInvitationConfiguration API operation.
type GetInvitationConfigurationRequest struct {
	*aws.Request
	Input *GetInvitationConfigurationInput
	Copy  func(*GetInvitationConfigurationInput) GetInvitationConfigurationRequest
}

// Send marshals and sends the GetInvitationConfiguration API request.
func (r GetInvitationConfigurationRequest) Send(ctx context.Context) (*GetInvitationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInvitationConfigurationResponse{
		GetInvitationConfigurationOutput: r.Request.Data.(*GetInvitationConfigurationOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInvitationConfigurationResponse is the response type for the
// GetInvitationConfiguration API operation.
type GetInvitationConfigurationResponse struct {
	*GetInvitationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInvitationConfiguration request.
func (r *GetInvitationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
