// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfigurationType
type DeleteNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (Amazon SNS) topic.
	//
	// TopicARN is a required field
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotificationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNotificationConfigurationInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.TopicARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicARN"))
	}
	if s.TopicARN != nil && len(*s.TopicARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TopicARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfigurationOutput
type DeleteNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteNotificationConfiguration = "DeleteNotificationConfiguration"

// DeleteNotificationConfigurationRequest returns a request value for making API operation for
// Auto Scaling.
//
// Deletes the specified notification.
//
//    // Example sending a request using DeleteNotificationConfigurationRequest.
//    req := client.DeleteNotificationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration
func (c *Client) DeleteNotificationConfigurationRequest(input *DeleteNotificationConfigurationInput) DeleteNotificationConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteNotificationConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteNotificationConfigurationRequest{Request: req, Input: input, Copy: c.DeleteNotificationConfigurationRequest}
}

// DeleteNotificationConfigurationRequest is the request type for the
// DeleteNotificationConfiguration API operation.
type DeleteNotificationConfigurationRequest struct {
	*aws.Request
	Input *DeleteNotificationConfigurationInput
	Copy  func(*DeleteNotificationConfigurationInput) DeleteNotificationConfigurationRequest
}

// Send marshals and sends the DeleteNotificationConfiguration API request.
func (r DeleteNotificationConfigurationRequest) Send(ctx context.Context) (*DeleteNotificationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNotificationConfigurationResponse{
		DeleteNotificationConfigurationOutput: r.Request.Data.(*DeleteNotificationConfigurationOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNotificationConfigurationResponse is the response type for the
// DeleteNotificationConfiguration API operation.
type DeleteNotificationConfigurationResponse struct {
	*DeleteNotificationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNotificationConfiguration request.
func (r *DeleteNotificationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
