// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsInput
type ListBuildsInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order to list build IDs. Valid values include:
	//
	//    * ASCENDING: List the build IDs in ascending order by build ID.
	//
	//    * DESCENDING: List the build IDs in descending order by build ID.
	SortOrder SortOrderType `locationName:"sortOrder" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsOutput
type ListBuildsOutput struct {
	_ struct{} `type:"structure"`

	// A list of build IDs, with each build ID representing a single build.
	Ids []string `locationName:"ids" min:"1" type:"list"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBuilds = "ListBuilds"

// ListBuildsRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Gets a list of build IDs, with each build ID representing a single build.
//
//    // Example sending a request using ListBuildsRequest.
//    req := client.ListBuildsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds
func (c *Client) ListBuildsRequest(input *ListBuildsInput) ListBuildsRequest {
	op := &aws.Operation{
		Name:       opListBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsInput{}
	}

	req := c.newRequest(op, input, &ListBuildsOutput{})
	return ListBuildsRequest{Request: req, Input: input, Copy: c.ListBuildsRequest}
}

// ListBuildsRequest is the request type for the
// ListBuilds API operation.
type ListBuildsRequest struct {
	*aws.Request
	Input *ListBuildsInput
	Copy  func(*ListBuildsInput) ListBuildsRequest
}

// Send marshals and sends the ListBuilds API request.
func (r ListBuildsRequest) Send(ctx context.Context) (*ListBuildsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBuildsResponse{
		ListBuildsOutput: r.Request.Data.(*ListBuildsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListBuildsResponse is the response type for the
// ListBuilds API operation.
type ListBuildsResponse struct {
	*ListBuildsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBuilds request.
func (r *ListBuildsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
