// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The credentials to use for federation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/Credentials
type Credentials struct {
	_ struct{} `type:"structure"`

	// An access token generated for a federated user to access Amazon Connect
	AccessToken *string `type:"string"`

	// A token generated with an expiration time for the session a user is logged
	// in to Amazon Connect
	AccessTokenExpiration *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Renews a token generated for a user to access the Amazon Connect instance.
	RefreshToken *string `type:"string"`

	// Renews the expiration timer for a generated token.
	RefreshTokenExpiration *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Credentials) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessToken != nil {
		v := *s.AccessToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccessTokenExpiration != nil {
		v := *s.AccessTokenExpiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessTokenExpiration", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.RefreshToken != nil {
		v := *s.RefreshToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RefreshToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RefreshTokenExpiration != nil {
		v := *s.RefreshTokenExpiration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RefreshTokenExpiration", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// A CurrentMetric object that contains the Name and Unit for the metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CurrentMetric
type CurrentMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	Name CurrentMetricName `type:"string" enum:"true"`

	// The unit for the metric.
	Unit Unit `type:"string" enum:"true"`
}

// String returns the string representation
func (s CurrentMetric) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CurrentMetric) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A CurrentMetricData object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CurrentMetricData
type CurrentMetricData struct {
	_ struct{} `type:"structure"`

	// The metric in a CurrentMetricData object.
	Metric *CurrentMetric `type:"structure"`

	// The value of the metric in the CurrentMetricData object.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s CurrentMetricData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CurrentMetricData) MarshalFields(e protocol.FieldEncoder) error {
	if s.Metric != nil {
		v := s.Metric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Metric", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// A CurrentMetricResult object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CurrentMetricResult
type CurrentMetricResult struct {
	_ struct{} `type:"structure"`

	// The Collections for the CurrentMetricResult object.
	Collections []CurrentMetricData `type:"list"`

	// The Dimensions for the CurrentMetricResult object.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s CurrentMetricResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CurrentMetricResult) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Collections) > 0 {
		v := s.Collections

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Collections", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	return nil
}

// A Dimensions object that includes the Channel and Queue for the metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/Dimensions
type Dimensions struct {
	_ struct{} `type:"structure"`

	// The channel used for grouping and filters. Only VOICE is supported.
	Channel Channel `type:"string" enum:"true"`

	// A QueueReference object used as one part of dimension for the metrics results.
	Queue *QueueReference `type:"structure"`
}

// String returns the string representation
func (s Dimensions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Dimensions) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Channel) > 0 {
		v := s.Channel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Channel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Queue != nil {
		v := s.Queue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Queue", v, metadata)
	}
	return nil
}

// The filter, either channel or queues, to apply to the metric results retrieved.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/Filters
type Filters struct {
	_ struct{} `type:"structure"`

	// The Channel to use as a filter for the metrics returned. Only VOICE is supported.
	Channels []Channel `type:"list"`

	// A list of up to 100 queue IDs or queue ARNs to use to filter the metrics
	// retrieved. You can include both IDs and ARNs in a request.
	Queues []string `min:"1" type:"list"`
}

// String returns the string representation
func (s Filters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filters"}
	if s.Queues != nil && len(s.Queues) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Queues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Filters) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Channels) > 0 {
		v := s.Channels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Channels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Queues) > 0 {
		v := s.Queues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Queues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// A HierarchyGroup object that contains information about a hierarchy group
// in your Amazon Connect instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HierarchyGroup
type HierarchyGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the hierarchy group.
	Arn *string `type:"string"`

	// A HierarchyPath object that contains information about the levels in the
	// hierarchy group.
	HierarchyPath *HierarchyPath `type:"structure"`

	// The identifier for the hierarchy group.
	Id *string `type:"string"`

	// The identifier for the level in the hierarchy group.
	LevelId *string `type:"string"`

	// The name of the hierarchy group in your instance.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HierarchyPath != nil {
		v := s.HierarchyPath

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HierarchyPath", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LevelId != nil {
		v := *s.LevelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LevelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A HierarchyGroupSummary object that contains information about the hierarchy
// group, including ARN, Id, and Name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HierarchyGroupSummary
type HierarchyGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ARN for the hierarchy group.
	Arn *string `type:"string"`

	// The identifier of the hierarchy group.
	Id *string `type:"string"`

	// The name of the hierarchy group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyGroupSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A HierarchyLevel object that contains information about the levels in a hierarchy
// group, including ARN, Id, and Name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HierarchyLevel
type HierarchyLevel struct {
	_ struct{} `type:"structure"`

	// The ARN for the hierarchy group level.
	Arn *string `type:"string"`

	// The identifier for the hierarchy group level.
	Id *string `type:"string"`

	// The name of the hierarchy group level.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyLevel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyLevel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A HierarchyPath object that contains information about the levels of the
// hierarchy group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HierarchyPath
type HierarchyPath struct {
	_ struct{} `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelFive *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelFour *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelOne *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelThree *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelTwo *HierarchyGroupSummary `type:"structure"`
}

// String returns the string representation
func (s HierarchyPath) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyPath) MarshalFields(e protocol.FieldEncoder) error {
	if s.LevelFive != nil {
		v := s.LevelFive

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFive", v, metadata)
	}
	if s.LevelFour != nil {
		v := s.LevelFour

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFour", v, metadata)
	}
	if s.LevelOne != nil {
		v := s.LevelOne

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelOne", v, metadata)
	}
	if s.LevelThree != nil {
		v := s.LevelThree

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelThree", v, metadata)
	}
	if s.LevelTwo != nil {
		v := s.LevelTwo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelTwo", v, metadata)
	}
	return nil
}

// A HierarchyStructure object that contains information about the hierarchy
// group structure.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HierarchyStructure
type HierarchyStructure struct {
	_ struct{} `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelFive *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelFour *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelOne *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelThree *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelTwo *HierarchyLevel `type:"structure"`
}

// String returns the string representation
func (s HierarchyStructure) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HierarchyStructure) MarshalFields(e protocol.FieldEncoder) error {
	if s.LevelFive != nil {
		v := s.LevelFive

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFive", v, metadata)
	}
	if s.LevelFour != nil {
		v := s.LevelFour

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelFour", v, metadata)
	}
	if s.LevelOne != nil {
		v := s.LevelOne

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelOne", v, metadata)
	}
	if s.LevelThree != nil {
		v := s.LevelThree

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelThree", v, metadata)
	}
	if s.LevelTwo != nil {
		v := s.LevelTwo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LevelTwo", v, metadata)
	}
	return nil
}

// A HistoricalMetric object that contains the Name, Unit, Statistic, and Threshold
// for the metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HistoricalMetric
type HistoricalMetric struct {
	_ struct{} `type:"structure"`

	// The name of the historical metric.
	Name HistoricalMetricName `type:"string" enum:"true"`

	// The statistic for the metric.
	Statistic Statistic `type:"string" enum:"true"`

	// The threshold for the metric, used with service level metrics.
	Threshold *Threshold `type:"structure"`

	// The unit for the metric.
	Unit Unit `type:"string" enum:"true"`
}

// String returns the string representation
func (s HistoricalMetric) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HistoricalMetric) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Statistic) > 0 {
		v := s.Statistic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Statistic", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Threshold != nil {
		v := s.Threshold

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Threshold", v, metadata)
	}
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A HistoricalMetricData object than contains a Metric and a Value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HistoricalMetricData
type HistoricalMetricData struct {
	_ struct{} `type:"structure"`

	// A HistoricalMetric object.
	Metric *HistoricalMetric `type:"structure"`

	// The Value of the metric.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s HistoricalMetricData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HistoricalMetricData) MarshalFields(e protocol.FieldEncoder) error {
	if s.Metric != nil {
		v := s.Metric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Metric", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Float64Value(v), metadata)
	}
	return nil
}

// The metrics data returned from a GetMetricData operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/HistoricalMetricResult
type HistoricalMetricResult struct {
	_ struct{} `type:"structure"`

	// A list of HistoricalMetricData objects.
	Collections []HistoricalMetricData `type:"list"`

	// The Dimensions for the metrics.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s HistoricalMetricResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HistoricalMetricResult) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Collections) > 0 {
		v := s.Collections

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Collections", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Dimensions != nil {
		v := s.Dimensions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Dimensions", v, metadata)
	}
	return nil
}

// A QueueReference object that contains the the QueueId and ARN for the queue
// resource for which metrics are returned.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/QueueReference
type QueueReference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of queue.
	Arn *string `type:"string"`

	// The ID of the queue associated with the metrics returned.
	Id *string `type:"string"`
}

// String returns the string representation
func (s QueueReference) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueReference) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A RoutingProfileSummary object that contains information about a routing
// profile, including ARN, Id, and Name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/RoutingProfileSummary
type RoutingProfileSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the routing profile.
	Arn *string `type:"string"`

	// The identifier of the routing profile.
	Id *string `type:"string"`

	// The name of the routing profile.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RoutingProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RoutingProfileSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A SecurityProfileSummary object that contains information about a security
// profile, including ARN, Id, Name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SecurityProfileSummary
type SecurityProfileSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the security profile.
	Arn *string `type:"string"`

	// The identifier of the security profile.
	Id *string `type:"string"`

	// The name of the security profile.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SecurityProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityProfileSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A Threshold object that includes a comparison and ThresholdValue to compare
// to. Used with service level metrics.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/Threshold
type Threshold struct {
	_ struct{} `type:"structure"`

	// The Threshold to use to compare service level metrics to. Only "Less than"
	// (LT) comparisons are supported.
	Comparison Comparison `type:"string" enum:"true"`

	// The value of the threshold to compare the metric to. Only "Less than" (LT)
	// comparisons are supported.
	ThresholdValue *float64 `type:"double"`
}

// String returns the string representation
func (s Threshold) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Threshold) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparison) > 0 {
		v := s.Comparison

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comparison", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ThresholdValue != nil {
		v := *s.ThresholdValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThresholdValue", protocol.Float64Value(v), metadata)
	}
	return nil
}

// A User object that contains information about a user account in your Amazon
// Connect instance, including configuration settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/User
type User struct {
	_ struct{} `type:"structure"`

	// The ARN of the user account.
	Arn *string `type:"string"`

	// The directory Id for the user account in the existing directory used for
	// identity management.
	DirectoryUserId *string `type:"string"`

	// The identifier for the hierarchy group assigned to the user.
	HierarchyGroupId *string `type:"string"`

	// The identifier of the user account.
	Id *string `type:"string"`

	// A UserIdentityInfo object.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// A UserPhoneConfig object.
	PhoneConfig *UserPhoneConfig `type:"structure"`

	// The identifier of the routing profile assigned to the user.
	RoutingProfileId *string `type:"string"`

	// The identifier(s) for the security profile assigned to the user.
	SecurityProfileIds []string `min:"1" type:"list"`

	// The user name assigned to the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s User) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DirectoryUserId != nil {
		v := *s.DirectoryUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DirectoryUserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HierarchyGroupId != nil {
		v := *s.HierarchyGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HierarchyGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityInfo != nil {
		v := s.IdentityInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IdentityInfo", v, metadata)
	}
	if s.PhoneConfig != nil {
		v := s.PhoneConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PhoneConfig", v, metadata)
	}
	if s.RoutingProfileId != nil {
		v := *s.RoutingProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoutingProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SecurityProfileIds) > 0 {
		v := s.SecurityProfileIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityProfileIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A UserIdentityInfo object that contains information about the user's identity,
// including email address, first name, and last name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UserIdentityInfo
type UserIdentityInfo struct {
	_ struct{} `type:"structure"`

	// The email address added to the user account. If you are using SAML for identity
	// management and include this parameter, an InvalidRequestException is returned.
	Email *string `type:"string"`

	// The first name used in the user account. This is required if you are using
	// Amazon Connect or SAML for identity management.
	FirstName *string `min:"1" type:"string"`

	// The last name used in the user account. This is required if you are using
	// Amazon Connect or SAML for identity management.
	LastName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserIdentityInfo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserIdentityInfo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserIdentityInfo"}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LastName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserIdentityInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FirstName != nil {
		v := *s.FirstName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FirstName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastName != nil {
		v := *s.LastName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A UserPhoneConfig object that contains information about the user phone configuration
// settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UserPhoneConfig
type UserPhoneConfig struct {
	_ struct{} `type:"structure"`

	// The After Call Work (ACW) timeout setting, in seconds, for the user.
	AfterContactWorkTimeLimit *int64 `type:"integer"`

	// The Auto accept setting for the user, Yes or No.
	AutoAccept *bool `type:"boolean"`

	// The phone number for the user's desk phone.
	DeskPhoneNumber *string `type:"string"`

	// The phone type selected for the user, either Soft phone or Desk phone.
	//
	// PhoneType is a required field
	PhoneType PhoneType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UserPhoneConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPhoneConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserPhoneConfig"}
	if len(s.PhoneType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PhoneType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserPhoneConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AfterContactWorkTimeLimit != nil {
		v := *s.AfterContactWorkTimeLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AfterContactWorkTimeLimit", protocol.Int64Value(v), metadata)
	}
	if s.AutoAccept != nil {
		v := *s.AutoAccept

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AutoAccept", protocol.BoolValue(v), metadata)
	}
	if s.DeskPhoneNumber != nil {
		v := *s.DeskPhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeskPhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PhoneType) > 0 {
		v := s.PhoneType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A UserSummary object that contains Information about a user, including ARN,
// Id, and user name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UserSummary
type UserSummary struct {
	_ struct{} `type:"structure"`

	// The ARN for the user account.
	Arn *string `type:"string"`

	// The identifier for the user account.
	Id *string `type:"string"`

	// The Amazon Connect user name for the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
