// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfigurationRequest
type DeleteVPCEConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the VPC endpoint configuration you want
	// to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVPCEConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVPCEConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVPCEConfigurationInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfigurationResult
type DeleteVPCEConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVPCEConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVPCEConfiguration = "DeleteVPCEConfiguration"

// DeleteVPCEConfigurationRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
//
//    // Example sending a request using DeleteVPCEConfigurationRequest.
//    req := client.DeleteVPCEConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration
func (c *Client) DeleteVPCEConfigurationRequest(input *DeleteVPCEConfigurationInput) DeleteVPCEConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteVPCEConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVPCEConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteVPCEConfigurationOutput{})
	return DeleteVPCEConfigurationRequest{Request: req, Input: input, Copy: c.DeleteVPCEConfigurationRequest}
}

// DeleteVPCEConfigurationRequest is the request type for the
// DeleteVPCEConfiguration API operation.
type DeleteVPCEConfigurationRequest struct {
	*aws.Request
	Input *DeleteVPCEConfigurationInput
	Copy  func(*DeleteVPCEConfigurationInput) DeleteVPCEConfigurationRequest
}

// Send marshals and sends the DeleteVPCEConfiguration API request.
func (r DeleteVPCEConfigurationRequest) Send(ctx context.Context) (*DeleteVPCEConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVPCEConfigurationResponse{
		DeleteVPCEConfigurationOutput: r.Request.Data.(*DeleteVPCEConfigurationOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVPCEConfigurationResponse is the response type for the
// DeleteVPCEConfiguration API operation.
type DeleteVPCEConfigurationResponse struct {
	*DeleteVPCEConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVPCEConfiguration request.
func (r *DeleteVPCEConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
