// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupRequest
type CreatePlacementGroupInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// A name for the placement group. Must be unique within the scope of your account
	// for the Region.
	//
	// Constraints: Up to 255 ASCII characters
	GroupName *string `locationName:"groupName" type:"string"`

	// The number of partitions. Valid only when Strategy is set to partition.
	PartitionCount *int64 `type:"integer"`

	// The placement strategy.
	Strategy PlacementStrategy `locationName:"strategy" type:"string" enum:"true"`
}

// String returns the string representation
func (s CreatePlacementGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupOutput
type CreatePlacementGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePlacementGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreatePlacementGroup = "CreatePlacementGroup"

// CreatePlacementGroupRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a placement group in which to launch instances. The strategy of the
// placement group determines how the instances are organized within the group.
//
// A cluster placement group is a logical grouping of instances within a single
// Availability Zone that benefit from low network latency, high network throughput.
// A spread placement group places instances on distinct hardware. A partition
// placement group places groups of instances in different partitions, where
// instances in one partition do not share the same hardware with instances
// in another partition.
//
// For more information, see Placement Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using CreatePlacementGroupRequest.
//    req := client.CreatePlacementGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup
func (c *Client) CreatePlacementGroupRequest(input *CreatePlacementGroupInput) CreatePlacementGroupRequest {
	op := &aws.Operation{
		Name:       opCreatePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlacementGroupInput{}
	}

	req := c.newRequest(op, input, &CreatePlacementGroupOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return CreatePlacementGroupRequest{Request: req, Input: input, Copy: c.CreatePlacementGroupRequest}
}

// CreatePlacementGroupRequest is the request type for the
// CreatePlacementGroup API operation.
type CreatePlacementGroupRequest struct {
	*aws.Request
	Input *CreatePlacementGroupInput
	Copy  func(*CreatePlacementGroupInput) CreatePlacementGroupRequest
}

// Send marshals and sends the CreatePlacementGroup API request.
func (r CreatePlacementGroupRequest) Send(ctx context.Context) (*CreatePlacementGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePlacementGroupResponse{
		CreatePlacementGroupOutput: r.Request.Data.(*CreatePlacementGroupOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePlacementGroupResponse is the response type for the
// CreatePlacementGroup API operation.
type CreatePlacementGroupResponse struct {
	*CreatePlacementGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePlacementGroup request.
func (r *CreatePlacementGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
