// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcRequest
type CreateVpcInput struct {
	_ struct{} `type:"structure"`

	// Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
	// the VPC. You cannot specify the range of IP addresses, or the size of the
	// CIDR block.
	AmazonProvidedIpv6CidrBlock *bool `locationName:"amazonProvidedIpv6CidrBlock" type:"boolean"`

	// The IPv4 network range for the VPC, in CIDR notation. For example, 10.0.0.0/16.
	//
	// CidrBlock is a required field
	CidrBlock *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The tenancy options for instances launched into the VPC. For default, instances
	// are launched with shared tenancy by default. You can launch instances with
	// any tenancy into a shared tenancy VPC. For dedicated, instances are launched
	// as dedicated tenancy instances by default. You can only launch instances
	// with a tenancy of dedicated or host into a dedicated tenancy VPC.
	//
	// Important: The host value cannot be used with this parameter. Use the default
	// or dedicated values only.
	//
	// Default: default
	InstanceTenancy Tenancy `locationName:"instanceTenancy" type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateVpcInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateVpcInput"}

	if s.CidrBlock == nil {
		invalidParams.Add(aws.NewErrParamRequired("CidrBlock"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcResult
type CreateVpcOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC.
	Vpc *Vpc `locationName:"vpc" type:"structure"`
}

// String returns the string representation
func (s CreateVpcOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateVpc = "CreateVpc"

// CreateVpcRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can
// create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16
// netmask (65,536 IPv4 addresses). For more information about how large to
// make your VPC, see Your VPC and Subnets (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can optionally request an Amazon-provided IPv6 CIDR block for the VPC.
// The IPv6 CIDR block uses a /56 prefix length, and is allocated from Amazon's
// pool of IPv6 addresses. You cannot choose the IPv6 range for your VPC.
//
// By default, each instance you launch in the VPC has the default DHCP options,
// which include only a default DNS server that we provide (AmazonProvidedDNS).
// For more information, see DHCP Options Sets (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// You can specify the instance tenancy value for the VPC when you create it.
// You can't change this value for the VPC after you create it. For more information,
// see Dedicated Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using CreateVpcRequest.
//    req := client.CreateVpcRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc
func (c *Client) CreateVpcRequest(input *CreateVpcInput) CreateVpcRequest {
	op := &aws.Operation{
		Name:       opCreateVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcInput{}
	}

	req := c.newRequest(op, input, &CreateVpcOutput{})
	return CreateVpcRequest{Request: req, Input: input, Copy: c.CreateVpcRequest}
}

// CreateVpcRequest is the request type for the
// CreateVpc API operation.
type CreateVpcRequest struct {
	*aws.Request
	Input *CreateVpcInput
	Copy  func(*CreateVpcInput) CreateVpcRequest
}

// Send marshals and sends the CreateVpc API request.
func (r CreateVpcRequest) Send(ctx context.Context) (*CreateVpcResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateVpcResponse{
		CreateVpcOutput: r.Request.Data.(*CreateVpcOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateVpcResponse is the response type for the
// CreateVpc API operation.
type CreateVpcResponse struct {
	*CreateVpcOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateVpc request.
func (r *CreateVpcResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
