// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RebootInstancesRequest
type RebootInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The instance IDs.
	//
	// InstanceIds is a required field
	InstanceIds []string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s RebootInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebootInstancesInput"}

	if s.InstanceIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RebootInstancesOutput
type RebootInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RebootInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opRebootInstances = "RebootInstances"

// RebootInstancesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Requests a reboot of the specified instances. This operation is asynchronous;
// it only queues a request to reboot the specified instances. The operation
// succeeds if the instances are valid and belong to you. Requests to reboot
// terminated instances are ignored.
//
// If an instance does not cleanly shut down within four minutes, Amazon EC2
// performs a hard reboot.
//
// For more information about troubleshooting, see Getting Console Output and
// Rebooting Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using RebootInstancesRequest.
//    req := client.RebootInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RebootInstances
func (c *Client) RebootInstancesRequest(input *RebootInstancesInput) RebootInstancesRequest {
	op := &aws.Operation{
		Name:       opRebootInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstancesInput{}
	}

	req := c.newRequest(op, input, &RebootInstancesOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RebootInstancesRequest{Request: req, Input: input, Copy: c.RebootInstancesRequest}
}

// RebootInstancesRequest is the request type for the
// RebootInstances API operation.
type RebootInstancesRequest struct {
	*aws.Request
	Input *RebootInstancesInput
	Copy  func(*RebootInstancesInput) RebootInstancesRequest
}

// Send marshals and sends the RebootInstances API request.
func (r RebootInstancesRequest) Send(ctx context.Context) (*RebootInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RebootInstancesResponse{
		RebootInstancesOutput: r.Request.Data.(*RebootInstancesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RebootInstancesResponse is the response type for the
// RebootInstances API operation.
type RebootInstancesResponse struct {
	*RebootInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RebootInstances request.
func (r *RebootInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
