// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupEgressRequest
type RevokeSecurityGroupEgressInput struct {
	_ struct{} `type:"structure"`

	// Not supported. Use a set of IP permissions to specify the CIDR.
	CidrIp *string `locationName:"cidrIp" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// Not supported. Use a set of IP permissions to specify the port.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The ID of the security group.
	//
	// GroupId is a required field
	GroupId *string `locationName:"groupId" type:"string" required:"true"`

	// The sets of IP permissions. You can't specify a destination security group
	// and a CIDR IP address range in the same set of permissions.
	IpPermissions []IpPermission `locationName:"ipPermissions" locationNameList:"item" type:"list"`

	// Not supported. Use a set of IP permissions to specify the protocol name or
	// number.
	IpProtocol *string `locationName:"ipProtocol" type:"string"`

	// Not supported. Use a set of IP permissions to specify a destination security
	// group.
	SourceSecurityGroupName *string `locationName:"sourceSecurityGroupName" type:"string"`

	// Not supported. Use a set of IP permissions to specify a destination security
	// group.
	SourceSecurityGroupOwnerId *string `locationName:"sourceSecurityGroupOwnerId" type:"string"`

	// Not supported. Use a set of IP permissions to specify the port.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s RevokeSecurityGroupEgressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeSecurityGroupEgressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RevokeSecurityGroupEgressInput"}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupEgressOutput
type RevokeSecurityGroupEgressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeSecurityGroupEgressOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeSecurityGroupEgress = "RevokeSecurityGroupEgress"

// RevokeSecurityGroupEgressRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// [VPC only] Removes the specified egress rules from a security group for EC2-VPC.
// This action doesn't apply to security groups for use in EC2-Classic. To remove
// a rule, the values that you specify (for example, ports) must match the existing
// rule's values exactly.
//
// Each rule consists of the protocol and the IPv4 or IPv6 CIDR range or source
// security group. For the TCP and UDP protocols, you must also specify the
// destination port or range of ports. For the ICMP protocol, you must also
// specify the ICMP type and code. If the security group rule has a description,
// you do not have to specify the description to revoke the rule.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
//
//    // Example sending a request using RevokeSecurityGroupEgressRequest.
//    req := client.RevokeSecurityGroupEgressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupEgress
func (c *Client) RevokeSecurityGroupEgressRequest(input *RevokeSecurityGroupEgressInput) RevokeSecurityGroupEgressRequest {
	op := &aws.Operation{
		Name:       opRevokeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSecurityGroupEgressInput{}
	}

	req := c.newRequest(op, input, &RevokeSecurityGroupEgressOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RevokeSecurityGroupEgressRequest{Request: req, Input: input, Copy: c.RevokeSecurityGroupEgressRequest}
}

// RevokeSecurityGroupEgressRequest is the request type for the
// RevokeSecurityGroupEgress API operation.
type RevokeSecurityGroupEgressRequest struct {
	*aws.Request
	Input *RevokeSecurityGroupEgressInput
	Copy  func(*RevokeSecurityGroupEgressInput) RevokeSecurityGroupEgressRequest
}

// Send marshals and sends the RevokeSecurityGroupEgress API request.
func (r RevokeSecurityGroupEgressRequest) Send(ctx context.Context) (*RevokeSecurityGroupEgressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeSecurityGroupEgressResponse{
		RevokeSecurityGroupEgressOutput: r.Request.Data.(*RevokeSecurityGroupEgressOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeSecurityGroupEgressResponse is the response type for the
// RevokeSecurityGroupEgress API operation.
type RevokeSecurityGroupEgressResponse struct {
	*RevokeSecurityGroupEgressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeSecurityGroupEgress request.
func (r *RevokeSecurityGroupEgressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
