// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfileRequest
type DeleteInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to delete.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInstanceProfileInput"}

	if s.InstanceProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfileOutput
type DeleteInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteInstanceProfile = "DeleteInstanceProfile"

// DeleteInstanceProfileRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Deletes the specified instance profile. The instance profile must not have
// an associated role.
//
// Make sure that you do not have any Amazon EC2 instances running with the
// instance profile you are about to delete. Deleting a role or instance profile
// that is associated with a running instance will break any applications running
// on the instance.
//
// For more information about instance profiles, go to About Instance Profiles
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
//    // Example sending a request using DeleteInstanceProfileRequest.
//    req := client.DeleteInstanceProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile
func (c *Client) DeleteInstanceProfileRequest(input *DeleteInstanceProfileInput) DeleteInstanceProfileRequest {
	op := &aws.Operation{
		Name:       opDeleteInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceProfileInput{}
	}

	req := c.newRequest(op, input, &DeleteInstanceProfileOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteInstanceProfileRequest{Request: req, Input: input, Copy: c.DeleteInstanceProfileRequest}
}

// DeleteInstanceProfileRequest is the request type for the
// DeleteInstanceProfile API operation.
type DeleteInstanceProfileRequest struct {
	*aws.Request
	Input *DeleteInstanceProfileInput
	Copy  func(*DeleteInstanceProfileInput) DeleteInstanceProfileRequest
}

// Send marshals and sends the DeleteInstanceProfile API request.
func (r DeleteInstanceProfileRequest) Send(ctx context.Context) (*DeleteInstanceProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInstanceProfileResponse{
		DeleteInstanceProfileOutput: r.Request.Data.(*DeleteInstanceProfileOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInstanceProfileResponse is the response type for the
// DeleteInstanceProfile API operation.
type DeleteInstanceProfileResponse struct {
	*DeleteInstanceProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInstanceProfile request.
func (r *DeleteInstanceProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
