// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterancesRequest
type DeleteUtterancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the bot that stored the utterances.
	//
	// BotName is a required field
	BotName *string `location:"uri" locationName:"botName" min:"2" type:"string" required:"true"`

	// The unique identifier for the user that made the utterances. This is the
	// user ID that was sent in the PostContent (http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html)
	// or PostText (http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html)
	// operation request that contained the utterance.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUtterancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUtterancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteUtterancesInput"}

	if s.BotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("BotName", 2))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteUtterancesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.BotName != nil {
		v := *s.BotName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "botName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "userId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterancesOutput
type DeleteUtterancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUtterancesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteUtterancesOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteUtterances = "DeleteUtterances"

// DeleteUtterancesRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Deletes stored utterances.
//
// Amazon Lex stores the utterances that users send to your bot. Utterances
// are stored for 15 days for use with the GetUtterancesView operation, and
// then stored indefinitely for use in improving the ability of your bot to
// respond to user input.
//
// Use the DeleteStoredUtterances operation to manually delete stored utterances
// for a specific user.
//
// This operation requires permissions for the lex:DeleteUtterances action.
//
//    // Example sending a request using DeleteUtterancesRequest.
//    req := client.DeleteUtterancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterances
func (c *Client) DeleteUtterancesRequest(input *DeleteUtterancesInput) DeleteUtterancesRequest {
	op := &aws.Operation{
		Name:       opDeleteUtterances,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botName}/utterances/{userId}",
	}

	if input == nil {
		input = &DeleteUtterancesInput{}
	}

	req := c.newRequest(op, input, &DeleteUtterancesOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteUtterancesRequest{Request: req, Input: input, Copy: c.DeleteUtterancesRequest}
}

// DeleteUtterancesRequest is the request type for the
// DeleteUtterances API operation.
type DeleteUtterancesRequest struct {
	*aws.Request
	Input *DeleteUtterancesInput
	Copy  func(*DeleteUtterancesInput) DeleteUtterancesRequest
}

// Send marshals and sends the DeleteUtterances API request.
func (r DeleteUtterancesRequest) Send(ctx context.Context) (*DeleteUtterancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteUtterancesResponse{
		DeleteUtterancesOutput: r.Request.Data.(*DeleteUtterancesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteUtterancesResponse is the response type for the
// DeleteUtterances API operation.
type DeleteUtterancesResponse struct {
	*DeleteUtterancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteUtterances request.
func (r *DeleteUtterancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
