// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerRequest
type CreateLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The optional alternative domains and subdomains to use with your SSL/TLS
	// certificate (e.g., www.example.com, example.com, m.example.com, blog.example.com).
	CertificateAlternativeNames []string `locationName:"certificateAlternativeNames" type:"list"`

	// The domain name with which your certificate is associated (e.g., example.com).
	//
	// If you specify certificateDomainName, then certificateName is required (and
	// vice-versa).
	CertificateDomainName *string `locationName:"certificateDomainName" type:"string"`

	// The name of the SSL/TLS certificate.
	//
	// If you specify certificateName, then certificateDomainName is required (and
	// vice-versa).
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The path you provided to perform the load balancer health check. If you didn't
	// specify a health check path, Lightsail uses the root path of your website
	// (e.g., "/").
	//
	// You may want to specify a custom health check path other than the root of
	// your application if your home page loads slowly or has a lot of media or
	// scripting on it.
	HealthCheckPath *string `locationName:"healthCheckPath" type:"string"`

	// The instance port where you're creating your load balancer.
	//
	// InstancePort is a required field
	InstancePort *int64 `locationName:"instancePort" type:"integer" required:"true"`

	// The name of your load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// To tag a resource after it has been created, see the tag resource operation.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLoadBalancerInput"}

	if s.InstancePort == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstancePort"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerResult
type CreateLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the API operations.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateLoadBalancer = "CreateLoadBalancer"

// CreateLoadBalancerRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Creates a Lightsail load balancer. To learn more about deciding whether to
// load balance your application, see Configure your Lightsail instances for
// load balancing (https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing).
// You can create up to 5 load balancers per AWS Region in your account.
//
// When you create a load balancer, you can specify a unique name and port settings.
// To change additional load balancer settings, use the UpdateLoadBalancerAttribute
// operation.
//
// The create load balancer operation supports tag-based access control via
// request tags. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using CreateLoadBalancerRequest.
//    req := client.CreateLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer
func (c *Client) CreateLoadBalancerRequest(input *CreateLoadBalancerInput) CreateLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opCreateLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &CreateLoadBalancerOutput{})
	return CreateLoadBalancerRequest{Request: req, Input: input, Copy: c.CreateLoadBalancerRequest}
}

// CreateLoadBalancerRequest is the request type for the
// CreateLoadBalancer API operation.
type CreateLoadBalancerRequest struct {
	*aws.Request
	Input *CreateLoadBalancerInput
	Copy  func(*CreateLoadBalancerInput) CreateLoadBalancerRequest
}

// Send marshals and sends the CreateLoadBalancer API request.
func (r CreateLoadBalancerRequest) Send(ctx context.Context) (*CreateLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLoadBalancerResponse{
		CreateLoadBalancerOutput: r.Request.Data.(*CreateLoadBalancerOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLoadBalancerResponse is the response type for the
// CreateLoadBalancer API operation.
type CreateLoadBalancerResponse struct {
	*CreateLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLoadBalancer request.
func (r *CreateLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
