// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResourceRequest
type GetOperationsForResourceInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get operations
	// for resource request.
	PageToken *string `locationName:"pageToken" type:"string"`

	// The name of the resource for which you are requesting information.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationsForResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOperationsForResourceInput"}

	if s.ResourceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResourceResult
type GetOperationsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// (Deprecated) Returns the number of pages of results that remain.
	//
	// In releases prior to June 12, 2017, this parameter returned null by the API.
	// It is now deprecated, and the API returns the next page token parameter instead.
	NextPageCount *string `locationName:"nextPageCount" deprecated:"true" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about the results of your
	// get operations for resource request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s GetOperationsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetOperationsForResource = "GetOperationsForResource"

// GetOperationsForResourceRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Gets operations for a specific resource (e.g., an instance or a static IP).
//
//    // Example sending a request using GetOperationsForResourceRequest.
//    req := client.GetOperationsForResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource
func (c *Client) GetOperationsForResourceRequest(input *GetOperationsForResourceInput) GetOperationsForResourceRequest {
	op := &aws.Operation{
		Name:       opGetOperationsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationsForResourceInput{}
	}

	req := c.newRequest(op, input, &GetOperationsForResourceOutput{})
	return GetOperationsForResourceRequest{Request: req, Input: input, Copy: c.GetOperationsForResourceRequest}
}

// GetOperationsForResourceRequest is the request type for the
// GetOperationsForResource API operation.
type GetOperationsForResourceRequest struct {
	*aws.Request
	Input *GetOperationsForResourceInput
	Copy  func(*GetOperationsForResourceInput) GetOperationsForResourceRequest
}

// Send marshals and sends the GetOperationsForResource API request.
func (r GetOperationsForResourceRequest) Send(ctx context.Context) (*GetOperationsForResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOperationsForResourceResponse{
		GetOperationsForResourceOutput: r.Request.Data.(*GetOperationsForResourceOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOperationsForResourceResponse is the response type for the
// GetOperationsForResource API operation.
type GetOperationsForResourceResponse struct {
	*GetOperationsForResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOperationsForResource request.
func (r *GetOperationsForResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
